/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.test.core.AsyncTestBase;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class VertxTest
extends AsyncTestBase {
    private final Runner RUNNER = new Runner(new OptionsBuilder().shouldDoGC(true).build());

    @Test
    public void testCloseHooksCalled() {
        AtomicInteger closedCount = new AtomicInteger();
        Closeable myCloseable1 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((AsyncResult)Future.succeededFuture());
        };
        Closeable myCloseable2 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((AsyncResult)Future.succeededFuture());
        };
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        vertx.addCloseHook(myCloseable1);
        vertx.addCloseHook(myCloseable2);
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseHookFailure1() {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Promise<Void> completion) {
                if (closedCount.incrementAndGet() == 1) {
                    throw new RuntimeException();
                }
                completion.handle((AsyncResult)Future.succeededFuture());
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseHookFailure2() throws Exception {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Promise<Void> completion) {
                if (closedCount.incrementAndGet() == 1) {
                    completion.handle((AsyncResult)Future.succeededFuture());
                    throw new RuntimeException();
                }
                completion.handle((AsyncResult)Future.succeededFuture());
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseFuture() {
        Vertx vertx = Vertx.vertx();
        Future fut = vertx.close();
        fut.onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeHttpClient() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference socketRef = new AtomicReference();
            vertx.createNetServer().connectHandler(socketRef::set).listen(8080, "localhost").onComplete(this.onSuccess(server -> latch.countDown()));
            this.awaitLatch(latch);
            AtomicBoolean closed = new AtomicBoolean();
            CloseFuture closeFuture = new CloseFuture();
            closeFuture.future().onComplete(ar -> closed.set(true));
            HttpClient client = vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false), closeFuture);
            vertx.addCloseHook((Closeable)closeFuture);
            client.request(HttpMethod.GET, 8080, "localhost", "/").compose(HttpClientRequest::send).onComplete(this.onFailure(err -> {}));
            WeakReference<HttpClient> ref = new WeakReference<HttpClient>(client);
            closeFuture = null;
            client = null;
            VertxTest.assertWaitUntil(() -> socketRef.get() != null);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(10L);
                this.RUNNER.runSystemGC();
                this.assertFalse(closed.get());
                this.assertNotNull(ref.get());
            }
            ((NetSocket)socketRef.get()).close();
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                this.RUNNER.runSystemGC();
            } while (ref.get() != null);
            this.assertTrue(closed.get());
        }
        finally {
            vertx.close(ar -> this.testComplete());
        }
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeNetClient() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference socketRef = new AtomicReference();
            vertx.createNetServer().connectHandler(socketRef::set).listen(1234, "localhost").onComplete(this.onSuccess(server -> latch.countDown()));
            this.awaitLatch(latch);
            AtomicBoolean closed = new AtomicBoolean();
            CloseFuture closeFuture = new CloseFuture();
            NetClient client = vertx.createNetClient(new NetClientOptions(), closeFuture);
            vertx.addCloseHook((Closeable)closeFuture);
            closeFuture.future().onComplete(ar -> closed.set(true));
            closeFuture = null;
            client.connect(1234, "localhost", this.onSuccess(so -> {}));
            WeakReference<NetClient> ref = new WeakReference<NetClient>(client);
            client = null;
            VertxTest.assertWaitUntil(() -> socketRef.get() != null);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(10L);
                this.RUNNER.runSystemGC();
                this.assertFalse(closed.get());
                this.assertNotNull(ref.get());
            }
            ((NetSocket)socketRef.get()).close();
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                this.RUNNER.runSystemGC();
            } while (ref.get() != null);
            this.assertTrue(closed.get());
        }
        finally {
            vertx.close(ar -> this.testComplete());
        }
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickContextFinalization() throws Exception {
        Vertx vertx = Vertx.vertx();
        try {
            AtomicReference ref = new AtomicReference();
            Thread t = new Thread(() -> {
                Context context = vertx.getOrCreateContext();
                ref.set(new WeakReference<Context>(context));
                CountDownLatch latch = new CountDownLatch(1);
                context.runOnContext(v -> latch.countDown());
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            t.start();
            t.join(10000L);
            t = null;
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                this.RUNNER.runSystemGC();
            } while (((WeakReference)ref.get()).get() != null);
        }
        finally {
            vertx.close(ar -> this.testComplete());
        }
        this.await();
    }

    @Test
    public void testCloseFutureDuplicateClose() {
        AtomicReference ref = new AtomicReference();
        CloseFuture fut = new CloseFuture();
        fut.add(ref::set);
        Promise p1 = Promise.promise();
        fut.close(p1);
        this.assertNotNull(ref.get());
        Promise p2 = Promise.promise();
        fut.close(p2);
        this.assertFalse(p1.future().isComplete());
        this.assertFalse(p2.future().isComplete());
        ((Promise)ref.get()).complete();
        this.assertTrue(p1.future().isComplete());
        this.assertTrue(p2.future().isComplete());
    }

    @Test
    public void testCloseVertxShouldWaitConcurrentCloseHook() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        AtomicReference ref = new AtomicReference();
        CloseFuture fut = new CloseFuture();
        fut.add(ref::set);
        vertx.addCloseHook((Closeable)fut);
        Promise p = Promise.promise();
        fut.close(p);
        AtomicBoolean closed = new AtomicBoolean();
        vertx.close(ar -> closed.set(true));
        Thread.sleep(500L);
        this.assertFalse(closed.get());
        ((Promise)ref.get()).complete();
        VertxTest.assertWaitUntil(closed::get);
    }
}

