/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.impl.launcher.commands.BareCommand;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.core.spi.launcher.Command;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ClasspathHandlerTest
extends CommandTestBase {
    public static final String VERTICLE = "io.vertx.core.externals.MyVerticle";
    RunCommand run;
    private BareCommand bare;

    @Override
    @Before
    public void setUp() throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        File output = new File("target/externals");
        output.mkdirs();
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(output));
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(new File("src/test/classpath/verticle/MyVerticle.java")));
        compiler.getTask(null, fileManager, null, null, null, compilationUnits1).call();
    }

    @Override
    @After
    public void tearDown() throws InterruptedException {
        if (this.run != null) {
            this.close(this.run.vertx);
        }
        if (this.bare != null) {
            this.close(this.bare.vertx);
        }
    }

    @Test
    public void testCPInRunCommand() {
        this.run = new RunCommand();
        this.run.setExecutionContext(new ExecutionContext((Command)this.run, null, null));
        this.run.setClasspath("." + File.pathSeparator + "target/externals");
        this.run.setMainVerticle(VERTICLE);
        this.run.setInstances(1);
        this.run.run();
        this.assertWaitUntil(() -> {
            try {
                return this.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Test
    public void testCPInBareCommand() {
        this.bare = new BareCommand();
        this.bare.setExecutionContext(new ExecutionContext((Command)this.bare, null, null));
        this.bare.setClasspath("." + File.pathSeparator + "target/externals");
        this.bare.setQuorum(1);
        this.bare.run();
        this.assertWaitUntil(() -> this.bare.vertx != null);
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.bare.createClassloader());
            this.bare.vertx.deployVerticle(VERTICLE, new DeploymentOptions().setHa(true));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
        this.assertWaitUntil(() -> {
            try {
                return this.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    private int getHttpCode() throws IOException {
        return ((HttpURLConnection)new URL("http://localhost:8080").openConnection()).getResponseCode();
    }
}

