/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonObjectTest;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.Shareable;
import io.vertx.test.core.TestUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonArrayTest {
    private JsonArray jsonArray;

    @Before
    public void setUp() {
        this.jsonArray = new JsonArray();
    }

    @Test
    public void testGetInteger() {
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(0));
        try {
            this.jsonArray.getInteger(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getInteger(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123L);
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(1));
        this.jsonArray.add((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(2));
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(3));
        this.jsonArray.add((Object)"foo");
        try {
            this.jsonArray.getInteger(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getInteger(5));
    }

    @Test
    public void testGetLong() {
        this.jsonArray.add((Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(0));
        try {
            this.jsonArray.getLong(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getLong(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(1));
        this.jsonArray.add((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(2));
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(3));
        this.jsonArray.add((Object)"foo");
        try {
            this.jsonArray.getLong(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getLong(5));
    }

    @Test
    public void testGetFloat() {
        this.jsonArray.add((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(0));
        try {
            this.jsonArray.getFloat(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getFloat(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(1));
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(2));
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(3));
        this.jsonArray.add((Object)"foo");
        try {
            this.jsonArray.getFloat(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getFloat(5));
    }

    @Test
    public void testGetDouble() {
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(0));
        try {
            this.jsonArray.getDouble(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getDouble(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(1));
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(2));
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(3));
        this.jsonArray.add((Object)"foo");
        try {
            this.jsonArray.getDouble(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getDouble(5));
    }

    @Test
    public void testGetString() {
        this.jsonArray.add((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        try {
            this.jsonArray.getString(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getString(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getString(1);
        }
        catch (ClassCastException e) {
            Assert.fail();
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getString(2));
    }

    @Test
    public void testGetBoolean() {
        this.jsonArray.add((Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(0));
        this.jsonArray.add((Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getBoolean(1));
        try {
            this.jsonArray.getBoolean(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getBoolean(2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getBoolean(2);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getBoolean(3));
    }

    @Test
    public void testGetBinary() {
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add((Object)bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonArray.getBinary(0));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonArray.getValue(0));
        Assert.assertArrayEquals((byte[])bytes, (byte[])JsonUtil.BASE64_DECODER.decode(this.jsonArray.getString(0)));
        try {
            this.jsonArray.getBinary(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getBinary(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getBinary(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getBinary(2));
    }

    @Test
    public void testGetBuffer() {
        Buffer bytes = TestUtils.randomBuffer(10);
        this.jsonArray.add((Object)bytes);
        Assert.assertEquals((Object)bytes, (Object)this.jsonArray.getBuffer(0));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes.getBytes()), (Object)this.jsonArray.getValue(0));
        Assert.assertEquals((Object)bytes, (Object)Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode(this.jsonArray.getString(0))));
        try {
            this.jsonArray.getBuffer(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getBuffer(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getBuffer(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getBuffer(2));
    }

    @Test
    public void testGetInstant() {
        Instant now = Instant.now();
        this.jsonArray.add((Object)now);
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(0));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonArray.getValue(0));
        Assert.assertEquals((Object)now, (Object)Instant.from(DateTimeFormatter.ISO_INSTANT.parse(this.jsonArray.getString(0))));
        try {
            this.jsonArray.getInstant(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getValue(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getInstant(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getValue(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getInstant(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getInstant(2));
        Assert.assertNull((Object)this.jsonArray.getValue(2));
    }

    @Test
    public void testGetJsonObject() {
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        this.jsonArray.add((Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(0));
        try {
            this.jsonArray.getJsonObject(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getJsonObject(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getJsonObject(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getJsonObject(2));
    }

    @Test
    public void testGetJsonArray() {
        JsonArray arr = new JsonArray().add((Object)"foo");
        this.jsonArray.add((Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(0));
        try {
            this.jsonArray.getJsonArray(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getJsonArray(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)123);
        try {
            this.jsonArray.getJsonArray(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getJsonArray(2));
    }

    @Test
    public void testGetValue() {
        this.jsonArray.add((Object)123);
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getValue(0));
        this.jsonArray.add((Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getValue(1));
        this.jsonArray.add((Object)Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getValue(2));
        this.jsonArray.add((Object)123.0);
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getValue(3));
        this.jsonArray.add((Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getValue(4));
        this.jsonArray.add((Object)true);
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getValue(5));
        this.jsonArray.add((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getValue(6));
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        this.jsonArray.add((Object)obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getValue(7));
        JsonArray arr = new JsonArray().add((Object)"blah").add((Object)"wibble");
        this.jsonArray.add((Object)arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getValue(8));
        byte[] bytes = TestUtils.randomByteArray(100);
        this.jsonArray.add((Object)bytes);
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonArray.getValue(9));
        Instant now = Instant.now();
        this.jsonArray.add((Object)now);
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(10));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonArray.getValue(10));
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getValue(11));
        try {
            this.jsonArray.getValue(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getValue(12);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayList<Cloneable> list = new ArrayList<Cloneable>();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("blah", "wibble");
        list.add(innerMap);
        this.jsonArray = new JsonArray(list);
        obj = (JsonObject)this.jsonArray.getValue(0);
        Assert.assertEquals((Object)"wibble", (Object)obj.getString("blah"));
        list = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        innerList.add("blah");
        list.add(innerList);
        this.jsonArray = new JsonArray(list);
        arr = (JsonArray)this.jsonArray.getValue(0);
        Assert.assertEquals((Object)"blah", (Object)arr.getString(0));
    }

    @Test
    public void testAddEnum() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)JsonObjectTest.SomeEnum.FOO));
        Assert.assertEquals((Object)JsonObjectTest.SomeEnum.FOO.toString(), (Object)this.jsonArray.getString(0));
        this.jsonArray.add((Object)((JsonObjectTest.SomeEnum)null));
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddString() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddCharSequence() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)new StringBuilder("bar")));
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getString(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddInteger() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)123));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(0));
        this.jsonArray.add((Object)null);
    }

    @Test
    public void testAddLong() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)123L));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddFloat() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)Float.valueOf(123.0f)));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddDouble() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddBoolean() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)true));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(0));
        this.jsonArray.add((Object)false);
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getBoolean(1));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(2));
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddJsonObject() {
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)obj));
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getJsonObject(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddJsonArray() {
        JsonArray arr = new JsonArray().add((Object)"foo");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)arr));
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddBinary() {
        byte[] bytes = TestUtils.randomByteArray(10);
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)bytes));
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonArray.getBinary(0));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonArray.getValue(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddInstant() {
        Instant now = Instant.now();
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Object)now));
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(0));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonArray.getValue(0));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(1));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddObject() {
        this.jsonArray.add((Object)"bar");
        this.jsonArray.add((Object)123);
        this.jsonArray.add((Object)123L);
        this.jsonArray.add((Object)Float.valueOf(1.23f));
        this.jsonArray.add((Object)1.23);
        this.jsonArray.add((Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add((Object)bytes);
        Instant now = Instant.now();
        this.jsonArray.add((Object)now);
        JsonObject obj = new JsonObject().put("foo", (Object)"blah");
        JsonArray arr = new JsonArray().add((Object)"quux");
        this.jsonArray.add((Object)obj);
        this.jsonArray.add((Object)arr);
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getString(0));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(1));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(2));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.jsonArray.getFloat(3));
        Assert.assertEquals((Object)1.23, (Object)this.jsonArray.getDouble(4));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(5));
        Assert.assertArrayEquals((byte[])bytes, (byte[])this.jsonArray.getBinary(6));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonArray.getValue(6));
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(7));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonArray.getValue(7));
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(8));
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(9));
        try {
            this.jsonArray.add((Object)new SomeClass());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonArray.add((Object)new BigDecimal(123));
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonArray.add((Object)new Date());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAddAllJsonArray() {
        this.jsonArray.add((Object)"bar");
        JsonArray arr = new JsonArray().add((Object)"foo").add((Object)48);
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.addAll(arr));
        Assert.assertEquals((Object)arr.getString(0), (Object)this.jsonArray.getString(1));
        Assert.assertEquals((Object)arr.getInteger(1), (Object)this.jsonArray.getInteger(2));
        this.jsonArray.add((Object)null);
        Assert.assertNull((Object)this.jsonArray.getValue(3));
        Assert.assertEquals((long)4L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddNull() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.addNull());
        Assert.assertEquals(null, (Object)this.jsonArray.getString(0));
        Assert.assertTrue((boolean)this.jsonArray.hasNull(0));
    }

    @Test
    public void testHasNull() {
        this.jsonArray.addNull();
        this.jsonArray.add((Object)"foo");
        Assert.assertEquals(null, (Object)this.jsonArray.getString(0));
        Assert.assertTrue((boolean)this.jsonArray.hasNull(0));
        Assert.assertFalse((boolean)this.jsonArray.hasNull(1));
    }

    @Test
    public void testContains() {
        this.jsonArray.add((Object)"wibble");
        this.jsonArray.add((Object)true);
        this.jsonArray.add((Object)123);
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        this.jsonArray.add((Object)obj);
        this.jsonArray.add((Object)arr);
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)"eek"));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)false));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)321));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)new JsonObject().put("blah", (Object)"flib")));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)new JsonArray().add((Object)"oob")));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)"wibble"));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)true));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)123));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)obj));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)arr));
    }

    @Test
    public void testRemoveByObject() {
        this.jsonArray.add((Object)"wibble");
        this.jsonArray.add((Object)true);
        this.jsonArray.add((Object)123);
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)"wibble"));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
        Assert.assertFalse((boolean)this.jsonArray.remove((Object)"notthere"));
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)true));
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)123));
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testRemoveByWrappedObject() {
        JsonArray arr = new JsonArray("[1, 2, 3]");
        this.jsonArray.add((Object)arr);
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)arr));
        Assert.assertEquals((long)0L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
        this.jsonArray.add((Object)arr.getList());
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)arr));
        Assert.assertEquals((long)0L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testRemoveByPos() {
        this.jsonArray.add((Object)"wibble");
        this.jsonArray.add((Object)true);
        this.jsonArray.add((Object)123);
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)"wibble", (Object)this.jsonArray.remove(0));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)123, (Object)this.jsonArray.remove(1));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)true, (Object)this.jsonArray.remove(0));
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testSize() {
        this.jsonArray.add((Object)"wibble");
        this.jsonArray.add((Object)true);
        this.jsonArray.add((Object)123);
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
    }

    @Test
    public void testClear() {
        this.jsonArray.add((Object)"wibble");
        this.jsonArray.add((Object)true);
        this.jsonArray.add((Object)123);
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)this.jsonArray, (Object)this.jsonArray.clear());
        Assert.assertEquals((long)0L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testIterator() {
        this.jsonArray.add((Object)"foo");
        this.jsonArray.add((Object)123);
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        this.jsonArray.add((Object)obj);
        Iterator iter = this.jsonArray.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Object entry = iter.next();
        Assert.assertEquals((Object)"foo", entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)123, entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)obj, entry);
        Assert.assertFalse((boolean)iter.hasNext());
        iter.remove();
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)obj));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testStream() {
        this.jsonArray.add((Object)"foo");
        this.jsonArray.add((Object)123);
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        this.jsonArray.add((Object)obj);
        List list = this.jsonArray.stream().collect(Collectors.toList());
        Iterator iter = list.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Object entry = iter.next();
        Assert.assertEquals((Object)"foo", entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)123, entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)obj, entry);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testCopy() {
        this.jsonArray.add((Object)"foo");
        this.jsonArray.add((Object)123);
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        this.jsonArray.add((Object)obj);
        this.jsonArray.add((Object)new StringBuilder("eeek"));
        JsonArray copy = this.jsonArray.copy();
        Assert.assertEquals((Object)"eeek", (Object)copy.getString(3));
        Assert.assertNotSame((Object)this.jsonArray, (Object)copy);
        Assert.assertEquals((Object)this.jsonArray, (Object)copy);
        Assert.assertEquals((long)4L, (long)copy.size());
        Assert.assertEquals((Object)"foo", (Object)copy.getString(0));
        Assert.assertEquals((Object)123, (Object)copy.getInteger(1));
        Assert.assertEquals((Object)obj, (Object)copy.getJsonObject(2));
        Assert.assertNotSame((Object)obj, (Object)copy.getJsonObject(2));
        copy.add((Object)"foo");
        Assert.assertEquals((long)4L, (long)this.jsonArray.size());
        this.jsonArray.add((Object)"bar");
        Assert.assertEquals((long)5L, (long)copy.size());
    }

    @Test
    public void testInvalidValsOnCopy1() {
        SomeClass invalid = new SomeClass();
        JsonArray array = new JsonArray(Collections.singletonList(invalid));
        try {
            array.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        array = array.copy(SomeClass.CLONER);
        Assert.assertTrue((boolean)(array.getValue(0) instanceof SomeClass));
        Assert.assertNotSame((Object)array.getValue(0), (Object)invalid);
    }

    @Test
    public void testInvalidValsOnCopy2() {
        SomeClass invalid = new SomeClass();
        JsonArray array = new JsonArray(Collections.singletonList(Collections.singletonMap("foo", invalid)));
        try {
            array.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        array = array.copy(SomeClass.CLONER);
        Assert.assertTrue((boolean)(array.getJsonObject(0).getValue("foo") instanceof SomeClass));
        Assert.assertNotSame((Object)array.getJsonObject(0).getValue("foo"), (Object)invalid);
    }

    @Test
    public void testInvalidValsOnCopy3() {
        SomeClass invalid = new SomeClass();
        JsonArray array = new JsonArray(Collections.singletonList(Collections.singletonList(invalid)));
        try {
            array.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        array = array.copy(SomeClass.CLONER);
        Assert.assertTrue((boolean)(array.getJsonArray(0).getValue(0) instanceof SomeClass));
        Assert.assertNotSame((Object)array.getJsonArray(0).getValue(0), (Object)invalid);
    }

    @Test
    public void testToString() {
        this.jsonArray.add((Object)"foo").add((Object)123);
        Assert.assertEquals((Object)this.jsonArray.encode(), (Object)this.jsonArray.toString());
    }

    @Test
    public void testGetList() {
        JsonObject obj = new JsonObject().put("quux", (Object)"wibble");
        this.jsonArray.add((Object)"foo").add((Object)123).add((Object)obj);
        List list = this.jsonArray.getList();
        list.remove("foo");
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)"foo"));
        list.add("floob");
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)"floob"));
        Assert.assertSame((Object)obj, list.get(1));
        obj.remove("quux");
    }

    @Test
    public void testCreateFromList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
    }

    @Test
    public void testCreateFromListCharSequence() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        list.add(new StringBuilder("eek"));
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertEquals((Object)"eek", (Object)arr.getString(2));
        Assert.assertSame(list, (Object)arr.getList());
    }

    @Test
    public void testCreateFromListNestedJsonObject() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonObject obj = new JsonObject().put("blah", (Object)"wibble");
        list.add(obj);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        Assert.assertSame((Object)obj, (Object)arr.getJsonObject(2));
    }

    @Test
    public void testCreateFromListNestedMap() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("blah", "wibble");
        list.add(map);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        JsonObject obj = arr.getJsonObject(2);
        Assert.assertSame(map, (Object)obj.getMap());
    }

    @Test
    public void testCreateFromListNestedJsonArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonArray arr2 = new JsonArray().add((Object)"blah").add((Object)"wibble");
        list.add(arr2);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        Assert.assertSame((Object)arr2, (Object)arr.getJsonArray(2));
    }

    @Test
    public void testCreateFromListNestedList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("blah");
        list2.add("wibble");
        list.add(list2);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        JsonArray arr2 = arr.getJsonArray(2);
        Assert.assertSame(list2, (Object)arr2.getList());
    }

    @Test
    public void testCreateFromBuffer() {
        JsonArray excepted = new JsonArray();
        excepted.add((Object)"foobar");
        excepted.add((Object)123);
        Buffer buf = Buffer.buffer((String)excepted.encode());
        Assert.assertEquals((Object)excepted, (Object)new JsonArray(buf));
    }

    @Test
    public void testClusterSerializable() {
        this.jsonArray.add((Object)"foo").add((Object)123);
        Buffer buff = Buffer.buffer();
        this.jsonArray.writeToBuffer(buff);
        JsonArray deserialized = new JsonArray();
        deserialized.readFromBuffer(0, buff);
        Assert.assertEquals((Object)this.jsonArray, (Object)deserialized);
    }

    @Test
    public void testJsonArrayEquality() {
        JsonObject obj = new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3)));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3L))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add((Object)3))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add((Object)3L))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(4))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add((Object)4))));
        JsonArray array = new JsonArray(Collections.singletonList(Collections.singletonList(3)));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(3))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(3L))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add((Object)3))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add((Object)3L))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(4))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add((Object)4))));
    }

    @Test
    public void testStreamCorrectTypes() throws Exception {
        String json = "{\"object1\": [{\"object2\": 12}]}";
        JsonObject object = new JsonObject(json);
        this.testStreamCorrectTypes(object.copy());
        this.testStreamCorrectTypes(object);
    }

    @Test
    public void testRemoveMethodReturnedObject() {
        JsonArray obj = new JsonArray();
        obj.add((Object)"bar").add((Object)new JsonObject().put("name", (Object)"vert.x").put("count", (Object)2)).add((Object)new JsonArray().add((Object)1.0).add((Object)2.0));
        Object removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof String));
        removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof JsonObject));
        Assert.assertEquals((Object)((JsonObject)removed).getString("name"), (Object)"vert.x");
        removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof JsonArray));
        Assert.assertEquals((double)((JsonArray)removed).getDouble(0), (double)1.0, (double)0.0);
    }

    private void testStreamCorrectTypes(JsonObject object) {
        object.getJsonArray("object1").stream().forEach(innerMap -> Assert.assertTrue((String)("Expecting JsonObject, found: " + innerMap.getClass().getCanonicalName()), (boolean)(innerMap instanceof JsonObject)));
    }

    @Test
    public void testInvalidConstruction() {
        try {
            new JsonArray((String)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonArray((Buffer)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonArray((List)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSetEnum() {
        try {
            this.jsonArray.set(0, (Object)JsonObjectTest.SomeEnum.FOO);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)JsonObjectTest.SomeEnum.FOO));
        Assert.assertEquals((Object)JsonObjectTest.SomeEnum.FOO.toString(), (Object)this.jsonArray.getString(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetString() {
        try {
            this.jsonArray.set(0, (Object)"foo");
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetCharSequence() {
        try {
            this.jsonArray.set(0, (Object)new StringBuilder("foo"));
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)new StringBuilder("foo")));
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetInteger() {
        try {
            this.jsonArray.set(0, (Object)123);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)123));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetLong() {
        try {
            this.jsonArray.set(0, (Object)123L);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)123L));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetFloat() {
        try {
            this.jsonArray.set(0, (Object)Float.valueOf(123.0f));
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)Float.valueOf(123.0f)));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetDouble() {
        try {
            this.jsonArray.set(0, (Object)123.0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetBoolean() {
        try {
            this.jsonArray.set(0, (Object)true);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.jsonArray.getBoolean(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetJsonObject() {
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        try {
            this.jsonArray.set(0, (Object)obj);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)obj));
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetJsonArray() {
        JsonArray arr = new JsonArray().add((Object)"foo");
        try {
            this.jsonArray.set(0, (Object)arr);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)arr));
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetBinary() {
        byte[] bytes = TestUtils.randomByteArray(10);
        try {
            this.jsonArray.set(0, (Object)bytes);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)bytes));
        Assert.assertEquals((Object)JsonUtil.BASE64_ENCODER.encodeToString(bytes), (Object)this.jsonArray.getValue(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetInstant() {
        Instant now = Instant.now();
        try {
            this.jsonArray.set(0, (Object)now);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.set(0, (Object)now));
        Assert.assertEquals((Object)now.toString(), (Object)this.jsonArray.getValue(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testSetObject() {
        this.jsonArray.add((Object)"bar");
        try {
            this.jsonArray.set(0, (Object)new SomeClass());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonArray.set(0, (Object)new BigDecimal(123));
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
        try {
            this.jsonArray.set(0, (Object)new Date());
        }
        catch (RuntimeException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSetNull() {
        try {
            this.jsonArray.setNull(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add((Object)"bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.setNull(0));
        Assert.assertNull((Object)this.jsonArray.getString(0));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
    }

    @Test
    public void testAddWithPos() {
        JsonArray arr = new JsonArray().add((Object)1).add((Object)2).add((Object)3);
        Assert.assertEquals((long)3L, (long)arr.size());
        Assert.assertEquals((Object)1, (Object)arr.getValue(0));
        Assert.assertEquals((Object)2, (Object)arr.getValue(1));
        Assert.assertEquals((Object)3, (Object)arr.getValue(2));
        arr.add(3, (Object)4);
        Assert.assertEquals((long)4L, (long)arr.size());
        Assert.assertEquals((Object)4, (Object)arr.getValue(3));
    }

    @Test
    public void testNoEncode() {
        Instant now = Instant.now();
        JsonArray json = new JsonArray();
        json.getList().add(now);
        Assert.assertEquals((Object)now, (Object)json.getInstant(0));
        Assert.assertSame((Object)now, (Object)json.getInstant(0));
        byte[] bytes = "bytes".getBytes();
        json.getList().add(bytes);
        Assert.assertEquals((Object)bytes, (Object)json.getBinary(1));
        Assert.assertSame((Object)bytes, (Object)json.getBinary(1));
    }

    @Test
    public void testBigDecimal() {
        BigDecimal bd1 = new BigDecimal("124567890.0987654321");
        JsonArray json = new JsonArray();
        json.add((Object)bd1);
        Assert.assertEquals((Object)bd1, (Object)json.getValue(0));
        Assert.assertSame((Object)bd1, (Object)json.getValue(0));
        JsonArray json2 = json.copy();
        Assert.assertEquals((Object)"[124567890.0987654321]", (Object)json.encode());
    }

    @Test
    public void testShareable() {
        Shareable myShareable = new Shareable(){

            public Shareable copy() {
                return this;
            }
        };
        JsonArray json = new JsonArray();
        json.add((Object)myShareable);
        Assert.assertEquals((Object)myShareable, (Object)json.getValue(0));
        Assert.assertSame((Object)myShareable, (Object)json.getValue(0));
        JsonArray json2 = json.copy();
    }

    @Test
    public void testNumber() {
        JsonArray numbers = new JsonArray().add((Object)new BigDecimal("124567890.0987654321")).add((Object)new BigInteger("1234567890123456789012345678901234567890")).add((Object)10).add((Object)Math.PI).add((Object)Float.valueOf((float)Math.PI)).add((Object)42).add((Object)1234567890123456789L).add((Object)Short.MAX_VALUE);
        JsonArray json2 = numbers.copy();
        Assert.assertEquals((Object)"[124567890.0987654321,1234567890123456789012345678901234567890,10,3.141592653589793,3.1415927,42,1234567890123456789,32767]", (Object)numbers.encode());
        Assert.assertNotNull((Object)numbers.getNumber(0));
        Assert.assertNotNull((Object)numbers.getNumber(1));
        Assert.assertNotNull((Object)numbers.getNumber(2));
        Assert.assertNotNull((Object)numbers.getNumber(3));
        Assert.assertNotNull((Object)numbers.getNumber(4));
        Assert.assertNotNull((Object)numbers.getNumber(5));
        Assert.assertNotNull((Object)numbers.getNumber(6));
        Assert.assertNotNull((Object)numbers.getNumber(7));
        Assert.assertTrue((boolean)(numbers.getNumber(0) instanceof BigDecimal));
        Assert.assertTrue((boolean)(numbers.getNumber(1) instanceof BigInteger));
        Assert.assertTrue((boolean)(numbers.getNumber(2) instanceof Byte));
        Assert.assertTrue((boolean)(numbers.getNumber(3) instanceof Double));
        Assert.assertTrue((boolean)(numbers.getNumber(4) instanceof Float));
        Assert.assertTrue((boolean)(numbers.getNumber(5) instanceof Integer));
        Assert.assertTrue((boolean)(numbers.getNumber(6) instanceof Long));
        Assert.assertTrue((boolean)(numbers.getNumber(7) instanceof Short));
        JsonArray object = new JsonArray().add((Object)42000);
        Number n = object.getNumber(0);
        Assert.assertEquals((long)-23536L, (long)n.shortValue());
        Assert.assertEquals((long)42000L, (long)n.intValue());
    }

    @Test
    public void testStreamRawVSJSON() {
        JsonArray arr = new JsonArray().add((Object)TimeUnit.DAYS).add((Object)TimeUnit.MINUTES);
        List jsonData = arr.stream().peek(t -> Assert.assertTrue((boolean)(t instanceof String))).collect(Collectors.toList());
        for (Object o : jsonData) {
            Assert.assertTrue((boolean)(o instanceof String));
        }
        List rawData = arr.getList().stream().peek(t -> Assert.assertTrue((boolean)(t instanceof TimeUnit))).collect(Collectors.toList());
        for (Object o : rawData) {
            Assert.assertTrue((boolean)(o instanceof TimeUnit));
        }
    }

    static class SomeClass {
        static final Function<Object, ?> CLONER = o -> {
            Assert.assertTrue((boolean)(o instanceof SomeClass));
            return new SomeClass();
        };

        SomeClass() {
        }
    }

    static enum SomeEnum {
        FOO,
        BAR;

    }
}

