/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pkcs1;

import io.vertx.core.net.impl.pkcs1.PrivateKeyParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PrivateKeyParserTest {
    @Test
    public void testGetPKCS8EncodedKeySpecSupportsRSA() {
        byte[] pkcs8 = new byte[]{48, 18, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
        this.assertKeySpecType(pkcs8, "RSA");
    }

    @Test
    public void testGetPKCS8EncodedKeySpecSupportsEC() {
        byte[] pkcs8 = new byte[]{48, 24, 2, 1, 0, 48, 19, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
        this.assertKeySpecType(pkcs8, "EC");
    }

    private void assertKeySpecType(byte[] encodedKey, String expectedAlgorithm) {
        String keyAlgorithm = PrivateKeyParser.getPKCS8EncodedKeyAlgorithm((byte[])encodedKey);
        Assert.assertThat((Object)keyAlgorithm, (Matcher)CoreMatchers.is((Object)expectedAlgorithm));
    }
}

