/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.junit.Test;

public abstract class EventBusTracerTestBase
extends VertxTestBase {
    VertxTracer tracer;
    Vertx vertx1;
    Vertx vertx2;

    @Override
    protected VertxTracer getTracer() {
        this.tracer = new VertxTracer(){

            public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
                return EventBusTracerTestBase.this.tracer.receiveRequest(context, kind, policy, request, operation, headers, tagExtractor);
            }

            public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                EventBusTracerTestBase.this.tracer.sendResponse(context, response, payload, failure, tagExtractor);
            }

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                return EventBusTracerTestBase.this.tracer.sendRequest(context, kind, policy, request, operation, headers, tagExtractor);
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                EventBusTracerTestBase.this.tracer.receiveResponse(context, response, payload, failure, tagExtractor);
            }
        };
        return this.tracer;
    }

    @Test
    public void testEventBusSend() throws Exception {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx2.runOnContext(v1 -> {
            Context ctx = this.vertx2.getOrCreateContext();
            this.vertx2.eventBus().consumer("the_address", msg -> {
                this.assertNotSame(Vertx.currentContext(), ctx);
                this.assertSameEventLoop(ctx, Vertx.currentContext());
                this.assertEquals("msg", msg.body());
            }).completionHandler(this.onSuccess(v2 -> latch.countDown()));
        });
        this.awaitLatch(latch);
        this.vertx1.runOnContext(v -> {
            Context ctx = this.vertx1.getOrCreateContext();
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx1.eventBus().send("the_address", (Object)"msg");
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 4);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[]"), ebTracer.sendEvents);
        this.assertEquals(Arrays.asList("receiveRequest[the_address]", "sendResponse[]"), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusSendNoConsumer() {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx1.eventBus().send("the_address", (Object)"msg");
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 2);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[NO_HANDLERS]"), ebTracer.sendEvents);
        this.assertEquals(Collections.emptyList(), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusRequestReply() throws Exception {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx2.runOnContext(v1 -> {
            Context ctx = this.vertx2.getOrCreateContext();
            this.vertx2.eventBus().consumer("the_address", msg -> {
                this.assertNotSame(ctx, this.vertx2.getOrCreateContext());
                this.assertSameEventLoop(ctx, this.vertx2.getOrCreateContext());
                this.assertEquals("msg_1", msg.body());
                ConcurrentMap tracerMap = ((ContextInternal)this.vertx.getOrCreateContext()).localContextData();
                tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
                msg.reply((Object)"msg_2");
            }).completionHandler(this.onSuccess(v2 -> latch.countDown()));
        });
        this.awaitLatch(latch);
        this.vertx1.runOnContext(v -> {
            Context ctx = this.vertx1.getOrCreateContext();
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx1.eventBus().request("the_address", (Object)"msg_1", this.onSuccess(reply -> {
                this.assertSame(ctx, this.vertx1.getOrCreateContext());
                this.assertSameEventLoop(ctx, this.vertx1.getOrCreateContext());
            }));
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 4);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[]"), ebTracer.sendEvents);
        this.assertEquals(Arrays.asList("receiveRequest[the_address]", "sendResponse[]"), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusRequestReplyFailure() throws Exception {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx1.eventBus().consumer("the_address", msg -> {
            this.assertEquals("msg", msg.body());
            ConcurrentMap tracerMap = ((ContextInternal)this.vertx.getOrCreateContext()).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            msg.fail(10, "it failed");
        }).completionHandler(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx2.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx2.eventBus().request("the_address", (Object)"msg", this.onFailure(failure -> {}));
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 4);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[RECIPIENT_FAILURE]"), ebTracer.sendEvents);
        this.assertEquals(Arrays.asList("receiveRequest[the_address]", "sendResponse[]"), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusRequestNoConsumer() {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        Context ctx = this.vertx2.getOrCreateContext();
        ctx.runOnContext(v -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx2.eventBus().request("the_address", (Object)"msg", this.onFailure(failure -> {}));
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 2);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[NO_HANDLERS]"), ebTracer.sendEvents);
        this.assertEquals(Collections.emptyList(), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusRequestTimeout() throws Exception {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx1.eventBus().consumer("the_address", msg -> {}).completionHandler(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx2.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx2.eventBus().request("the_address", (Object)"msg", new DeliveryOptions().setSendTimeout(100L), this.onFailure(failure -> {}));
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 3);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[TIMEOUT]"), ebTracer.sendEvents);
        this.assertEquals(Arrays.asList("receiveRequest[the_address]"), ebTracer.receiveEvents);
    }

    @Test
    public void testEventBusRequestReplyReply() throws Exception {
        EventBusTracer ebTracer = new EventBusTracer();
        this.tracer = ebTracer;
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx2.runOnContext(v1 -> {
            Context ctx = this.vertx2.getOrCreateContext();
            this.vertx2.eventBus().consumer("the_address", msg -> {
                Context consumerCtx = this.vertx2.getOrCreateContext();
                this.assertNotSame(ctx, consumerCtx);
                this.assertSameEventLoop(ctx, consumerCtx);
                this.assertEquals("msg_1", msg.body());
                ConcurrentMap tracerMap = ((ContextInternal)this.vertx.getOrCreateContext()).localContextData();
                tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
                msg.replyAndRequest((Object)"msg_2", reply -> {
                    this.assertSame(consumerCtx, this.vertx2.getOrCreateContext());
                    this.assertSameEventLoop(consumerCtx, this.vertx2.getOrCreateContext());
                });
            }).completionHandler(this.onSuccess(v2 -> latch.countDown()));
        });
        this.awaitLatch(latch);
        this.vertx1.runOnContext(v -> {
            Context ctx = this.vertx1.getOrCreateContext();
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
            this.vertx1.eventBus().request("the_address", (Object)"msg_1", this.onSuccess(reply -> {
                this.assertSame(Vertx.currentContext(), ctx);
                tracerMap.put(ebTracer.sendKey, ebTracer.sendVal);
                reply.reply((Object)"msg_3");
            }));
        });
        EventBusTracerTestBase.waitUntil(() -> ebTracer.sendEvents.size() + ebTracer.receiveEvents.size() == 8);
        this.assertEquals(Arrays.asList("sendRequest[the_address]", "receiveResponse[]", "sendRequest[generated]", "receiveResponse[]"), ebTracer.sendEvents);
        this.assertEquals(Arrays.asList("receiveRequest[the_address]", "sendResponse[]", "receiveRequest[generated]", "sendResponse[]"), ebTracer.receiveEvents);
    }

    class EventBusTracer
    implements VertxTracer<Object, Object> {
        final String receiveKey = TestUtils.randomAlphaString(10);
        final Object receiveVal = new Object();
        final Object receiveTrace = new Object();
        final String sendKey = TestUtils.randomAlphaString(10);
        final Object sendVal = new Object();
        final Object sendTrace = new Object();
        final List<String> sendEvents = new CopyOnWriteArrayList<String>();
        final List<String> receiveEvents = new CopyOnWriteArrayList<String>();

        EventBusTracer() {
        }

        private <T> String addressOf(T obj, TagExtractor<T> extractor) {
            int len = extractor.len(obj);
            for (int idx = 0; idx < len; ++idx) {
                if (!extractor.name(obj, idx).equals("message_bus.destination")) continue;
                String value = extractor.value(obj, idx);
                if (value.startsWith("__vertx")) {
                    value = "generated";
                }
                return value;
            }
            return null;
        }

        public <R> Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
            context.putLocal(this.receiveKey, this.receiveVal);
            Object body = ((Message)request).body();
            this.receiveEvents.add("receiveRequest[" + this.addressOf(request, tagExtractor) + "]");
            return this.receiveTrace;
        }

        public <R> void sendResponse(Context context, R response, Object payload, Throwable failure, TagExtractor<R> tagExtractor) {
            EventBusTracerTestBase.this.assertSame(this.receiveTrace, payload);
            EventBusTracerTestBase.this.assertSame(this.receiveVal, context.getLocal(this.receiveKey));
            EventBusTracerTestBase.this.assertTrue(context.removeLocal(this.receiveKey));
            this.receiveEvents.add("sendResponse[]");
        }

        public <R> Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
            EventBusTracerTestBase.this.assertSame(this.sendVal, context.getLocal(this.sendKey));
            this.sendEvents.add("sendRequest[" + this.addressOf(request, tagExtractor) + "]");
            EventBusTracerTestBase.this.assertTrue(request instanceof Message);
            return this.sendTrace;
        }

        public <R> void receiveResponse(Context context, R response, Object payload, Throwable failure, TagExtractor<R> tagExtractor) {
            EventBusTracerTestBase.this.assertSame(this.sendTrace, payload);
            EventBusTracerTestBase.this.assertSame(this.sendVal, context.getLocal(this.sendKey));
            EventBusTracerTestBase.this.assertTrue(context.removeLocal(this.sendKey));
            if (failure != null) {
                EventBusTracerTestBase.this.assertTrue(failure instanceof ReplyException);
                ReplyException replyException = (ReplyException)failure;
                this.sendEvents.add("receiveResponse[" + replyException.failureType() + "]");
            } else {
                Object body = response != null ? ((Message)response).body() : null;
                this.sendEvents.add("receiveResponse[]");
            }
        }
    }
}

