/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakedns;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.io.encoder.DnsMessageEncoder;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.protocol.DnsUdpDecoder;
import org.apache.directory.server.dns.protocol.DnsUdpEncoder;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;

public final class FakeDNSServer
extends DnsServer {
    public static final int PORT = 53530;
    public static final String IP_ADDRESS = "127.0.0.1";
    private String ipAddress = "127.0.0.1";
    private int port = 53530;
    private volatile RecordStore store;
    private DatagramAcceptor acceptor;
    private final Deque<DnsMessage> currentMessage = new ArrayDeque<DnsMessage>();

    public static RecordStore A_store(Map<String, String> entries) {
        return questionRecord -> entries.entrySet().stream().map(entry -> {
            ResourceRecordModifier rm = new ResourceRecordModifier();
            rm.setDnsClass(RecordClass.IN);
            rm.setDnsName((String)entry.getKey());
            rm.setDnsTtl(100);
            rm.setDnsType(RecordType.A);
            rm.put("apacheDnsIpAddress", (String)entry.getValue());
            return rm.getEntry();
        }).collect(Collectors.toSet());
    }

    public FakeDNSServer store(RecordStore store) {
        this.store = store;
        return this;
    }

    public synchronized DnsMessage pollMessage() {
        return this.currentMessage.poll();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.getTransports()[0].getAcceptor().getLocalAddress();
    }

    public FakeDNSServer ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public FakeDNSServer port(int p) {
        this.port = p;
        return this;
    }

    public FakeDNSServer testResolveA(String ipAddress) {
        return this.testResolveA(Collections.singletonMap("dns.vertx.io", ipAddress));
    }

    public FakeDNSServer testResolveA(Map<String, String> entries) {
        return this.store(FakeDNSServer.A_store(entries));
    }

    public FakeDNSServer testResolveAAAA(final String ipAddress) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.AAAA);
                rm.put("apacheDnsIpAddress", ipAddress);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveMX(final int prio, final String mxRecord) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.MX);
                rm.put("apacheDnsMxPreference", String.valueOf(prio));
                rm.put("apacheDnsDomainName", mxRecord);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveTXT(final String txt) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.TXT);
                rm.put("apacheDnsCharacterString", txt);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveNS(final String ns) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.NS);
                rm.put("apacheDnsDomainName", ns);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveCNAME(final String cname) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.CNAME);
                rm.put("apacheDnsDomainName", cname);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolvePTR(final String ptr) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.PTR);
                rm.put("apacheDnsDomainName", ptr);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveSRV(final int priority, final int weight, final int port, final String target) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.SRV);
                rm.put("apacheDnsServicePriority", String.valueOf(priority));
                rm.put("apacheDnsServiceWeight", String.valueOf(weight));
                rm.put("apacheDnsServicePort", String.valueOf(port));
                rm.put("apacheDnsDomainName", target);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testLookup4(final String ip) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.A);
                rm.put("apacheDnsIpAddress", ip);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testLookup6() {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.AAAA);
                rm.put("apacheDnsIpAddress", "::1");
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testLookup(String ip) {
        return this.testLookup4(ip);
    }

    public FakeDNSServer testLookupNonExisting() {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                return null;
            }
        });
    }

    public FakeDNSServer testReverseLookup(final String ptr) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.PTR);
                rm.put("apacheDnsDomainName", ptr);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public FakeDNSServer testResolveASameServer(String ipAddress) {
        return this.store(FakeDNSServer.A_store(Collections.singletonMap("vertx.io", ipAddress)));
    }

    public FakeDNSServer testLookup4CNAME(final String cname, final String ip) {
        return this.store(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                LinkedHashSet<ResourceRecord> set = new LinkedHashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.CNAME);
                rm.put("apacheDnsDomainName", cname);
                set.add(rm.getEntry());
                ResourceRecordModifier rm2 = new ResourceRecordModifier();
                rm2.setDnsClass(RecordClass.IN);
                rm2.setDnsName(cname);
                rm2.setDnsTtl(100);
                rm2.setDnsType(RecordType.A);
                rm2.put("apacheDnsIpAddress", ip);
                set.add(rm2.getEntry());
                return set;
            }
        });
    }

    public void start() throws IOException {
        UdpTransport transport = new UdpTransport(this.ipAddress, this.port);
        this.setTransports(new Transport[]{transport});
        this.acceptor = transport.getAcceptor();
        this.acceptor.setHandler((IoHandler)new DnsProtocolHandler(this, new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                RecordStore actual = FakeDNSServer.this.store;
                if (actual == null) {
                    return Collections.emptySet();
                }
                return actual.getRecords(question);
            }
        }){

            public void sessionCreated(IoSession session) throws Exception {
                session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TestDnsProtocolUdpCodecFactory()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(IoSession session, Object message) {
                if (message instanceof DnsMessage) {
                    FakeDNSServer fakeDNSServer = FakeDNSServer.this;
                    synchronized (fakeDNSServer) {
                        FakeDNSServer.this.currentMessage.add((DnsMessage)message);
                    }
                }
                super.messageReceived(session, message);
            }
        });
        ((DatagramSessionConfig)this.acceptor.getSessionConfig()).setReuseAddress(true);
        this.acceptor.bind();
    }

    public void stop() {
        this.acceptor.dispose();
    }

    private final class TestDnsProtocolUdpCodecFactory
    implements ProtocolCodecFactory {
        private DnsMessageEncoder encoder = new DnsMessageEncoder();
        private TestAAAARecordEncoder recordEncoder = new TestAAAARecordEncoder();

        private TestDnsProtocolUdpCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
            return new DnsUdpEncoder(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
                    IoBuffer buf = IoBuffer.allocate((int)1024);
                    DnsMessage dnsMessage = (DnsMessage)message;
                    TestDnsProtocolUdpCodecFactory.this.encoder.encode(buf, dnsMessage);
                    for (ResourceRecord record : dnsMessage.getAnswerRecords()) {
                        if (record.getRecordType() != RecordType.AAAA) continue;
                        try {
                            TestDnsProtocolUdpCodecFactory.this.recordEncoder.put(buf, record);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    buf.flip();
                    out.write((Object)buf);
                }
            };
        }

        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
            return new DnsUdpDecoder();
        }

        private final class TestAAAARecordEncoder
        extends ResourceRecordEncoder {
            private TestAAAARecordEncoder() {
            }

            protected void putResourceRecordData(IoBuffer ioBuffer, ResourceRecord resourceRecord) {
                if (!resourceRecord.get("apacheDnsIpAddress").equals("::1")) {
                    throw new IllegalStateException("Only supposed to be used with IPV6 address of ::1");
                }
                ioBuffer.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            }
        }
    }
}

