/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.fakedns.FakeDNSServer;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class VertxStartFailureTest
extends AsyncTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventBusStartFailure() throws Exception {
        FakeDNSServer dnsServer = new FakeDNSServer().testResolveASameServer("127.0.0.1");
        dnsServer.start();
        try {
            InetSocketAddress dnsServerAddress = dnsServer.localAddress();
            String hostName = "zoom.zoom.zen.tld";
            FakeClusterManager clusterManager = new FakeClusterManager();
            VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)clusterManager);
            options.getAddressResolverOptions().addServer(dnsServerAddress.getAddress().getHostAddress() + ":" + dnsServerAddress.getPort());
            options.getEventBusOptions().setHost(hostName);
            Throwable failure = this.failStart(options);
            this.assertTrue("Was expecting failure to be an instance of UnknownHostException", failure instanceof UnknownHostException);
        }
        finally {
            dnsServer.stop();
        }
    }

    @Test
    public void testClusterManagerStartFailure() throws Exception {
        final Exception expected = new Exception();
        FakeClusterManager clusterManager = new FakeClusterManager(){

            @Override
            public void join(Promise<Void> promise) {
                promise.fail((Throwable)expected);
            }
        };
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)clusterManager);
        Throwable failure = this.failStart(options);
        this.assertSame(expected, failure);
    }

    @Test
    public void testHAManagerGetMapFailure() throws Exception {
        final RuntimeException expected = new RuntimeException();
        FakeClusterManager clusterManager = new FakeClusterManager(){

            @Override
            public <K, V> Map<K, V> getSyncMap(String name) {
                throw expected;
            }
        };
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)clusterManager);
        Throwable failure = this.failStart(options);
        this.assertSame(expected, failure);
    }

    @Test
    public void testHAManagerInitFailure() throws Exception {
        final RuntimeException expected = new RuntimeException();
        FakeClusterManager clusterManager = new FakeClusterManager(){

            @Override
            public void nodeListener(NodeListener listener) {
                throw expected;
            }
        };
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)clusterManager);
        Throwable failure = this.failStart(options);
        this.assertSame(expected, failure);
    }

    private Throwable failStart(VertxOptions options) throws Exception {
        final ArrayList loops = new ArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        Transport transport = new Transport(){

            public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
                EventLoopGroup eventLoop = super.eventLoopGroup(type, nThreads, threadFactory, ioRatio);
                loops.add(eventLoop);
                return eventLoop;
            }
        };
        AtomicReference resultRef = new AtomicReference();
        new VertxBuilder(options).init().transport(transport).clusteredVertx(ar -> {
            resultRef.set(ar);
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertFalse(resultRef.get() == null);
        this.assertTrue(((AsyncResult)resultRef.get()).failed());
        loops.forEach(loop -> VertxStartFailureTest.waitUntil(() -> loop.isShutdown()));
        return ((AsyncResult)resultRef.get()).cause();
    }
}

