/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.handler.codec.DecoderException;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpServerFileUploadTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    protected File testDir;
    private File tmp;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testDir = this.testFolder.newFolder();
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
            this.requestOptions.setServer(this.testAddress);
        }
    }

    @Test
    public void testFormUploadEmptyFile() {
        this.testFormUploadFile("", false, false, false);
    }

    @Test
    public void testFormUploadSmallFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), false, false, false);
    }

    @Test
    public void testFormUploadMediumFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), false, false, false);
    }

    @Test
    public void testFormUploadLargeFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), false, false, false);
    }

    @Test
    public void testFormUploadEmptyFileStreamToDisk() {
        this.testFormUploadFile("", true, false, false);
    }

    @Test
    public void testFormUploadSmallFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, false, false);
    }

    @Test
    public void testFormUploadMediumFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, false, false);
    }

    @Test
    public void testFormUploadLargeFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, false, false);
    }

    @Test
    public void testFormUploadWithExtFilename() {
        this.testFormUploadFile(null, "%c2%a3%20and%20%e2%82%ac%20rates", "the-content", true, false, false);
    }

    @Test
    public void testBrokenFormUploadEmptyFile() {
        this.testFormUploadFile("", true, true, false);
    }

    @Test
    public void testBrokenFormUploadSmallFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, true, false);
    }

    @Test
    public void testBrokenFormUploadMediumFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, true, false);
    }

    @Test
    public void testBrokenFormUploadLargeFile() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, true, false);
    }

    @Test
    public void testBrokenFormUploadEmptyFileStreamToDisk() {
        this.testFormUploadFile("", true, true, false);
    }

    @Test
    public void testBrokenFormUploadSmallFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, true, false);
    }

    @Test
    public void testBrokenFormUploadMediumFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, true, false);
    }

    @Test
    public void testBrokenFormUploadLargeFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, true, false);
    }

    @Test
    public void testCancelFormUploadEmptyFileStreamToDisk() {
        this.testFormUploadFile("", true, false, true);
    }

    @Test
    public void testCancelFormUploadSmallFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true, false, true);
    }

    @Test
    public void testCancelFormUploadMediumFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(20480), true, false, true);
    }

    @Test
    public void testCancelFormUploadLargeFileStreamToDisk() {
        this.testFormUploadFile(TestUtils.randomAlphaString(0x400000), true, false, true);
    }

    private void testFormUploadFile(String contentStr, boolean streamToDisk, boolean abortClient, boolean cancelStream) {
        this.testFormUploadFile("tmp-0.txt", "tmp-0.txt", contentStr, streamToDisk, abortClient, cancelStream);
    }

    private void testFormUploadFile(String filename, String extFilename, String contentStr, boolean streamToDisk, boolean abortClient, boolean cancelStream) {
        String expectedFilename;
        try {
            expectedFilename = extFilename != null ? URLDecoder.decode(extFilename, "UTF-8") : filename;
        }
        catch (UnsupportedEncodingException e) {
            this.fail(e);
            return;
        }
        this.waitFor(2);
        Buffer content = Buffer.buffer((String)contentStr);
        AtomicInteger attributeCount = new AtomicInteger();
        AtomicReference clientConn = new AtomicReference();
        AtomicReference serverConn = new AtomicReference();
        Runnable checkClose = () -> {
            if (clientConn.get() != null && serverConn.get() != null) {
                ((HttpConnection)clientConn.get()).close();
            }
        };
        this.server.requestHandler(req -> {
            Context requestContext = this.vertx.getOrCreateContext();
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.uploadHandler(upload -> {
                    Context uploadContext = Vertx.currentContext();
                    this.assertNotNull(uploadContext);
                    this.assertSame(requestContext, uploadContext);
                    serverConn.set(req.connection());
                    checkClose.run();
                    Buffer tot = Buffer.buffer();
                    this.assertEquals("file", upload.name());
                    this.assertEquals(expectedFilename, upload.filename());
                    this.assertEquals("image/gif", upload.contentType());
                    if (!streamToDisk) {
                        upload.handler(arg_0 -> ((Buffer)tot).appendBuffer(arg_0));
                        upload.exceptionHandler(err -> {
                            this.assertTrue(abortClient);
                            this.complete();
                        });
                        upload.endHandler(v -> {
                            this.assertFalse(abortClient);
                            this.assertEquals(content, tot);
                            this.assertTrue(upload.isSizeAvailable());
                            this.assertEquals(content.length(), upload.size());
                            this.assertNull(upload.file());
                            this.complete();
                        });
                    } else {
                        BooleanSupplier test;
                        String uploadedFileName = new File(this.testDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName, ar -> {
                            if (ar.succeeded()) {
                                Buffer uploaded = this.vertx.fileSystem().readFileBlocking(uploadedFileName);
                                this.assertEquals(content.length(), uploaded.length());
                                this.assertEquals(content, uploaded);
                                AsyncFile file = upload.file();
                                this.assertNotNull(file);
                                try {
                                    file.flush();
                                    this.fail("Was expecting uploaded file to be closed");
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                this.assertTrue(ar.failed());
                            }
                            this.complete();
                        });
                        if (cancelStream && !(test = () -> {
                            File f = new File(uploadedFileName);
                            if (f.length() == (long)(contentStr.length() / 2)) {
                                this.assertTrue(upload.cancelStreamToFileSystem());
                                long now = System.currentTimeMillis();
                                this.vertx.setPeriodic(10L, id -> {
                                    this.assertTrue(System.currentTimeMillis() - now < 20000L);
                                    if (!new File(uploadedFileName).exists()) {
                                        this.vertx.cancelTimer(id.longValue());
                                        req.response().end();
                                    }
                                });
                                return true;
                            }
                            return false;
                        }).getAsBoolean()) {
                            long now = System.currentTimeMillis();
                            this.vertx.setPeriodic(10L, id -> {
                                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                                if (test.getAsBoolean()) {
                                    this.vertx.cancelTimer(id.longValue());
                                }
                            });
                        }
                    }
                });
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/form")).onComplete(this.onSuccess(req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            String epi = "\r\n--" + boundary + "--\r\n";
            String pro = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"" + (filename == null ? "" : "; filename=\"" + filename + "\"") + (extFilename == null ? "" : "; filename*=\"UTF-8''" + extFilename) + "\"\r\nContent-Type: image/gif\r\n\r\n";
            req.headers().set("content-length", "" + (pro + contentStr + epi).length());
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            if (abortClient || cancelStream) {
                Future fut = req.write(pro + contentStr.substring(0, contentStr.length() / 2));
                if (abortClient) {
                    fut.onComplete(this.onSuccess(v -> {
                        clientConn.set(req.connection());
                        checkClose.run();
                    }));
                }
            } else {
                req.end(pro + contentStr + epi);
            }
            if (abortClient) {
                req.response(this.onFailure(err -> this.complete()));
            } else {
                req.response(this.onSuccess(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                    this.assertEquals(0L, attributeCount.get());
                    this.complete();
                }));
            }
        }))));
        this.await();
    }

    @Test
    public void testFormUploadAttributes() throws Exception {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                req.uploadHandler(upload -> upload.handler(buffer -> this.fail("Should get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("vert x", attrs.get("framework"));
                    this.assertEquals("vert x", req.getFormAttribute("framework"));
                    this.assertEquals("vert x", req.formAttributes().get("framework"));
                    this.assertEquals(Collections.singletonList("vert x"), req.formAttributes().getAll("framework"));
                    this.assertEquals("jvm", attrs.get("runson"));
                    this.assertEquals("jvm", req.getFormAttribute("runson"));
                    this.assertEquals("jvm", req.formAttributes().get("runson"));
                    this.assertEquals(Collections.singletonList("jvm"), req.formAttributes().getAll("runson"));
                    this.assertEquals("0", attrs.get("list"));
                    this.assertEquals("0", req.getFormAttribute("list"));
                    this.assertEquals("0", req.formAttributes().get("list"));
                    this.assertEquals(Arrays.asList("0", "1"), req.formAttributes().getAll("list"));
                    req.response().end();
                });
            }
        });
        Buffer buffer = Buffer.buffer();
        buffer.appendString("framework=" + URLEncoder.encode("vert x", "UTF-8") + "&runson=jvm&list=0&list=1", "UTF-8");
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/form"), this.onSuccess(req -> req.putHeader("content-length", String.valueOf(buffer.length())).putHeader("content-type", "application/x-www-form-urlencoded").send(buffer, this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
            this.assertEquals(3L, attributeCount.get());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testFormUploadAttributes2() {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.setExpectMultipart(true);
                req.uploadHandler(event -> event.handler(buffer -> this.fail("Should not get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("junit-testUserAlias", attrs.get("origin"));
                    this.assertEquals("admin@foo.bar", attrs.get("login"));
                    this.assertEquals("admin", attrs.get("pass word"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=junit-testUserAlias&login=admin%40foo.bar&pass+word=admin");
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/form")).onComplete(this.onSuccess(req -> req.putHeader("content-length", String.valueOf(buffer.length())).putHeader("content-type", "application/x-www-form-urlencoded").response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(3L, attributeCount.get());
                this.testComplete();
            })).end(buffer)));
        }));
        this.await();
    }

    @Test
    public void testAttributeSizeOverflow() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setMaxFormAttributeSize(9));
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                AtomicReference err = new AtomicReference();
                req.setExpectMultipart(true).exceptionHandler(err::set).endHandler(v -> {
                    this.assertNotNull(err.get());
                    this.assertTrue(err.get() instanceof DecoderException);
                    this.assertTrue(((Throwable)err.get()).getMessage().contains("Size exceed allowed maximum capacity"));
                    this.assertEquals(0L, req.formAttributes().size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=0123456789");
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/form")).onComplete(this.onSuccess(req -> req.putHeader("content-length", String.valueOf(buffer.length())).putHeader("content-type", "application/x-www-form-urlencoded").response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            })).end(buffer)));
        }));
        this.await();
    }

    @Test
    public void testInvalidPostFileUpload() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            AtomicInteger errCount = new AtomicInteger();
            req.exceptionHandler(err -> errCount.incrementAndGet());
            req.endHandler(v -> {
                this.assertTrue(errCount.get() > 0);
                this.testComplete();
            });
        });
        this.startServer(this.testAddress);
        String contentType = "multipart/form-data; boundary=a4e41223-a527-49b6-ac1c-315d76be757e";
        String body = "--a4e41223-a527-49b6-ac1c-315d76be757e\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif; charset=ABCD\r\nContent-Length: 12\r\n\r\nsome-content\r\n--a4e41223-a527-49b6-ac1c-315d76be757e--\r\n";
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/form"), this.onSuccess(req -> {
            req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            req.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)("" + body.length()));
            req.end(body);
        }));
        this.await();
    }
}

