/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.json.EncodeException;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class JacksonTest
extends VertxTestBase {
    private final JacksonCodec codec = new JacksonCodec();

    @Test
    public void testEncodeUnknownNumber() {
        String result = this.codec.toString((Object)new Number(){

            @Override
            public int intValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long longValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public float floatValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public double doubleValue() {
                return 4.0;
            }
        });
        this.assertEquals("4.0", result);
    }

    @Test
    public void testEncodePojoFailure() {
        try {
            this.codec.toString((Object)new MyPojo());
            this.fail();
        }
        catch (EncodeException e) {
            this.assertTrue(e.getMessage().contains(MyPojo.class.getName()));
        }
    }

    public static class MyPojo {
    }
}

