/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.test.core.VertxTestBase;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import org.hamcrest.CoreMatchers;
import org.junit.Assume;
import org.junit.Test;

public class KeyStoreHelperTest
extends VertxTestBase {
    @Test
    public void testKeyStoreHelperSupportsRSAPrivateKeys() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions().addKeyPath("target/test-classes/tls/server-key.pem").addCertPath("target/test-classes/tls/server-cert.pem");
        KeyStoreHelper helper = options.getHelper(this.vertx);
        this.assertKeyType(helper.store(), RSAPrivateKey.class);
    }

    @Test
    public void testKeyStoreHelperSupportsECPrivateKeys() throws Exception {
        Assume.assumeTrue((String)"ECC is not supported by VM's security providers", (boolean)this.isECCSupportedByVM());
        PemKeyCertOptions options = new PemKeyCertOptions().addKeyPath("target/test-classes/tls/server-key-ec.pem").addCertPath("target/test-classes/tls/server-cert-ec.pem");
        KeyStoreHelper helper = options.getHelper(this.vertx);
        this.assertKeyType(helper.store(), ECPrivateKey.class);
    }

    private void assertKeyType(KeyStore store, Class<?> expectedKeyType) throws KeyStoreException, GeneralSecurityException {
        this.assertTrue(store.size() > 0);
        Enumeration<String> e = store.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.assertThat(store.getKey(alias, "dummy".toCharArray()), CoreMatchers.instanceOf(expectedKeyType));
            this.assertThat(store.getCertificate(alias), CoreMatchers.instanceOf(X509Certificate.class));
        }
    }

    private boolean isECCSupportedByVM() {
        try {
            KeyFactory.getInstance("EC");
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

