/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.net.impl.pool.CombinerExecutor;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.test.core.AsyncTestBase;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;

public class SynchronizationTest
extends AsyncTestBase {
    static long iterationsForOneMilli = Utils.calibrateBlackhole();

    private static void burnCPU(long cpu) {
        long target_delay = Utils.ONE_MICRO_IN_NANO * cpu;
        long num_iters = Math.round((double)target_delay * 1.0 * (double)iterationsForOneMilli / (double)Utils.ONE_MILLI_IN_NANO);
        Utils.blackholeCpu(num_iters);
    }

    @Test
    public void testActionReentrancy() throws Exception {
        AtomicBoolean isReentrant1 = new AtomicBoolean();
        AtomicBoolean isReentrant2 = new AtomicBoolean();
        CombinerExecutor sync = new CombinerExecutor(new Object());
        CountDownLatch latch = new CountDownLatch(2);
        sync.submit(arg_0 -> SynchronizationTest.lambda$testActionReentrancy$2((Executor)sync, isReentrant1, latch, isReentrant2, arg_0));
        this.awaitLatch(latch);
        this.assertFalse(isReentrant1.get());
        this.assertFalse(isReentrant2.get());
    }

    @Test
    public void testPostTaskReentrancy() throws Exception {
        AtomicBoolean isReentrant1 = new AtomicBoolean();
        AtomicBoolean isReentrant2 = new AtomicBoolean();
        CombinerExecutor sync = new CombinerExecutor(new Object());
        CountDownLatch latch = new CountDownLatch(1);
        sync.submit(arg_0 -> SynchronizationTest.lambda$testPostTaskReentrancy$6((Executor)sync, isReentrant1, latch, isReentrant2, arg_0));
        this.awaitLatch(latch);
        this.assertFalse(isReentrant1.get());
        this.assertFalse(isReentrant2.get());
    }

    @Test
    public void testFoo() throws Exception {
        int numThreads = 8;
        int numIter = 100000;
        CombinerExecutor sync = new CombinerExecutor(new Object());
        Executor.Action action = s -> {
            SynchronizationTest.burnCPU(10L);
            return null;
        };
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(() -> SynchronizationTest.lambda$testFoo$8(numIter, (Executor)sync, action));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    private static /* synthetic */ void lambda$testFoo$8(int numIter, Executor sync, Executor.Action action) {
        for (int j = 0; j < numIter; ++j) {
            if (j % 1000 == 0) {
                System.out.println("Thread " + Thread.currentThread() + " " + j / 1000);
            }
            sync.submit(action);
        }
    }

    private static /* synthetic */ Runnable lambda$testPostTaskReentrancy$6(Executor sync, AtomicBoolean isReentrant1, CountDownLatch latch, AtomicBoolean isReentrant2, Object state1) {
        return () -> {
            AtomicBoolean inCallback = new AtomicBoolean();
            inCallback.set(true);
            try {
                sync.submit(state2 -> {
                    isReentrant1.set(inCallback.get());
                    latch.countDown();
                    return () -> {
                        isReentrant2.set(inCallback.get());
                        latch.countDown();
                    };
                });
            }
            finally {
                inCallback.set(false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Runnable lambda$testActionReentrancy$2(Executor sync, AtomicBoolean isReentrant1, CountDownLatch latch, AtomicBoolean isReentrant2, Object state1) {
        AtomicBoolean inCallback = new AtomicBoolean();
        inCallback.set(true);
        try {
            sync.submit(state2 -> {
                isReentrant1.set(inCallback.get());
                latch.countDown();
                return () -> {
                    isReentrant2.set(inCallback.get());
                    latch.countDown();
                };
            });
        }
        finally {
            inCallback.set(false);
        }
        return null;
    }

    public static class Utils {
        public static long res = 0L;
        public static long ONE_MILLI_IN_NANO = 1000000L;
        public static long ONE_MICRO_IN_NANO = 1000L;

        public static void blackholeCpu(long iterations) {
            long result = 0L;
            int i = 0;
            while ((long)i < iterations) {
                int next = ThreadLocalRandom.current().nextInt() % 1019 / 17;
                result ^= Math.round(Math.pow(next, 3.0)) % 251L;
                ++i;
            }
            res += result;
        }

        public static long calibrateBlackhole() {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            for (int i = 0; i < 50000; ++i) {
                Utils.blackholeCpu(100L);
            }
            long[] iters = new long[]{1000L, 5000L, 10000L, 20000L, 50000L, 100000L};
            long timing = 0L;
            int i = -1;
            while (timing < ONE_MILLI_IN_NANO && ++i < iters.length) {
                long start_cpu = threadBean.getCurrentThreadCpuTime();
                Utils.blackholeCpu(iters[i]);
                timing = threadBean.getCurrentThreadCpuTime() - start_cpu;
            }
            return Math.round(Math.ceil((double)ONE_MILLI_IN_NANO * 1.0 / (double)timing * (double)iters[i]));
        }
    }
}

