/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.fakemetrics.EndpointMetric;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;

public class FakeHttpClientMetrics
extends FakeMetricsBase
implements HttpClientMetrics<HttpClientMetric, WebSocketMetric, SocketMetric, Void> {
    static volatile Throwable unexpectedError;
    private final String name;
    private final ConcurrentMap<SocketAddress, SocketMetric> sockets = new ConcurrentHashMap<SocketAddress, SocketMetric>();
    private final ConcurrentMap<WebSocketBase, WebSocketMetric> webSockets = new ConcurrentHashMap<WebSocketBase, WebSocketMetric>();
    private final ConcurrentMap<SocketAddress, EndpointMetric> endpoints = new ConcurrentHashMap<SocketAddress, EndpointMetric>();

    public FakeHttpClientMetrics(String name) {
        this.name = name;
    }

    public WebSocketMetric getMetric(WebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws);
    }

    public HttpClientMetric getMetric(HttpClientRequest request) {
        for (EndpointMetric metric : this.endpoints.values()) {
            for (HttpRequest req : metric.requests.keySet()) {
                if (req.id() != request.streamId()) continue;
                return (HttpClientMetric)metric.requests.get(req);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> endpoints() {
        return this.endpoints.keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public EndpointMetric endpoint(String name) {
        for (Map.Entry entry : this.endpoints.entrySet()) {
            if (!((SocketAddress)entry.getKey()).toString().equalsIgnoreCase(name)) continue;
            return (EndpointMetric)entry.getValue();
        }
        return null;
    }

    public Integer queueSize(String name) {
        EndpointMetric server = this.endpoint(name);
        return server != null ? Integer.valueOf(server.queueSize.get()) : null;
    }

    public Integer connectionCount(String name) {
        EndpointMetric server = this.endpoint(name);
        return server != null ? Integer.valueOf(server.connectionCount.get()) : null;
    }

    public ClientMetrics<HttpClientMetric, Void, HttpRequest, HttpResponse> createEndpointMetrics(final SocketAddress remoteAddress, int maxPoolSize) {
        EndpointMetric metric = new EndpointMetric(){

            public void close() {
                FakeHttpClientMetrics.this.endpoints.remove(remoteAddress);
            }
        };
        this.endpoints.put(remoteAddress, metric);
        return metric;
    }

    public void endpointConnected(ClientMetrics<HttpClientMetric, Void, ?, ?> endpointMetric) {
        ((EndpointMetric)endpointMetric).connectionCount.incrementAndGet();
    }

    public void endpointDisconnected(ClientMetrics<HttpClientMetric, Void, ?, ?> endpointMetric) {
        ((EndpointMetric)endpointMetric).connectionCount.decrementAndGet();
    }

    public WebSocketMetric connected(WebSocket webSocket) {
        WebSocketMetric metric = new WebSocketMetric((WebSocketBase)webSocket);
        this.webSockets.put((WebSocketBase)webSocket, metric);
        return metric;
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.webSockets.remove(webSocketMetric.ws);
    }

    public SocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        SocketMetric metric = new SocketMetric(remoteAddress, remoteName);
        this.sockets.put(remoteAddress, metric);
        return metric;
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        this.sockets.remove(remoteAddress);
        socketMetric.connected.set(false);
    }

    public SocketMetric getSocket(SocketAddress address) {
        return (SocketMetric)this.sockets.get(address);
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
        socketMetric.bytesReadEvents.add(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
        socketMetric.bytesWrittenEvents.add(numberOfBytes);
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    public static void sanityCheck() {
        Throwable err = unexpectedError;
        if (err != null) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(err);
            throw afe;
        }
    }
}

