/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.impl.ClassLoaderHolder;
import io.vertx.core.impl.IsolatingClassLoader;
import io.vertx.core.impl.VerticleManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LoaderManager {
    private final Map<String, ClassLoaderHolder> classLoaders = new HashMap<String, ClassLoaderHolder>();

    LoaderManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderHolder getClassLoader(DeploymentOptions options) {
        ClassLoaderHolder holder;
        String isolationGroup = options.getIsolationGroup();
        if (isolationGroup == null) {
            return null;
        }
        LoaderManager loaderManager = this;
        synchronized (loaderManager) {
            holder = this.classLoaders.get(isolationGroup);
            if (holder == null) {
                ClassLoader current = VerticleManager.getCurrentClassLoader();
                if (!(current instanceof URLClassLoader)) {
                    throw new IllegalStateException("Current classloader must be URLClassLoader");
                }
                holder = new ClassLoaderHolder(isolationGroup, LoaderManager.buildLoader((URLClassLoader)current, options));
                this.classLoaders.put(isolationGroup, holder);
            }
            ++holder.refCount;
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(ClassLoaderHolder holder) {
        LoaderManager loaderManager = this;
        synchronized (loaderManager) {
            if (--holder.refCount == 0) {
                this.classLoaders.remove(holder.group);
                if (holder.loader instanceof Closeable) {
                    try {
                        ((Closeable)((Object)holder.loader)).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static ClassLoader buildLoader(URLClassLoader parent, DeploymentOptions options) {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<String> extraClasspath = options.getExtraClasspath();
        if (extraClasspath != null) {
            for (String pathElement : extraClasspath) {
                File file = new File(pathElement);
                try {
                    URL url = file.toURI().toURL();
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        urls.addAll(Arrays.asList(parent.getURLs()));
        return new IsolatingClassLoader(urls.toArray(new URL[0]), (ClassLoader)parent, options.getIsolatedClasses());
    }
}

