/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.impl.DefaultNodeSelector;
import io.vertx.test.core.VertxTestBase;
import java.util.Collections;
import org.junit.Test;

public final class WriteHandlerLookupFailureTest
extends VertxTestBase {
    private Vertx vertx;

    @Test
    public void test() {
        final Throwable cause = new Throwable();
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setHost("localhost").setPort(0);
        DefaultNodeSelector nodeSelector = new DefaultNodeSelector(){

            public void selectForSend(Message<?> message, Promise<String> promise) {
                promise.fail(cause);
            }

            public void selectForPublish(Message<?> message, Promise<Iterable<String>> promise) {
                promise.fail("Not implemented");
            }
        };
        new VertxBuilder(options).init().clusterNodeSelector((NodeSelector)nodeSelector).clusteredVertx(this.onSuccess(node -> {
            this.vertx = node;
            MessageProducer sender = this.vertx.eventBus().sender("foo");
            sender.write((Object)"the_string", this.onFailure(err -> {
                this.assertSame(cause, err);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.vertx != null) {
                this.closeClustered(Collections.singletonList(this.vertx));
            }
        }
        finally {
            super.tearDown();
        }
    }
}

