/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.WebSocketInternal;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.CheckingSender;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.proxy.HAProxy;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;

public class WebSocketTest
extends VertxTestBase {
    private static final String TEST_REASON = "I'm moving away!";
    private static final short TEST_STATUS_CODE = 1001;
    private HttpClient client;
    private HttpServer server;
    private NetServer netServer;
    Consumer<Handler<AsyncResult<HttpClientResponse>>> INVALID_MISSING_CONNECTION_HEADER = handler -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/some/path"), this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").send(handler)));
    Consumer<Handler<AsyncResult<HttpClientResponse>>> INVALID_HTTP_METHOD = handler -> this.client.request(new RequestOptions().setMethod(HttpMethod.HEAD).setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/some/path")).onComplete(this.onSuccess(req -> {
        req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade");
        req.send(handler);
    }));
    Consumer<Handler<AsyncResult<HttpClientResponse>>> INVALID_URI = handler -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(":")).onComplete(this.onSuccess(req -> {
        req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade");
        req.send(handler);
    }));
    Consumer<Handler<AsyncResult<HttpClientResponse>>> INVALID_WEBSOCKET_VERSION = handler -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/some/path"), this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Sec-Websocket-Version", "15").putHeader("Connection", "Upgrade").send(handler)));
    Consumer<Handler<AsyncResult<HttpClientResponse>>> HANDSHAKE_EXCEPTION = handler -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/some/path"), this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Sec-Websocket-Version", "13").putHeader("Connection", "Upgrade").send(handler)));
    final BlockingQueue<Throwable> resultQueue = new ArrayBlockingQueue<Throwable>(10);

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        CountDownLatch latch;
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            latch = new CountDownLatch(1);
            this.server.close(ar -> {
                this.assertTrue(ar.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        if (this.netServer != null) {
            latch = new CountDownLatch(1);
            this.netServer.close(ar -> {
                this.assertTrue(ar.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host2.com"));
        return options;
    }

    @Test
    public void testRejectHybi00() throws Exception {
        this.testReject(WebsocketVersion.V00, null, 502);
    }

    @Test
    public void testRejectHybi08() throws Exception {
        this.testReject(WebsocketVersion.V08, null, 502);
    }

    @Test
    public void testRejectWithStatusCode() throws Exception {
        this.testReject(WebsocketVersion.V08, 404, 404);
    }

    @Test
    public void testWSBinaryHybi00() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V00);
    }

    @Test
    public void testWSStringHybi00() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V00);
    }

    @Test
    public void testWSBinaryHybi08() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V08);
    }

    @Test
    public void testWSStringHybi08() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V08);
    }

    @Test
    public void testWSBinaryHybi17() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V13);
    }

    @Test
    public void testWSStringHybi17() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V13);
    }

    @Test
    public void testWSStreamsHybi00() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V00);
    }

    @Test
    public void testWSStreamsHybi08() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V08);
    }

    @Test
    public void testWSStreamsHybi17() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V13);
    }

    @Test
    public void testWriteFromConnectHybi00() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V00);
    }

    @Test
    public void testWriteFromConnectHybi08() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V08);
    }

    @Test
    public void testWriteFromConnectHybi17() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V13);
    }

    @Test
    public void testContinuationWriteFromConnectHybi08() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebsocketVersion.V08);
    }

    @Test
    public void testContinuationWriteFromConnectHybi17() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebsocketVersion.V13);
    }

    @Test
    public void testValidSubProtocolHybi00() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V00);
    }

    @Test
    public void testValidSubProtocolHybi08() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V08);
    }

    @Test
    public void testValidSubProtocolHybi17() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V13);
    }

    @Test
    public void testInvalidSubProtocolHybi00() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V00);
    }

    @Test
    public void testInvalidSubProtocolHybi08() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V08);
    }

    @Test
    public void testInvalidSubProtocolHybi17() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V13);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertWithSNI() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE, false, false, false, false, true, true, true, true, new String[0], (HttpClient client, Handler<AsyncResult<WebSocket>> handler) -> client.webSocket(4043, "host2.com", "/", handler));
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PKCS12, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PEM, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PKCS12, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(Cert.CLIENT_PKCS12, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE, false, false, false, true, false, new String[0]);
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA, true, true, false, false, false, new String[0]);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, ENABLED_CIPHER_SUITES);
    }

    @Test
    public void testClearClientRequestOptionsSetSSL() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(4043)).setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, false, true, false, new String[0], (HttpClient client, Handler<AsyncResult<WebSocket>> handler) -> client.webSocket(options, handler));
    }

    @Test
    public void testSSLClientRequestOptionsSetSSL() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(4043)).setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, true, true, false, new String[0], (HttpClient client, Handler<AsyncResult<WebSocket>> handler) -> client.webSocket(options, handler));
    }

    @Test
    public void testClearClientRequestOptionsSetClear() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(4043)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, false, false, false, new String[0], (HttpClient client, Handler<AsyncResult<WebSocket>> handler) -> client.webSocket(options, handler));
    }

    @Test
    public void testSSLClientRequestOptionsSetClear() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(4043)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, true, false, false, new String[0], (HttpClient client, Handler<AsyncResult<WebSocket>> handler) -> client.webSocket(options, handler));
    }

    private void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, String ... enabledCipherSuites) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, serverUsesCrl, clientTrustAll, clientUsesCrl, shouldPass, true, true, false, enabledCipherSuites, (HttpClient client, Handler<AsyncResult<WebSocket>> fut) -> client.webSocket(4043, "localhost", "/", fut));
    }

    private void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, boolean clientSsl, boolean serverSsl, boolean sni, String[] enabledCipherSuites, BiConsumer<HttpClient, Handler<AsyncResult<WebSocket>>> wsProvider) throws Exception {
        HttpClientOptions options = new HttpClientOptions();
        options.setSsl(clientSsl);
        options.setTrustAll(clientTrustAll);
        if (clientUsesCrl) {
            options.addCrlPath("tls/root-ca/crl.pem");
        }
        options.setTrustOptions((TrustOptions)clientTrust.get());
        options.setKeyCertOptions((KeyCertOptions)clientCert.get());
        for (String suite : enabledCipherSuites) {
            options.addEnabledCipherSuite(suite);
        }
        this.client = this.vertx.createHttpClient(options);
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setSsl(serverSsl);
        serverOptions.setSni(sni);
        serverOptions.setTrustOptions((TrustOptions)serverTrust.get());
        serverOptions.setKeyCertOptions((KeyCertOptions)serverCert.get());
        if (requireClientAuth) {
            serverOptions.setClientAuth(ClientAuth.REQUIRED);
        }
        if (serverUsesCrl) {
            serverOptions.addCrlPath("tls/root-ca/crl.pem");
        }
        for (String suite : enabledCipherSuites) {
            serverOptions.addEnabledCipherSuite(suite);
        }
        this.server = this.vertx.createHttpServer(serverOptions.setPort(4043));
        this.server.webSocketHandler(ws -> ws.handler(arg_0 -> ((ServerWebSocket)ws).write(arg_0)));
        try {
            this.server.listen(ar -> {
                this.assertTrue(ar.succeeded());
                Handler handler = ar2 -> {
                    if (ar2.succeeded()) {
                        WebSocket ws = (WebSocket)ar2.result();
                        if (clientSsl && sni) {
                            try {
                                Certificate clientPeerCert = (Certificate)ws.peerCertificates().get(0);
                                this.assertEquals("host2.com", TestUtils.cnOf(clientPeerCert));
                            }
                            catch (Exception err) {
                                this.fail(err);
                            }
                        }
                        int size = 100;
                        Buffer received = Buffer.buffer();
                        ws.handler(data -> {
                            received.appendBuffer(data);
                            if (received.length() == size) {
                                ws.close();
                                this.testComplete();
                            }
                        });
                        Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(size));
                        ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
                    } else if (shouldPass) {
                        ar2.cause().printStackTrace();
                        this.fail("Should not throw exception");
                    } else {
                        this.testComplete();
                    }
                };
                wsProvider.accept(this.client, handler);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.await();
    }

    @Test
    public void testHandleWSManually() throws Exception {
        String path = "/some/path";
        String message = "here is some text data";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> this.getUpgradedNetSocket((HttpServerRequest)req, path).onComplete(this.onSuccess(sock -> {
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)-127);
            buff.appendByte((byte)message.length());
            buff.appendString(message);
            sock.write((Object)buff);
        })));
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> ws.handler(buff -> {
                this.assertEquals(message, buff.toString("UTF-8"));
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        int numServers = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE / 2 - 1;
        int numConnections = numServers * 100;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
            servers.add(theServer);
            theServer.webSocketHandler(arg_0 -> WebSocketTest.lambda$testSharedServersRoundRobin$17((Set)connectedServers, theServer, connectCount, latchConns, arg_0)).listen(ar -> {
                if (ar.succeeded()) {
                    latchListen.countDown();
                } else {
                    this.fail("Failed to bind server");
                }
            });
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        this.client = this.vertx.createHttpClient();
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                ws.closeHandler(v -> latchClient.countDown());
                ws.close();
            }));
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> i = connectCount.values().iterator();
        while (i.hasNext()) {
            int cnt = (Integer)i.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.webSocketHandler(ws -> this.fail("Should not connect")).listen(ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.webSocketHandler(ws -> this.fail("Should not connect")).listen(ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        theServer.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testWebSocketFrameFactoryArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> WebSocketFrame.binaryFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.textFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.continuationFrame(null, (boolean)true));
    }

    private String sha1(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] bytes = md.digest(s.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new InternalError("Failed to compute sha-1");
        }
    }

    private Future<NetSocket> getUpgradedNetSocket(HttpServerRequest req, String path) {
        this.assertEquals(path, req.path());
        this.assertEquals("upgrade", req.headers().get("Connection"));
        String secHeader = req.headers().get("Sec-WebSocket-Key");
        String tmp = secHeader + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        String encoded = this.sha1(tmp);
        return ((Http1xServerConnection)req.connection()).netSocket().onSuccess(sock -> sock.write("HTTP/1.1 101 Web Socket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: upgrade\r\nSec-WebSocket-Accept: " + encoded + "\r\n\r\n"));
    }

    private void testWSWriteStream(WebsocketVersion version) throws Exception {
        String host = "localhost:8080";
        String scheme = "http";
        String path = "/some/path";
        String query = "handshake=bar&wibble=eek";
        String uri = path + "?" + query;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals(host, ws.host());
            this.assertEquals(scheme, ws.scheme());
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            ws.handler(data -> ws.write(data));
        });
        this.server.listen(this.onSuccess(s -> {
            int bsize = 100;
            int sends = 10;
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path + "?" + query).setVersion(version);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == bsize * sends) {
                        ws.close();
                        this.testComplete();
                    }
                });
                Buffer sent = Buffer.buffer();
                for (int i = 0; i < sends; ++i) {
                    Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                    ws.write((Object)buff);
                    sent.appendBuffer(buff);
                }
            }));
        }));
        this.await();
    }

    private void testWSFrames(boolean binary, WebsocketVersion version) throws Exception {
        String host = "localhost:8080";
        String scheme = "http";
        String path = "/some/path";
        String query = "handshake=bar&wibble=eek";
        String uri = path + "?" + query;
        int frames = version == WebsocketVersion.V00 ? 1 : 10;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals(host, ws.host());
            this.assertEquals(scheme, ws.scheme());
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            AtomicInteger count = new AtomicInteger();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    this.testComplete();
                } else {
                    if (count.get() == 0) {
                        if (binary) {
                            this.assertTrue(frame.isBinary());
                            this.assertFalse(frame.isText());
                        } else {
                            this.assertFalse(frame.isBinary());
                            this.assertTrue(frame.isText());
                        }
                        this.assertFalse(frame.isContinuation());
                    } else {
                        this.assertFalse(frame.isBinary());
                        this.assertFalse(frame.isText());
                        this.assertTrue(frame.isContinuation());
                    }
                    if (count.get() == frames - 1) {
                        this.assertTrue(frame.isFinal());
                    } else {
                        this.assertFalse(frame.isFinal());
                    }
                    ws.writeFrame(frame);
                    if (count.incrementAndGet() == frames) {
                        count.set(0);
                    }
                }
            });
        });
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path + "?" + query).setVersion(version);
            this.client = this.vertx.createHttpClient();
            int bsize = 100;
            int msgs = 10;
            this.client.webSocket(options, this.onSuccess(ws -> {
                ArrayList<Buffer> sent = new ArrayList<Buffer>();
                ArrayList received = new ArrayList();
                String webSocketLocation = ws.headers().get("sec-websocket-location");
                if (version == WebsocketVersion.V00) {
                    this.assertEquals("ws://localhost:8080" + uri, webSocketLocation);
                } else {
                    this.assertNull(webSocketLocation);
                }
                AtomicReference<Buffer> currentReceived = new AtomicReference<Buffer>(Buffer.buffer());
                ws.frameHandler(frame -> {
                    ((Buffer)currentReceived.get()).appendBuffer(frame.binaryData());
                    if (frame.isFinal()) {
                        received.add(currentReceived.get());
                        currentReceived.set(Buffer.buffer());
                    }
                    if (received.size() == msgs) {
                        int pos = 0;
                        for (Buffer rec : received) {
                            this.assertEquals(rec, sent.get(pos++));
                        }
                        ws.close();
                    }
                });
                AtomicReference<Buffer> currentSent = new AtomicReference<Buffer>(Buffer.buffer());
                for (int i = 0; i < msgs; ++i) {
                    for (int j = 0; j < frames; ++j) {
                        WebSocketFrame frame2;
                        Buffer buff;
                        if (binary) {
                            buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                            frame2 = j == 0 ? WebSocketFrame.binaryFrame((Buffer)buff, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                        } else {
                            String str = TestUtils.randomAlphaString(bsize);
                            buff = Buffer.buffer((String)str);
                            frame2 = j == 0 ? WebSocketFrame.textFrame((String)str, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                        }
                        currentSent.get().appendBuffer(buff);
                        ws.writeFrame(frame2);
                        if (j != frames - 1) continue;
                        sent.add(currentSent.get());
                        currentSent.set(Buffer.buffer());
                    }
                }
            }));
        }));
        this.await();
    }

    @Test
    public void testWriteFinalTextFrame() throws Exception {
        this.testWriteFinalFrame(false);
    }

    @Test
    public void testWriteFinalBinaryFrame() throws Exception {
        this.testWriteFinalFrame(true);
    }

    private void testWriteFinalFrame(boolean binary) throws Exception {
        this.waitFor(2);
        String text = TestUtils.randomUnicodeString(100);
        Buffer data = TestUtils.randomBuffer(100);
        Consumer<WebSocketFrame> frameConsumer = frame -> {
            if (binary) {
                this.assertTrue(frame.isBinary());
                this.assertFalse(frame.isText());
                this.assertEquals(data, frame.binaryData());
            } else {
                this.assertFalse(frame.isBinary());
                this.assertTrue(frame.isText());
                this.assertEquals(text, frame.textData());
            }
            this.assertTrue(frame.isFinal());
        };
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> ws.frameHandler(frame -> {
            if (frame.isClose()) {
                this.complete();
            } else {
                frameConsumer.accept((WebSocketFrame)frame);
                if (binary) {
                    ws.writeFinalBinaryFrame(frame.binaryData());
                } else {
                    ws.writeFinalTextFrame(frame.textData());
                }
            }
        }));
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ws.frameHandler(frame -> {
                    if (frame.isClose()) {
                        this.complete();
                    } else {
                        frameConsumer.accept((WebSocketFrame)frame);
                        ws.close();
                    }
                });
                if (binary) {
                    ws.writeFinalBinaryFrame(data);
                } else {
                    ws.writeFinalTextFrame(text);
                }
            }));
        }));
        this.await();
    }

    private void testContinuationWriteFromConnectHandler(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String firstFrame = "AAA";
        String continuationFrame = "BBB";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> this.getUpgradedNetSocket((HttpServerRequest)req, path).onComplete(this.onSuccess(sock -> {
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)1);
            buff.appendByte((byte)firstFrame.length());
            buff.appendString(firstFrame);
            sock.write((Object)buff);
            buff = Buffer.buffer();
            buff.appendByte((byte)-128);
            buff.appendByte((byte)continuationFrame.length());
            buff.appendString(continuationFrame);
            sock.write((Object)buff);
        })));
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                AtomicBoolean receivedFirstFrame = new AtomicBoolean();
                ws.frameHandler(received -> {
                    Buffer receivedBuffer = Buffer.buffer((String)received.textData());
                    if (!received.isFinal()) {
                        this.assertEquals(firstFrame, receivedBuffer.toString());
                        receivedFirstFrame.set(true);
                    } else if (receivedFirstFrame.get() && received.isFinal()) {
                        this.assertEquals(continuationFrame, receivedBuffer.toString());
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    private void testWriteFromConnectHandler(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testNormalWSDeflateFrameCompressionNegotiation() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("deflate-frame", ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientOptions options = new HttpClientOptions();
            options.setTryUsePerFrameWebSocketCompression(true);
            this.client = this.vertx.createHttpClient(options);
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        });
        this.await();
    }

    @Test
    public void testNormalWSPermessageDeflateCompressionNegotiation() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("permessage-deflate;client_max_window_bits", ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientOptions options = new HttpClientOptions();
            options.setTryUsePerMessageWebSocketCompression(true);
            this.client = this.vertx.createHttpClient(options);
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        });
        this.await();
    }

    @Test
    public void testWSPermessageDeflateCompressionEnabled() {
        this.waitFor(2);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("permessage-deflate", ws.headers().get("sec-websocket-extensions"));
            this.complete();
        });
        this.server.listen(8080, "localhost", this.onSuccess(ar -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/"), this.onSuccess(req -> req.putHeader("origin", "localhost").putHeader("Upgrade", "Websocket").putHeader("Connection", "upgrade").putHeader("Sec-WebSocket-Extensions", "permessage-deflate").send(this.onSuccess(resp -> {
            this.assertEquals(101L, resp.statusCode());
            this.assertEquals("permessage-deflate", resp.headers().get("sec-websocket-extensions"));
            this.complete();
        }))))));
        this.await();
    }

    @Test
    public void testConnectWithWebSocketCompressionDisabled() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setPerFrameWebSocketCompressionSupported(false).setPerMessageWebSocketCompressionSupported(false)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertNull(ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientOptions options = new HttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    private void testValidSubProtocol(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        List<String> clientSubProtocols = Arrays.asList("clientproto", "commonproto");
        List<String> serverSubProtocols = Arrays.asList("serverproto", "commonproto");
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setWebSocketSubProtocols(serverSubProtocols)).webSocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            this.assertNull(ws.subProtocol());
            ws.accept();
            this.assertEquals("commonproto", ws.subProtocol());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version).setSubProtocols(clientSubProtocols);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                this.assertEquals("commonproto", ws.subProtocol());
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    private void testInvalidSubProtocol(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String subProtocol = "myprotocol";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).addWebSocketSubProtocol("invalid")).webSocketHandler(ws -> {});
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version).addSubProtocol(subProtocol);
        this.server.listen(this.onSuccess(ar -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onFailure(err -> this.testComplete()));
        }));
        this.await();
    }

    @Test
    public void testInvalidMissingConnectionHeader() {
        this.testInvalidHandshake(this.INVALID_MISSING_CONNECTION_HEADER, false, false, 400);
        this.await();
    }

    @Test
    public void testInvalidMissingConnectionHeaderRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_MISSING_CONNECTION_HEADER, false, true, 400);
        this.await();
    }

    @Test
    public void testInvalidMethod() {
        this.testInvalidHandshake(this.INVALID_HTTP_METHOD, false, false, 405);
        this.await();
    }

    @Test
    public void testInvalidMethodRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_HTTP_METHOD, false, true, 405);
        this.await();
    }

    @Test
    public void testInvalidUri() {
        this.testInvalidHandshake(this.INVALID_URI, false, false, 400);
        this.await();
    }

    @Test
    public void testInvalidUriRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_URI, false, true, 400);
        this.await();
    }

    @Test
    public void testInvalidWebSocketVersion() {
        this.testInvalidHandshake(this.INVALID_WEBSOCKET_VERSION, false, false, 426);
        this.await();
    }

    @Test
    public void testInvalidWebSocketVersionRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_WEBSOCKET_VERSION, false, true, 426);
        this.await();
    }

    @Test
    public void testHandshakeException() {
        this.testInvalidHandshake(this.HANDSHAKE_EXCEPTION, true, false, 400);
        this.await();
    }

    @Test
    public void testHandshakeExceptionRequestUpgrade() {
        this.testInvalidHandshake(this.HANDSHAKE_EXCEPTION, true, true, 400);
        this.await();
    }

    private void testInvalidHandshake(Consumer<Handler<AsyncResult<HttpClientResponse>>> requestProvider, boolean expectEvent, boolean upgradeRequest, int expectedStatus) {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        if (upgradeRequest) {
            this.server = this.vertx.createHttpServer().webSocketHandler(ws -> this.assertTrue(expectEvent)).requestHandler(req -> req.response().end());
        } else {
            AtomicBoolean first = new AtomicBoolean();
            this.server = this.vertx.createHttpServer().requestHandler(req -> {
                if (first.compareAndSet(false, true)) {
                    try {
                        req.toWebSocket();
                    }
                    catch (Exception exception) {}
                } else {
                    req.response().end();
                }
            });
        }
        this.server.listen(8080, "localhost", this.onSuccess(s -> requestProvider.accept(this.onSuccess(resp -> {
            this.assertEquals(expectedStatus, resp.statusCode());
            resp.endHandler(v1 -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost")).onComplete(this.onSuccess(req2 -> req2.send(this.onSuccess(resp2 -> resp2.endHandler(v2 -> this.testComplete()))))));
        }))));
    }

    private void testReject(WebsocketVersion version, Integer rejectionStatus, int expectedRejectionStatus) throws Exception {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            if (rejectionStatus != null) {
                ws.reject(rejectionStatus.intValue());
            } else {
                ws.reject();
            }
        });
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onFailure(t -> {
                this.assertTrue(t instanceof UpgradeRejectedException);
                this.assertEquals(expectedRejectionStatus, ((UpgradeRejectedException)t).getStatus());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testAsyncAccept() {
        AtomicBoolean resolved = new AtomicBoolean();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            Promise promise = Promise.promise();
            ws.setHandshake(promise.future());
            try {
                ws.accept();
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                ws.writeTextMessage("hello");
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.vertx.setTimer(500L, id -> {
                resolved.set(true);
                promise.complete((Object)101);
            });
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/some/path", this.onSuccess(ws -> {
                this.assertTrue(resolved.get());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testCloseAsyncPending() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            Promise promise = Promise.promise();
            Future result = ws.setHandshake(promise.future());
            ws.close();
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/some/path", this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete())));
        }));
        this.await();
    }

    @Test
    public void testServerClose() {
        this.client = this.vertx.createHttpClient();
        this.testClose(false, true, true);
    }

    @Test
    public void testClientClose() {
        this.client = this.vertx.createHttpClient();
        this.testClose(true, false, true);
    }

    @Test
    public void testClientAndServerClose() {
        this.client = this.vertx.createHttpClient();
        this.testClose(true, false, true);
    }

    @Test
    public void testConnectionClose() {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setIdleTimeout(1));
        this.testClose(false, false, false);
    }

    public void testClose(boolean closeClient, boolean closeServer, boolean regularClose) {
        this.waitFor(4);
        Consumer<WebSocketBase> test = ws -> {
            this.assertFalse(ws.isClosed());
            AtomicInteger cnt = new AtomicInteger();
            ws.exceptionHandler(err -> {
                if (regularClose) {
                    this.fail();
                } else if (cnt.getAndIncrement() == 0) {
                    this.complete();
                }
            });
            ws.endHandler(v -> {
                if (regularClose) {
                    this.complete();
                } else {
                    this.fail();
                }
            });
            ws.closeHandler(v -> {
                this.assertTrue(ws.isClosed());
                try {
                    ws.close();
                }
                catch (Exception e) {
                    this.fail();
                }
                this.complete();
            });
        };
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            test.accept((WebSocketBase)ws);
            if (closeServer) {
                ws.close();
            }
        });
        this.server.listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/some/path", this.onSuccess(ws -> {
            test.accept((WebSocketBase)ws);
            if (closeClient) {
                ws.close();
            }
        }))));
        this.await();
    }

    @Test
    public void testCloseBeforeHandshake() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> req.connection().close());
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/some/path", this.onFailure(err -> this.testComplete()));
        }));
        this.await();
    }

    @Test
    public void testRequestEntityTooLarge() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> this.fail());
        this.server.listen(this.onSuccess(ar -> {
            this.client = this.vertx.createHttpClient();
            this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI(path), this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade").send(TestUtils.randomBuffer(8193), this.onSuccess(resp -> {
                this.assertEquals(413L, resp.statusCode());
                resp.request().connection().closeHandler(v -> this.testComplete());
            }))));
        }));
        this.await();
    }

    @Test
    public void testWriteMessageHybi00() {
        this.testWriteMessage(256, WebsocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi00() {
        this.testWriteMessage(65792, WebsocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi00() {
        this.testWriteMessage(131328, WebsocketVersion.V00);
    }

    @Test
    public void testWriteMessageHybi08() {
        this.testWriteMessage(256, WebsocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi08() {
        this.testWriteMessage(65792, WebsocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi08() {
        this.testWriteMessage(131328, WebsocketVersion.V08);
    }

    @Test
    public void testWriteMessageHybi17() {
        this.testWriteMessage(256, WebsocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi17() {
        this.testWriteMessage(65792, WebsocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi17() {
        this.testWriteMessage(131328, WebsocketVersion.V13);
    }

    private void testWriteMessage(int size, WebsocketVersion version) {
        this.client = this.vertx.createHttpClient();
        this.waitFor(2);
        String path = "/some/path";
        byte[] expected = TestUtils.randomByteArray(size);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            AtomicInteger count = new AtomicInteger();
            ws.writeBinaryMessage(Buffer.buffer((byte[])expected), this.onSuccess(v -> {
                this.assertEquals(1L, count.incrementAndGet());
                this.complete();
            }));
            ws.close();
        });
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI(path).setVersion(version);
            this.client.webSocket(options, this.onSuccess(ws -> {
                Buffer actual = Buffer.buffer();
                ws.handler(arg_0 -> ((Buffer)actual).appendBuffer(arg_0));
                ws.closeHandler(v -> {
                    this.assertArrayEquals(expected, actual.getBytes(0, actual.length()));
                    this.complete();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testNonFragmentedTextMessage2Hybi00() {
        String messageToSend = TestUtils.randomAlphaString(256);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V00);
    }

    @Test
    public void testFragmentedTextMessage2Hybi07() {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V07);
    }

    @Test
    public void testFragmentedTextMessage2Hybi08() {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V08);
    }

    @Test
    public void testFragmentedTextMessage2Hybi13() {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V13);
    }

    @Test
    public void testMaxLengthFragmentedTextMessage() {
        String messageToSend = TestUtils.randomAlphaString(262144);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V13);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi07() {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V07);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi08() {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V08);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi13() {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebsocketVersion.V13);
    }

    @Test
    public void testTooLargeMessage() {
        String messageToSend = TestUtils.randomAlphaString(262145);
        SocketMessages socketMessages = this.testWriteTextMessages(Collections.singletonList(messageToSend), WebsocketVersion.V13);
        List<String> receivedMessages = socketMessages.getReceivedMessages();
        List expectedMessages = Collections.emptyList();
        this.assertEquals("Should not have received any messages", expectedMessages, receivedMessages);
        List<Throwable> receivedExceptions = socketMessages.getReceivedExceptions();
        this.assertEquals("Should have received a single exception", 1L, receivedExceptions.size());
        this.assertTrue("Should have received IllegalStateException", receivedExceptions.get(0) instanceof IllegalStateException);
    }

    @Test
    public void testContinueAfterTooLargeMessage() {
        int shortMessageLength = 65536;
        String shortFirstMessage = TestUtils.randomAlphaString(shortMessageLength);
        String tooLongMiddleMessage = TestUtils.randomAlphaString(524288);
        String shortLastMessage = TestUtils.randomAlphaString(shortMessageLength);
        List<String> messagesToSend = Arrays.asList(shortFirstMessage, tooLongMiddleMessage, shortLastMessage);
        SocketMessages socketMessages = this.testWriteTextMessages(messagesToSend, WebsocketVersion.V13);
        List<String> receivedMessages = socketMessages.getReceivedMessages();
        List<String> expectedMessages = Arrays.asList(shortFirstMessage, shortLastMessage);
        this.assertEquals("Incorrect received messages", expectedMessages, receivedMessages);
    }

    private void testWriteSingleTextMessage(String messageToSend, WebsocketVersion version) {
        List<String> messagesToSend = Collections.singletonList(messageToSend);
        SocketMessages socketMessages = this.testWriteTextMessages(messagesToSend, version);
        this.assertEquals("Did not receive all messages", messagesToSend, socketMessages.getReceivedMessages());
        List expectedExceptions = Collections.emptyList();
        this.assertEquals("Should not have received any exceptions", expectedExceptions, socketMessages.getReceivedExceptions());
    }

    private SocketMessages testWriteTextMessages(List<String> messagesToSend, WebsocketVersion version) {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            for (String messageToSend : messagesToSend) {
                ws.writeTextMessage(messageToSend);
            }
            ws.close();
        });
        ArrayList<String> receivedMessages = new ArrayList<String>();
        ArrayList<Throwable> receivedExceptions = new ArrayList<Throwable>();
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path).setVersion(version);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                ws.textMessageHandler(receivedMessages::add);
                ws.exceptionHandler(receivedExceptions::add);
                ws.closeHandler(v -> this.testComplete());
            }));
        });
        this.await();
        return new SocketMessages(receivedMessages, receivedExceptions);
    }

    @Test
    public void testWebSocketPauseAndResume() {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setConnectTimeout(1000));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setAcceptBacklog(1).setPort(8080));
        AtomicBoolean paused = new AtomicBoolean();
        ReadStream stream = this.server.webSocketStream();
        stream.handler(ws -> {
            this.assertFalse(paused.get());
            ws.writeBinaryMessage(Buffer.buffer((String)"whatever"));
            ws.close();
        });
        this.server.listen(listenAR -> {
            this.assertTrue(listenAR.succeeded());
            stream.pause();
            paused.set(true);
            this.connectUntilWebSocketReject(this.client, 0, (Handler<AsyncResult<Void>>)((Handler)res -> {
                if (!res.succeeded()) {
                    this.fail((Throwable)((Object)new AssertionError("Was expecting error to be WebSocketHandshakeException", res.cause())));
                }
                this.assertTrue(paused.get());
                paused.set(false);
                stream.resume();
                this.client.webSocket(8080, "localhost", "/some/path", this.onSuccess(ws -> ws.handler(buffer -> {
                    this.assertEquals("whatever", buffer.toString("UTF-8"));
                    ws.closeHandler(v2 -> this.testComplete());
                })));
            }));
        });
        this.await();
    }

    private void connectUntilWebSocketReject(HttpClient client, int count, Handler<AsyncResult<Void>> doneHandler) {
        this.vertx.runOnContext(v -> client.webSocket(8080, "localhost", "/some/path", ar -> {
            if (ar.succeeded()) {
                if (count < 100) {
                    this.connectUntilWebSocketReject(client, count + 1, doneHandler);
                } else {
                    doneHandler.handle((Object)Future.failedFuture((Throwable)((Object)new AssertionError())));
                }
            } else {
                Throwable err = ar.cause();
                if (err instanceof UpgradeRejectedException || err instanceof IOException) {
                    doneHandler.handle((Object)Future.succeededFuture());
                } else if (count < 100) {
                    this.connectUntilWebSocketReject(client, count + 1, doneHandler);
                } else {
                    doneHandler.handle((Object)Future.failedFuture((Throwable)err));
                }
            }
        }));
    }

    @Test
    public void testClosingServerClosesWebSocketStreamEndHandler() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        ReadStream stream = this.server.webSocketStream();
        stream.endHandler(v -> this.complete());
        stream.handler(ws -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.server.close(v -> {
                this.assertTrue(ar.succeeded());
                this.complete();
            });
        });
        this.await();
    }

    @Test
    public void testWebSocketStreamCallbackAsynchronously() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger done = new AtomicInteger();
        ReadStream stream = this.server.webSocketStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.webSocketStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testClearClientHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(WebSocketBase::close);
        this.server.listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> ws.endHandler(v2 -> {
                try {
                    ws.endHandler(null);
                    ws.exceptionHandler(null);
                    ws.handler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the socket is closed");
                    return;
                }
                this.testComplete();
            })));
        }));
        this.await();
    }

    @Test
    public void testWriteOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(WebSocketBase::close);
        this.server.listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> ws.endHandler(v2 -> ws.write((Object)Buffer.buffer((String)"test"), this.onFailure(err -> this.testComplete())))));
        }));
        this.await();
    }

    @Test
    public void testReceiveHttpResponseHeadersOnClient() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> this.handshakeWithCookie((HttpServerRequest)req));
        AtomicReference webSocketRef = new AtomicReference();
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/some/path", this.onSuccess(ws -> {
                MultiMap entries = ws.headers();
                this.assertNotNull(entries);
                this.assertFalse(entries.isEmpty());
                this.assertEquals("websocket".toLowerCase(), entries.get("Upgrade").toLowerCase());
                this.assertEquals("upgrade".toLowerCase(), entries.get("Connection").toLowerCase());
                HashSet cookiesToSet = new HashSet(entries.getAll("Set-Cookie"));
                this.assertEquals(2L, cookiesToSet.size());
                this.assertTrue(cookiesToSet.contains("SERVERID=test-server-id"));
                this.assertTrue(cookiesToSet.contains("JSONID=test-json-id"));
                webSocketRef.set(ws);
                this.vertx.runOnContext(v -> {
                    this.assertNull(ws.headers());
                    this.testComplete();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testUpgrade() {
        this.testUpgrade(false);
    }

    @Test
    public void testUpgradeDelayed() {
        this.testUpgrade(true);
    }

    private void testUpgrade(boolean delayed) {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(request -> {
            Runnable runner = () -> request.toWebSocket().onComplete(this.onSuccess(ws -> {
                HttpServerResponse response = request.response();
                this.assertTrue(response.ended());
                try {
                    response.putHeader("foo", "bar");
                    this.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    response.end();
                    this.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ws.handler(buff -> {
                    ws.write((Object)Buffer.buffer((String)"helloworld"));
                    ws.close();
                });
            }));
            if (delayed) {
                request.pause();
                this.vertx.runOnContext(v -> runner.run());
            } else {
                runner.run();
            }
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", path, this.onSuccess(ws -> {
                Buffer buff = Buffer.buffer();
                ws.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
                ws.endHandler(v -> {
                    this.assertEquals("helloworld", buff.toString("UTF-8"));
                    this.testComplete();
                });
                ws.write((Object)Buffer.buffer((String)"foo"));
            }));
        }));
        this.await();
    }

    @Test
    public void testUpgradeFailure() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(request -> request.toWebSocket(this.onFailure(err -> this.testComplete())));
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.handshake(this.client, (Handler<HttpClientRequest>)((Handler)req -> {
                req.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"100");
                req.sendHead(this.onSuccess(v -> req.connection().close()));
            }));
        }));
        this.await();
    }

    @Test
    public void testUnmaskedFrameRequest() {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSendUnmaskedFrames(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setAcceptUnmaskedFrames(true));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> ws.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer data) {
                WebSocketTest.this.assertEquals(data.toString(), "first unmasked frame");
                WebSocketTest.this.testComplete();
            }
        }));
        this.server.listen(this.onSuccess(server -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.writeFinalTextFrame("first unmasked frame")))));
        this.await();
    }

    @Test
    public void testInvalidUnmaskedFrameRequest() {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSendUnmaskedFrames(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setAcceptUnmaskedFrames(false));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> {
            ws.exceptionHandler(exception -> {
                ws.exceptionHandler(null);
                this.testComplete();
            });
            ws.handler(result -> this.fail("Cannot decode unmasked message because I require masked frame as configured"));
        });
        this.server.listen(this.onSuccess(server -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.writeFinalTextFrame("first unmasked frame")))));
        this.await();
    }

    @Test
    public void testUpgradeInvalidRequest() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(request -> {
            request.toWebSocket().onComplete(this.onFailure(err -> this.complete()));
            request.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.request(HttpMethod.GET, 8080, "localhost", "/").compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testRaceConditionWithWebSocketClientEventLoop() {
        this.testRaceConditionWithWebSocketClient(this.vertx.getOrCreateContext());
    }

    @Test
    public void testRaceConditionWithWebSocketClientWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setWorker(true), ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        this.testRaceConditionWithWebSocketClient((Context)fut.get());
    }

    private Future<NetSocket> handshakeWithCookie(HttpServerRequest req) {
        return ((Http1xServerConnection)req.connection()).netSocket().compose(so -> {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] inputBytes = (req.getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
                digest.update(inputBytes);
                byte[] hashedBytes = digest.digest();
                byte[] accept = Base64.getEncoder().encode(hashedBytes);
                Buffer data = Buffer.buffer();
                data.appendString("HTTP/1.1 101 Switching Protocols\r\n");
                data.appendString("Upgrade: websocket\r\n");
                data.appendString("Connection: upgrade\r\n");
                data.appendString("Sec-WebSocket-Accept: " + new String(accept) + "\r\n");
                data.appendString("Set-Cookie: SERVERID=test-server-id\r\n");
                data.appendString("Set-Cookie: JSONID=test-json-id\r\n");
                data.appendString("\r\n");
                so.write((Object)data);
                return Future.succeededFuture((Object)so);
            }
            catch (NoSuchAlgorithmException e) {
                req.response().setStatusCode(500).end();
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    private Future<NetSocket> handshake(HttpServerRequest req) {
        return ((Http1xServerConnection)req.connection()).netSocket().flatMap(so -> {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] inputBytes = (req.getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
                digest.update(inputBytes);
                byte[] hashedBytes = digest.digest();
                byte[] accept = Base64.getEncoder().encode(hashedBytes);
                Buffer data = Buffer.buffer();
                data.appendString("HTTP/1.1 101 Switching Protocols\r\n");
                data.appendString("Upgrade: websocket\r\n");
                data.appendString("Connection: upgrade\r\n");
                data.appendString("Sec-WebSocket-Accept: " + new String(accept) + "\r\n");
                data.appendString("\r\n");
                so.write((Object)data);
                return Future.succeededFuture((Object)so);
            }
            catch (NoSuchAlgorithmException e) {
                req.response().setStatusCode(500).end();
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    private void handshake(HttpClient client, Handler<HttpClientRequest> handler) {
        client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/")).onComplete(this.onSuccess(req -> {
            req.putHeader("Upgrade", "websocket").putHeader("Connection", "Upgrade").putHeader("Sec-WebSocket-Key", "dGhlIHNhbXBsZSBub25jZQ==").putHeader("Sec-WebSocket-Protocol", "chat").putHeader("Sec-WebSocket-Version", "13").putHeader("Origin", "http://example.com");
            handler.handle(req);
        }));
    }

    private void testRaceConditionWithWebSocketClient(Context context) {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> so.write((Object)Buffer.buffer((byte[])new byte[]{-126, 5, 104, 101, 108, 108, 111})))));
        this.server.listen(this.onSuccess(s -> context.runOnContext(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            })));
        })));
        this.await();
    }

    @Test
    public void testRaceConditionWithWebSocketClientWorker2() throws Exception {
        int size = this.getOptions().getWorkerPoolSize() - 4;
        List<Context> workers = this.createWorkers(size + 1);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.webSocketHandler(ws -> ws.write((Object)Buffer.buffer((String)"hello")));
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            ((Context)workers.get(0)).runOnContext(v -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testWorker() {
        this.waitFor(2);
        DeploymentOptions deploymentOptions = new DeploymentOptions().setWorker(true);
        this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                WebSocketTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
                WebSocketTest.this.server.webSocketHandler(ws -> {
                    WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                    ws.handler(msg -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        ws.write((Object)Buffer.buffer((String)"pong"));
                    });
                    ws.endHandler(v -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        WebSocketTest.this.complete();
                    });
                });
                WebSocketTest.this.server.listen().mapEmpty().onComplete(startPromise);
            }
        }, deploymentOptions, this.onSuccess(serverID -> this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start() {
                WebSocketTest.this.client = this.vertx.createHttpClient();
                WebSocketTest.this.client.webSocket(8080, "localhost", "/", WebSocketTest.this.onSuccess(ws -> {
                    WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                    ws.write((Object)Buffer.buffer((String)"ping"));
                    ws.handler(buf -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        ws.end();
                    });
                    ws.endHandler(v -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        WebSocketTest.this.complete();
                    });
                }));
            }
        }, deploymentOptions, this.onSuccess(id -> {}))));
        this.await();
    }

    @Test
    public void httpClientWebSocketConnectionFailureHandlerShouldBeCalled() throws Exception {
        int port = 7867;
        HttpClient client = this.vertx.createHttpClient();
        client.webSocket(port, "localhost", "", this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testClientWebSocketWithHttp2Client() throws Exception {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setHttp2ClearTextUpgrade(false).setProtocolVersion(HttpVersion.HTTP_2));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> ws.writeFinalTextFrame("ok"));
        this.server.listen(this.onSuccess(server -> this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.handler(buff -> {
            this.assertEquals("ok", buff.toString());
            this.testComplete();
        })))))))));
        this.await();
    }

    @Test
    public void testClientWebSocketConnectionCloseOnBadResponseWithKeepalive() throws Throwable {
        this.doTestClientWebSocketConnectionCloseOnBadResponse(true);
    }

    @Test
    public void testClientWebSocketConnectionCloseOnBadResponseWithoutKeepalive() throws Throwable {
        this.doTestClientWebSocketConnectionCloseOnBadResponse(false);
    }

    void addResult(Throwable result) {
        try {
            this.resultQueue.put(result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void doTestClientWebSocketConnectionCloseOnBadResponse(boolean keepAliveInOptions) throws Throwable {
        Exception serverGotCloseException = new Exception();
        this.netServer = this.vertx.createNetServer().connectHandler(sock -> {
            Buffer fullReq = Buffer.buffer((int)230);
            sock.handler(b -> {
                fullReq.appendBuffer(b);
                String reqPart = b.toString();
                if (fullReq.toString().contains("\r\n\r\n")) {
                    try {
                        String content = "0123456789";
                        content = content + content;
                        content = content + content + content + content + content;
                        String resp = "HTTP/1.1 200 OK\r\n";
                        if (keepAliveInOptions) {
                            resp = resp + "Connection: close\r\n";
                        }
                        resp = resp + "Content-Length: 100\r\n\r\n" + content;
                        sock.write((Object)Buffer.buffer((byte[])resp.getBytes("ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.addResult(e);
                    }
                }
            });
            sock.closeHandler(v -> this.addResult(serverGotCloseException));
        }).listen(ar -> {
            if (ar.failed()) {
                this.addResult(ar.cause());
                return;
            }
            NetServer server = (NetServer)ar.result();
            int port = server.actualPort();
            HttpClientOptions opts = new HttpClientOptions().setKeepAlive(keepAliveInOptions);
            this.client = this.vertx.createHttpClient(opts);
            this.client.webSocket(port, "localhost", "/", ar2 -> {
                if (ar2.succeeded()) {
                    this.addResult((Throwable)((Object)new AssertionError((Object)"WebSocket unexpectedly connected")));
                    ((WebSocket)ar2.result()).close();
                } else {
                    this.addResult(ar2.cause());
                }
            });
        });
        boolean serverGotClose = false;
        boolean clientGotCorrectException = false;
        while (!serverGotClose || !clientGotCorrectException) {
            Throwable result = this.resultQueue.poll(20L, TimeUnit.SECONDS);
            if (result == null) {
                throw new AssertionError((Object)("Timed out waiting for expected state, current: serverGotClose = " + serverGotClose + ", clientGotCorrectException = " + clientGotCorrectException));
            }
            if (result == serverGotCloseException) {
                serverGotClose = true;
                continue;
            }
            if (result instanceof UpgradeRejectedException && ((UpgradeRejectedException)result).getStatus() == 200) {
                clientGotCorrectException = true;
                continue;
            }
            throw result;
        }
    }

    @Test
    public void testClearClientSslOptions() {
        HttpServerOptions serverOptions = new HttpServerOptions().setPort(4043).setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        HttpClientOptions clientOptions = new HttpClientOptions().setTrustAll(true).setVerifyHost(false);
        this.client = this.vertx.createHttpClient(clientOptions);
        this.server = this.vertx.createHttpServer(serverOptions).webSocketHandler(WebSocketBase::close).listen(this.onSuccess(server -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(4043)).setSsl(Boolean.valueOf(true));
            this.client.webSocket(options, this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete())));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketPingPong() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost"));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> {
                this.assertEquals("ping", buff.toString());
                ws.close();
            });
            ws.writePing(Buffer.buffer((String)"ping"));
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ws.handler(buff -> this.fail("Should not receive a buffer"));
                ws.closeHandler(v2 -> this.testComplete());
            }));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketPingExceeds125Bytes() {
        this.testServerWebSocketPingPongCheck(255, ws -> ws.writePing(Buffer.buffer((String)TestUtils.randomAlphaString(126))));
    }

    @Test
    public void testServerWebSocketPongExceeds125Bytes() {
        this.testServerWebSocketPingPongCheck(255, ws -> ws.writePong(Buffer.buffer((String)TestUtils.randomAlphaString(126))));
    }

    @Test
    public void testServerWebSocketPingExceedsMaxFrameSize() {
        this.testServerWebSocketPingPongCheck(100, ws -> ws.writePing(Buffer.buffer((String)TestUtils.randomAlphaString(101))));
    }

    @Test
    public void testServerWebSocketPongExceedsMaxFrameSize() {
        this.testServerWebSocketPingPongCheck(100, ws -> ws.writePong(Buffer.buffer((String)TestUtils.randomAlphaString(101))));
    }

    private void testServerWebSocketPingPongCheck(int maxFrameSize, Function<ServerWebSocket, Future<Void>> check) {
        Pattern pattern = Pattern.compile("^P[io]ng cannot exceed maxWebSocketFrameSize or 125 bytes$");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            ((Future)check.apply((ServerWebSocket)ws)).onComplete(this.onFailure(err -> {
                Matcher matcher = pattern.matcher(err.getMessage());
                if (matcher.matches()) {
                    ws.close();
                } else {
                    this.fail("Unexpected error message" + err.getMessage());
                }
            }));
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.closeHandler(v2 -> this.testComplete())));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketSendPingExceeds125Bytes() {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            ws.writeFrame(WebSocketFrame.pingFrame((Buffer)Buffer.buffer((String)pingBody)));
            this.vertx.setTimer(2000L, id -> this.testComplete());
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {}));
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketSendPingExceeds125Bytes() {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {}).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ws.pongHandler(buffer -> this.fail());
                ws.writeFrame(WebSocketFrame.pingFrame((Buffer)Buffer.buffer((String)pingBody)));
                this.vertx.setTimer(2000L, id -> this.testComplete());
            }));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketSendPongExceeds125Bytes() {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> ws.writeFrame(WebSocketFrame.pongFrame((Buffer)Buffer.buffer((String)pingBody)))).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ws.pongHandler(buff -> this.fail());
                this.vertx.setTimer(2000L, id -> this.testComplete());
            }));
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketSendPongExceeds125Bytes() {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            this.vertx.setTimer(2000L, id -> this.testComplete());
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.writeFrame(WebSocketFrame.pongFrame((Buffer)Buffer.buffer((String)pingBody)))));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketReceivePongExceedsMaxFrameSize() {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {
            ArrayList pongs = new ArrayList();
            ws.pongHandler(pong -> {
                pongs.add(pong);
                if (pongs.size() == 2) {
                    this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                    this.testComplete();
                }
            });
        }).listen(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                try {
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ping1.copy().getByteBuf(), false));
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ping2.copy().getByteBuf(), true));
                }
                catch (Throwable t) {
                    this.fail(t);
                }
            }));
        });
        this.await();
    }

    @Test
    public void testClientWebSocketReceivePongExceedsMaxFrameSize() {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ping1.copy().getByteBuf(), false));
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ping2.copy().getByteBuf(), true));
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }).listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ArrayList pongs = new ArrayList();
                ws.pongHandler(pong -> {
                    pongs.add(pong);
                    if (pongs.size() == 2) {
                        this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketReceivePingExceedsMaxFrameSize() {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {}).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ArrayList pongs = new ArrayList();
                ws.pongHandler(pong -> {
                    pongs.add(pong);
                    if (pongs.size() == 2) {
                        this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                        this.testComplete();
                    }
                });
                try {
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ping1.copy().getByteBuf(), false));
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ping2.copy().getByteBuf(), true));
                }
                catch (Throwable t) {
                    this.fail(t);
                }
            }));
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketReceivePingExceedsMaxFrameSize() {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {}).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ArrayList pongs = new ArrayList();
                ws.pongHandler(pong -> {
                    pongs.add(pong);
                    if (pongs.size() == 2) {
                        this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                        this.testComplete();
                    }
                });
                try {
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ping1.copy().getByteBuf(), false));
                    ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ping2.copy().getByteBuf(), true));
                }
                catch (Throwable t) {
                    this.fail(t);
                }
            }));
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketPingPong() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost"));
        this.server.webSocketHandler(ws -> {}).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
                ws.pongHandler(pong -> {
                    this.assertEquals("ping", pong.toString());
                    this.testComplete();
                });
                ws.writePing(Buffer.buffer((String)"ping"));
            }));
        }));
        this.await();
    }

    @Test
    public void testWebSocketAbs() {
        HttpServerOptions serverOptions = new HttpServerOptions().setPort(4043).setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        HttpClientOptions clientOptions = new HttpClientOptions().setTrustAll(true).setVerifyHost(false);
        this.client = this.vertx.createHttpClient(clientOptions);
        this.server = this.vertx.createHttpServer(serverOptions).requestHandler(request -> {
            if ("/test".equals(request.path())) {
                request.toWebSocket().onComplete(this.onSuccess(ServerWebSocket::close));
            } else {
                request.response().end();
            }
        }).listen(this.onSuccess(server -> {
            String url = "wss://" + clientOptions.getDefaultHost() + ":" + 4043 + "/test";
            this.client.webSocketAbs(url, null, null, null, this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete())));
        }));
        this.await();
    }

    @Test
    public void testCloseStatusCodeFromServer() {
        this.waitFor(3);
        this.testCloseStatusCodeFromServer(ServerWebSocket::close);
    }

    @Test
    public void testCloseStatusCodeFromServerWithHandler() {
        this.waitFor(4);
        this.testCloseStatusCodeFromServer(ws -> ws.close(this.onSuccess(v -> this.complete())));
    }

    private void testCloseStatusCodeFromServer(Consumer<ServerWebSocket> closeOp) {
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> {
            socket.closeHandler(a -> this.complete());
            this.vertx.setTimer(100L, id -> closeOp.accept((ServerWebSocket)socket));
        }).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
            ws.frameHandler(frame -> {
                this.assertEquals(1000L, frame.binaryData().getByteBuf().getShort(0));
                this.assertEquals(1000L, frame.closeStatusCode());
                this.assertNull(frame.closeReason());
                this.complete();
            });
            ws.closeHandler(sc -> {
                this.assertEquals((Object)1000, ws.closeStatusCode());
                this.complete();
            });
        }))));
        this.await();
    }

    @Test
    public void testCloseStatusCodeFromClient() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> {
            socket.closeHandler(a -> latch.countDown());
            socket.frameHandler(frame -> {
                this.assertEquals(1000L, frame.binaryData().getByteBuf().getShort(0));
                this.assertEquals(1000L, frame.closeStatusCode());
                this.assertNull(frame.closeReason());
                latch.countDown();
            });
        }).listen(ar -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(WebSocketBase::close)));
        this.awaitLatch(latch);
    }

    @Test
    public void testCloseFrame() {
        this.waitFor(3);
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> {
            socket.closeHandler(a -> {
                this.assertEquals((Object)1001, socket.closeStatusCode());
                this.assertEquals(TEST_REASON, socket.closeReason());
                this.complete();
            });
            socket.frameHandler(frame -> {
                if (frame.isText()) {
                    TestUtils.assertIllegalStateException(() -> ((WebSocketFrame)frame).closeStatusCode());
                    this.complete();
                } else {
                    this.assertEquals(frame.closeReason(), TEST_REASON);
                    this.assertEquals(frame.closeStatusCode(), 1001L);
                    this.complete();
                }
            });
        }).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
            ws.writeTextMessage("Hello");
            ws.close((short)1001, TEST_REASON);
        }))));
        this.await();
    }

    @Test
    public void testCloseCustomPayloadFromServer() {
        this.waitFor(2);
        this.testCloseCustomPayloadFromServer(ws -> ws.close((short)1001, TEST_REASON));
    }

    @Test
    public void testCloseCustomPayloadFromServerWithHandler() {
        this.waitFor(3);
        this.testCloseCustomPayloadFromServer(ws -> ws.close((short)1001, TEST_REASON, this.onSuccess(v -> this.complete())));
    }

    private void testCloseCustomPayloadFromServer(Consumer<ServerWebSocket> closeOp) {
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> {
            socket.closeHandler(a -> {
                this.assertEquals((Object)1001, socket.closeStatusCode());
                this.assertEquals(TEST_REASON, socket.closeReason());
                this.complete();
            });
            this.vertx.setTimer(100L, ar -> closeOp.accept((ServerWebSocket)socket));
        }).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> ws.frameHandler(frame -> {
            this.assertEquals(TEST_REASON, frame.binaryData().getByteBuf().readerIndex(2).toString(StandardCharsets.UTF_8));
            this.assertEquals(1001L, frame.binaryData().getByteBuf().getShort(0));
            this.assertEquals(TEST_REASON, frame.closeReason());
            this.assertEquals(1001L, frame.closeStatusCode());
            this.complete();
        })))));
        this.await();
    }

    @Test
    public void testCloseCustomPayloadFromClient() {
        this.waitFor(2);
        this.testCloseCustomPayloadFromClient(ws -> ws.close((short)1001, TEST_REASON));
    }

    @Test
    public void testCloseCustomPayloadFromClientWithHandler() {
        this.waitFor(3);
        this.testCloseCustomPayloadFromClient(ws -> ws.close((short)1001, TEST_REASON, this.onSuccess(v -> this.complete())));
    }

    private void testCloseCustomPayloadFromClient(Consumer<WebSocket> closeOp) {
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> {
            socket.closeHandler(a -> this.complete());
            socket.frameHandler(frame -> {
                this.assertEquals(TEST_REASON, frame.binaryData().getByteBuf().readerIndex(2).toString(StandardCharsets.UTF_8));
                this.assertEquals(1001L, frame.binaryData().getByteBuf().getShort(0));
                this.assertEquals(TEST_REASON, frame.closeReason());
                this.assertEquals(1001L, frame.closeStatusCode());
                this.complete();
            });
        }).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(closeOp))));
        this.await();
    }

    @Test
    public void testServerCloseHandshake() {
        short status = (short)(4000 + TestUtils.randomPositiveInt() % 100);
        this.waitFor(2);
        this.server = this.vertx.createHttpServer();
        this.server.webSocketHandler(ws -> ws.closeHandler(sc -> {
            this.assertEquals((Object)status, ws.closeStatusCode());
            this.complete();
        }));
        this.server.listen(8080, "localhost", this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient();
            this.handshake(this.client, (Handler<HttpClientRequest>)((Handler)req -> req.send(this.onSuccess(resp -> {
                this.assertEquals(101L, resp.statusCode());
                Http1xClientConnection conn = (Http1xClientConnection)req.connection();
                NetSocketInternal soi = conn.toNetSocket();
                soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
                soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, 1000));
                String reason = TestUtils.randomAlphaString(10);
                soi.writeMessage((Object)new CloseWebSocketFrame((int)status, reason));
                AtomicBoolean closeFrameReceived = new AtomicBoolean();
                soi.messageHandler(msg -> {
                    if (msg instanceof CloseWebSocketFrame) {
                        CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                        this.assertEquals(status, frame.statusCode());
                        this.assertEquals(reason, frame.reasonText());
                        closeFrameReceived.set(true);
                    }
                    ReferenceCountUtil.release((Object)msg);
                });
                soi.closeHandler(v2 -> {
                    this.assertTrue(closeFrameReceived.get());
                    this.complete();
                });
            }))));
        }));
        this.await();
    }

    @Test
    public void testClientCloseHandshake() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(false));
            soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(true, false, 1000));
            ArrayDeque received = new ArrayDeque();
            soi.messageHandler(msg -> {
                received.add(msg);
                if (msg instanceof CloseWebSocketFrame) {
                    so.close();
                }
            });
            int status = 4000 + TestUtils.randomPositiveInt() % 100;
            String reason = TestUtils.randomAlphaString(10);
            soi.writeMessage((Object)new CloseWebSocketFrame(status, reason));
            soi.closeHandler(v -> {
                this.assertEquals(1L, received.size());
                Object msg = received.getFirst();
                this.assertEquals(msg.getClass(), CloseWebSocketFrame.class);
                CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                this.assertEquals(status, frame.statusCode());
                this.assertEquals(reason, frame.reasonText());
                this.complete();
            });
        })));
        this.server.listen(8080, "localhost", this.onSuccess(v1 -> {
            HttpClientOptions options = new HttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
            this.client.webSocket(8080, "localhost", "/chat", this.onSuccess(ws -> ws.closeHandler(v -> this.complete())));
        }));
        this.await();
    }

    @Test
    public void testClientConnectionCloseTimeout() {
        this.testClientConnectionCloseTimeout(1);
    }

    @Test
    public void testClientConnectionCloseImmediately() {
        this.testClientConnectionCloseTimeout(0);
    }

    public void testClientConnectionCloseTimeout(int timeout) {
        this.waitFor(3);
        List received = Collections.synchronizedList(new ArrayList());
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(false));
            soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(true, false, 1000));
            soi.messageHandler(msg -> {
                received.add(msg);
                if (msg instanceof CloseWebSocketFrame) {
                    CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                    soi.writeMessage((Object)new CloseWebSocketFrame(frame.statusCode(), frame.reasonText()));
                }
            });
            soi.closeHandler(v -> this.complete());
        })));
        this.server.listen(8080, "localhost", this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setWebSocketClosingTimeout(timeout));
            this.client.webSocket(8080, "localhost", "/chat", this.onSuccess(ws -> {
                ws.endHandler(v -> this.complete());
                ws.exceptionHandler(err -> this.fail());
                ws.closeHandler(v -> {
                    this.assertEquals(1L, received.size());
                    this.assertEquals(received.get(0).getClass(), CloseWebSocketFrame.class);
                    this.complete();
                });
                ws.close();
            }));
        }));
        this.await();
    }

    @Test
    public void testServerCloseTimeout() {
        this.testServerConnectionClose(1);
    }

    @Test
    public void testServerImmediateClose() {
        this.testServerConnectionClose(0);
    }

    public void testServerConnectionClose(int timeout) {
        this.waitFor(3);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setWebSocketClosingTimeout(timeout)).webSocketHandler(ws -> {
            long now = System.currentTimeMillis();
            ws.endHandler(v -> this.fail());
            ws.exceptionHandler(ignore -> this.complete());
            ws.closeHandler(v -> {
                long elapsed = System.currentTimeMillis() - now;
                this.assertTrue((long)timeout <= elapsed && elapsed < 5000L);
                this.complete();
            });
            ws.close();
        }).listen(8080, "localhost", this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.handshake(this.client, (Handler<HttpClientRequest>)((Handler)req -> req.send(this.onSuccess(resp -> {
                this.assertEquals(101L, resp.statusCode());
                Http1xClientConnection conn = (Http1xClientConnection)req.connection();
                NetSocketInternal soi = conn.toNetSocket();
                soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
                soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, 1000));
                soi.closeHandler(v -> this.complete());
            }))));
        }));
        this.await();
    }

    @Test
    public void testCloseServer() {
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(socket -> socket.textMessageHandler(msg -> this.server.close())).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> {
            ws.writeTextMessage("ping");
            AtomicBoolean closeFrameReceived = new AtomicBoolean();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    closeFrameReceived.set(true);
                }
            });
            ws.endHandler(v -> {
                this.assertTrue(closeFrameReceived.get());
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testCloseClient() {
        this.client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            AtomicBoolean closeFrameReceived = new AtomicBoolean();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    closeFrameReceived.set(true);
                }
            });
            ws.endHandler(v -> {
                this.assertTrue(closeFrameReceived.get());
                this.testComplete();
            });
        }).listen(this.onSuccess(s -> this.client.webSocket(8080, "localhost", "/", this.onSuccess(ws -> this.client.close()))));
        this.await();
    }

    @Test
    public void testReportProtocolViolationOnClient() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> this.getUpgradedNetSocket((HttpServerRequest)req, "/some/path").onComplete(this.onSuccess(sock -> {
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)8).appendByte((byte)0);
            sock.write((Object)buff);
        })));
        this.server.listen(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/some/path").setVersion(WebsocketVersion.V13);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(options, this.onSuccess(ws -> {
                AtomicReference failure = new AtomicReference();
                ws.closeHandler(v -> {
                    this.assertNotNull(failure.get());
                    this.testComplete();
                });
                ws.exceptionHandler(failure::set);
            }));
        }));
        this.await();
    }

    @Test
    public void testReportProtocolViolationOnServer() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            AtomicReference failure = new AtomicReference();
            ws.closeHandler(v -> {
                this.assertNotNull(failure.get());
                this.testComplete();
            });
            ws.exceptionHandler(failure::set);
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.handshake(this.client, (Handler<HttpClientRequest>)((Handler)req -> req.connect(this.onSuccess(resp -> {
                this.assertEquals(101L, resp.statusCode());
                NetSocket sock = resp.netSocket();
                Buffer buff = Buffer.buffer();
                buff.appendByte((byte)8).appendByte((byte)0);
                sock.write((Object)buff);
            }))));
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketShouldBeClosedWhenTheClosedHandlerIsCalled() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
            sender.send();
            ws.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.testComplete();
                }
            });
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> this.vertx.setTimer(1000L, id -> ws.close())));
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketShouldBeClosedWhenTheClosedHandlerIsCalled() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> this.vertx.setTimer(1000L, id -> ws.close()));
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
                sender.send();
                ws.closeHandler(v -> {
                    Throwable failure = sender.close();
                    if (failure != null) {
                        this.fail(failure);
                    } else {
                        this.testComplete();
                    }
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testDontReceiveMessagerAfterCloseHandlerCalled() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            boolean[] closed = new boolean[1];
            ws.handler(msg -> {
                if (closed[0]) {
                    this.fail("Should not receive a message after close handler callback");
                }
            });
            ws.closeHandler(v -> {
                closed[0] = true;
                this.vertx.setTimer(10L, id -> this.testComplete());
            });
            this.vertx.setTimer(500L, id -> {
                while (!ws.writeQueueFull()) {
                    ws.write((Object)TestUtils.randomBuffer(1000));
                }
                ws.close();
            });
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
                ws.closeHandler(v -> sender.close());
                sender.send();
            }));
        }));
        this.await();
    }

    @Test
    public void testNoRequestHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.createHttpServer().webSocketHandler(ws -> this.fail()).listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client = this.vertx.createHttpClient();
        this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080))).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertEquals(400L, resp.statusCode());
            this.testComplete();
        })))));
        this.await();
    }

    @Test
    public void testPausedDuringClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            AtomicBoolean paused = new AtomicBoolean(true);
            ws.pause();
            ws.closeHandler(v1 -> {
                paused.set(false);
                this.vertx.runOnContext(v2 -> ws.resume());
            });
            ws.endHandler(v -> {
                this.assertFalse(paused.get());
                this.testComplete();
            });
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> ws.close()));
        }));
        this.await();
    }

    @Test
    public void testPausedBeforeClosed() {
        this.waitFor(2);
        Buffer expected = TestUtils.randomBuffer(128);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).webSocketHandler(ws -> {
            AtomicBoolean paused = new AtomicBoolean(true);
            ws.pause();
            ws.closeHandler(v1 -> {
                paused.set(false);
                this.vertx.runOnContext(v2 -> ws.resume());
            });
            ws.handler(buffer -> {
                this.assertFalse(paused.get());
                this.assertEquals(expected, buffer);
                this.complete();
            });
            ws.endHandler(v -> {
                this.assertFalse(paused.get());
                this.complete();
            });
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                ws.write((Object)expected);
                ws.close();
            }));
        }));
        this.await();
    }

    @Test
    public void testContext() throws Exception {
        int num = 10;
        this.waitFor(num);
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {
            Context current = Vertx.currentContext();
            this.assertSameEventLoop(serverCtx, current);
            ws.handler(buff -> this.assertEquals(current, Vertx.currentContext()));
            ws.frameHandler(frame -> this.assertEquals(current, Vertx.currentContext()));
            ws.closeHandler(v -> this.assertEquals(current, Vertx.currentContext()));
            ws.endHandler(v -> {
                this.assertEquals(current, Vertx.currentContext());
                this.complete();
            });
        });
        CountDownLatch latch = new CountDownLatch(1);
        serverCtx.runOnContext(v -> this.server.listen(8080, "localhost", this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(num));
        for (int i = 0; i < num; ++i) {
            Context clientCtx = this.vertx.getOrCreateContext();
            clientCtx.runOnContext(v -> this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                this.assertEquals(clientCtx, Vertx.currentContext());
                ws.write((Object)Buffer.buffer((String)"data"));
                ws.pongHandler(pong -> {
                    this.assertEquals(clientCtx, Vertx.currentContext());
                    ws.close();
                });
                ws.writePing(Buffer.buffer((String)"ping"));
            })));
        }
        this.await();
    }

    private void fillQueue(WebSocketBase ws, Handler<Void> onFull) {
        if (!ws.writeQueueFull()) {
            ws.writeFrame(WebSocketFrame.textFrame((String)TestUtils.randomAlphaString(512), (boolean)true));
            this.vertx.runOnContext(v -> this.fillQueue(ws, onFull));
        } else {
            onFull.handle(null);
        }
    }

    @Test
    public void testDrainServerWebSocket() {
        Promise resume = Promise.promise();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> this.fillQueue((WebSocketBase)ws, (Handler<Void>)((Handler)v1 -> {
            resume.complete();
            ws.drainHandler(v2 -> this.testComplete());
        }))).listen(8080, this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                ws.pause();
                resume.future().onComplete(this.onSuccess(v2 -> ws.resume()));
            }));
        }));
        this.await();
    }

    @Test
    public void testDrainClientWebSocket() {
        Promise resume = Promise.promise();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {
            ws.pause();
            resume.future().onComplete(this.onSuccess(v2 -> ws.resume()));
        }).listen(8080, this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                while (!ws.writeQueueFull()) {
                    ws.writeFrame(WebSocketFrame.textFrame((String)TestUtils.randomAlphaString(512), (boolean)true));
                }
                ws.drainHandler(v -> this.testComplete());
                resume.complete();
            }));
        }));
        this.await();
    }

    @Test
    public void testWriteHandlerSuccess() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> ws.handler(buff -> this.complete())).listen(8080, this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> ws.write((Object)Buffer.buffer((String)"foo"), this.onSuccess(v -> this.complete()))));
        }));
        this.await();
    }

    @Test
    public void testWriteHandlerFailure() {
        this.server = this.vertx.createHttpServer().webSocketHandler(ServerWebSocket::pause).listen(8080, this.onSuccess(v1 -> {
            Buffer buffer = TestUtils.randomBuffer(1024);
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(8080, "localhost", "/someuri", this.onSuccess(ws -> {
                while (!ws.writeQueueFull()) {
                    ws.write((Object)buffer);
                }
                ws.write((Object)buffer, this.onFailure(err -> this.testComplete()));
                ((WebSocketInternal)ws).channelHandlerContext().close();
            }));
        }));
        this.await();
    }

    @Test
    public void testCloseClientImmediately() {
        HttpClient client = this.vertx.createHttpClient();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {}).listen(8080, this.onSuccess(v1 -> {
            AtomicBoolean resolved = new AtomicBoolean();
            client.webSocket(8080, "localhost", "/someuri", ar -> {
                if (resolved.compareAndSet(false, true)) {
                    if (ar.succeeded()) {
                        this.fail();
                    } else {
                        this.testComplete();
                    }
                }
            });
            client.close();
        }));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAProxy() throws Exception {
        this.waitFor(2);
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        HAProxy proxy = new HAProxy("localhost", 8080, header);
        proxy.start(this.vertx);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setUseProxyProtocol(true)).webSocketHandler(ws -> {
            this.assertEquals(remote, ws.remoteAddress());
            this.assertEquals(local, ws.localAddress());
            ws.handler(buff -> this.complete());
        }).listen(8080, "localhost", this.onSuccess(v1 -> {
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(proxy.getPort(), proxy.getHost(), "/someuri", this.onSuccess(ws -> ws.write((Object)Buffer.buffer((String)"foo"), this.onSuccess(v -> this.complete()))));
        }));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testWebSocketDisablesALPN() {
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2).setUseAlpn(true).setSsl(true).setTrustAll(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setUseAlpn(true).setSni(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get())).requestHandler(req -> req.response().end()).webSocketHandler(ws -> ws.handler(msg -> {
            this.assertEquals("hello", msg.toString());
            ws.close();
        }));
        this.server.listen(4043, "localhost", this.onSuccess(server -> this.client.request(HttpMethod.GET, 4043, "localhost", "some-uri", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            this.client.webSocket(4043, "localhost", "/", this.onSuccess(ws -> {
                this.assertTrue(ws.isSsl());
                ws.write((Object)Buffer.buffer((String)"hello"));
                ws.closeHandler(v -> this.testComplete());
            }));
        }))))));
        this.await();
    }

    @Test
    public void testSetOriginHeaderV13() {
        this.testOriginHeader(WebsocketVersion.V13, true, "http://www.example.com", HttpHeaders.ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV13() {
        this.testOriginHeader(WebsocketVersion.V13, true, null, HttpHeaders.ORIGIN, "http://localhost:8080");
    }

    @Test
    public void testDisableOriginHeaderV13() {
        this.testOriginHeader(WebsocketVersion.V13, false, null, HttpHeaders.ORIGIN, null);
    }

    @Test
    public void testSetOriginHeaderV08() {
        this.testOriginHeader(WebsocketVersion.V08, true, "http://www.example.com", (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV08() {
        this.testOriginHeader(WebsocketVersion.V08, true, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://localhost:8080");
    }

    @Test
    public void testDisableOriginHeaderV08() {
        this.testOriginHeader(WebsocketVersion.V08, false, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, null);
    }

    @Test
    public void testSetOriginHeaderV07() {
        this.testOriginHeader(WebsocketVersion.V07, true, "http://www.example.com", (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV07() {
        this.testOriginHeader(WebsocketVersion.V07, true, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://localhost:8080");
    }

    @Test
    public void testDisableOriginHeaderV07() {
        this.testOriginHeader(WebsocketVersion.V07, false, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, null);
    }

    private void testOriginHeader(WebsocketVersion version, boolean allow, String origin, CharSequence header, String expected) {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        this.server.webSocketHandler(ws -> {
            if (expected != null) {
                this.assertEquals(expected, ws.headers().get(header));
            } else {
                this.assertNull(ws.headers().get(header));
            }
        }).listen(this.onSuccess(v -> {
            this.client = this.vertx.createHttpClient();
            WebSocketConnectOptions options = new WebSocketConnectOptions().setVersion(version).setAllowOriginHeader(allow).setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/");
            if (origin != null) {
                options.addHeader(header, (CharSequence)origin);
            }
            this.client.webSocket(options, this.onSuccess(ws -> this.testComplete()));
        }));
        this.await();
    }

    private static /* synthetic */ void lambda$testSharedServersRoundRobin$17(Set connectedServers, HttpServer theServer, Map connectCount, CountDownLatch latchConns, ServerWebSocket ws) {
        connectedServers.add(theServer);
        Integer cnt = (Integer)connectCount.get(theServer);
        int icnt = cnt == null ? 0 : cnt;
        connectCount.put(theServer, ++icnt);
        latchConns.countDown();
    }

    private static class SocketMessages {
        private final List<String> receivedMessages;
        private final List<Throwable> receivedExceptions;

        public SocketMessages(List<String> receivedMessages, List<Throwable> receivedExceptions) {
            this.receivedMessages = receivedMessages;
            this.receivedExceptions = receivedExceptions;
        }

        public List<String> getReceivedMessages() {
            return this.receivedMessages;
        }

        public List<Throwable> getReceivedExceptions() {
            return this.receivedExceptions;
        }
    }
}

