/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.core.file.ZipFileResolverTest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class JarFileResolverTest
extends FileResolverTestBase {
    static File getFiles(File baseDir) throws Exception {
        return ZipFileResolverTest.getFiles(baseDir, new File("target", "files.jar"), out -> {
            try {
                return new JarOutputStream((OutputStream)out);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }, JarEntry::new);
    }

    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File files = JarFileResolverTest.getFiles(baseDir);
        return new URLClassLoader(new URL[]{files.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }
}

