/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileResolverTest
extends FileResolverTestBase {
    static File getFiles(File baseDir) throws Exception {
        return ZipFileResolverTest.getFiles(baseDir, new File("target", "files.jar"), ZipOutputStream::new, ZipEntry::new);
    }

    static File getFiles(File baseDir, File files, Function<OutputStream, ZipOutputStream> zipFact, final Function<String, ZipEntry> entryFact) throws Exception {
        if (!files.exists()) {
            try (final ZipOutputStream zip = zipFact.apply(new FileOutputStream(files));){
                final Path filesPath = new File(baseDir, "files").toPath();
                Files.walkFileTree(filesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = (ZipEntry)entryFact.apply(TestUtils.getJarEntryName(filesPath.relativize(file)));
                        zip.putNextEntry(entry);
                        zip.write(Files.readAllBytes(file));
                        zip.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String name = TestUtils.getJarEntryName(filesPath.relativize(dir));
                        if (!name.isEmpty()) {
                            ZipEntry entry = (ZipEntry)entryFact.apply(name + "/");
                            zip.putNextEntry(entry);
                            zip.closeEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                zip.putNextEntry(entryFact.apply("afilewithspaceatend "));
                zip.write("afilewithspaceatend ".getBytes());
                zip.closeEntry();
            }
        }
        return files;
    }

    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File files = ZipFileResolverTest.getFiles(baseDir);
        return new URLClassLoader(new URL[]{files.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }
}

