/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.buffer.Unpooled;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public abstract class HttpClientConnectionTest
extends HttpTestBase {
    protected SocketAddress peerAddress;
    private File tmp;
    protected HttpClientImpl client;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.peerAddress = this.testAddress;
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
            this.requestOptions.setServer(this.testAddress);
        }
        this.client = (HttpClientImpl)((HttpTestBase)this).client;
    }

    @Test
    public void testGet() throws Exception {
        this.waitFor(3);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.peerAddress).onComplete(this.onSuccess(conn -> conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
            stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), "localhost:8080", ""), false, Unpooled.EMPTY_BUFFER, true, new StreamPriority(), false, this.onSuccess(v -> {}));
            stream.headHandler(resp -> {
                this.assertEquals(200L, resp.statusCode);
                this.complete();
            });
            stream.endHandler(headers -> {
                this.assertEquals(0L, headers.size());
                this.complete();
            });
            stream.closeHandler(v -> this.complete());
        }))));
        this.await();
    }

    @Test
    public void testConnectionClose() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().close());
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress, this.peerAddress).onComplete(this.onSuccess(conn -> {
            AtomicInteger evictions = new AtomicInteger();
            conn.evictionHandler(v -> {
                this.assertEquals(1L, evictions.incrementAndGet());
                this.complete();
            });
            conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
                stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), "localhost:8080", ""), false, Unpooled.EMPTY_BUFFER, true, new StreamPriority(), false, this.onSuccess(v -> {}));
                stream.headHandler(resp -> this.fail());
                stream.endHandler(headers -> this.fail());
                stream.closeHandler(v -> {
                    this.assertEquals(1L, evictions.get());
                    this.complete();
                });
            }));
        }));
        this.await();
    }
}

