/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class HttpCompressionTest
extends HttpTestBase {
    private static final String COMPRESS_TEST_STRING = "/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */";
    private Buffer compressedTestString;
    private int compressionLevel;

    @Parameterized.Parameters(name="{index}: compressionLevel = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1}, {6}, {9});
    }

    public HttpCompressionTest(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public void setUp() throws Exception {
        ByteBuf buf;
        super.setUp();
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addFirst(new ChannelHandler[]{new JdkZlibEncoder(ZlibWrapper.GZIP, this.compressionLevel)});
        channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)COMPRESS_TEST_STRING, (Charset)StandardCharsets.UTF_8));
        channel.close();
        Queue messages = channel.outboundMessages();
        this.compressedTestString = Buffer.buffer();
        while ((buf = (ByteBuf)messages.poll()) != null) {
            byte[] tmp = new byte[buf.readableBytes()];
            buf.readBytes(tmp);
            buf.release();
            this.compressedTestString.appendBytes(tmp);
        }
    }

    @Test
    public void testSkipEncoding() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setCompressionSupported(true));
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY).end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        });
        this.startServer();
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> {
            req.putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP);
            req.send(this.onSuccess(resp -> {
                if (req.version() != HttpVersion.HTTP_2) {
                    this.assertNull(resp.getHeader(HttpHeaders.CONTENT_ENCODING));
                } else {
                    this.assertEquals(HttpHeaders.IDENTITY.toString(), resp.getHeader(HttpHeaders.CONTENT_ENCODING));
                }
                resp.body(this.onSuccess(responseBuffer -> {
                    String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
                    this.assertEquals(COMPRESS_TEST_STRING, responseBody);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testServerCompression() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setCompressionLevel(this.compressionLevel).setCompressionSupported(true));
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        });
        this.startServer();
        this.client.request(new RequestOptions().addHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP)).onComplete(this.onSuccess(req -> req.send().flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> {
            this.assertEquals(StringUtil.toHexString((byte[])this.compressedTestString.getBytes()), StringUtil.toHexString((byte[])body.getBytes()));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testServerDecompression() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setDecompressionSupported(true));
        this.server.requestHandler(req -> req.body().onComplete(this.onSuccess(body -> {
            this.assertEquals(COMPRESS_TEST_STRING, body.toString());
            req.response().end();
        })));
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)"gzip")).onComplete(this.onSuccess(req -> req.send(this.compressedTestString).flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testClientDecompression() throws Exception {
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)"gzip").end(this.compressedTestString);
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setTryUseCompression(true));
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> req.send().flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> {
            this.assertEquals(COMPRESS_TEST_STRING, body.toString());
            this.testComplete();
        }))));
        this.await();
    }
}

