/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.test.core.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NodeInfoSerializationTest {
    private final NodeInfo expected;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new NodeInfo("foo", 13004, null)}, {new NodeInfo("bar", 59500, new JsonObject())}, {new NodeInfo("baz", 30120, new JsonObject().put("foo", (Object)"bar"))});
    }

    public NodeInfoSerializationTest(NodeInfo expected) {
        this.expected = expected;
    }

    @Test
    public void testSerialization() {
        Buffer padding = TestUtils.randomBuffer(TestUtils.randomShort());
        Buffer buffer = Buffer.buffer();
        buffer.appendBuffer(padding);
        this.expected.writeToBuffer(buffer);
        NodeInfo registrationInfo = new NodeInfo();
        int pos = registrationInfo.readFromBuffer(padding.length(), buffer);
        Assert.assertEquals((Object)this.expected, (Object)registrationInfo);
        Assert.assertEquals((long)buffer.length(), (long)pos);
    }
}

