/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Context;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.Span;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Test;

public abstract class HttpTracingTestBase
extends HttpTestBase {
    private FakeTracer tracer;

    @Override
    protected VertxTracer getTracer() {
        this.tracer = new FakeTracer();
        return this.tracer;
    }

    @Test
    public void testHttpServerRequest() throws Exception {
        this.server.requestHandler(req -> {
            this.assertNotNull(this.tracer.activeSpan());
            req.response().end();
        });
        this.startServer();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            Span rootSpan = this.tracer.newTrace();
            this.tracer.activate(rootSpan);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/1", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                this.assertEquals(rootSpan, this.tracer.activeSpan());
                this.assertEquals(200L, resp.statusCode());
            }))));
        });
        HttpTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 2);
        this.assertSingleTrace(this.tracer.getFinishedSpans());
    }

    @Test
    public void testHttpServerRequestWithClient() throws Exception {
        this.server.requestHandler(req -> {
            this.assertNotNull(this.tracer.activeSpan());
            switch (req.path()) {
                case "/1": {
                    this.vertx.setTimer(10L, id1 -> this.client.request(HttpMethod.GET, 8080, "localhost", "/2", this.onSuccess(req1 -> req1.send(this.onSuccess(resp1 -> this.vertx.setTimer(10L, id2 -> this.client.request(HttpMethod.GET, 8080, "localhost", "/2", this.onSuccess(req2 -> req2.send(this.onSuccess(resp -> req.response().end()))))))))));
                    break;
                }
                case "/2": {
                    req.response().end();
                    break;
                }
                default: {
                    req.response().setStatusCode(500).end();
                }
            }
        });
        this.startServer();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            Span rootSpan = this.tracer.newTrace();
            this.tracer.activate(rootSpan);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/1", this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v2 -> {
                this.assertEquals(rootSpan, this.tracer.activeSpan());
                this.assertEquals(200L, resp.statusCode());
            })))));
        });
        HttpTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 6);
        this.assertSingleTrace(this.tracer.getFinishedSpans());
    }

    @Test
    public void testMultipleHttpServerRequest() throws Exception {
        this.server.requestHandler(serverReq -> {
            this.assertNotNull(this.tracer.activeSpan());
            switch (serverReq.path()) {
                case "/1": {
                    this.vertx.setTimer(10L, id -> this.client.request(HttpMethod.GET, 8080, "localhost", "/2", this.onSuccess(clientReq -> clientReq.send(this.onSuccess(resp -> serverReq.response().end())))));
                    break;
                }
                case "/2": {
                    serverReq.response().end();
                    break;
                }
                default: {
                    serverReq.response().setStatusCode(500).end();
                }
            }
        });
        this.startServer();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            Span rootSpan = this.tracer.newTrace();
            this.tracer.activate(rootSpan);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/1", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                this.assertEquals(rootSpan, this.tracer.activeSpan());
                this.assertEquals(200L, resp.statusCode());
            }))));
        });
        HttpTracingTestBase.waitUntil(() -> this.tracer.getFinishedSpans().size() == 4);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertEquals(4L, finishedSpans.size());
        this.assertSingleTrace(finishedSpans);
        Map spanMap = finishedSpans.stream().collect(Collectors.toMap(o -> o.id, Function.identity()));
        List lastServerSpans = finishedSpans.stream().filter(mockSpan -> mockSpan.getTags().get("span_kind").equals("server")).filter(mockSpan -> mockSpan.getTags().get("http.url").contains("localhost:8080/2")).collect(Collectors.toList());
        this.assertEquals(1L, lastServerSpans.size());
        String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
        for (Span server2Span : lastServerSpans) {
            Span client2Span = (Span)spanMap.get(server2Span.parentId);
            this.assertEquals("GET", client2Span.operation);
            this.assertEquals(scheme + "://localhost:8080/2", client2Span.getTags().get("http.url"));
            this.assertEquals("200", client2Span.getTags().get("http.status_code"));
            this.assertEquals("client", client2Span.getTags().get("span_kind"));
            Span server1Span = (Span)spanMap.get(client2Span.parentId);
            this.assertEquals("GET", server1Span.operation);
            this.assertEquals(scheme + "://localhost:8080/1", server1Span.getTags().get("http.url"));
            this.assertEquals("200", client2Span.getTags().get("http.status_code"));
            this.assertEquals("server", server1Span.getTags().get("span_kind"));
            Span client1Span = (Span)spanMap.get(server1Span.parentId);
            this.assertEquals("GET", client1Span.operation);
            this.assertEquals(scheme + "://localhost:8080/1", client1Span.getTags().get("http.url"));
            this.assertEquals("200", client2Span.getTags().get("http.status_code"));
            this.assertEquals("client", client1Span.getTags().get("span_kind"));
        }
    }

    private void assertSingleTrace(List<Span> spans) {
        for (int i = 1; i < spans.size(); ++i) {
            this.assertEquals(spans.get((int)(i - 1)).traceId, spans.get((int)i).traceId);
        }
    }
}

