/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HeadersContainsBenchmark
extends BenchmarkBase {
    private io.netty.handler.codec.http.HttpHeaders nettySmallHeaders;
    private HeadersMultiMap vertxSmallHeaders;

    @Setup
    public void setup() {
        this.nettySmallHeaders = new DefaultHttpHeaders();
        this.vertxSmallHeaders = HeadersMultiMap.httpHeaders();
        HeadersUtils.setBaseHeaders(this.nettySmallHeaders);
        HeadersUtils.setBaseHeaders((io.netty.handler.codec.http.HttpHeaders)this.vertxSmallHeaders);
    }

    @Benchmark
    public boolean nettySmallMatch() throws Exception {
        return this.nettySmallHeaders.contains(HttpHeaders.CONTENT_LENGTH.toString());
    }

    @Benchmark
    public boolean nettySmallMiss() throws Exception {
        return this.nettySmallHeaders.contains(HttpHeaders.CLOSE.toString());
    }

    @Benchmark
    public boolean nettySmallExactMatch() throws Exception {
        return this.nettySmallHeaders.contains(HttpHeaders.CONTENT_LENGTH);
    }

    @Benchmark
    public boolean nettySmallExactMiss() throws Exception {
        return this.nettySmallHeaders.contains(HttpHeaders.CLOSE);
    }

    @Benchmark
    public boolean vertxSmallMatch() throws Exception {
        return this.vertxSmallHeaders.contains(HttpHeaders.CONTENT_LENGTH.toString());
    }

    @Benchmark
    public boolean vertxSmallMiss() throws Exception {
        return this.vertxSmallHeaders.contains(HttpHeaders.CLOSE.toString());
    }

    @Benchmark
    public boolean vertxSmallExactMatch() throws Exception {
        return this.vertxSmallHeaders.contains(HttpHeaders.CONTENT_LENGTH);
    }

    @Benchmark
    public boolean vertxSmallExactMiss() throws Exception {
        return this.vertxSmallHeaders.contains(HttpHeaders.CLOSE);
    }
}

