/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.core.http.HttpHeaders;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class HeadersUtils {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z");
    public static final CharSequence VERTX_HEADER = HttpHeaders.createOptimized((String)"vert.x");
    public static final CharSequence TEXT_PLAIN_HEADER = HttpHeaders.createOptimized((String)"text/plain");
    public static final CharSequence CONTENT_LENGTH_HEADER = HttpHeaders.createOptimized((String)"20");
    public static final CharSequence DATE_HEADER = HttpHeaders.createOptimized((String)DATE_FORMAT.format(new Date()));

    public static void setBaseHeaders(io.netty.handler.codec.http.HttpHeaders headers, boolean asciiNames, boolean asciiValues) {
        headers.add(HeadersUtils.toString(HttpHeaders.CONTENT_TYPE, !asciiNames), (Object)HeadersUtils.toString(TEXT_PLAIN_HEADER, !asciiValues));
        headers.add(HeadersUtils.toString(HttpHeaders.CONTENT_LENGTH, !asciiNames), (Object)HeadersUtils.toString(CONTENT_LENGTH_HEADER, !asciiValues));
        headers.add(HeadersUtils.toString(HttpHeaders.SERVER, !asciiNames), (Object)HeadersUtils.toString(VERTX_HEADER, !asciiValues));
        headers.add(HeadersUtils.toString(HttpHeaders.DATE, !asciiNames), (Object)HeadersUtils.toString(DATE_HEADER, !asciiValues));
    }

    private static CharSequence toString(CharSequence chars, boolean toString) {
        if (!toString) {
            return chars;
        }
        return chars.toString();
    }
}

