/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.VertxSslContext;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.Test;

public class SSLHelperTest
extends VertxTestBase {
    @Test
    public void testUseJdkCiphersWhenNotSpecified() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        String[] expected = engine.getEnabledCipherSuites();
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setKeyStoreOptions((JksOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createClientContext(null, false, false);
            this.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet(ctx.cipherSuites()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUseOpenSSLCiphersWhenNotSpecified() throws Exception {
        Set expected = OpenSsl.availableOpenSslCipherSuites();
        SSLHelper helper = new SSLHelper((TCPSSLOptions)new HttpClientOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions()).setPemKeyCertOptions((PemKeyCertOptions)Cert.CLIENT_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), null);
        helper.buildContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createClientContext(null, false, false);
            this.assertEquals(expected, new HashSet(ctx.cipherSuites()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDefaultOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(true);
    }

    @Test
    public void testUserSetOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(false);
    }

    private void testOpenSslServerSessionContext(boolean testDefault) {
        HttpServerOptions httpServerOptions = new HttpServerOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions());
        if (!testDefault) {
            httpServerOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions().setSessionCacheEnabled(false));
        }
        SSLHelper defaultHelper = new SSLHelper((TCPSSLOptions)httpServerOptions.setPemKeyCertOptions((PemKeyCertOptions)Cert.SERVER_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), null);
        defaultHelper.buildContextProvider(httpServerOptions.getSslOptions(), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createServerContext(false);
            SSLSessionContext sslSessionContext = ctx.sessionContext();
            this.assertTrue(sslSessionContext instanceof OpenSslServerSessionContext);
            if (sslSessionContext instanceof OpenSslServerSessionContext) {
                this.assertEquals(testDefault, ((OpenSslServerSessionContext)sslSessionContext).isSessionCacheEnabled());
            }
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPreserveEnabledCipherSuitesOrder() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        HttpServerOptions options = new HttpServerOptions();
        for (String suite : engine.getEnabledCipherSuites()) {
            options.addEnabledCipherSuite(suite);
        }
        this.assertEquals(new ArrayList(options.getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        this.assertEquals(new ArrayList(new HttpServerOptions(options).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        SSLHelper helper = new SSLHelper((TCPSSLOptions)options.setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()), null);
        helper.buildContextProvider(options.getSslOptions(), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(sslContextProvider -> {
            this.assertEquals(new HashSet<String>(Arrays.asList(this.createEngine((SslContextProvider)sslContextProvider).getEnabledCipherSuites())), new HashSet<String>(Arrays.asList(engine.getEnabledCipherSuites())));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPreserveEnabledSecureTransportProtocolOrder() throws Exception {
        HttpServerOptions options = new HttpServerOptions();
        ArrayList<String> expectedProtocols = new ArrayList<String>(options.getEnabledSecureTransportProtocols());
        options.removeEnabledSecureTransportProtocol("TLSv1");
        options.addEnabledSecureTransportProtocol("SSLv3");
        expectedProtocols.remove("TLSv1");
        expectedProtocols.add("SSLv3");
        this.assertEquals(new ArrayList(options.getEnabledSecureTransportProtocols()), expectedProtocols);
        this.assertEquals(new ArrayList(new HttpServerOptions(options).getEnabledSecureTransportProtocols()), expectedProtocols);
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledSecureTransportProtocols()), expectedProtocols);
    }

    @Test
    public void testDefaultVersions() {
        this.testTLSVersions(new HttpServerOptions(), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(2L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1.2"));
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    @Test
    public void testSetVersion() {
        this.testTLSVersions(new HttpServerOptions().setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList("TLSv1.3"))), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(1L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    @Test
    public void testSetVersions() {
        this.testTLSVersions(new HttpServerOptions().setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.3"))), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(2L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1"));
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    private void testTLSVersions(HttpServerOptions options, Consumer<SSLEngine> check) {
        SSLHelper helper = new SSLHelper((TCPSSLOptions)options.setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()), null);
        helper.buildContextProvider(options.getSslOptions(), (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(sslContextProvider -> {
            SSLEngine engine = this.createEngine((SslContextProvider)sslContextProvider);
            check.accept(engine);
            this.testComplete();
        }));
        this.await();
    }

    public SSLEngine createEngine(SslContextProvider provider) {
        return provider.createClientContext(null, false, false).newEngine(ByteBufAllocator.DEFAULT);
    }
}

