/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.spi.tracing.HttpTracerTestBase;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.faketracer.FakeTracer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class Http2TracerTest
extends HttpTracerTestBase {
    private static final String SPAN_KIND_SERVER = "server";
    private static final String SPAN_KIND_CLIENT = "client";
    private static final String SPAN_KIND_KEY = "span_kind";

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(8080, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Test
    public void testTracingWorksAfterUpgrading() throws Exception {
        this.client.close();
        FakeTracer fakeTracer = new FakeTracer();
        this.setTracer(fakeTracer);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS).setProtocolVersion(HttpVersion.HTTP_2));
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> req.response().end("Ok"));
        this.startServer(this.testAddress);
        CountDownLatch finished = new CountDownLatch(1);
        this.waitFor(1);
        this.client.request(this.requestOptions).onSuccess(request -> {
            request.connection().closeHandler(v -> finished.countDown());
            request.send().onSuccess(response -> this.complete());
        });
        this.await();
        finished.await(5L, TimeUnit.SECONDS);
        this.assertEquals(2L, fakeTracer.getFinishedSpans().size());
        this.assertTrue("Span with kind server was not found!", fakeTracer.getFinishedSpans().stream().anyMatch(s -> SPAN_KIND_SERVER.equals(s.getTags().get(SPAN_KIND_KEY))));
        this.assertTrue("Span with kind client was not found!", fakeTracer.getFinishedSpans().stream().anyMatch(s -> SPAN_KIND_CLIENT.equals(s.getTags().get(SPAN_KIND_KEY))));
    }
}

