/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.core.TestUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.junit.Test;

public abstract class HttpTracerTestBase
extends HttpTestBase {
    private VertxTracer tracer;

    @Override
    protected VertxTracer getTracer() {
        return this.tracer;
    }

    @Test
    public void testHttpServer() throws Exception {
        final String key = TestUtils.randomAlphaString(10);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        this.setTracer(new VertxTracer(){

            public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertNull(context.getLocal((Object)key));
                context.putLocal((Object)key, val);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                return request;
            }

            public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
                HttpTracerTestBase.this.assertNotNull(response);
                HttpTracerTestBase.this.assertTrue(response instanceof HttpServerResponse);
                HttpTracerTestBase.this.assertNull(failure);
                HttpTracerTestBase.this.assertSame(val, context.getLocal((Object)key));
                HttpTracerTestBase.this.assertTrue(context.removeLocal((Object)key));
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(1L, seq.get());
            ContextInternal ctx = (ContextInternal)Vertx.currentContext();
            this.assertSame(val, ctx.localContextData().get(key));
            req.response().endHandler(v -> {
                this.assertNull(ctx.localContextData().get(key));
                this.assertEquals(2L, seq.get());
            });
            req.response().end();
        }).listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.request(HttpMethod.GET, 8080, "localhost", "/", this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testHttpServerError() throws Exception {
        this.waitFor(2);
        final String key = TestUtils.randomAlphaString(10);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        this.setTracer(new VertxTracer(){

            public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertNull(context.getLocal((Object)key));
                context.putLocal((Object)key, val);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                return request;
            }

            public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
                HttpTracerTestBase.this.assertNull(response);
                HttpTracerTestBase.this.assertNotNull(failure);
                HttpTracerTestBase.this.assertTrue(context.removeLocal((Object)key));
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(1L, seq.get());
            ContextInternal ctx = (ContextInternal)Vertx.currentContext();
            this.assertSame(val, ctx.localContextData().get(key));
            req.exceptionHandler(v -> {
                this.assertNull(ctx.localContextData().get(key));
                this.assertEquals(2L, seq.get());
                this.complete();
            });
        }).listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/")).onComplete(this.onSuccess(req -> req.response(this.onFailure(err -> this.complete())).setChunked(true).sendHead(v -> req.connection().close())));
        this.await();
    }

    @Test
    public void testHttpClientRequest() throws Exception {
        this.testHttpClientRequest(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/"), "GET");
    }

    @Test
    public void testHttpClientRequestOverrideOperation() throws Exception {
        this.testHttpClientRequest(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("/").setTraceOperation("operation-override"), "operation-override");
    }

    private void testHttpClientRequest(RequestOptions request, final String expectedOperation) throws Exception {
        final String key = TestUtils.randomAlphaString(10);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        final String traceId = UUID.randomUUID().toString();
        this.setTracer(new VertxTracer(){

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, context.getLocal((Object)key));
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                headers.accept("X-B3-TraceId", traceId);
                HttpTracerTestBase.this.assertNotNull(request);
                HttpTracerTestBase.this.assertTrue(request instanceof HttpRequest);
                HttpTracerTestBase.this.assertEquals(expectedOperation, operation);
                return request;
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, context.getLocal((Object)key));
                HttpTracerTestBase.this.assertTrue(context.removeLocal((Object)key));
                HttpTracerTestBase.this.assertNotNull(response);
                HttpTracerTestBase.this.assertTrue(response instanceof HttpResponse);
                HttpTracerTestBase.this.assertNull(failure);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(traceId, req.getHeader("X-B3-TraceId"));
            req.response().end();
        }).listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(key, val);
            this.client.request(request, this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v2 -> ctx.runOnContext(v -> {
                this.assertNull(tracerMap.get(key));
                this.testComplete();
            }))))));
        });
        this.await();
    }

    @Test
    public void testHttpClientError() throws Exception {
        final String key = TestUtils.randomAlphaString(10);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        final String traceId = UUID.randomUUID().toString();
        this.setTracer(new VertxTracer(){

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, context.getLocal((Object)key));
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                headers.accept("X-B3-TraceId", traceId);
                return request;
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, context.getLocal((Object)key));
                HttpTracerTestBase.this.assertTrue(context.removeLocal((Object)key));
                HttpTracerTestBase.this.assertNull(response);
                HttpTracerTestBase.this.assertNotNull(failure);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(traceId, req.getHeader("X-B3-TraceId"));
            req.connection().close();
        }).listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            ConcurrentMap tracerMap = ((ContextInternal)ctx).localContextData();
            tracerMap.put(key, val);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/", this.onSuccess(req -> req.send(this.onFailure(err -> {
                this.assertEquals(2L, seq.get());
                this.assertEquals(2L, seq.get());
                this.assertNull(tracerMap.get(key));
                this.testComplete();
            }))));
        });
        this.await();
    }

    protected void setTracer(VertxTracer tracer) {
        this.server.close();
        this.tracer = tracer;
        this.vertx = this.vertx(this.getOptions());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
    }
}

