/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.junit.Test;

public class TimerTest
extends VertxTestBase {
    @Test
    public void testTimer() {
        this.timer(1L);
    }

    @Test
    public void testPeriodic1() {
        this.periodic(new PeriodicArg(100L, 100L), (delay, handler) -> this.vertx.setPeriodic(delay.delay, handler));
    }

    @Test
    public void testPeriodic2() {
        this.periodic(new PeriodicArg(100L, 100L), (delay, handler) -> this.vertx.setPeriodic(delay.delay, delay.delay, handler));
    }

    @Test
    public void testPeriodicWithInitialDelay1() {
        this.periodic(new PeriodicArg(0L, 100L), (delay, handler) -> this.vertx.setPeriodic(delay.initialDelay, delay.delay, handler));
    }

    @Test
    public void testPeriodicWithInitialDelay2() {
        this.periodic(new PeriodicArg(100L, 200L), (delay, handler) -> this.vertx.setPeriodic(delay.initialDelay, delay.delay, handler));
    }

    @Test
    public void testTimings() {
        long start = System.currentTimeMillis();
        long delay = 2000L;
        this.vertx.setTimer(2000L, timerID -> {
            long dur = System.currentTimeMillis() - start;
            this.assertTrue(dur >= 2000L);
            long maxDelay = 4000L;
            this.assertTrue("Timer accuracy: " + dur + " vs " + maxDelay, dur < maxDelay);
            this.vertx.cancelTimer(timerID.longValue());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInVerticle() {
        class MyVerticle
        extends AbstractVerticle {
            AtomicInteger cnt = new AtomicInteger();

            MyVerticle() {
            }

            public void start() {
                Thread thr = Thread.currentThread();
                this.vertx.setTimer(1L, id -> {
                    TimerTest.this.assertSame(thr, Thread.currentThread());
                    if (this.cnt.incrementAndGet() == 5) {
                        TimerTest.this.testComplete();
                    }
                });
                this.vertx.setPeriodic(2L, id -> {
                    TimerTest.this.assertSame(thr, Thread.currentThread());
                    if (this.cnt.incrementAndGet() == 5) {
                        TimerTest.this.testComplete();
                    }
                });
                this.vertx.setPeriodic(3L, 4L, id -> {
                    TimerTest.this.assertSame(thr, Thread.currentThread());
                    if (this.cnt.incrementAndGet() == 5) {
                        TimerTest.this.testComplete();
                    }
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle);
        this.await();
    }

    private void periodic(final PeriodicArg delay, BiFunction<PeriodicArg, Handler<Long>, Long> abc) {
        int numFires = 10;
        final AtomicLong id = new AtomicLong(-1L);
        final long now = System.currentTimeMillis();
        id.set(abc.apply(delay, new Handler<Long>(){
            int count;

            public void handle(Long timerID) {
                TimerTest.this.assertTrue(System.currentTimeMillis() - now >= delay.initialDelay + (long)this.count * delay.delay);
                TimerTest.this.assertEquals(id.get(), timerID);
                ++this.count;
                if (this.count == 10) {
                    TimerTest.this.vertx.cancelTimer(timerID.longValue());
                    TimerTest.this.setEndTimer();
                }
                if (this.count > 10) {
                    TimerTest.this.fail("Fired too many times");
                }
            }
        }));
        this.await();
    }

    private void timer(long delay) {
        final AtomicLong id = new AtomicLong(-1L);
        id.set(this.vertx.setTimer(delay, (Handler)new Handler<Long>(){
            int count;
            boolean fired;

            public void handle(Long timerID) {
                TimerTest.this.assertFalse(this.fired);
                this.fired = true;
                TimerTest.this.assertEquals(id.get(), timerID);
                TimerTest.this.assertEquals(0L, this.count);
                ++this.count;
                TimerTest.this.setEndTimer();
            }
        }));
        this.await();
    }

    private void setEndTimer() {
        this.vertx.setTimer(10L, id -> this.testComplete());
    }

    @Test
    public void testTimerStreamSetHandlerSchedulesTheTimer() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean handled = new AtomicBoolean();
            timer.handler(l -> {
                this.assertFalse(handled.get());
                handled.set(true);
            });
            timer.endHandler(v2 -> {
                this.assertTrue(handled.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerStreamExceptionDuringHandle() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean handled = new AtomicBoolean();
            timer.handler(l -> {
                this.assertFalse(handled.get());
                handled.set(true);
                throw new RuntimeException();
            });
            timer.endHandler(v2 -> {
                this.assertTrue(handled.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerStreamCallingWithNullHandlerCancelsTheTimer() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicInteger count = new AtomicInteger();
            timer.handler(arg_0 -> this.lambda$null$13(count, (ReadStream)timer, arg_0));
        });
        this.await();
    }

    @Test
    public void testTimerStreamCancellation() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean called = new AtomicBoolean();
            timer.handler(l -> called.set(true));
            timer.cancel();
            this.vertx.setTimer(500L, id -> {
                this.assertFalse(called.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerSetHandlerTwice() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            timer.handler(l -> this.testComplete());
            try {
                timer.handler(l -> this.fail());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.await();
    }

    @Test
    public void testTimerPauseResume() {
        TimeoutStream timer = this.vertx.timerStream(10L);
        timer.handler(l -> this.testComplete());
        timer.pause();
        timer.resume();
        this.await();
    }

    @Test
    public void testTimerPause() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(10L);
            timer.handler(l -> this.fail());
            timer.endHandler(l -> this.testComplete());
            timer.pause();
        });
        this.await();
    }

    @Test
    public void testPeriodicStreamHandler() {
        TimeoutStream timer = this.vertx.periodicStream(10L);
        AtomicInteger count = new AtomicInteger();
        timer.handler(l -> {
            int value = count.incrementAndGet();
            switch (value) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new RuntimeException();
                }
                case 2: {
                    timer.cancel();
                    this.testComplete();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        timer.endHandler(v -> this.fail());
        this.await();
    }

    @Test
    public void testPeriodicStreamHandlerWithInitialDelay() {
        TimeoutStream timer = this.vertx.periodicStream(10L, 20L);
        AtomicInteger count = new AtomicInteger();
        timer.handler(l -> {
            int value = count.incrementAndGet();
            switch (value) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new RuntimeException();
                }
                case 2: {
                    timer.cancel();
                    this.testComplete();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        timer.endHandler(v -> this.fail());
        this.await();
    }

    @Test
    public void testPeriodicSetHandlerTwice() {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.periodicStream(200L);
            timer.handler(l -> this.testComplete());
            try {
                timer.handler(l -> this.fail());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.await();
    }

    @Test
    public void testPeriodicPauseResume() {
        TimeoutStream timer = this.vertx.periodicStream(200L);
        AtomicInteger count = new AtomicInteger();
        timer.handler(arg_0 -> this.lambda$testPeriodicPauseResume$33(count, (ReadStream)timer, arg_0));
        this.await();
    }

    @Test
    public void testTimeoutStreamEndCallbackAsynchronously() {
        TimeoutStream stream = this.vertx.timerStream(200L);
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v2 -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            this.testComplete();
        });
        stream.handler(id -> {});
        this.await();
    }

    @Test
    public void testCancelTimerWhenScheduledOnWorker() {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                long id = this.vertx.setTimer(100L, id_ -> TimerTest.this.fail());
                Thread.sleep(200L);
                TimerTest.this.assertTrue(this.vertx.cancelTimer(id));
                TimerTest.this.testComplete();
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testWorkerTimer() {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                this.vertx.setTimer(10L, id -> {
                    TimerTest.this.assertTrue(Context.isOnWorkerThread());
                    TimerTest.this.testComplete();
                });
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testFailInTimer() {
        RuntimeException failure = new RuntimeException();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            ctx.exceptionHandler(err -> {
                this.assertSame(err, failure);
                this.testComplete();
            });
            this.vertx.setTimer(5L, id -> {
                throw failure;
            });
        });
        this.await();
    }

    @Test
    public void testCancellationRace() throws Exception {
        for (int i = 0; i < 200; ++i) {
            AtomicBoolean fired = new AtomicBoolean();
            long timerId = this.vertx.setTimer(5L, id -> fired.set(true));
            Thread.sleep(5L);
            boolean res = this.vertx.cancelTimer(timerId);
            if (res && fired.get()) {
                throw new AssertionError((Object)("It failed " + i));
            }
        }
    }

    @Test
    public void testUndeployCancelTimer() {
        this.testUndeployCancellation(() -> this.vertx.setTimer(1000L, id -> {}));
    }

    @Test
    public void testUndeployCancelPeriodic() {
        this.testUndeployCancellation(() -> this.vertx.setPeriodic(1000L, id -> {}));
    }

    private void testUndeployCancellation(final Supplier<Long> f) {
        final AtomicLong timer = new AtomicLong();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() {
                timer.set((Long)f.get());
            }
        }, this.onSuccess(deployment -> this.vertx.undeploy(deployment, v -> {
            this.assertFalse(this.vertx.cancelTimer(timer.get()));
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testTimerOnContext() {
        this.disableThreadChecks();
        EventLoopContext ctx1 = ((VertxInternal)this.vertx).createEventLoopContext();
        this.waitFor(2);
        EventLoopContext ctx2 = ((VertxInternal)this.vertx).createEventLoopContext();
        this.assertNotSame(ctx1, ctx2);
        ctx2.runOnContext(arg_0 -> this.lambda$testTimerOnContext$48((ContextInternal)ctx2, (ContextInternal)ctx1, arg_0));
        this.await();
    }

    @Test
    public void testPeriodicOnContext() {
        this.disableThreadChecks();
        this.waitFor(4);
        EventLoopContext ctx1 = ((VertxInternal)this.vertx).createEventLoopContext();
        EventLoopContext ctx2 = ((VertxInternal)this.vertx).createEventLoopContext();
        this.assertNotSame(ctx1, ctx2);
        ctx2.runOnContext(arg_0 -> this.lambda$testPeriodicOnContext$49((ContextInternal)ctx2, (ContextInternal)ctx1, arg_0));
        this.await();
    }

    @Repeat(times=100)
    @Test
    public void testRaceWhenTimerCreatedOutsideEventLoop() {
        int numThreads = 1000;
        int numIter = 1;
        Thread[] threads = new Thread[numThreads];
        AtomicInteger count = new AtomicInteger(numIter * numThreads);
        for (int i = 0; i < numThreads; ++i) {
            Thread th = new Thread(() -> ((VertxImpl)this.vertx).scheduleTimeout(((VertxImpl)this.vertx).getOrCreateContext(), false, 1L, TimeUnit.NANOSECONDS, false, ignore -> count.decrementAndGet()));
            th.start();
            threads[i] = th;
        }
        TimerTest.waitUntil(() -> count.get() == 0);
    }

    @Test
    public void testContextTimer() {
        this.waitFor(2);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                ((ContextInternal)this.context).setTimer(1000L, id -> TimerTest.this.complete());
                this.context.runOnContext(v -> this.vertx.undeploy(this.context.deploymentID(), TimerTest.this.onSuccess(ar -> ((ContextInternal)this.context).setTimer(1L, id -> TimerTest.this.complete()))));
            }
        });
        this.await();
    }

    private /* synthetic */ void lambda$testPeriodicOnContext$49(final ContextInternal ctx2, final ContextInternal ctx1, Void v) {
        this.vertx.setPeriodic(10L, (Handler)new Handler<Long>(){
            int count;

            public void handle(Long l) {
                TimerTest.this.assertSame(ctx2, TimerTest.this.vertx.getOrCreateContext());
                if (++this.count == 2) {
                    TimerTest.this.vertx.cancelTimer(l.longValue());
                }
                TimerTest.this.complete();
            }
        });
        ctx1.setPeriodic(10L, (Handler)new Handler<Long>(){
            int count;

            public void handle(Long l) {
                TimerTest.this.assertSame(ctx1, TimerTest.this.vertx.getOrCreateContext());
                if (++this.count == 2) {
                    TimerTest.this.vertx.cancelTimer(l.longValue());
                }
                TimerTest.this.complete();
            }
        });
    }

    private /* synthetic */ void lambda$testTimerOnContext$48(ContextInternal ctx2, ContextInternal ctx1, Void v) {
        this.vertx.setTimer(10L, l -> {
            this.assertSame(ctx2, this.vertx.getOrCreateContext());
            this.complete();
        });
        ctx1.setTimer(10L, l -> {
            this.assertSame(ctx1, this.vertx.getOrCreateContext());
            this.complete();
        });
    }

    private /* synthetic */ void lambda$testPeriodicPauseResume$33(AtomicInteger count, ReadStream timer, Long id) {
        int cnt = count.incrementAndGet();
        if (cnt == 2) {
            timer.pause();
            this.vertx.setTimer(500L, id2 -> {
                this.assertEquals(2L, count.get());
                timer.resume();
            });
        } else if (cnt == 3) {
            this.testComplete();
        }
    }

    private /* synthetic */ void lambda$null$13(AtomicInteger count, ReadStream timer, Long l) {
        if (count.incrementAndGet() == 1) {
            timer.handler(null);
            this.vertx.setTimer(200L, id -> {
                this.assertEquals(1L, count.get());
                this.testComplete();
            });
        } else {
            this.fail();
        }
    }

    static class PeriodicArg {
        final long initialDelay;
        final long delay;

        PeriodicArg(long initialDelay, long delay) {
            this.initialDelay = initialDelay;
            this.delay = delay;
        }
    }
}

