/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2UpgradeClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.tls.Cert;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.KeyManagerFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class Http2ClientTest
extends Http2TestBase {
    @Test
    public void testClientSettings() throws Exception {
        this.waitFor(2);
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        Http2Settings updatedSettings = TestUtils.randomHttp2Settings();
        updatedSettings.setHeaderTableSize(initialSettings.getHeaderTableSize());
        AtomicInteger count = new AtomicInteger();
        Promise end = Promise.promise();
        this.server.requestHandler(req -> end.future().onComplete(v -> req.response().end())).connectionHandler(conn -> {
            Http2Settings initialRemoteSettings = conn.remoteSettings();
            this.assertEquals(initialSettings.isPushEnabled(), initialRemoteSettings.isPushEnabled());
            this.assertEquals(initialSettings.getMaxHeaderListSize(), initialRemoteSettings.getMaxHeaderListSize());
            this.assertEquals(initialSettings.getMaxFrameSize(), initialRemoteSettings.getMaxFrameSize());
            this.assertEquals(initialSettings.getInitialWindowSize(), initialRemoteSettings.getInitialWindowSize());
            this.assertEquals(initialSettings.getHeaderTableSize(), initialRemoteSettings.getHeaderTableSize());
            this.assertEquals(initialSettings.get(7), initialRemoteSettings.get(7));
            Context ctx = Vertx.currentContext();
            conn.remoteSettingsHandler(settings -> {
                this.assertOnIOContext(ctx);
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(updatedSettings.getMaxHeaderListSize(), settings.getMaxHeaderListSize());
                        this.assertEquals(updatedSettings.getMaxFrameSize(), settings.getMaxFrameSize());
                        this.assertEquals(updatedSettings.getInitialWindowSize(), settings.getInitialWindowSize());
                        this.assertEquals(updatedSettings.getHeaderTableSize(), settings.getHeaderTableSize());
                        this.assertEquals(updatedSettings.get(7), settings.get(7));
                        this.complete();
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setInitialSettings(initialSettings));
        this.client.connectionHandler(conn -> this.vertx.runOnContext(v -> conn.updateSettings(updatedSettings, ar -> end.complete())));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.complete()))));
        this.await();
    }

    @Test
    public void testInvalidSettings() throws Exception {
        Http2Settings settings = new Http2Settings();
        try {
            settings.set(Integer.MAX_VALUE, 0L);
            this.fail("max id should be 0-0xFFFF");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            settings.set(7, -1L);
            this.fail("max value should be 0-0xFFFFFFFF");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testServerSettings() throws Exception {
        Http2Settings expectedSettings = TestUtils.randomHttp2Settings();
        expectedSettings.setHeaderTableSize(4096L);
        Context otherContext = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> otherContext.runOnContext(v -> conn.updateSettings(expectedSettings)));
        this.server.requestHandler(req -> {});
        this.startServer();
        AtomicInteger count = new AtomicInteger();
        this.client.connectionHandler(conn -> conn.remoteSettingsHandler(settings -> {
            switch (count.getAndIncrement()) {
                case 0: {
                    this.assertEquals(expectedSettings.getMaxHeaderListSize(), settings.getMaxHeaderListSize());
                    this.assertEquals(expectedSettings.getMaxFrameSize(), settings.getMaxFrameSize());
                    this.assertEquals(expectedSettings.getInitialWindowSize(), settings.getInitialWindowSize());
                    this.assertEquals(expectedSettings.getMaxConcurrentStreams(), settings.getMaxConcurrentStreams());
                    this.assertEquals(expectedSettings.getHeaderTableSize(), settings.getHeaderTableSize());
                    this.assertEquals(expectedSettings.get(7), settings.get(7));
                    this.testComplete();
                }
            }
        }));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(resp -> {}))));
        this.await();
    }

    @Test
    public void testReduceMaxConcurrentStreams() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxConcurrentStreams(10L)));
        ArrayList requests = new ArrayList();
        AtomicBoolean flipped = new AtomicBoolean();
        this.server.requestHandler(req -> {
            int max = flipped.get() ? 5 : 10;
            requests.add(req);
            this.assertTrue("Was expecting at most " + max + " concurrent requests instead of " + requests.size(), requests.size() <= max);
            if (requests.size() == max) {
                this.vertx.setTimer(30L, id -> {
                    HttpConnection conn = req.connection();
                    if (max == 10) {
                        conn.updateSettings(new Http2Settings(conn.settings()).setMaxConcurrentStreams((long)(max / 2)));
                        flipped.set(true);
                    }
                    requests.forEach(request -> request.response().end());
                    requests.clear();
                });
            }
        });
        this.startServer();
        this.client.connectionHandler(conn -> conn.remoteSettingsHandler(settings -> conn.ping(Buffer.buffer((String)"settings"))));
        this.waitFor(50);
        for (int i = 0; i < 50; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.body(this.onSuccess(body -> this.complete()))))));
        }
        this.await();
    }

    @Test
    public void testGet() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            {
                this.val$encoder = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertTrue(endStream);
                    this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, true, ctx.newPromise());
                    ctx.flush();
                });
            }

            public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> Http2ClientTest.this.testComplete());
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                Context ctx = this.vertx.getOrCreateContext();
                this.assertOnIOContext(ctx);
                resp.endHandler(v -> {
                    this.assertOnIOContext(ctx);
                    resp.request().connection().close();
                });
            }))));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testHeaders() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            this.assertEquals("https", req.scheme());
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("/somepath", req.path());
            this.assertEquals("localhost:4043", req.host());
            this.assertEquals("localhost", req.authority().host());
            this.assertEquals(4043L, req.authority().port());
            this.assertEquals("foo_request_value", req.getHeader("Foo_request"));
            this.assertEquals("bar_request_value", req.getHeader("bar_request"));
            this.assertEquals(2L, req.headers().getAll("juu_request").size());
            this.assertEquals("juu_request_value_1", req.headers().getAll("juu_request").get(0));
            this.assertEquals("juu_request_value_2", req.headers().getAll("juu_request").get(1));
            this.assertEquals(new HashSet<String>(Arrays.asList("foo_request", "bar_request", "juu_request")), new HashSet(req.headers().names()));
            reqCount.incrementAndGet();
            HttpServerResponse resp = req.response();
            resp.putHeader("content-type", "text/plain");
            resp.putHeader("Foo_response", "foo_value");
            resp.putHeader("bar_response", "bar_value");
            resp.putHeader("juu_response", Arrays.asList("juu_value_1", "juu_value_2"));
            resp.end();
        });
        this.startServer();
        this.client.request(new RequestOptions().setPort(Integer.valueOf(4043)).setHost("localhost").setURI("/somepath")).onComplete(this.onSuccess(req -> {
            req.putHeader("Foo_request", "foo_request_value").putHeader("bar_request", "bar_request_value").putHeader("juu_request", Arrays.asList("juu_request_value_1", "juu_request_value_2"));
            req.send(this.onSuccess(resp -> {
                Context ctx = this.vertx.getOrCreateContext();
                this.assertOnIOContext(ctx);
                this.assertEquals(1L, resp.request().streamId());
                this.assertEquals(1L, reqCount.get());
                this.assertEquals(HttpVersion.HTTP_2, resp.version());
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals("OK", resp.statusMessage());
                this.assertEquals("text/plain", resp.getHeader("content-type"));
                this.assertEquals("foo_value", resp.getHeader("foo_response"));
                this.assertEquals("bar_value", resp.getHeader("bar_response"));
                this.assertEquals(2L, resp.headers().getAll("juu_response").size());
                this.assertEquals("juu_value_1", resp.headers().getAll("juu_response").get(0));
                this.assertEquals("juu_value_2", resp.headers().getAll("juu_response").get(1));
                this.assertEquals(new HashSet<String>(Arrays.asList("content-type", "content-length", "foo_response", "bar_response", "juu_response")), new HashSet(resp.headers().names()));
                resp.endHandler(v -> {
                    this.assertOnIOContext(ctx);
                    this.testComplete();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testResponseBody() throws Exception {
        this.testResponseBody(TestUtils.randomAlphaString(100));
    }

    @Test
    public void testEmptyResponseBody() throws Exception {
        this.testResponseBody("");
    }

    private void testResponseBody(String expected) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.end(expected);
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            AtomicInteger count = new AtomicInteger();
            Buffer content = Buffer.buffer();
            resp.handler(buff -> {
                content.appendBuffer(buff);
                count.incrementAndGet();
            });
            resp.endHandler(v -> {
                this.assertTrue(count.get() > 0);
                this.assertEquals(expected, content.toString());
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testOverrideAuthority() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.host());
            this.assertEquals("localhost", req.authority().host());
            this.assertEquals(4444L, req.authority().port());
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions().setServer(this.testAddress).setPort(Integer.valueOf(4444)).setHost("localhost")).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()));
        this.await();
    }

    @Test
    public void testTrailers() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            resp.write("some-content");
            resp.putTrailer("Foo", "foo_value");
            resp.putTrailer("bar", "bar_value");
            resp.putTrailer("juu", Arrays.asList("juu_value_1", "juu_value_2"));
            resp.end();
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(null, resp.getTrailer("foo"));
            resp.exceptionHandler(this::fail);
            resp.endHandler(v -> {
                this.assertEquals("foo_value", resp.getTrailer("foo"));
                this.assertEquals("foo_value", resp.getTrailer("Foo"));
                this.assertEquals("bar_value", resp.getTrailer("bar"));
                this.assertEquals(2L, resp.trailers().getAll("juu").size());
                this.assertEquals("juu_value_1", resp.trailers().getAll("juu").get(0));
                this.assertEquals("juu_value_2", resp.trailers().getAll("juu").get(1));
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testBodyEndHandler() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(131072));
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.end(expected);
        });
        this.startServer();
        this.client.request(this.requestOptions).onSuccess(req -> req.send(this.onSuccess(resp -> {
            Context ctx = this.vertx.getOrCreateContext();
            resp.exceptionHandler(this::fail);
            resp.bodyHandler(body -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(expected, body);
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testPost() throws Exception {
        this.testPost(TestUtils.randomAlphaString(100));
    }

    @Test
    public void testEmptyPost() throws Exception {
        this.testPost("");
    }

    private void testPost(String expected) throws Exception {
        Buffer content = Buffer.buffer();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.POST, req.method());
            req.handler(buff -> {
                content.appendBuffer(buff);
                count.getAndIncrement();
            });
            req.endHandler(v -> {
                this.assertTrue(count.get() > 0);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertEquals(expected, content.toString());
            this.testComplete();
        }))).end(Buffer.buffer((String)expected))));
        this.await();
    }

    @Test
    public void testClientRequestWriteability() throws Exception {
        Buffer content = Buffer.buffer();
        Buffer expected = Buffer.buffer();
        String chunk = TestUtils.randomAlphaString(100);
        CompletableFuture done = new CompletableFuture();
        AtomicBoolean paused = new AtomicBoolean();
        AtomicInteger numPause = new AtomicInteger();
        this.server.requestHandler(req -> {
            Context ctx = this.vertx.getOrCreateContext();
            done.thenAccept(v1 -> {
                paused.set(false);
                ctx.runOnContext(v2 -> req.resume());
            });
            numPause.incrementAndGet();
            req.pause();
            paused.set(true);
            req.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
            req.endHandler(v -> {
                this.assertEquals(expected, content);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        this.client.close();
        ctx.runOnContext(v -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> {
                req.response(this.onSuccess(resp -> this.testComplete())).setChunked(true).exceptionHandler(err -> this.fail());
                AtomicInteger sent = new AtomicInteger();
                AtomicInteger count = new AtomicInteger();
                AtomicInteger drained = new AtomicInteger();
                this.vertx.setPeriodic(1L, timerID -> {
                    if (req.writeQueueFull()) {
                        this.assertTrue(paused.get());
                        this.assertEquals(1L, numPause.get());
                        req.drainHandler(v2 -> {
                            this.assertOnIOContext(ctx);
                            this.assertEquals(0L, drained.getAndIncrement());
                            this.assertEquals(1L, numPause.get());
                            this.assertFalse(paused.get());
                            req.end();
                        });
                        this.vertx.cancelTimer(timerID.longValue());
                        done.complete(null);
                    } else {
                        count.incrementAndGet();
                        expected.appendString(chunk);
                        req.write(chunk);
                        sent.addAndGet(chunk.length());
                    }
                });
            }));
        });
        this.await();
    }

    @Test
    public void testClientResponsePauseResume() throws Exception {
        String content = TestUtils.randomAlphaString(1024);
        Buffer expected = Buffer.buffer();
        Promise whenFull = Promise.promise();
        AtomicBoolean drain = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.putHeader("content-type", "text/plain");
            resp.setChunked(true);
            this.vertx.setPeriodic(1L, timerID -> {
                if (resp.writeQueueFull()) {
                    resp.drainHandler(v -> {
                        Buffer last = Buffer.buffer((String)"last");
                        expected.appendBuffer(last);
                        resp.end(last);
                        this.assertEquals(expected.toString().getBytes().length, resp.bytesWritten());
                    });
                    this.vertx.cancelTimer(timerID.longValue());
                    drain.set(true);
                    whenFull.complete();
                } else {
                    Buffer chunk = Buffer.buffer((String)content);
                    expected.appendBuffer(chunk);
                    resp.write((Object)chunk);
                }
            });
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            Context ctx = this.vertx.getOrCreateContext();
            Buffer received = Buffer.buffer();
            resp.pause();
            resp.handler(buff -> {
                if (whenFull.future().isComplete()) {
                    this.assertSame(ctx, Vertx.currentContext());
                } else {
                    this.assertOnIOContext(ctx);
                }
                received.appendBuffer(buff);
            });
            resp.endHandler(v -> {
                this.assertEquals(expected.toString().length(), received.toString().length());
                this.testComplete();
            });
            whenFull.future().onComplete(v -> resp.resume());
        }))));
        this.await();
    }

    @Test
    public void testQueueingRequests() throws Exception {
        this.testQueueingRequests(100, null);
    }

    @Test
    public void testQueueingRequestsMaxConcurrentStream() throws Exception {
        this.testQueueingRequests(100, 10L);
    }

    private void testQueueingRequests(int numReq, Long max) throws Exception {
        this.waitFor(numReq);
        String expected = TestUtils.randomAlphaString(100);
        this.server.close();
        Http2Settings serverSettings = new Http2Settings();
        if (max != null) {
            serverSettings.setMaxConcurrentStreams(max.longValue());
        }
        this.server = this.vertx.createHttpServer(this.serverOptions.setInitialSettings(serverSettings));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer();
        CountDownLatch latch = new CountDownLatch(1);
        this.client.connectionHandler(conn -> {
            this.assertEquals(max == null ? 0xFFFFFFFFL : max, conn.remoteSettings().getMaxConcurrentStreams());
            latch.countDown();
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::end));
        this.awaitLatch(latch);
        for (int i = 0; i < numReq; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                Buffer content = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
                resp.endHandler(v -> {
                    this.assertEquals(expected, content.toString());
                    this.complete();
                });
            }))));
        }
        this.await();
    }

    @Test
    public void testReuseConnection() throws Exception {
        ArrayList ports = new ArrayList();
        this.server.requestHandler(req -> {
            SocketAddress address = req.remoteAddress();
            this.assertNotNull(address);
            ports.add(address);
            req.response().end();
        });
        this.startServer();
        CountDownLatch doReq = new CountDownLatch(1);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> doReq.countDown())))));
        this.awaitLatch(doReq);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertEquals(2L, ports.size());
            this.assertEquals(ports.get(0), ports.get(1));
            this.testComplete();
        })))));
        this.await();
    }

    @Test
    public void testConnectionFailed() throws Exception {
        this.client.request(new RequestOptions(this.requestOptions).setPort(Integer.valueOf(4044))).onComplete(this.onFailure(err -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            this.assertTrue(err instanceof ConnectException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFallbackOnHttp1() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setUseAlpn(false));
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testServerResetClientStreamDuringRequest() throws Exception {
        String chunk = TestUtils.randomAlphaString(1024);
        this.server.requestHandler(req -> req.handler(buf -> req.response().reset(8L)));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> req.response(this.onFailure(resp -> {})).exceptionHandler(err -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            this.assertTrue(err instanceof StreamResetException);
            StreamResetException reset = (StreamResetException)err;
            this.assertEquals(8L, reset.getCode());
            this.testComplete();
        }).setChunked(true).write(chunk)));
        this.await();
    }

    @Test
    public void testServerResetClientStreamDuringResponse() throws Exception {
        this.waitFor(2);
        String chunk = TestUtils.randomAlphaString(1024);
        Promise doReset = Promise.promise();
        this.server.requestHandler(req -> {
            doReset.future().onComplete(this.onSuccess(v -> req.response().reset(8L)));
            req.response().setChunked(true).write((Object)Buffer.buffer((String)chunk));
        });
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        Handler resetHandler = err -> {
            this.assertOnIOContext(ctx);
            if (err instanceof StreamResetException) {
                StreamResetException reset = (StreamResetException)err;
                this.assertEquals(8L, reset.getCode());
                this.complete();
            }
        };
        this.client.close();
        ctx.runOnContext(v -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> {
                resp.exceptionHandler(resetHandler);
                resp.handler(buff -> doReset.complete());
            })).exceptionHandler(resetHandler).setChunked(true).write(chunk)));
        });
        this.await();
    }

    @Test
    public void testClientResetServerStream1() throws Exception {
        this.testClientResetServerStream(false, false);
    }

    @Test
    public void testClientResetServerStream2() throws Exception {
        this.testClientResetServerStream(true, false);
    }

    @Test
    public void testClientResetServerStream3() throws Exception {
        this.testClientResetServerStream(false, true);
    }

    private void testClientResetServerStream(boolean endClient, boolean endServer) throws Exception {
        this.waitFor(1);
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder, endServer){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            final /* synthetic */ boolean val$endServer;
            {
                this.val$encoder = http2ConnectionEncoder;
                this.val$endServer = bl;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, false, ctx.newPromise());
                ctx.flush();
            }

            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                this.val$encoder.writeData(ctx, streamId, Unpooled.copiedBuffer((CharSequence)"pong", (int)0, (int)4, (Charset)StandardCharsets.UTF_8), 0, this.val$endServer, ctx.newPromise());
                ctx.flush();
                return super.onDataRead(ctx, streamId, data, padding, endOfStream);
            }

            public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(10L, errorCode);
                    Http2ClientTest.this.complete();
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            if (endClient) {
                req.end(Buffer.buffer((String)"ping"));
            } else {
                req.setChunked(true).write((Object)Buffer.buffer((String)"ping"));
            }
            req.response(this.onSuccess(resp -> {
                if (endServer) {
                    resp.endHandler(v -> req.reset(10L));
                } else {
                    resp.handler(v -> req.reset(10L));
                }
            }));
        }));
        this.await();
    }

    @Test
    public void testPushPromise() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble?a=b", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse response = (HttpServerResponse)ar.result();
            response.end("the_content");
        }).end());
        this.startServer(this.testAddress);
        AtomicReference ctx = new AtomicReference();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.pushHandler(pushedReq -> {
            Context current = Vertx.currentContext();
            if (ctx.get() == null) {
                ctx.set(current);
            } else {
                this.assertSameEventLoop((Context)ctx.get(), current);
            }
            this.assertOnIOContext(current);
            this.assertEquals(HttpMethod.GET, pushedReq.getMethod());
            this.assertEquals("/wibble?a=b", pushedReq.getURI());
            this.assertEquals("/wibble", pushedReq.path());
            this.assertEquals("a=b", pushedReq.query());
            pushedReq.response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                Buffer content = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
                resp.endHandler(v -> this.complete());
            }));
        }).send(this.onSuccess(resp -> {
            Context current = Vertx.currentContext();
            if (ctx.get() == null) {
                ctx.set(current);
            } else {
                this.assertSameEventLoop((Context)ctx.get(), current);
            }
            resp.endHandler(v -> this.complete());
        }))));
        this.await();
    }

    @Test
    public void testResetActivePushPromise() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse response = (HttpServerResponse)ar.result();
            response.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.assertEquals(Http2Error.CANCEL.code(), ((StreamResetException)err).getCode());
                    this.testComplete();
                }
            });
            response.setChunked(true).write("some_content");
        }));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.pushHandler(pushedReq -> pushedReq.response(this.onSuccess(pushedResp -> pushedResp.handler(buff -> pushedReq.reset(Http2Error.CANCEL.code()))))).send(this.onFailure(resp -> {}))));
        this.await();
    }

    @Test
    public void testResetPendingPushPromise() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertFalse(ar.succeeded());
            this.testComplete();
        }));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setInitialSettings(new Http2Settings().setMaxConcurrentStreams(0L)));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.pushHandler(pushedReq -> pushedReq.reset(Http2Error.CANCEL.code())).send(this.onFailure(resp -> {}))));
        this.await();
    }

    @Test
    public void testResetPushPromiseNoHandler() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse resp = (HttpServerResponse)ar.result();
            resp.setChunked(true).write("content");
            AtomicLong reset = new AtomicLong();
            resp.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    reset.set(((StreamResetException)err).getCode());
                }
            });
            resp.closeHandler(v -> {
                this.assertEquals(Http2Error.CANCEL.code(), reset.get());
                this.testComplete();
            });
        }));
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::end));
        this.await();
    }

    @Test
    public void testConnectionHandler() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        AtomicReference connection = new AtomicReference();
        AtomicInteger count = new AtomicInteger();
        this.client.connectionHandler(conn -> {
            if (count.getAndIncrement() == 0) {
                Context ctx = Vertx.currentContext();
                this.assertOnIOContext(ctx);
                this.assertTrue(connection.compareAndSet(null, conn));
            } else {
                this.fail();
            }
        });
        for (int i = 0; i < 2; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                this.assertSame(connection.get(), resp.request().connection());
                this.complete();
            }))));
        }
        this.await();
    }

    @Ignore(value="Does not pass in CI - investigate")
    @Test
    public void testConnectionShutdownInConnectionHandler() throws Exception {
        this.waitFor(2);
        AtomicInteger serverStatus = new AtomicInteger();
        this.server.connectionHandler(conn -> {
            if (serverStatus.getAndIncrement() == 0) {
                conn.goAwayHandler(ga -> {
                    this.assertEquals(0L, ga.getErrorCode());
                    this.assertEquals(1L, serverStatus.getAndIncrement());
                });
                conn.shutdownHandler(v -> this.assertEquals(2L, serverStatus.getAndIncrement()));
                conn.closeHandler(v -> this.assertEquals(3L, serverStatus.getAndIncrement()));
            }
        });
        this.server.requestHandler(req -> {
            this.assertEquals(5L, serverStatus.getAndIncrement());
            req.response().end("" + serverStatus.get());
        });
        this.startServer(this.testAddress);
        AtomicInteger clientStatus = new AtomicInteger();
        this.client.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            if (clientStatus.getAndIncrement() == 0) {
                conn.shutdownHandler(v -> {
                    this.assertOnIOContext(ctx);
                    clientStatus.compareAndSet(1, 2);
                    this.complete();
                });
                conn.shutdown();
            }
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.exceptionHandler(err -> this.complete()).send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testServerShutdownConnection() throws Exception {
        this.waitFor(2);
        this.server.connectionHandler(HttpConnection::shutdown);
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        this.client.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            conn.goAwayHandler(ga -> {
                this.assertOnIOContext(ctx);
                this.complete();
            });
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {
            this.assertEquals("Was expecting HttpClosedException instead of " + err.getClass().getName() + " / " + err.getMessage(), HttpClosedException.class, err.getClass());
            this.assertEquals(0L, ((HttpClosedException)err).goAway().getErrorCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testReceivingGoAwayDiscardsTheConnection() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        Set connections = Collections.synchronizedSet(new HashSet());
        this.server.requestHandler(req -> {
            connections.add(req.connection());
            switch (reqCount.getAndIncrement()) {
                case 0: {
                    req.connection().goAway(0L);
                    break;
                }
                case 1: {
                    req.response().end();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            HttpConnection conn = req.connection();
            conn.goAwayHandler(ga -> this.vertx.runOnContext(v -> this.client.request(new RequestOptions(this.requestOptions).setTimeout(5000L)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp2 -> {
                this.assertEquals(2L, connections.size());
                this.testComplete();
            }))));
            req.send(this.onFailure(resp -> {}));
        }));
        this.await();
    }

    @Test
    public void testSendingGoAwayDiscardsTheConnection() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (reqCount.getAndIncrement()) {
                case 0: {
                    req.response().setChunked(true).write("some-data");
                    break;
                }
                case 1: {
                    req.response().end();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req1 -> req1.send(this.onSuccess(resp -> {
            resp.request().connection().goAway(0L);
            this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(4043)).setURI("/somepath").setTimeout(5000L)).onComplete(this.onSuccess(req2 -> req2.send(this.onSuccess(resp2 -> this.testComplete()))));
        }))));
        this.await();
    }

    private Http2ConnectionHandler createHttpConnectionHandler(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler) {
        class Builder
        extends AbstractHttp2ConnectionHandlerBuilder<Handler, Builder> {
            Builder() {
            }

            protected Handler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
                class Handler
                extends Http2ConnectionHandler {
                    final /* synthetic */ BiFunction val$handler;

                    public Handler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) {
                        this.val$handler = biFunction;
                        super(decoder, encoder, initialSettings);
                        decoder.frameListener((Http2FrameListener)this.val$handler.apply(decoder, encoder));
                    }
                }
                return new Handler(Http2ClientTest.this, decoder, encoder, initialSettings, handler);
            }

            public Handler build() {
                return (Handler)super.build();
            }
        }
        Builder builder = new Builder();
        return builder.build();
    }

    private ServerBootstrap createH2Server(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        this.eventLoopGroups.add(eventLoopGroup);
        bootstrap.group((EventLoopGroup)eventLoopGroup);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)((JksOptions)Cert.SERVER_JKS.get()).getKeyManagerFactory(Http2ClientTest.this.vertx)).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{HttpVersion.HTTP_2.alpnName(), HttpVersion.HTTP_1_1.alpnName()})).build();
                SslHandler sslHandler = sslContext.newHandler(ByteBufAllocator.DEFAULT);
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("whatever"){

                    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                        if ("h2".equals(protocol)) {
                            ChannelPipeline p = ctx.pipeline();
                            Http2ConnectionHandler clientHandler = Http2ClientTest.this.createHttpConnectionHandler(handler);
                            p.addLast("handler", (ChannelHandler)clientHandler);
                            return;
                        }
                        ctx.close();
                        throw new IllegalStateException("unknown protocol: " + protocol);
                    }
                }});
            }
        });
        return bootstrap;
    }

    private ServerBootstrap createH2CServer(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler, final Handler<HttpServerUpgradeHandler.UpgradeEvent> upgradeHandler, final boolean upgrade) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                if (upgrade) {
                    HttpServerCodec sourceCodec = new HttpServerCodec();
                    HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                            Http2ConnectionHandler httpConnectionHandler = Http2ClientTest.this.createHttpConnectionHandler((a, b) -> new Http2FrameListenerDecorator((Http2FrameListener)handler.apply(a, b), (Http2ConnectionDecoder)a, (Http2ConnectionEncoder)b){
                                final /* synthetic */ Http2ConnectionDecoder val$a;
                                final /* synthetic */ Http2ConnectionEncoder val$b;
                                {
                                    this.val$a = http2ConnectionDecoder;
                                    this.val$b = http2ConnectionEncoder;
                                    super(x0);
                                }

                                public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings settings) throws Http2Exception {
                                    super.onSettingsRead(ctx, settings);
                                    Http2Connection conn = this.val$a.connection();
                                    Http2Stream stream = conn.stream(1);
                                    DefaultHttp2Headers blah = new DefaultHttp2Headers();
                                    blah.status((CharSequence)"200");
                                    this.val$b.frameWriter().writeHeaders(ctx, 1, (Http2Headers)blah, 0, true, ctx.voidPromise());
                                }
                            });
                            return new Http2ServerUpgradeCodec(httpConnectionHandler);
                        }
                        return null;
                    };
                    ch.pipeline().addLast(new ChannelHandler[]{sourceCodec});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
                                upgradeHandler.handle((Object)((HttpServerUpgradeHandler.UpgradeEvent)evt));
                            }
                            super.userEventTriggered(ctx, evt);
                        }
                    }});
                } else {
                    Http2ConnectionHandler clientHandler = Http2ClientTest.this.createHttpConnectionHandler(handler);
                    ch.pipeline().addLast("handler", (ChannelHandler)clientHandler);
                }
            }
        });
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamError() throws Exception {
        this.waitFor(3);
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, false, ctx.newPromise());
                ctx.channel().write((Object)Buffer.buffer((byte[])new byte[]{0, 0, 18, 0, 8, 0, 0, 0, (byte)(streamId & 0xFF), 31, 104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).getByteBuf());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.close();
            Context ctx = this.vertx.getOrCreateContext();
            ctx.runOnContext(v -> {
                this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
                this.client.connectionHandler(conn -> conn.exceptionHandler(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }));
                this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(4043)).setURI("some-uri")).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> resp.exceptionHandler(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }))).exceptionHandler(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }).sendHead()));
            });
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionDecodeError() throws Exception {
        this.waitFor(3);
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, false, ctx.newPromise());
                this.val$enc.frameWriter().writeRstStream(ctx, 10, 0L, ctx.newPromise());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            Context ctx = this.vertx.getOrCreateContext();
            this.client.close();
            ctx.runOnContext(v -> {
                this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
                this.client.connectionHandler(conn -> conn.exceptionHandler(err -> {
                    this.assertSame(ctx, Vertx.currentContext());
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }));
                this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(4043)).setURI("some-uri")).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> resp.exceptionHandler(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }))).exceptionHandler(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof Http2Exception) {
                        this.complete();
                    }
                }).sendHead()));
            });
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidServerResponse() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"xyz"), 0, false, ctx.newPromise());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            Context ctx = this.vertx.getOrCreateContext();
            this.client.close();
            ctx.runOnContext(v -> {
                this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
                this.client.connectionHandler(conn -> conn.exceptionHandler(err -> this.fail()));
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {
                    this.assertOnIOContext(ctx);
                    if (err instanceof NumberFormatException) {
                        this.testComplete();
                    }
                }))));
            });
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testResponseCompressionEnabled() throws Exception {
        this.testResponseCompression(true);
    }

    @Test
    public void testResponseCompressionDisabled() throws Exception {
        this.testResponseCompression(false);
    }

    private void testResponseCompression(boolean enabled) throws Exception {
        byte[] expected = TestUtils.randomAlphaString(1000).getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream in = new GZIPOutputStream(baos);
        in.write(expected);
        in.close();
        byte[] compressed = baos.toByteArray();
        this.server.requestHandler(req -> {
            this.assertEquals(enabled ? "deflate, gzip, br" : null, req.getHeader((CharSequence)HttpHeaderNames.ACCEPT_ENCODING));
            req.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING.toLowerCase(), (CharSequence)"gzip").end(Buffer.buffer((byte[])compressed));
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setTryUseCompression(enabled));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            String encoding = resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            this.assertEquals(enabled ? null : "gzip", encoding);
            resp.body(this.onSuccess(buff -> {
                this.assertEquals(Buffer.buffer((byte[])(enabled ? expected : compressed)), buff);
                this.testComplete();
            }));
        }))));
        this.await();
    }

    @Test
    public void test100Continue() throws Exception {
        AtomicInteger status = new AtomicInteger();
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHandle100ContinueAutomatically(true));
        this.server.requestHandler(req -> {
            status.getAndIncrement();
            HttpServerResponse resp = req.response();
            req.bodyHandler(body -> {
                this.assertEquals(2L, status.getAndIncrement());
                this.assertEquals("request-body", body.toString());
                resp.putHeader("wibble", "wibble-value").end("response-body");
            });
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.putHeader("expect", "100-continue");
            req.response(this.onSuccess(resp -> {
                this.assertEquals(3L, status.getAndIncrement());
                resp.bodyHandler(body -> {
                    this.assertEquals(4L, status.getAndIncrement());
                    this.assertEquals("response-body", body.toString());
                    this.testComplete();
                });
            }));
            req.continueHandler(v -> {
                Context ctx = Vertx.currentContext();
                this.assertOnIOContext(ctx);
                status.getAndIncrement();
                req.end(Buffer.buffer((String)"request-body"));
            });
            req.sendHead(version -> this.assertEquals(1L, req.streamId()));
        }));
        this.await();
    }

    @Test
    public void testNetSocketConnect() throws Exception {
        this.waitFor(4);
        this.server.requestHandler(req -> req.toNetSocket(this.onSuccess(socket -> {
            AtomicInteger status = new AtomicInteger();
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.write(buff, this.onSuccess(v -> this.complete()));
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> {
                this.assertEquals(2L, status.getAndIncrement());
                socket.end((Object)Buffer.buffer((String)"last-data"), this.onSuccess(v2 -> this.complete()));
            });
            socket.closeHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.complete();
            });
        })));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            NetSocket socket = resp.netSocket();
            StringBuilder received = new StringBuilder();
            AtomicInteger count = new AtomicInteger();
            socket.handler(buff -> {
                if (buff.length() > 0) {
                    received.append(buff);
                    if (received.toString().equals("some-data")) {
                        received.setLength(0);
                        socket.end((Object)Buffer.buffer((String)"last-data"));
                    } else if (received.toString().equals("last-data")) {
                        this.assertEquals(0L, count.getAndIncrement());
                    }
                }
            });
            socket.endHandler(v -> this.assertEquals(1L, count.getAndIncrement()));
            socket.closeHandler(v -> {
                this.assertEquals(2L, count.getAndIncrement());
                this.complete();
            });
            socket.write((Object)Buffer.buffer((String)"some-data"));
        }))));
        this.await();
    }

    @Test
    public void testServerCloseNetSocket() throws Exception {
        this.waitFor(2);
        AtomicInteger status = new AtomicInteger();
        this.server.requestHandler(req -> req.toNetSocket(this.onSuccess(socket -> {
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.end(buff);
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> this.assertEquals(2L, status.getAndIncrement()));
            socket.closeHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.complete();
            });
        })));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            NetSocket socket = resp.netSocket();
            AtomicInteger count = new AtomicInteger();
            socket.handler(buff -> {
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals("some-data", buff.toString());
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> {
                this.assertEquals(1L, count.getAndIncrement());
                socket.end((Object)Buffer.buffer((String)"last-data"));
            });
            socket.closeHandler(v -> {
                this.assertEquals(2L, count.getAndIncrement());
                this.complete();
            });
            socket.write((Object)Buffer.buffer((String)"some-data"));
        }))));
        this.await();
    }

    @Test
    public void testSendHeadersCompletionHandler() throws Exception {
        AtomicInteger status = new AtomicInteger();
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(1L, status.getAndIncrement());
                resp.endHandler(v -> {
                    this.assertEquals(2L, status.getAndIncrement());
                    this.testComplete();
                });
            }));
            req.sendHead(this.onSuccess(version -> {
                this.assertEquals(0L, status.getAndIncrement());
                this.assertSame(HttpVersion.HTTP_2, req.version());
                req.end();
            }));
        }));
        this.await();
    }

    @Test
    public void testUnknownFrame() throws Exception {
        Buffer expectedSend = TestUtils.randomBuffer(500);
        Buffer expectedRecv = TestUtils.randomBuffer(500);
        this.server.requestHandler(req -> req.customFrameHandler(frame -> {
            this.assertEquals(10L, frame.type());
            this.assertEquals(253L, frame.flags());
            this.assertEquals(expectedSend, frame.payload());
            req.response().writeCustomFrame(12, 134, expectedRecv).end();
        }));
        this.startServer(this.testAddress);
        AtomicInteger status = new AtomicInteger();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                Context ctx = Vertx.currentContext();
                this.assertEquals(0L, status.getAndIncrement());
                resp.customFrameHandler(frame -> {
                    this.assertOnIOContext(ctx);
                    this.assertEquals(1L, status.getAndIncrement());
                    this.assertEquals(12L, frame.type());
                    this.assertEquals(134L, frame.flags());
                    this.assertEquals(expectedRecv, frame.payload());
                });
                resp.endHandler(v -> {
                    this.assertEquals(2L, status.getAndIncrement());
                    this.testComplete();
                });
            }));
            req.sendHead(this.onSuccess(version -> {
                this.assertSame(HttpVersion.HTTP_2, req.version());
                req.writeCustomFrame(10, 253, expectedSend);
                req.end();
            }));
        }));
        this.await();
    }

    @Test
    public void testClearTextUpgrade() throws Exception {
        List<String> requests = this.testClearText(true, false);
        Assert.assertEquals(Arrays.asList("GET", "GET"), requests);
    }

    @Test
    public void testClearTextUpgradeWithPreflightRequest() throws Exception {
        List<String> requests = this.testClearText(true, true);
        Assert.assertEquals(Arrays.asList("OPTIONS", "GET", "GET"), requests);
    }

    @Test
    public void testClearTextWithPriorKnowledge() throws Exception {
        List<String> requests = this.testClearText(false, false);
        Assert.assertEquals(Arrays.asList("GET", "GET"), requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> testClearText(boolean withUpgrade, boolean withPreflightRequest) throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        final ArrayList<String> requests = new ArrayList<String>();
        ServerBootstrap bootstrap = this.createH2CServer((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                requests.add(headers.method().toString());
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, true, ctx.newPromise());
                ctx.flush();
            }
        }, (Handler<HttpServerUpgradeHandler.UpgradeEvent>)((Handler)upgrade -> requests.add(upgrade.upgradeRequest().method().name())), withUpgrade);
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.close();
            this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(withUpgrade).setHttp2ClearTextUpgradeWithPreflightRequest(withPreflightRequest));
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req1 -> req1.send(this.onSuccess(resp1 -> {
                HttpConnection conn = resp1.request().connection();
                this.assertEquals(HttpVersion.HTTP_2, resp1.version());
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req2 -> req2.send(this.onSuccess(resp2 -> {
                    this.assertSame(((HttpClientConnection)conn).channel(), ((HttpClientConnection)resp2.request().connection()).channel());
                    this.testComplete();
                }))));
            }))));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
        return requests;
    }

    @Test
    public void testRejectClearTextUpgrade() throws Exception {
        System.setProperty("vertx.disableH2c", "true");
        try {
            this.server.close();
            this.server = this.vertx.createHttpServer(this.serverOptions.setUseAlpn(false).setSsl(false));
            AtomicBoolean first = new AtomicBoolean(true);
            this.server.requestHandler(req -> {
                MultiMap headers = req.headers();
                String upgrade = headers.get("upgrade");
                if (first.getAndSet(false)) {
                    this.assertEquals("h2c", upgrade);
                } else {
                    this.assertNull(upgrade);
                }
                this.assertEquals("localhost:4043", req.host());
                this.assertEquals("localhost", req.authority().host());
                this.assertEquals(4043L, req.authority().port());
                req.response().end("wibble");
                this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            });
            this.startServer(this.testAddress);
            this.client.close();
            this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false).setMaxPoolSize(1));
            this.waitFor(5);
            for (int i = 0; i < 5; ++i) {
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                    Http2UpgradeClientConnection connection = (Http2UpgradeClientConnection)resp.request().connection();
                    Channel ch = connection.channel();
                    ChannelPipeline pipeline = ch.pipeline();
                    for (Map.Entry entry : pipeline) {
                        this.assertTrue("Was not expecting pipeline handler " + entry.getValue().getClass(), ((String)entry.getKey()).equals("codec") || ((String)entry.getKey()).equals("handler"));
                    }
                    this.assertEquals(200L, resp.statusCode());
                    this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
                    resp.bodyHandler(body -> this.complete());
                }))));
            }
            this.await();
        }
        finally {
            System.clearProperty("vertx.disableH2c");
        }
    }

    @Test
    public void testRejectClearTextDirect() throws Exception {
        System.setProperty("vertx.disableH2c", "true");
        try {
            this.server.close();
            this.server = this.vertx.createHttpServer(this.serverOptions.setUseAlpn(false).setSsl(false));
            this.server.requestHandler(req -> this.fail());
            this.startServer(this.testAddress);
            this.client.close();
            this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(false));
            this.client.request(this.requestOptions).onComplete(this.onFailure(err -> this.testComplete()));
            this.await();
        }
        finally {
            System.clearProperty("vertx.disableH2c");
        }
    }

    @Test
    public void testIdleTimeout() throws Exception {
        this.testIdleTimeout(this.serverOptions, this.clientOptions.setDefaultPort(4043));
    }

    @Test
    public void testIdleTimeoutClearTextUpgrade() throws Exception {
        this.testIdleTimeout(new HttpServerOptions().setPort(8080).setHost("localhost"), this.clientOptions.setDefaultPort(8080).setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(true));
    }

    @Test
    public void testIdleTimeoutClearTextDirect() throws Exception {
        this.testIdleTimeout(new HttpServerOptions().setPort(8080).setHost("localhost"), this.clientOptions.setDefaultPort(8080).setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(false));
    }

    private void testIdleTimeout(HttpServerOptions serverOptions, HttpClientOptions clientOptions) throws Exception {
        this.waitFor(3);
        this.server.close();
        this.server = this.vertx.createHttpServer(serverOptions);
        this.server.requestHandler(req -> {
            req.connection().closeHandler(v -> this.complete());
            req.response().setChunked(true).write("somedata");
        });
        this.startServer(this.testAddress);
        this.client.close();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            this.client = this.vertx.createHttpClient(clientOptions.setIdleTimeout(2));
            this.client.connectionHandler(conn -> conn.closeHandler(v2 -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            }));
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
                req.exceptionHandler(err -> this.complete());
                req.sendHead();
            }));
        });
        this.await();
    }

    @Test
    public void testIdleTimoutNoConnections() throws Exception {
        this.waitFor(4);
        AtomicLong time = new AtomicLong();
        this.server.requestHandler(req -> {
            req.connection().closeHandler(v -> this.complete());
            req.response().end("somedata");
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setHttp2KeepAliveTimeout(5).setIdleTimeout(2));
        this.client.connectionHandler(conn -> conn.closeHandler(v -> {
            this.assertTrue(System.currentTimeMillis() - time.get() > 1000L);
            this.complete();
        }));
        this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(resp -> {
            time.set(System.currentTimeMillis());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testDisableIdleTimeoutClearTextUpgrade() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setIdleTimeout(2).setProtocolVersion(HttpVersion.HTTP_2).setDefaultPort(8080).setDefaultHost("localhost"));
        this.client.request(HttpMethod.GET, "/somepath").compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body1 -> this.vertx.setTimer(10L, id1 -> this.client.request(HttpMethod.GET, "/somepath").compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body2 -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testSendPing() throws Exception {
        this.waitFor(2);
        Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> conn.pingHandler(data -> {
            this.assertEquals(expected, data);
            this.complete();
        }));
        this.server.requestHandler(req -> {});
        this.startServer(ctx);
        this.client.connectionHandler(conn -> conn.ping(expected, ar -> {
            this.assertTrue(ar.succeeded());
            Buffer buff = (Buffer)ar.result();
            this.assertEquals(expected, buff);
            this.complete();
        }));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testReceivePing() throws Exception {
        Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> conn.ping(expected, ar -> {}));
        this.server.requestHandler(req -> {});
        this.startServer(ctx);
        this.client.connectionHandler(conn -> conn.pingHandler(data -> {
            this.assertEquals(expected, data);
            this.complete();
        }));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testMaxConcurrencySingleConnection() throws Exception {
        this.testMaxConcurrency(1, 5);
    }

    @Test
    public void testMaxConcurrencyMultipleConnections() throws Exception {
        this.testMaxConcurrency(2, 1);
    }

    private void testMaxConcurrency(int poolSize, int maxConcurrency) throws Exception {
        int rounds = 1 + poolSize;
        int maxRequests = poolSize * maxConcurrency;
        int totalRequests = maxRequests + maxConcurrency;
        HashSet serverConns = new HashSet();
        this.server.connectionHandler(conn -> {
            serverConns.add(conn);
            this.assertTrue(serverConns.size() <= poolSize);
        });
        ArrayList requests = new ArrayList();
        this.server.requestHandler(req -> {
            if (requests.size() < maxRequests) {
                requests.add(req);
                if (requests.size() == maxRequests) {
                    this.vertx.setTimer(300L, v -> {
                        this.assertEquals(maxRequests, requests.size());
                        requests.forEach(r -> r.response().end());
                    });
                }
            } else {
                req.response().end();
            }
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions(this.clientOptions).setHttp2MaxPoolSize(poolSize).setHttp2MultiplexingLimit(maxConcurrency));
        AtomicInteger respCount = new AtomicInteger();
        Set clientConnections = Collections.synchronizedSet(new HashSet());
        this.client.connectionHandler(clientConnections::add);
        for (int j = 0; j < rounds; ++j) {
            for (int i = 0; i < maxConcurrency; ++i) {
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> {
                    if (respCount.incrementAndGet() == totalRequests) {
                        this.testComplete();
                    }
                })))));
            }
            if (j >= poolSize) continue;
            int threshold = j + 1;
            AsyncTestBase.assertWaitUntil(() -> clientConnections.size() == threshold);
        }
        this.await();
    }

    @Test
    public void testConnectionWindowSize() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ClientTest.this.testComplete();
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions(this.clientOptions).setHttp2ConnectionWindowSize(131070));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testUpdateConnectionWindowSize() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ClientTest.this.testComplete();
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        this.client.connectionHandler(conn -> {
            this.assertEquals(65535L, conn.getWindowSize());
            conn.setWindowSize(75535);
            this.assertEquals(75535L, conn.getWindowSize());
            conn.setWindowSize(131070);
            this.assertEquals(131070L, conn.getWindowSize());
        });
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamPriority() throws Exception {
        final StreamPriority requestStreamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        StreamPriority responseStreamPriority = new StreamPriority().setDependency(153).setWeight((short)75).setExclusive(false);
        this.waitFor(2);
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder, responseStreamPriority){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            final /* synthetic */ StreamPriority val$responseStreamPriority;
            {
                this.val$encoder = http2ConnectionEncoder;
                this.val$responseStreamPriority = streamPriority2;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(requestStreamPriority.getDependency(), streamDependency);
                    Http2ClientTest.this.assertEquals(requestStreamPriority.getWeight(), weight);
                    Http2ClientTest.this.assertEquals(requestStreamPriority.isExclusive(), exclusive);
                    this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), this.val$responseStreamPriority.getDependency(), this.val$responseStreamPriority.getWeight(), this.val$responseStreamPriority.isExclusive(), 0, true, ctx.newPromise());
                    ctx.flush();
                    if (endStream) {
                        Http2ClientTest.this.complete();
                    }
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.setStreamPriority(requestStreamPriority).send(this.onSuccess(resp -> {
                this.assertEquals(responseStreamPriority, resp.request().getStreamPriority());
                Context ctx = this.vertx.getOrCreateContext();
                this.assertOnIOContext(ctx);
                resp.endHandler(v -> this.complete());
            }))));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamPriorityChange() throws Exception {
        final StreamPriority requestStreamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        final StreamPriority requestStreamPriority2 = new StreamPriority().setDependency(223).setWeight((short)145).setExclusive(false);
        StreamPriority responseStreamPriority = new StreamPriority().setDependency(153).setWeight((short)75).setExclusive(false);
        StreamPriority responseStreamPriority2 = new StreamPriority().setDependency(253).setWeight((short)175).setExclusive(true);
        this.waitFor(5);
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder, responseStreamPriority, responseStreamPriority2){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            final /* synthetic */ StreamPriority val$responseStreamPriority;
            final /* synthetic */ StreamPriority val$responseStreamPriority2;
            {
                this.val$encoder = http2ConnectionEncoder;
                this.val$responseStreamPriority = streamPriority3;
                this.val$responseStreamPriority2 = streamPriority4;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(requestStreamPriority.getDependency(), streamDependency);
                    Http2ClientTest.this.assertEquals(requestStreamPriority.getWeight(), weight);
                    Http2ClientTest.this.assertEquals(requestStreamPriority.isExclusive(), exclusive);
                    Http2ClientTest.this.assertFalse(endStream);
                    Http2ClientTest.this.complete();
                });
            }

            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(requestStreamPriority2.getDependency(), streamDependency);
                    Http2ClientTest.this.assertEquals(requestStreamPriority2.getWeight(), weight);
                    Http2ClientTest.this.assertEquals(requestStreamPriority2.isExclusive(), exclusive);
                    Http2ClientTest.this.complete();
                });
            }

            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                if (endOfStream) {
                    this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), this.val$responseStreamPriority.getDependency(), this.val$responseStreamPriority.getWeight(), this.val$responseStreamPriority.isExclusive(), 0, false, ctx.newPromise());
                    ctx.flush();
                    this.val$encoder.writePriority(ctx, streamId, this.val$responseStreamPriority2.getDependency(), this.val$responseStreamPriority2.getWeight(), this.val$responseStreamPriority2.isExclusive(), ctx.newPromise());
                    ctx.flush();
                    this.val$encoder.writeData(ctx, streamId, Buffer.buffer((String)"hello").getByteBuf(), 0, true, ctx.newPromise());
                    ctx.flush();
                    Http2ClientTest.this.vertx.runOnContext(v -> Http2ClientTest.this.complete());
                }
                return super.onDataRead(ctx, streamId, data, padding, endOfStream);
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.request(new RequestOptions().setPort(Integer.valueOf(4043)).setHost("localhost").setURI("/somepath")).onComplete(this.onSuccess(req -> {
                req.response(this.onSuccess(resp -> {
                    this.assertEquals(responseStreamPriority, resp.request().getStreamPriority());
                    Context ctx = this.vertx.getOrCreateContext();
                    this.assertOnIOContext(ctx);
                    resp.streamPriorityHandler(streamPriority -> {
                        this.assertOnIOContext(ctx);
                        this.assertEquals(responseStreamPriority2, streamPriority);
                        this.assertEquals(responseStreamPriority2, resp.request().getStreamPriority());
                        this.complete();
                    });
                    resp.endHandler(v -> {
                        this.assertOnIOContext(ctx);
                        this.assertEquals(responseStreamPriority2, resp.request().getStreamPriority());
                        this.complete();
                    });
                })).setStreamPriority(requestStreamPriority);
                req.sendHead(h -> {
                    req.setStreamPriority(requestStreamPriority2);
                    req.end();
                });
            }));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Cannot pass reliably for now (https://github.com/netty/netty/issues/9842)")
    @Test
    public void testClientStreamPriorityNoChange() throws Exception {
        final StreamPriority streamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        this.waitFor(2);
        final Promise latch = Promise.promise();
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            {
                this.val$encoder = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(streamPriority.getDependency(), streamDependency);
                    Http2ClientTest.this.assertEquals(streamPriority.getWeight(), weight);
                    Http2ClientTest.this.assertEquals(streamPriority.isExclusive(), exclusive);
                    Http2ClientTest.this.assertFalse(endStream);
                    latch.complete();
                });
                this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, true, ctx.newPromise());
                ctx.flush();
            }

            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                Http2ClientTest.this.fail("Priority frame should not be sent");
            }

            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                if (endOfStream) {
                    Http2ClientTest.this.vertx.runOnContext(v -> Http2ClientTest.this.complete());
                }
                return super.onDataRead(ctx, streamId, data, padding, endOfStream);
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(4043)).setURI("/somepath")).onComplete(this.onSuccess(req -> {
                req.response(this.onSuccess(resp -> resp.endHandler(v -> this.complete()))).setStreamPriority(streamPriority);
                req.sendHead();
                latch.future().onComplete(this.onSuccess(v -> {
                    req.setStreamPriority(streamPriority);
                    req.end();
                }));
            }));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Cannot pass reliably for now (https://github.com/netty/netty/issues/9842)")
    @Test
    public void testServerStreamPriorityNoChange() throws Exception {
        StreamPriority streamPriority = new StreamPriority().setDependency(123).setWeight((short)45).setExclusive(true);
        this.waitFor(1);
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder, streamPriority){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            final /* synthetic */ StreamPriority val$streamPriority;
            {
                this.val$encoder = http2ConnectionEncoder;
                this.val$streamPriority = streamPriority;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), this.val$streamPriority.getDependency(), this.val$streamPriority.getWeight(), this.val$streamPriority.isExclusive(), 0, false, ctx.newPromise());
                this.val$encoder.writePriority(ctx, streamId, this.val$streamPriority.getDependency(), this.val$streamPriority.getWeight(), this.val$streamPriority.isExclusive(), ctx.newPromise());
                this.val$encoder.writeData(ctx, streamId, Buffer.buffer((String)"hello").getByteBuf(), 0, true, ctx.newPromise());
                ctx.flush();
            }

            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                Http2ClientTest.this.fail("Priority frame should not be sent");
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                this.assertEquals(streamPriority, resp.request().getStreamPriority());
                Context ctx = this.vertx.getOrCreateContext();
                this.assertOnIOContext(ctx);
                resp.streamPriorityHandler(priority -> this.fail("Stream priority handler should not be called"));
                resp.endHandler(v -> {
                    this.assertEquals(streamPriority, resp.request().getStreamPriority());
                    this.complete();
                });
            }))));
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testClearTestDirectServerCloseBeforeSettingsRead() {
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(conn -> conn.handler(buff -> conn.close()));
        server.listen(4043, "localhost", this.onSuccess(s -> {
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2).setHttp2ClearTextUpgrade(false));
            this.client.request(this.requestOptions).onComplete(this.onFailure(err -> {
                this.assertEquals(err, (Object)ConnectionBase.CLOSED_EXCEPTION);
                this.testComplete();
            }));
        }));
        this.await();
    }
}

