/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.headers;

import io.netty.util.AsciiString;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpUtilsTest;
import io.vertx.core.http.headers.HeadersTestBase;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class VertxHttpHeadersTest
extends HeadersTestBase {
    protected String sameHash1 = "ABCDEF";
    protected String sameHash2 = "HOBOURN";
    protected String sameBucket1 = "ZEITOUN";
    protected String sameBucket2 = "AAKSUHX";

    protected HeadersMultiMap newMultiMap() {
        return HeadersMultiMap.httpHeaders();
    }

    @Test
    public void checkNameCollision() {
        Assert.assertEquals((long)AsciiString.hashCode((CharSequence)this.sameHash1), (long)AsciiString.hashCode((CharSequence)this.sameHash2));
        Assert.assertEquals((long)(AsciiString.hashCode((CharSequence)this.sameBucket1) & 0xF), (long)(AsciiString.hashCode((CharSequence)this.sameBucket2) & 0xF));
        Assert.assertNotEquals((long)AsciiString.hashCode((CharSequence)this.sameBucket1), (long)AsciiString.hashCode((CharSequence)this.sameBucket2));
    }

    @Test
    public void testAddEmptyStringNameIterableStringValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"=somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddEmptyStringNameEmptyStringValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        Assert.assertEquals((Object)"=\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddEmptyStringName() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "aaa";
        Assert.assertEquals((Object)"=aaa\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testSetAllEmptyStringNameAndEmptyValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringNameAndEmptyValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringName() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "bbb";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"=bbb\n", (Object)result.toString());
    }

    @Override
    @Test
    public void testSetAll() {
        HeadersMultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        headers.put("aaa", "bbb");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"=\naaa=bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetEmptyStringNameIterableStringValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"=somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testGetHashColl() {
        HeadersMultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
    }

    @Test
    public void testGetAllHashColl() {
        HeadersMultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
    }

    @Test
    public void testRemoveHashColl() {
        HeadersMultiMap mm = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        String name3 = "RZ";
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        mm.add(name3, "value3");
        mm.add(name1, "value4");
        mm.add(name2, "value5");
        mm.add(name3, "value6");
        Assert.assertEquals((long)3L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertEquals((long)1L, (long)mm.size());
        mm = this.newMultiMap();
        name1 = this.sameBucket1;
        name2 = this.sameBucket2;
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertTrue((String)"not empty", (boolean)mm.isEmpty());
    }

    @Test
    public void testRemovalNext() {
        HeadersMultiMap mmap = this.newMultiMap();
        String name1 = this.sameHash1;
        String name2 = this.sameHash2;
        mmap.add(name1, "v");
        mmap.add(name1, "v");
        mmap.add(name2, "q");
        mmap.remove(name1);
        mmap.set(name1, "w");
        Assert.assertEquals((Object)"w", (Object)mmap.get(name1));
    }

    @Test
    public void testNonCharSequenceValue() {
        HeadersMultiMap mmap = this.newMultiMap();
        mmap.set("key1", (Object)0);
        Assert.assertEquals((Object)"0", (Object)mmap.get("key1"));
        mmap.set((CharSequence)"key2", (Object)1);
        Assert.assertEquals((Object)"1", (Object)mmap.get("key2"));
        mmap.set("key3", Arrays.asList(2, 3));
        Assert.assertEquals((Object)"2", (Object)mmap.get("key3"));
        mmap.set((CharSequence)"key4", Arrays.asList(4, 5));
        Assert.assertEquals((Object)"4", (Object)mmap.get("key4"));
        mmap.add("key5", (Object)6);
        Assert.assertEquals((Object)"6", (Object)mmap.get("key5"));
        mmap.add((CharSequence)"key6", (Object)7);
        Assert.assertEquals((Object)"7", (Object)mmap.get("key6"));
        mmap.add("key8", Arrays.asList(2, 3));
        Assert.assertEquals((Object)"2", (Object)mmap.get("key8"));
        mmap.add((CharSequence)"key9", Arrays.asList(4, 5));
        Assert.assertEquals((Object)"4", (Object)mmap.get("key9"));
    }

    @Test
    public void testContainsValue1() {
        HeadersMultiMap mmap = this.newMultiMap();
        mmap.add("foo", "val1,val2,val3");
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val1", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val2", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val3", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"VAL1", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"VAL2", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"VAL3", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val4", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"helloworld", true));
    }

    @Test
    public void testContainsValue2() {
        HeadersMultiMap mmap = this.newMultiMap();
        mmap.add("foo", "val1 , val2 , val3");
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val1", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val2", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val3", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val4", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"helloworld", true));
    }

    @Test
    public void testContainsValue3() {
        HeadersMultiMap mmap = this.newMultiMap();
        mmap.add("foo", "val1,,val3");
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val1", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val2", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val3", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val4", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"helloworld", true));
    }

    @Test
    public void testContainsValue4() {
        HeadersMultiMap mmap = this.newMultiMap();
        mmap.add("foo", "val1, ,val3");
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val1", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val2", true));
        Assert.assertTrue((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val3", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"val4", true));
        Assert.assertFalse((boolean)mmap.containsValue((CharSequence)"foo", (CharSequence)"helloworld", true));
    }

    @Test
    public void testInvalidChars() {
        HeadersMultiMap mmap = HeadersMultiMap.httpHeaders();
        this.testInvalidChars(cs -> mmap.set(cs, (CharSequence)"header_value"), AsciiString::new);
        this.testInvalidChars(cs -> mmap.set(cs, (CharSequence)"header_value"), Object::toString);
    }

    public void testInvalidChars(Consumer<CharSequence> consumer, Function<byte[], CharSequence> b) {
        for (int i = 9; i < 10; ++i) {
            CharSequence val = b.apply(new byte[]{(byte)i});
            if (!HttpUtilsTest.HEADER_NAME_ALLOWED_CHARS.contains((byte)i)) {
                try {
                    consumer.accept(val);
                    Assert.fail((String)("Was not expecting " + i + " to pass"));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            consumer.accept(val);
        }
    }
}

