/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.vertx.core.Context;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class ConnectionBaseTest
extends VertxTestBase {
    @Test
    public void testQueueMessageFromEvent() {
        NetClient client = this.vertx.createNetClient();
        NetServer server = this.vertx.createNetServer();
        try {
            server.connectHandler(so -> {
                final NetSocketInternal conn = (NetSocketInternal)so;
                ChannelHandlerContext ctx = conn.channelHandlerContext();
                ChannelPipeline pipeline = ctx.pipeline();
                final ArrayList order = new ArrayList();
                pipeline.addBefore("handler", "myhandler", (ChannelHandler)new ChannelDuplexHandler(){

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                        if (msg instanceof String) {
                            String s = (String)msg;
                            order.add(s);
                            if ("msg1".equals(s)) {
                                conn.writeMessage((Object)"msg3");
                            }
                            if (order.size() == 3) {
                                ConnectionBaseTest.this.vertx.runOnContext(v -> {
                                    ConnectionBaseTest.this.assertEquals(Arrays.asList("msg1", "msg2", "msg3"), order);
                                    ConnectionBaseTest.this.testComplete();
                                });
                            }
                        } else {
                            super.write(ctx, msg, promise);
                        }
                    }
                });
                this.executeAsyncTask(() -> {
                    conn.writeMessage((Object)"msg1");
                    conn.writeMessage((Object)"msg2");
                });
            });
            server.listen(1234, "localhost", this.onSuccess(s -> client.connect(1234, "localhost", this.onSuccess(so -> {}))));
            this.await();
        }
        finally {
            server.close();
            client.close();
        }
    }

    @Test
    public void testQueueFlushFromEventLoop() {
        NetClient client = this.vertx.createNetClient();
        NetServer server = this.vertx.createNetServer();
        try {
            server.connectHandler(so -> {
                final ConnectionBase conn = (ConnectionBase)so;
                ChannelHandlerContext ctx = conn.channelHandlerContext();
                ChannelPipeline pipeline = ctx.pipeline();
                final ArrayList order = new ArrayList();
                final Runnable checkOrder = () -> {
                    if (order.size() == 3) {
                        this.vertx.runOnContext(v -> {
                            this.assertEquals(Arrays.asList("msg1", "msg2", "flush"), order);
                            this.testComplete();
                        });
                    }
                };
                pipeline.addBefore("handler", "myhandler", (ChannelHandler)new ChannelDuplexHandler(){

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                        if (msg instanceof String) {
                            String s = (String)msg;
                            order.add(s);
                            if ("msg1".equals(s)) {
                                conn.flush();
                            }
                            checkOrder.run();
                        } else {
                            super.write(ctx, msg, promise);
                        }
                    }

                    public void flush(ChannelHandlerContext ctx) throws Exception {
                        order.add("flush");
                        checkOrder.run();
                        super.flush(ctx);
                    }
                });
                this.executeAsyncTask(() -> {
                    conn.writeToChannel((Object)"msg1");
                    conn.writeToChannel((Object)"msg2");
                });
            });
            server.listen(1234, "localhost", this.onSuccess(s -> client.connect(1234, "localhost", this.onSuccess(so -> {}))));
            this.await();
        }
        finally {
            server.close();
            client.close();
        }
    }

    private void executeAsyncTask(Runnable runnable) {
        this.assertTrue(Context.isOnEventLoopThread());
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            runnable.run();
            latch.countDown();
        }).start();
        try {
            latch.await(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

