/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.net.impl.HostAndPortImpl;
import org.junit.Assert;
import org.junit.Test;

public class HostAndPortTest {
    @Test
    public void testParseIPLiteral() {
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPLiteral((String)"", (int)0, (int)0));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPLiteral((String)"[", (int)0, (int)1));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPLiteral((String)"[]", (int)0, (int)2));
        Assert.assertEquals((long)3L, (long)HostAndPortImpl.parseIPLiteral((String)"[0]", (int)0, (int)3));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPLiteral((String)"[0", (int)0, (int)2));
    }

    @Test
    public void testParseDecOctet() {
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseDecOctet((String)"", (int)0, (int)0));
        Assert.assertEquals((long)1L, (long)HostAndPortImpl.parseDecOctet((String)"0", (int)0, (int)1));
        Assert.assertEquals((long)1L, (long)HostAndPortImpl.parseDecOctet((String)"9", (int)0, (int)1));
        Assert.assertEquals((long)1L, (long)HostAndPortImpl.parseDecOctet((String)"01", (int)0, (int)2));
        Assert.assertEquals((long)2L, (long)HostAndPortImpl.parseDecOctet((String)"19", (int)0, (int)2));
        Assert.assertEquals((long)3L, (long)HostAndPortImpl.parseDecOctet((String)"192", (int)0, (int)3));
        Assert.assertEquals((long)3L, (long)HostAndPortImpl.parseDecOctet((String)"1234", (int)0, (int)4));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseDecOctet((String)"256", (int)0, (int)3));
    }

    @Test
    public void testParseIPV4Address() {
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPv4Address((String)"0.0.0", (int)0, (int)5));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPv4Address((String)"0.0.0#0", (int)0, (int)7));
        Assert.assertEquals((long)7L, (long)HostAndPortImpl.parseIPv4Address((String)"0.0.0.0", (int)0, (int)7));
        Assert.assertEquals((long)11L, (long)HostAndPortImpl.parseIPv4Address((String)"192.168.0.0", (int)0, (int)11));
        Assert.assertEquals((long)-1L, (long)HostAndPortImpl.parseIPv4Address((String)"011.168.0.0", (int)0, (int)11));
    }

    @Test
    public void testParseRegName() {
        Assert.assertEquals((long)5L, (long)HostAndPortImpl.parseRegName((String)"abcdef", (int)0, (int)5));
        Assert.assertEquals((long)5L, (long)HostAndPortImpl.parseRegName((String)"abcdef:1234", (int)0, (int)5));
        Assert.assertEquals((long)11L, (long)HostAndPortImpl.parseRegName((String)"example.com", (int)0, (int)11));
        Assert.assertEquals((long)14L, (long)HostAndPortImpl.parseRegName((String)"example-fr.com", (int)0, (int)14));
    }

    @Test
    public void testParseHost() {
        Assert.assertEquals((long)14L, (long)HostAndPortImpl.parseHost((String)"example-fr.com", (int)0, (int)14));
        Assert.assertEquals((long)5L, (long)HostAndPortImpl.parseHost((String)"[0::]", (int)0, (int)5));
        Assert.assertEquals((long)7L, (long)HostAndPortImpl.parseHost((String)"0.0.0.0", (int)0, (int)7));
    }

    @Test
    public void testParseHostAndPort() {
        this.assertHostAndPort("example.com", 8080, "example.com:8080");
        this.assertHostAndPort("example.com", -1, "example.com");
        this.assertHostAndPort("0.1.2.3", -1, "0.1.2.3");
        this.assertHostAndPort("[0::]", -1, "[0::]");
        this.assertHostAndPort("", -1, "");
        this.assertHostAndPort("", 8080, ":8080");
        Assert.assertNull((Object)HostAndPortImpl.parseHostAndPort((String)"/", (int)-1));
    }

    private void assertHostAndPort(String expectedHost, int expectedPort, String actual) {
        HostAndPortImpl hostAndPort = HostAndPortImpl.parseHostAndPort((String)actual, (int)-1);
        Assert.assertNotNull((Object)hostAndPort);
        Assert.assertEquals((Object)expectedHost, (Object)hostAndPort.host());
        Assert.assertEquals((long)expectedPort, (long)hostAndPort.port());
    }
}

