/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.metrics.Measured;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import junit.framework.AssertionFailedError;

public class FakeMetricsBase
implements Metrics {
    private static volatile Throwable unexpectedError;
    private boolean closed;

    public static <M extends FakeMetricsBase> M getMetrics(Measured measured) {
        return (M)((FakeMetricsBase)((MetricsProvider)measured).getMetrics());
    }

    public static void registerFailure(Throwable failure) {
        unexpectedError = failure;
    }

    public static void sanityCheck() {
        Throwable err = unexpectedError;
        if (err != null) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(err);
            unexpectedError = null;
            throw afe;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            FakeMetricsBase.registerFailure(new IllegalStateException(this.getClass().getSimpleName() + " already closed"));
        }
        this.closed = true;
    }
}

