/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.faketracer;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.faketracer.Scope;
import io.vertx.test.faketracer.Span;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class FakeTracer
implements VertxTracer<Span, Span> {
    private static final String ACTIVE_SCOPE_KEY = "active.scope";
    private AtomicInteger idGenerator = new AtomicInteger(0);
    List<Span> finishedSpans = new CopyOnWriteArrayList<Span>();
    private AtomicInteger closeCount = new AtomicInteger();

    int nextId() {
        return this.idGenerator.getAndIncrement();
    }

    private Span newTrace(SpanKind kind, String operation) {
        return new Span(this, kind, this.nextId(), this.nextId(), this.nextId(), operation);
    }

    public Span newTrace() {
        return new Span(this, null, this.nextId(), this.nextId(), this.nextId(), null);
    }

    public Span activeSpan() {
        return this.activeSpan(Vertx.currentContext());
    }

    public Span activeSpan(Context data) {
        Scope scope = (Scope)data.getLocal((Object)ACTIVE_SCOPE_KEY);
        return scope != null ? scope.wrapped : null;
    }

    public Scope activate(Span span) {
        return this.activate(Vertx.currentContext(), span);
    }

    public Scope activate(Context context, Span span) {
        Scope toRestore = (Scope)context.getLocal((Object)ACTIVE_SCOPE_KEY);
        Scope active = new Scope(this, span, toRestore);
        context.putLocal((Object)ACTIVE_SCOPE_KEY, (Object)active);
        return active;
    }

    public void encode(Span span, BiConsumer<String, String> headers) {
        headers.accept("span-trace-id", "" + span.traceId);
        headers.accept("span-parent-id", "" + span.parentId);
        headers.accept("span-id", "" + span.id);
    }

    private Span decode(SpanKind kind, String operation, Iterable<Map.Entry<String, String>> headers) {
        String traceId = null;
        String spanId = null;
        String spanParentId = null;
        for (Map.Entry<String, String> header : headers) {
            switch (header.getKey()) {
                case "span-trace-id": {
                    traceId = header.getValue();
                    break;
                }
                case "span-id": {
                    spanId = header.getValue();
                    break;
                }
                case "span-parent-id": {
                    spanParentId = header.getValue();
                }
            }
        }
        if (traceId != null && spanId != null && spanParentId != null) {
            return new Span(this, kind, Integer.parseInt(traceId), Integer.parseInt(spanParentId), Integer.parseInt(spanId), operation);
        }
        return null;
    }

    private Span getServerSpan(SpanKind kind, TracingPolicy policy, String operation, Iterable<Map.Entry<String, String>> headers) {
        Span parent = this.decode(kind, operation, headers);
        if (parent != null) {
            return parent.createChild(kind, operation);
        }
        if (policy == TracingPolicy.ALWAYS) {
            return this.newTrace(kind, operation);
        }
        return null;
    }

    public <R> Span receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        Span serverSpan = this.getServerSpan(kind, policy, operation, headers);
        if (serverSpan == null) {
            return null;
        }
        serverSpan.addTag("span_kind", "server");
        this.addTags(serverSpan, request, tagExtractor);
        return this.activate(context, serverSpan).span();
    }

    public <R> void sendResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            this.addTags(span, response, tagExtractor);
            span.finish(failure);
        }
    }

    public <R> Span sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        Span span = this.activeSpan(context);
        if (span != null) {
            span = span.createChild(kind, operation);
        } else if (policy == TracingPolicy.ALWAYS) {
            span = this.newTrace(kind, operation);
        } else {
            return null;
        }
        span.addTag("span_kind", "client");
        this.addTags(span, request, tagExtractor);
        this.encode(span, headers);
        return span;
    }

    public <R> void receiveResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            this.addTags(span, response, tagExtractor);
            span.finish(failure);
        }
    }

    private <T> void addTags(Span span, T obj, TagExtractor<T> tagExtractor) {
        if (obj != null) {
            int len = tagExtractor.len(obj);
            for (int idx = 0; idx < len; ++idx) {
                span.addTag(tagExtractor.name(obj, idx), tagExtractor.value(obj, idx));
            }
        }
    }

    public List<Span> getFinishedSpans() {
        return Collections.unmodifiableList(this.finishedSpans);
    }

    public void close() {
        this.closeCount.incrementAndGet();
    }

    public int closeCount() {
        return this.closeCount.get();
    }
}

