/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.faketracer;

import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.test.faketracer.FakeTracer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Span {
    private static final Throwable FINISHED_SENTINEL = new Throwable();
    public final SpanKind kind;
    public final int traceId;
    public final int parentId;
    public final int id;
    public final String operation;
    final FakeTracer tracer;
    private AtomicReference<Throwable> finished = new AtomicReference();
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();

    Span(FakeTracer tracer, SpanKind kind, int traceId, int parentId, int id, String operation) {
        this.kind = kind;
        this.tracer = tracer;
        this.traceId = traceId;
        this.parentId = parentId;
        this.id = id;
        this.operation = operation;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Span createChild(SpanKind kind, String operation) {
        return new Span(this.tracer, kind, this.traceId, this.id, this.tracer.nextId(), operation);
    }

    public void addTag(String key, String value) {
        if (value != null) {
            this.tags.put(key, value);
        }
    }

    public Throwable failure() {
        Throwable failure = this.finished.get();
        return failure == FINISHED_SENTINEL ? null : failure;
    }

    public void finish(Throwable failure) {
        Throwable t;
        Throwable throwable = t = failure == null ? FINISHED_SENTINEL : failure;
        if (!this.finished.compareAndSet(null, t)) {
            throw new IllegalStateException("Finishing already finished span!");
        }
        this.tracer.finishedSpans.add(this);
    }

    public boolean equals(Object obj) {
        Span span = (Span)obj;
        return span.kind == this.kind && span.traceId == this.traceId && span.parentId == this.parentId && span.id == this.id;
    }

    public String toString() {
        return "Span[kind=" + this.kind.name() + ",traceId=" + this.traceId + ",parentId=" + this.parentId + ",id=" + this.id + "]";
    }
}

