/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class VerticleFactoryTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        for (VerticleFactory factory : this.vertx.verticleFactories()) {
            this.vertx.unregisterVerticleFactory(factory);
        }
    }

    @Test
    public void testRegister() {
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
    }

    @Test
    public void testUnregister() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
    }

    @Test
    public void testRegisterTwice() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.registerVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterTwice() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterNoFact() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterUnregisterTwo() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        TestVerticleFactory fact2 = new TestVerticleFactory("bar");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.assertEquals(2L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact2);
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertFalse(this.vertx.verticleFactories().contains(fact2));
    }

    @Test
    public void testMatchWithPrefix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = new TestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "aa:myverticle1";
        String name2 = "bb:myverticle2";
        String name3 = "cc:myverticle3";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions(), ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMatchWithSuffix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = new TestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "myverticle1.aa";
        String name2 = "myverticle2.bb";
        String name3 = "myverticle3.cc";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions(), ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testNoMatch() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        String name1 = "cc:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertFalse(ar.succeeded());
            this.assertFalse(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertTrue(ar.cause() instanceof ClassNotFoundException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrdering() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate2() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact3.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreateAll() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertFalse(res.succeeded());
            this.assertTrue(res.cause() instanceof ClassNotFoundException);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close(done -> this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertFalse(ar.succeeded());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithoutCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close(done -> {
            this.vertx.deployVerticle((Verticle)verticle);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testClassLoader() {
        ClassLoader loader = new ClassLoader(Thread.currentThread().getContextClassLoader()){};
        final AtomicReference createClassLoader = new AtomicReference();
        VerticleFactory factory = new VerticleFactory(){

            public String prefix() {
                return "test";
            }

            public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
                createClassLoader.set(classLoader);
                promise.complete(() -> new AbstractVerticle(){});
            }
        };
        this.vertx.registerVerticleFactory(factory);
        this.vertx.deployVerticle("test:foo", new DeploymentOptions().setClassLoader(loader), this.onSuccess(id -> {
            this.assertSame(loader, createClassLoader.get());
            this.testComplete();
        }));
        this.await();
    }

    class TestVerticle
    extends AbstractVerticle {
        boolean startCalled;

        TestVerticle() {
        }

        public void start() throws Exception {
            this.startCalled = true;
        }

        public void stop() throws Exception {
        }
    }

    class TestVerticleFactory
    implements VerticleFactory {
        String prefix;
        Verticle verticle;
        String identifier;
        String isolationGroup;
        int order;
        boolean failInCreate;
        Context createContext;
        boolean createWorkerThread;

        TestVerticleFactory(String prefix) {
            this.prefix = prefix;
        }

        TestVerticleFactory(String prefix, Verticle verticle) {
            this.prefix = prefix;
            this.verticle = verticle;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order, boolean failInCreate) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
            this.failInCreate = failInCreate;
        }

        public int order() {
            return this.order;
        }

        public void init(Vertx vertx) {
        }

        public String prefix() {
            return this.prefix;
        }

        public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
            if (this.failInCreate) {
                promise.fail((Throwable)new ClassNotFoundException("whatever"));
                return;
            }
            this.identifier = verticleName;
            this.createContext = Vertx.currentContext();
            this.createWorkerThread = Context.isOnWorkerThread();
            promise.complete(() -> this.verticle);
        }

        public void close() {
        }
    }
}

