/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class EventBusInterceptorTest
extends VertxTestBase {
    protected EventBus eb;

    @Test
    public void testOutboundInterceptorOnSend() {
        this.eb.addOutboundInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertSame(sc.body(), sc.message().body());
            this.assertTrue(sc.send());
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInterceptorsOnSend() {
        this.eb.addOutboundInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertTrue(sc.send());
            sc.next();
        }).addInboundInterceptor(dc -> {
            this.assertEquals("armadillo", dc.message().body());
            this.assertSame(dc.body(), dc.message().body());
            this.assertTrue(dc.send());
            dc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testOutboundInterceptorOnPublish() {
        this.eb.addOutboundInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertFalse(sc.send());
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.publish("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInterceptorsOnPublish() {
        this.eb.addOutboundInterceptor(sc -> {
            this.assertEquals("armadillo", sc.message().body());
            this.assertFalse(sc.send());
            sc.next();
        }).addInboundInterceptor(dc -> {
            this.assertEquals("armadillo", dc.message().body());
            this.assertFalse(dc.send());
            dc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.testComplete();
        });
        this.eb.publish("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testOutboundInterceptorNoNext() {
        this.eb.addOutboundInterceptor(sc -> this.assertEquals("armadillo", sc.message().body()));
        this.eb.consumer("some-address", msg -> this.fail("Should not receive message"));
        this.eb.send("some-address", (Object)"armadillo");
        this.vertx.setTimer(200L, tid -> this.testComplete());
        this.await();
    }

    @Test
    public void testInboundInterceptorNoNext() {
        this.eb.addInboundInterceptor(dc -> this.assertEquals("armadillo", dc.message().body()));
        this.eb.consumer("some-address", msg -> this.fail("Should not receive message"));
        this.eb.send("some-address", (Object)"armadillo");
        this.vertx.setTimer(200L, tid -> this.testComplete());
        this.await();
    }

    @Test
    public void testMultipleOutboundInterceptors() {
        AtomicInteger cnt = new AtomicInteger();
        int interceptorNum = 10;
        int i = 0;
        while (i < interceptorNum) {
            int expectedCount = i++;
            this.eb.addOutboundInterceptor(sc -> {
                this.assertEquals("armadillo", sc.message().body());
                int count = cnt.getAndIncrement();
                this.assertEquals(expectedCount, count);
                sc.next();
            });
        }
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(interceptorNum, cnt.get());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testRemoveInterceptor() {
        AtomicInteger cnt1 = new AtomicInteger();
        AtomicInteger cnt2 = new AtomicInteger();
        AtomicInteger cnt3 = new AtomicInteger();
        Handler eb1 = sc -> {
            cnt1.incrementAndGet();
            sc.next();
        };
        Handler eb2 = sc -> {
            cnt2.incrementAndGet();
            sc.next();
        };
        Handler eb3 = sc -> {
            cnt3.incrementAndGet();
            sc.next();
        };
        this.eb.addInboundInterceptor(eb1).addOutboundInterceptor(eb1).addInboundInterceptor(eb2).addOutboundInterceptor(eb2).addInboundInterceptor(eb3).addOutboundInterceptor(eb3);
        this.eb.consumer("some-address", msg -> {
            if (msg.body().equals("armadillo")) {
                this.assertEquals(2L, cnt1.get());
                this.assertEquals(2L, cnt2.get());
                this.assertEquals(2L, cnt3.get());
                this.eb.removeInboundInterceptor(eb2).removeOutboundInterceptor(eb2);
                this.eb.send("some-address", (Object)"aardvark");
            } else if (msg.body().equals("aardvark")) {
                this.assertEquals(4L, cnt1.get());
                this.assertEquals(2L, cnt2.get());
                this.assertEquals(4L, cnt3.get());
                this.eb.removeInboundInterceptor(eb3).removeOutboundInterceptor(eb3);
                this.eb.send("some-address", (Object)"anteater");
            } else if (msg.body().equals("anteater")) {
                this.assertEquals(6L, cnt1.get());
                this.assertEquals(2L, cnt2.get());
                this.assertEquals(4L, cnt3.get());
                this.testComplete();
            } else {
                this.fail("wrong body");
            }
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testOutboundInterceptorOnReply() {
        AtomicInteger cnt = new AtomicInteger();
        this.eb.addOutboundInterceptor(sc -> {
            if (sc.message().body().equals("armadillo")) {
                this.assertEquals(0L, cnt.get());
            } else if (sc.message().body().equals("echidna")) {
                this.assertEquals(1L, cnt.get());
            } else {
                this.fail("wrong body");
            }
            cnt.incrementAndGet();
            sc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(1L, cnt.get());
            msg.reply((Object)"echidna");
        });
        this.eb.request("some-address", (Object)"armadillo", reply -> {
            this.assertEquals("echidna", ((Message)reply.result()).body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInboundInterceptorOnReply() {
        AtomicInteger cnt = new AtomicInteger();
        this.eb.addInboundInterceptor(dc -> {
            if (dc.message().body().equals("armadillo")) {
                this.assertEquals(0L, cnt.get());
            } else if (dc.message().body().equals("echidna")) {
                this.assertEquals(1L, cnt.get());
            } else {
                this.fail("wrong body");
            }
            cnt.incrementAndGet();
            dc.next();
        });
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(1L, cnt.get());
            msg.reply((Object)"echidna");
        });
        this.eb.request("some-address", (Object)"armadillo", reply -> {
            this.assertEquals("echidna", ((Message)reply.result()).body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExceptionInOutboundInterceptor() {
        AtomicInteger cnt = new AtomicInteger();
        Handler eb1 = sc -> {
            cnt.incrementAndGet();
            this.vertx.runOnContext(v -> sc.next());
            throw new RuntimeException("foo");
        };
        Handler eb2 = sc -> {
            cnt.incrementAndGet();
            sc.next();
        };
        this.eb.addOutboundInterceptor(eb1).addOutboundInterceptor(eb2);
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testExceptionInInboundInterceptor() {
        AtomicInteger cnt = new AtomicInteger();
        Handler eb1 = dc -> {
            cnt.incrementAndGet();
            this.vertx.runOnContext(v -> dc.next());
            throw new RuntimeException("foo");
        };
        Handler eb2 = dc -> {
            cnt.incrementAndGet();
            dc.next();
        };
        this.eb.addInboundInterceptor(eb1).addInboundInterceptor(eb2);
        this.eb.consumer("some-address", msg -> {
            this.assertEquals("armadillo", msg.body());
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        });
        this.eb.send("some-address", (Object)"armadillo");
        this.await();
    }

    @Test
    public void testInboundInterceptorContextOnSend() {
        this.testInboundInterceptorContext(false, false);
    }

    @Test
    public void testInboundInterceptorContextOnReply() {
        this.testInboundInterceptorContext(true, false);
    }

    @Test
    public void testInboundInterceptorContextOnReplyFailure() {
        this.testInboundInterceptorContext(true, true);
    }

    private void testInboundInterceptorContext(boolean reply, boolean failure) {
        this.waitFor(reply ? 2 : 1);
        AtomicReference msgCtx = new AtomicReference();
        AtomicReference replyCtx = new AtomicReference();
        this.eb.addInboundInterceptor(dc -> {
            if ("bar".equals(dc.body())) {
                msgCtx.set(Vertx.currentContext());
            } else {
                replyCtx.set(Vertx.currentContext());
            }
            dc.next();
        });
        this.eb.consumer("foo", msg -> {
            this.assertSame(msgCtx.get(), Vertx.currentContext());
            if (failure) {
                msg.fail(42, "fail");
            } else if (reply) {
                msg.reply((Object)"baz");
            }
            this.complete();
        });
        if (reply) {
            this.eb.request("foo", (Object)"bar", ar -> {
                this.assertEquals(failure, ar.failed());
                this.assertSame(replyCtx.get(), Vertx.currentContext());
                this.complete();
            });
        } else {
            this.eb.send("foo", (Object)"bar");
        }
        this.await();
    }

    @Test
    public void testOutboundInterceptorFromNonVertxThreadDispatch() {
        AtomicReference interceptorThread = new AtomicReference();
        this.eb.addOutboundInterceptor(sc -> interceptorThread.set(Thread.currentThread()));
        this.eb.consumer("some-address", msg -> {});
        this.eb.send("some-address", (Object)"armadillo");
        this.assertSame(Thread.currentThread(), interceptorThread.get());
    }

    @Test
    public void testOutboundInterceptorFromNonVertxThreadFailure() {
        RuntimeException expected = new RuntimeException();
        this.eb.addOutboundInterceptor(sc -> {
            throw expected;
        });
        this.eb.consumer("some-address", msg -> {});
        Context ctx = this.vertx.getOrCreateContext();
        AtomicReference caught = new AtomicReference();
        ctx.exceptionHandler(err -> caught.set(err));
        this.eb.send("some-address", (Object)"armadillo");
        this.assertSame(expected, caught.get());
    }

    @Test
    public void testInboundInterceptorFromNonVertxThreadDispatch() {
        AtomicReference interceptorThread = new AtomicReference();
        AtomicReference th = new AtomicReference();
        this.eb.addInboundInterceptor(sc -> new Thread(() -> {
            th.set(Thread.currentThread());
            sc.next();
        }).start());
        this.eb.addInboundInterceptor(sc -> interceptorThread.set(Thread.currentThread()));
        this.eb.consumer("some-address", msg -> {});
        this.eb.send("some-address", (Object)"armadillo");
        EventBusInterceptorTest.waitUntil(() -> interceptorThread.get() != null);
        this.assertSame(th.get(), interceptorThread.get());
    }

    @Test
    public void testInboundInterceptorFromNonVertxThreadFailure() {
        RuntimeException expected = new RuntimeException();
        this.eb.addInboundInterceptor(sc -> new Thread(() -> sc.next()).start());
        this.eb.addInboundInterceptor(sc -> {
            throw expected;
        });
        this.eb.consumer("some-address", msg -> {});
        Context ctx = this.vertx.getOrCreateContext();
        AtomicReference caught = new AtomicReference();
        ctx.exceptionHandler(err -> caught.set(err));
        this.eb.send("some-address", (Object)"armadillo");
        EventBusInterceptorTest.waitUntil(() -> caught.get() != null);
        this.assertSame(expected, caught.get());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.eb = this.vertx.eventBus();
    }
}

