/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.impl.launcher.commands.FileSelector;
import java.io.File;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class FileSelectorTest {
    @Test
    public void test() {
        String separator = File.separator;
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("**" + separator + "*.js"), (String)"foo.js")).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("**" + separator + "*.js"), (String)("target" + separator + "foo.js"))).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("**" + separator + "*.js"), (String)("src/main" + separator + "js" + separator + "foo.js"))).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("**" + separator + "*.js"), (String)("src" + separator + "main" + separator + "js" + separator + "dir" + separator + "foo.js"))).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("*" + separator + "*.js"), (String)("src" + separator + "main" + separator + "js" + separator + "dir" + separator + "foo.js"))).isFalse();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("*" + separator + "*.js"), (String)("src" + separator + "js" + separator + "foo.js"))).isFalse();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("*" + separator + "*.js"), (String)("src" + separator + "foo.js"))).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)("*" + separator + "*.js"), (String)"foo.js")).isFalse();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)"*.js", (String)"foo.js")).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)"*.js", (String)("foo" + separator + "foo.js"))).isFalse();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)"*.?s", (String)"foo.js")).isTrue();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)"*.?s", (String)"foo.s")).isFalse();
        Assertions.assertThat((boolean)FileSelector.matchPath((String)"*.?s", (String)"foo.ajs")).isFalse();
        Assertions.assertThat((boolean)FileSelector.match((String)("not" + separator + "*" + separator + "something.js"), (String)("foo" + separator + "bar" + separator + "something.js"))).isFalse();
        Assertions.assertThat((boolean)FileSelector.match((String)("**" + separator + "not" + separator + "something.js"), (String)("foo" + separator + "bar" + separator + "something.js"))).isFalse();
    }

    @Test
    public void testMatchPath_DefaultFileSeparator() {
        String separator = File.separator;
        Assert.assertTrue((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt")));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)("b" + separator + "a.txt")));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt")));
        Assert.assertTrue((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)("b" + separator + "a.txt")));
    }

    @Test
    public void testMatchPath_UnixFileSeparator() {
        String separator = "/";
        Assert.assertTrue((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)("b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertTrue((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)("b" + separator + "a.txt"), (String)separator, (boolean)false));
    }

    @Test
    public void testMatchPath_WindowsFileSeparator() {
        String separator = "\\";
        Assert.assertTrue((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)(separator + "*" + separator + "a.txt"), (String)("b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertFalse((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)(separator + "b" + separator + "a.txt"), (String)separator, (boolean)false));
        Assert.assertTrue((boolean)FileSelector.matchPath((String)("*" + separator + "a.txt"), (String)("b" + separator + "a.txt"), (String)separator, (boolean)false));
    }
}

