/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnection;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.net.impl.pool.PoolWaiter;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class ConnectionPoolTest
extends VertxTestBase {
    VertxInternal vertx;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)((VertxTestBase)this).vertx;
    }

    @Test
    public void testConnect() {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected = new Connection();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(expected, lease.get());
            this.assertSame(context, Vertx.currentContext());
            this.assertEquals(0L, pool.requests());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context, request.context);
        request.connect(expected, 0);
        this.await();
    }

    @Test
    public void testAcquireRecycledConnection() throws Exception {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10});
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            lease.recycle();
            latch.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context, request.context);
        request.connect(expected, 0);
        this.awaitLatch(latch);
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(expected, lease.get());
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRecycleRemovedConnection() throws Exception {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected1 = new Connection();
        Promise promise = Promise.promise();
        pool.acquire((ContextInternal)context, 0, (Handler)promise);
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(expected1, 0);
        CountDownLatch latch = new CountDownLatch(1);
        promise.future().onComplete(this.onSuccess(lease -> {
            request1.listener.onRemove();
            lease.recycle();
            latch.countDown();
        }));
        this.awaitLatch(latch);
        Connection expected2 = new Connection();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(expected2, lease.get());
            this.assertSame(context, Vertx.currentContext());
            this.testComplete();
        }));
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(expected2, 0);
        this.await();
    }

    @Test
    public void testConcurrency() throws Exception {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire((ContextInternal)context, 0, this.onSuccess(conn -> latch.countDown()));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(expected, 0);
        this.awaitLatch(latch);
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(lease.get(), expected);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testIncreaseConcurrency() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        CountDownLatch l1 = new CountDownLatch(1);
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> l1.countDown()));
        CountDownLatch l2 = new CountDownLatch(1);
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> l2.countDown()));
        CountDownLatch l3 = new CountDownLatch(1);
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> l3.countDown()));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(conn1, 0);
        this.awaitLatch(l1);
        this.assertEquals(1L, l2.getCount());
        request.listener.onConcurrencyChange(2L);
        this.awaitLatch(l2);
        request.listener.onConcurrencyChange(3L);
        this.awaitLatch(l3);
    }

    @Test
    public void testSatisfyPendingWaitersWithExtraConcurrency() throws Exception {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)2);
        Connection expected = new Connection();
        AtomicInteger seq = new AtomicInteger();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(0L, seq.getAndIncrement());
        }));
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(1L, seq.getAndIncrement());
            this.testComplete();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(expected, 0);
        this.await();
    }

    @Test
    public void testEmptyConcurrency() {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)2);
        Connection expected = new Connection();
        AtomicInteger seq = new AtomicInteger();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(1L, seq.getAndIncrement());
        }));
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(2L, seq.getAndIncrement());
            this.testComplete();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(0).connect(expected, 0);
        this.assertEquals(0L, seq.getAndIncrement());
        request.concurrency(2);
        this.await();
    }

    @Test
    public void testDecreaseConcurrency() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        CountDownLatch l1 = new CountDownLatch(2);
        CountDownLatch l2 = new CountDownLatch(1);
        Lease[] leases = new Lease[3];
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
            leases[0] = lease;
            l1.countDown();
        }));
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
            leases[1] = lease;
            l1.countDown();
        }));
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
            leases[2] = lease;
            l2.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(conn1, 0);
        this.awaitLatch(l1);
        this.assertEquals(1L, l2.getCount());
        request.listener.onConcurrencyChange(1L);
        ctx.runOnContext(v -> {
            leases[0].recycle();
            this.assertEquals(1L, l2.getCount());
            leases[1].recycle();
            this.assertEquals(0L, l2.getCount());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testWaiter() throws Exception {
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire((ContextInternal)ctx1, 0, this.onSuccess(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease1 = (Lease)latch.get(10L, TimeUnit.SECONDS);
        AtomicBoolean recycled = new AtomicBoolean();
        EventLoopContext ctx2 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx2, 0, this.onSuccess(lease2 -> {
            this.assertSame(ctx1, Vertx.currentContext());
            this.assertTrue(recycled.get());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.waiters());
        recycled.set(true);
        lease1.recycle();
        this.await();
    }

    @Test
    public void testRemoveSingleConnection() throws Exception {
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection conn = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire((ContextInternal)ctx1, 0, this.onSuccess(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(conn, 0);
        latch.get(10L, TimeUnit.SECONDS);
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
        this.assertEquals(0L, pool.capacity());
    }

    @Test
    public void testRemoveFirstConnection() throws Exception {
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        Connection conn1 = new Connection();
        CompletableFuture latch1 = new CompletableFuture();
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(latch1::complete));
        Connection conn2 = new Connection();
        CompletableFuture latch2 = new CompletableFuture();
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(latch2::complete));
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(conn1, 0);
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(conn2, 0);
        latch1.get(10L, TimeUnit.SECONDS);
        request1.listener.onRemove();
        this.assertEquals(1L, pool.size());
        this.assertEquals(1L, pool.capacity());
    }

    @Test
    public void testRemoveSingleConnectionWithWaiter() throws Exception {
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        Connection connection1 = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire((ContextInternal)ctx1, 0, this.onSuccess(latch::complete));
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(connection1, 0);
        Lease lease1 = (Lease)latch.get(10L, TimeUnit.SECONDS);
        this.assertSame(connection1, lease1.get());
        AtomicBoolean evicted = new AtomicBoolean();
        Connection conn2 = new Connection();
        EventLoopContext ctx2 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx2, 0, this.onSuccess(lease2 -> {
            this.assertSame(ctx2, Vertx.currentContext());
            this.assertTrue(evicted.get());
            this.assertSame(conn2, lease2.get());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.waiters());
        evicted.set(true);
        request1.listener.onRemove();
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(conn2, 0);
        this.await();
    }

    @Test
    public void testConnectFailureWithPendingWaiter() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1, 2}, (int)2);
        Throwable failure = new Throwable();
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx1, 0, this.onFailure(cause -> {
            this.assertSame(failure, cause);
            this.assertEquals(1L, pool.requests());
            latch.countDown();
        }));
        EventLoopContext ctx2 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx2, 1, this.onSuccess(lease -> {
            this.assertSame(expected, lease.get());
            this.testComplete();
        }));
        ConnectionRequest request1 = mgr.assertRequest();
        this.assertEquals(2L, pool.capacity());
        request1.fail(failure);
        this.awaitLatch(latch);
        this.assertEquals(1L, pool.capacity());
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(expected, 0);
        this.await();
    }

    @Test
    public void testExpireFirst() throws Exception {
        this.assertEquals(Arrays.asList(0), this.testExpire(1, 10, 0));
        this.assertEquals(Arrays.asList(0), this.testExpire(2, 10, 0));
        this.assertEquals(Arrays.asList(0), this.testExpire(3, 10, 0));
    }

    @Test
    public void testExpireLast() throws Exception {
        this.assertEquals(Arrays.asList(0), this.testExpire(1, 10, 0));
        this.assertEquals(Arrays.asList(1), this.testExpire(2, 10, 1));
        this.assertEquals(Arrays.asList(2), this.testExpire(3, 10, 2));
    }

    @Test
    public void testExpireMiddle() throws Exception {
        this.assertEquals(Arrays.asList(1), this.testExpire(3, 10, 1));
    }

    @Test
    public void testExpireSome() throws Exception {
        this.assertEquals(Arrays.asList(2, 1), this.testExpire(3, 10, 1, 2));
        this.assertEquals(Arrays.asList(2, 1, 0), this.testExpire(3, 10, 0, 1, 2));
        this.assertEquals(Arrays.asList(1, 0), this.testExpire(3, 10, 0, 1));
    }

    private List<Integer> testExpire(int num, int max, int ... recycled) throws Exception {
        int i;
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{max}, (int)max);
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList leases = new ArrayList();
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        for (i = 0; i < num; ++i) {
            Connection expected = new Connection();
            pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
                this.assertSame(expected, lease.get());
                leases.add(lease);
                latch.countDown();
            }));
            mgr.assertRequest().connect(expected, 0);
        }
        this.awaitLatch(latch);
        for (i = 0; i < recycled.length; ++i) {
            ((Lease)leases.get(recycled[i])).recycle();
        }
        CompletableFuture cf = new CompletableFuture();
        pool.evict(c -> true, ar -> {
            if (ar.succeeded()) {
                ArrayList res = new ArrayList();
                List all = leases.stream().map(Lease::get).collect(Collectors.toList());
                ((List)ar.result()).forEach(c -> res.add(all.indexOf(c)));
                cf.complete(res);
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        return (List)cf.get();
    }

    @Test
    public void testRemoveEvicted() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        Connection conn = new Connection();
        request.connect(conn, 0);
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        pool.evict(c -> c == conn, this.onSuccess(l -> latch2.countDown()));
        this.awaitLatch(latch2);
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
    }

    @Test
    public void testSynchronousEviction() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        Connection conn1 = new Connection();
        request.connect(conn1, 0);
        this.awaitLatch(latch1);
        Connection conn2 = new Connection();
        pool.evict(candidate -> {
            this.assertSame(candidate, conn1);
            pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {
                Connection c2 = (Connection)lease.get();
                this.assertSame(conn2, c2);
                latch3.countDown();
            }));
            return true;
        }, this.onSuccess(list -> latch2.countDown()));
        this.awaitLatch(latch2);
        request = mgr.assertRequest();
        request.connect(conn2, 0);
        this.awaitLatch(latch3);
    }

    @Test
    public void testConnectionInProgressShouldNotBeEvicted() {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)5);
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx, 0, ar -> {});
        mgr.assertRequest();
        pool.evict(c -> {
            this.fail();
            return false;
        }, this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testRecycleRemoveConnection() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx1, 0, this.onSuccess(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease = (Lease)latch.get();
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
        lease.recycle();
        this.assertEquals(0L, pool.size());
    }

    @Test
    public void testRecycleMultiple() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        EventLoopContext ctx1 = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)ctx1, 0, this.onSuccess(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease = (Lease)latch.get();
        lease.recycle();
        try {
            lease.recycle();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxWaiters() {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)5);
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        for (int i = 0; i < 5; ++i) {
            pool.acquire((ContextInternal)ctx, 0, ar -> this.fail());
        }
        pool.acquire((ContextInternal)ctx, 0, this.onFailure(err -> {
            this.assertTrue(err instanceof ConnectionPoolTooBusyException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHeterogeneousSizes() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{5, 2});
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch = new CountDownLatch(5);
        for (int i = 0; i < 5; ++i) {
            pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> latch.countDown()));
            Connection conn = new Connection();
            mgr.assertRequest().connect(conn, 0);
        }
        this.awaitLatch(latch);
        this.assertEquals(10L, pool.capacity());
        pool.acquire((ContextInternal)ctx, 1, this.onSuccess(lease -> {}));
        this.assertEquals(1L, pool.waiters());
    }

    @Test
    public void testClose() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        pool.acquire((ContextInternal)ctx, 0, this.onSuccess(lease -> {}));
        this.waitFor(3);
        pool.acquire((ContextInternal)ctx, 0, this.onFailure(err -> this.complete()));
        pool.acquire((ContextInternal)ctx, 0, this.onFailure(err -> this.complete()));
        mgr.assertRequest().connect(conn1, 0);
        mgr.assertRequest();
        pool.close(this.onSuccess(lst -> {
            this.assertEquals(2L, lst.size());
            this.assertEquals(0L, pool.size());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCloseTwice() throws Exception {
        AtomicBoolean isReentrant = new AtomicBoolean();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        CountDownLatch latch = new CountDownLatch(1);
        pool.close(this.onSuccess(lst -> {
            AtomicBoolean inCallback = new AtomicBoolean();
            pool.close(this.onFailure(err -> {
                isReentrant.set(inCallback.get());
                latch.countDown();
            }));
        }));
        this.awaitLatch(latch);
        this.assertFalse(isReentrant.get());
    }

    @Test
    public void testUseAfterClose() throws Exception {
        this.waitFor(3);
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        final CompletableFuture waiterFut = new CompletableFuture();
        pool.acquire((ContextInternal)ctx, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                waiterFut.complete(waiter);
            }
        }, 0, ar -> {});
        PoolWaiter waiter = (PoolWaiter)waiterFut.get(20L, TimeUnit.SECONDS);
        ConnectionRequest request = mgr.assertRequest();
        CountDownLatch latch = new CountDownLatch(1);
        pool.close(this.onSuccess(lst -> latch.countDown()));
        this.awaitLatch(latch);
        pool.evict(c -> true, this.onFailure(err -> this.complete()));
        pool.acquire((ContextInternal)ctx, 0, this.onFailure(err -> this.complete()));
        pool.cancel(waiter, this.onFailure(err -> this.complete()));
        request.connect(new Connection(), 0);
        this.await();
    }

    @Test
    public void testAcquireClosedConnection() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        EventLoopContext context = this.vertx.createEventLoopContext();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> lease.recycle()));
        Connection expected = new Connection();
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        context.runOnContext(v -> pool.evict(conn -> {
            latch1.countDown();
            try {
                latch2.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }, ar -> {}));
        this.awaitLatch(latch1);
        AtomicBoolean closed = new AtomicBoolean();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            this.assertNotNull(lease.get());
            this.assertTrue(closed.get());
            this.testComplete();
        }));
        request.listener.onRemove();
        closed.set(true);
        latch2.countDown();
        this.await();
    }

    @Test
    public void testConnectSuccessAfterClose() {
        this.testConnectResultAfterClose(true);
    }

    @Test
    public void testConnectFailureAfterClose() {
        this.testConnectResultAfterClose(false);
    }

    private void testConnectResultAfterClose(boolean success) {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        EventLoopContext ctx = this.vertx.createEventLoopContext();
        AtomicInteger acquired = new AtomicInteger();
        pool.acquire((ContextInternal)ctx, 0, ar -> this.assertEquals(0L, acquired.getAndIncrement()));
        this.assertEquals(1L, pool.size());
        ConnectionRequest request = mgr.assertRequest();
        Promise closeResult = Promise.promise();
        pool.close((Handler)closeResult);
        Throwable cause = new Throwable();
        Connection expected = new Connection();
        if (success) {
            request.connect(expected, 0);
        } else {
            request.fail(cause);
        }
        this.assertTrue(closeResult.future().isComplete());
        List connections = (List)closeResult.future().result();
        this.assertEquals(1L, connections.size());
        this.assertEquals(success, ((Future)connections.get(0)).succeeded());
        this.assertEquals(0L, pool.size());
        if (success) {
            this.assertEquals(expected, ((Future)connections.get(0)).result());
        } else {
            this.assertEquals(cause, ((Future)connections.get(0)).cause());
        }
        ConnectionPoolTest.waitUntil(() -> acquired.get() == 1);
    }

    @Test
    public void testCancelQueuedWaiters() throws Exception {
        this.waitFor(1);
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        final CompletableFuture w = new CompletableFuture();
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {}));
        pool.acquire((ContextInternal)context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onEnqueue(PoolWaiter<Connection> waiter) {
                w.complete(waiter);
            }
        }, 0, ar -> this.fail());
        PoolWaiter waiter = (PoolWaiter)w.get(10L, TimeUnit.SECONDS);
        pool.cancel(waiter, this.onSuccess(removed1 -> {
            this.assertTrue((boolean)removed1);
            this.assertEquals(0L, pool.waiters());
            pool.cancel(waiter, this.onSuccess(removed2 -> {
                this.assertFalse((boolean)removed2);
                this.assertEquals(0L, pool.waiters());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testCancelWaiterBeforeConnectionSuccess() throws Exception {
        this.testCancelWaiterBeforeConnection(true, 0);
    }

    @Test
    public void testCancelWaiterBeforeConnectionSuccessWithExtraWaiters() throws Exception {
        this.testCancelWaiterBeforeConnection(true, 2);
    }

    @Test
    public void testCancelWaiterBeforeConnectionFailure() throws Exception {
        this.testCancelWaiterBeforeConnection(false, 0);
    }

    public void testCancelWaiterBeforeConnection(boolean success, int extra) throws Exception {
        if (!success && extra > 0) {
            throw new IllegalArgumentException();
        }
        this.waitFor(1);
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)(1 + extra));
        final CompletableFuture waiterLatch = new CompletableFuture();
        pool.acquire((ContextInternal)context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                waiterLatch.complete(waiter);
            }
        }, 0, ar -> this.fail());
        waiterLatch.get(10L, TimeUnit.SECONDS);
        final CountDownLatch enqueuedLatch = new CountDownLatch(extra);
        CountDownLatch recycledLatch = new CountDownLatch(extra);
        for (int i = 0; i < extra; ++i) {
            pool.acquire((ContextInternal)context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

                public void onEnqueue(PoolWaiter<Connection> waiter) {
                    enqueuedLatch.countDown();
                }
            }, 0, this.onSuccess(conn -> {
                conn.recycle();
                recycledLatch.countDown();
            }));
        }
        this.awaitLatch(enqueuedLatch);
        ConnectionRequest request = mgr.assertRequest();
        CountDownLatch latch = new CountDownLatch(1);
        pool.cancel((PoolWaiter)waiterLatch.get(10L, TimeUnit.SECONDS), this.onSuccess(removed -> {
            this.assertTrue((boolean)removed);
            latch.countDown();
        }));
        this.awaitLatch(latch);
        if (success) {
            request.connect(new Connection(), 0);
        } else {
            request.fail(new Throwable());
        }
        this.awaitLatch(recycledLatch);
        CountDownLatch doneLatch = new CountDownLatch(extra);
        for (int i = 0; i < extra; ++i) {
            pool.acquire((ContextInternal)context, 0, this.onSuccess(conn -> {
                doneLatch.countDown();
                conn.recycle();
            }));
        }
        this.awaitLatch(doneLatch);
    }

    @Test
    public void testCancelWaiterAfterConnectionSuccess() throws Exception {
        this.testCancelWaiterAfterConnectionSuccess(true);
    }

    @Test
    public void testCancelWaiterAfterConnectionFailure() throws Exception {
        this.testCancelWaiterAfterConnectionSuccess(false);
    }

    public void testCancelWaiterAfterConnectionSuccess(boolean success) throws Exception {
        this.waitFor(1);
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        final CompletableFuture w = new CompletableFuture();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire((ContextInternal)context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                w.complete(waiter);
            }
        }, 0, ar -> latch.countDown());
        w.get(10L, TimeUnit.SECONDS);
        ConnectionRequest request = mgr.assertRequest();
        if (success) {
            request.connect(new Connection(), 0);
        } else {
            request.fail(new Throwable());
        }
        this.awaitLatch(latch);
        pool.cancel((PoolWaiter)w.get(10L, TimeUnit.SECONDS), this.onSuccess(removed -> {
            this.assertFalse((boolean)removed);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testConnectionSelector() throws Exception {
        this.waitFor(1);
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2});
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        Connection conn1 = new Connection();
        mgr.assertRequest().connect(conn1, 0);
        this.awaitLatch(latch1);
        pool.connectionSelector((waiter, list) -> {
            this.assertEquals(1L, list.size());
            PoolConnection pooled = (PoolConnection)list.get(0);
            this.assertEquals(1L, pooled.available());
            this.assertEquals(1L, pooled.concurrency());
            this.assertSame(conn1, pooled.get());
            this.assertSame(context, pooled.context());
            this.assertSame(context, waiter.context());
            return pooled;
        });
        pool.acquire((ContextInternal)context, 0, this.onSuccess(lease -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDefaultSelector() throws Exception {
        EventLoopContext context1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire((ContextInternal)context1, 0, this.onSuccess(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        Connection expected = new Connection();
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        pool.acquire((ContextInternal)context1, 0, this.onSuccess(lease -> {
            this.assertEquals(expected, lease.get());
            lease.recycle();
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        EventLoopContext context2 = this.vertx.createEventLoopContext(context1.nettyEventLoop(), context1.workerPool(), context1.classLoader());
        pool.acquire((ContextInternal)context2, 0, this.onSuccess(lease -> {
            this.assertEquals(expected, lease.get());
            lease.recycle();
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
    }

    @Test
    public void testDefaultContextProviderUnwrap() {
        EventLoopContext context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        pool.acquire(context.duplicate(), 0, this.onSuccess(lease -> {}));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context, request.context);
    }

    @Test
    public void testDefaultContextProviderReusesSameEventLoop() {
        WorkerContext context = this.vertx.createWorkerContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        pool.acquire(context.duplicate(), 0, this.onSuccess(lease -> {}));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context.nettyEventLoop(), request.context.nettyEventLoop());
    }

    @Test
    public void testPostTasksTrampoline() throws Exception {
        final int numAcquires = 5;
        final AtomicReference<ConnectionPool> ref = new AtomicReference<ConnectionPool>();
        final EventLoopContext ctx = this.vertx.createEventLoopContext();
        final List res = Collections.synchronizedList(new LinkedList());
        final AtomicInteger seq = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(numAcquires);
        final int[] count = new int[1];
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<Connection>>> handler) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int n = count[0];
                    count[0] = n + 1;
                    int val = n;
                    if (val == 0) {
                        for (int i = 0; i < numAcquires; ++i) {
                            int num = seq.getAndIncrement();
                            ((ConnectionPool)ref.get()).acquire((ContextInternal)ctx, 0, ConnectionPoolTest.this.onFailure(err -> {
                                res.add(num);
                                latch.countDown();
                            }));
                        }
                        ConnectionPoolTest.this.assertEquals(1L, count[0]);
                    }
                    handler.handle((Object)Future.failedFuture((String)"failure"));
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)(1 + numAcquires));
        ref.set(pool);
        int num = seq.getAndIncrement();
        pool.acquire((ContextInternal)ctx, 0, this.onFailure(err -> res.add(num)));
        this.awaitLatch(latch);
        this.assertEquals(1 + numAcquires, count[0]);
        List expected = IntStream.range(0, numAcquires + 1).boxed().collect(Collectors.toList());
        this.assertEquals(expected, res);
    }

    @Test
    public void testConcurrentPostTasksTrampoline() throws Exception {
        final AtomicReference<ConnectionPool> ref1 = new AtomicReference<ConnectionPool>();
        final AtomicReference<ConnectionPool> ref2 = new AtomicReference<ConnectionPool>();
        final EventLoopContext ctx = this.vertx.createEventLoopContext();
        final List res = Collections.synchronizedList(new LinkedList());
        final CountDownLatch latch = new CountDownLatch(4);
        ConnectionPool pool1 = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int count = 0;
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<Connection>>> handler) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int val = this.count++;
                    if (val == 0) {
                        ((ConnectionPool)ref1.get()).acquire((ContextInternal)ctx, 0, ConnectionPoolTest.this.onFailure(err -> {
                            res.add(1);
                            latch.countDown();
                        }));
                        ((ConnectionPool)ref2.get()).acquire((ContextInternal)ctx, 0, ConnectionPoolTest.this.onFailure(err -> {
                            res.add(2);
                            latch.countDown();
                        }));
                    }
                    handler.handle((Object)Future.failedFuture((String)"failure"));
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)2);
        ConnectionPool pool2 = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int count = 0;
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<Connection>>> handler) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int val = this.count++;
                    if (val == 0) {
                        ((ConnectionPool)ref2.get()).acquire((ContextInternal)ctx, 0, ConnectionPoolTest.this.onFailure(err -> {
                            res.add(3);
                            latch.countDown();
                        }));
                        ((ConnectionPool)ref1.get()).acquire((ContextInternal)ctx, 0, ConnectionPoolTest.this.onFailure(err -> {
                            res.add(4);
                            latch.countDown();
                        }));
                    }
                    handler.handle((Object)Future.failedFuture((String)"failure"));
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)2);
        ref1.set(pool1);
        ref2.set(pool2);
        pool1.acquire((ContextInternal)ctx, 0, this.onFailure(err -> res.add(0)));
        this.awaitLatch(latch);
    }

    class ConnectionManager
    implements PoolConnector<Connection> {
        private final Queue<ConnectionRequest> requests = new ArrayBlockingQueue<ConnectionRequest>(100);

        ConnectionManager() {
        }

        public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<Connection>>> handler) {
            this.requests.add(new ConnectionRequest(context, listener, handler));
        }

        public boolean isValid(Connection connection) {
            return true;
        }

        ConnectionRequest assertRequest() {
            ConnectionRequest request = this.requests.poll();
            ConnectionPoolTest.this.assertNotNull(request);
            return request;
        }
    }

    static class ConnectionRequest {
        final EventLoopContext context;
        final PoolConnector.Listener listener;
        final Handler<AsyncResult<ConnectResult<Connection>>> handler;
        private int concurrency;
        private Connection connection;

        ConnectionRequest(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<Connection>>> handler) {
            this.context = context;
            this.listener = listener;
            this.handler = handler;
            this.concurrency = 1;
        }

        void connect(Connection connection, int type) {
            if (this.connection != null) {
                throw new IllegalStateException();
            }
            this.connection = connection;
            this.handler.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)connection, (long)this.concurrency, (long)type)));
        }

        ConnectionRequest concurrency(int value) {
            if (value < this.concurrency) {
                if (this.connection != null) {
                    throw new IllegalStateException();
                }
                this.concurrency = value;
            } else {
                this.concurrency = value;
                this.listener.onConcurrencyChange((long)this.concurrency);
            }
            return this;
        }

        public void fail(Throwable cause) {
            this.handler.handle((Object)Future.failedFuture((Throwable)cause));
        }
    }

    static class Connection {
    }
}

