/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.test.core.AsyncTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class TaskQueueTest
extends AsyncTestBase {
    private TaskQueue taskQueue;
    private Executor executor;
    private List<Thread> threads = Collections.synchronizedList(new ArrayList());

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.taskQueue = new TaskQueue();
        AtomicInteger idx = new AtomicInteger();
        this.executor = cmd -> new Thread(cmd, "vert.x-" + idx.getAndIncrement()).start();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.threads.size(); ++i) {
                this.threads.get(i).join();
            }
        }
        finally {
            this.threads.clear();
        }
        super.tearDown();
    }

    private void suspendAndAwaitResume(WorkerExecutor.TaskController controller) {
        try {
            controller.suspendAndAwaitResume();
        }
        catch (InterruptedException e) {
            this.fail(e);
        }
    }

    @Test
    public void testCreateThread() throws Exception {
        AtomicReference thread = new AtomicReference();
        this.taskQueue.execute(() -> thread.set(Thread.currentThread()), this.executor);
        TaskQueueTest.waitUntil(() -> thread.get() != null);
        Thread.sleep(10L);
        this.taskQueue.execute(() -> {
            this.assertNotSame(thread.get(), Thread.currentThread());
            this.testComplete();
        }, this.executor);
        this.await();
    }

    @Test
    public void testAwaitSchedulesOnNewThread() {
        this.taskQueue.execute(() -> {
            Thread current = Thread.currentThread();
            this.taskQueue.execute(() -> {
                this.assertNotSame(current, Thread.currentThread());
                this.testComplete();
            }, this.executor);
            WorkerExecutor.TaskController cont = this.taskQueue.current();
            this.suspendAndAwaitResume(cont);
        }, this.executor);
        this.await();
    }

    @Test
    public void testResumeFromAnotherThread() {
        this.taskQueue.execute(() -> {
            WorkerExecutor.TaskController continuation = this.taskQueue.current();
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                continuation.resume();
                this.suspendAndAwaitResume(continuation);
            }).start();
            this.testComplete();
        }, this.executor);
        this.await();
    }

    @Test
    public void testResumeFromContextThread() {
        this.taskQueue.execute(() -> {
            WorkerExecutor.TaskController continuation = this.taskQueue.current();
            this.taskQueue.execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                continuation.resume();
            }, this.executor);
            this.suspendAndAwaitResume(continuation);
            this.testComplete();
        }, this.executor);
        this.await();
    }

    @Test
    public void testResumeWhenIdle() {
        this.taskQueue.execute(() -> {
            WorkerExecutor.TaskController cont = this.taskQueue.current();
            AtomicReference ref = new AtomicReference();
            new Thread(() -> {
                Thread th;
                while ((th = (Thread)ref.get()) == null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    th.join(2000L);
                }
                catch (InterruptedException ignore) {
                    ignore.printStackTrace(System.out);
                }
                cont.resume();
            }).start();
            this.taskQueue.execute(() -> ref.set(Thread.currentThread()), this.executor);
            this.suspendAndAwaitResume(cont);
            this.testComplete();
        }, this.executor);
        this.await();
    }

    @Test
    public void testRaceResumeBeforeSuspend() {
        AtomicInteger seq = new AtomicInteger();
        this.taskQueue.execute(() -> {
            this.taskQueue.execute(() -> {
                WorkerExecutor.TaskController cont = this.taskQueue.current();
                cont.resume(() -> this.assertEquals(1L, seq.getAndIncrement()));
                this.assertEquals(0L, seq.getAndIncrement());
                this.suspendAndAwaitResume(cont);
                this.assertEquals(2L, seq.getAndIncrement());
            }, this.executor);
            this.taskQueue.execute(() -> {
                this.assertEquals(3L, seq.getAndIncrement());
                this.testComplete();
            }, this.executor);
        }, this.executor);
        this.await();
    }

    @Test
    public void testUnscheduleRace2() {
        AtomicInteger seq = new AtomicInteger();
        this.taskQueue.execute(() -> {
            CompletableFuture cf = new CompletableFuture();
            this.taskQueue.execute(() -> {
                this.assertEquals("vert.x-0", Thread.currentThread().getName());
                this.assertEquals(0L, seq.getAndIncrement());
                WorkerExecutor.TaskController cont = this.taskQueue.current();
                cf.whenComplete((v, e) -> cont.resume(() -> {
                    this.assertEquals("vert.x-1", Thread.currentThread().getName());
                    this.assertEquals(2L, seq.getAndIncrement());
                }));
                this.suspendAndAwaitResume(cont);
            }, this.executor);
            AtomicBoolean enqueued = new AtomicBoolean();
            this.taskQueue.execute(() -> {
                this.assertEquals("vert.x-1", Thread.currentThread().getName());
                this.assertEquals(1L, seq.getAndIncrement());
                while (!enqueued.get()) {
                }
                cf.complete(null);
            }, this.executor);
            this.taskQueue.execute(() -> {
                this.assertEquals("vert.x-0", Thread.currentThread().getName());
                this.assertEquals(3L, seq.getAndIncrement());
                this.testComplete();
            }, this.executor);
            enqueued.set(true);
        }, this.executor);
        this.await();
    }
}

