/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Verticle;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.test.core.VertxTestBase;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class VirtualThreadDeploymentTest
extends VertxTestBase {
    private static final Method IS_VIRTUAL;

    public static boolean isVirtual(Thread th) {
        if (IS_VIRTUAL != null) {
            try {
                return (Boolean)IS_VIRTUAL.invoke((Object)th, new Object[0]);
            }
            catch (Exception e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
        return false;
    }

    @Test
    public void testDeploy() {
        Assume.assumeTrue((boolean)VertxInternal.isVirtualThreadAvailable());
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() {
                VirtualThreadDeploymentTest.this.assertTrue(VirtualThreadDeploymentTest.isVirtual(Thread.currentThread()));
                Future fut = Future.future(p -> this.vertx.setTimer(500L, id -> p.complete()));
                Future.await((Future)fut);
                VirtualThreadDeploymentTest.this.testComplete();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD));
        this.await();
    }

    @Test
    public void testExecuteBlocking() {
        Assume.assumeTrue((boolean)VertxInternal.isVirtualThreadAvailable());
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() {
                Future fut = this.vertx.executeBlocking(() -> {
                    VirtualThreadDeploymentTest.this.assertTrue(VirtualThreadDeploymentTest.isVirtual(Thread.currentThread()));
                    return Thread.currentThread().getName();
                });
                String res = (String)Future.await((Future)fut);
                VirtualThreadDeploymentTest.this.assertNotSame(Thread.currentThread().getName(), res);
                VirtualThreadDeploymentTest.this.testComplete();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD));
        this.await();
    }

    @Test
    public void testDeployHTTPServer() throws Exception {
        Assume.assumeTrue((boolean)VertxInternal.isVirtualThreadAvailable());
        final AtomicInteger inflight = new AtomicInteger();
        final AtomicBoolean processing = new AtomicBoolean();
        final AtomicInteger max = new AtomicInteger();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){
            HttpServer server;

            public void start() {
                this.server = this.vertx.createHttpServer().requestHandler(req -> {
                    VirtualThreadDeploymentTest.this.assertFalse(processing.getAndSet(true));
                    int val = inflight.incrementAndGet();
                    max.set(Math.max(val, max.get()));
                    Future fut = Future.future(p -> this.vertx.setTimer(50L, id -> p.complete()));
                    processing.set(false);
                    Future.await((Future)fut);
                    VirtualThreadDeploymentTest.this.assertFalse(processing.getAndSet(true));
                    req.response().end();
                    inflight.decrementAndGet();
                    processing.set(false);
                });
                Future.await((Future)this.server.listen(8080, "localhost"));
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).toCompletionStage().toCompletableFuture().get();
        HttpClient client = this.vertx.createHttpClient();
        int numReq = 10;
        this.waitFor(numReq);
        for (int i = 0; i < numReq; ++i) {
            Future resp = client.request(HttpMethod.GET, 8080, "localhost", "/").compose(req -> req.send().compose(HttpClientResponse::body));
            resp.onComplete(this.onSuccess(v -> this.complete()));
        }
        this.await();
        Assert.assertEquals((long)5L, (long)max.get());
    }

    @Test
    public void testVirtualThreadsNotAvailable() {
        Assume.assumeFalse((boolean)VertxInternal.isVirtualThreadAvailable());
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() {
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    static {
        Method isVirtualMethod = null;
        try {
            isVirtualMethod = Thread.class.getDeclaredMethod("isVirtual", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        IS_VIRTUAL = isVirtualMethod;
    }
}

