/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.proxy.HttpProxy;
import io.vertx.test.proxy.SocksProxy;
import io.vertx.test.proxy.TestProxyBase;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class HttpTestBase
extends VertxTestBase {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final String DEFAULT_HTTPS_HOST = "localhost";
    public static final int DEFAULT_HTTPS_PORT = 4043;
    public static final String DEFAULT_HTTPS_HOST_AND_PORT = "localhost:4043";
    public static final String DEFAULT_TEST_URI = "some-uri";
    protected HttpServer server;
    protected HttpClient client;
    protected TestProxyBase proxy;
    protected SocketAddress testAddress;
    protected RequestOptions requestOptions;
    private File tmp;
    private static final Handler noOp = e -> {};

    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(8080).setHost("localhost");
    }

    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HttpServerOptions baseServerOptions = this.createBaseServerOptions();
        this.testAddress = SocketAddress.inetSocketAddress((int)baseServerOptions.getPort(), (String)baseServerOptions.getHost());
        this.requestOptions = new RequestOptions().setHost(baseServerOptions.getHost()).setPort(Integer.valueOf(baseServerOptions.getPort())).setURI(DEFAULT_TEST_URI);
        this.server = this.vertx.createHttpServer(baseServerOptions);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
    }

    protected void configureDomainSockets() throws Exception {
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
            this.requestOptions.setServer(this.testAddress);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    protected <E> Handler<E> noOpHandler() {
        return noOp;
    }

    protected void startServer() throws Exception {
        this.startServer(this.vertx.getOrCreateContext());
    }

    protected void startServer(SocketAddress bindAddress) throws Exception {
        this.startServer(bindAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(HttpServer server) throws Exception {
        this.startServer(this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(SocketAddress bindAddress, HttpServer server) throws Exception {
        this.startServer(bindAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(Context context) throws Exception {
        this.startServer(context, this.server);
    }

    protected void startServer(SocketAddress bindAddress, Context context) throws Exception {
        this.startServer(bindAddress, context, this.server);
    }

    protected void startServer(Context context, HttpServer server) throws Exception {
        this.startServer(null, context, server);
    }

    protected void startServer(SocketAddress bindAddress, Context context, HttpServer server) throws Exception {
        CompletableFuture latch = new CompletableFuture();
        context.runOnContext(v -> {
            Future fut = bindAddress != null ? server.listen(bindAddress) : server.listen();
            fut.onComplete(ar -> {
                if (ar.succeeded()) {
                    latch.complete(null);
                } else {
                    latch.completeExceptionally(ar.cause());
                }
            });
        });
        try {
            latch.get(20L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    protected void startProxy(String username, ProxyType proxyType) throws Exception {
        this.proxy = proxyType == ProxyType.HTTP ? new HttpProxy() : new SocksProxy();
        this.proxy.username(username);
        this.proxy.start(this.vertx);
    }
}

