/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.AsciiString;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.Http1xTest;
import io.vertx.core.http.Http2Test;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.DetectFileDescriptorLeaks;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakestream.FakeStream;
import io.vertx.test.netty.TestLoggerFactory;
import io.vertx.test.proxy.HAProxy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = TemporaryFolder.builder().assureDeletion().build();
    protected File testDir;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testDir = this.testFolder.newFolder();
    }

    @Test
    public void testClientRequestArguments() throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            TestUtils.assertNullPointerException(() -> req.putHeader((String)null, "someValue"));
            TestUtils.assertNullPointerException(() -> req.putHeader((CharSequence)null, (CharSequence)"someValue"));
            TestUtils.assertNullPointerException(() -> req.putHeader("someKey", (Iterable)null));
            TestUtils.assertNullPointerException(() -> req.write((Object)null));
            TestUtils.assertNullPointerException(() -> req.write((String)null));
            TestUtils.assertNullPointerException(() -> req.write(null, "UTF-8"));
            TestUtils.assertNullPointerException(() -> req.write("someString", (String)null));
            TestUtils.assertNullPointerException(() -> req.end((Buffer)null));
            TestUtils.assertNullPointerException(() -> req.end((String)null));
            TestUtils.assertNullPointerException(() -> req.end(null, "UTF-8"));
            TestUtils.assertNullPointerException(() -> req.end("someString", (String)null));
            TestUtils.assertIllegalArgumentException(() -> req.setTimeout(0L));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testListenSocketAddress() {
        NetClient netClient = this.vertx.createNetClient();
        this.server = this.vertx.createHttpServer().requestHandler(req -> req.response().end());
        SocketAddress sockAddress = SocketAddress.inetSocketAddress((int)8080, (String)"localhost");
        this.server.listen(sockAddress, this.onSuccess(server -> netClient.connect(sockAddress, this.onSuccess(sock -> {
            sock.handler(buf -> {
                this.assertTrue("Response is not an http 200", buf.toString("UTF-8").startsWith("HTTP/1.1 200 OK"));
                this.testComplete();
            });
            sock.write("GET / HTTP/1.1\r\n\r\n");
        }))));
        try {
            this.await();
        }
        finally {
            netClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenDomainSocketAddress() throws Exception {
        SocketAddress sockAddress;
        Vertx vx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));
        Assume.assumeTrue((String)"Native transport must be enabled", (boolean)vx.isNativeTransportEnabled());
        Assume.assumeTrue((String)"Transport must support domain sockets", (boolean)((VertxInternal)vx).transport().supportsDomainSockets());
        int len = 3;
        this.waitFor(len * len);
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        for (int i = 0; i < len; ++i) {
            File sockFile = TestUtils.tmpFile(".sock");
            sockAddress = SocketAddress.domainSocketAddress((String)sockFile.getAbsolutePath());
            HttpServer server = vx.createHttpServer(this.createBaseServerOptions()).requestHandler(req -> req.response().end(sockAddress.path()));
            this.startServer(sockAddress, server);
            addresses.add(sockAddress);
        }
        HttpClient client = vx.createHttpClient(this.createBaseClientOptions());
        for (int i = 0; i < len; ++i) {
            sockAddress = (SocketAddress)addresses.get(i);
            for (int j = 0; j < len; ++j) {
                client.request(new RequestOptions(this.requestOptions).setServer(sockAddress)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.body(this.onSuccess(body -> {
                    this.assertEquals(sockAddress.path(), body.toString());
                    this.complete();
                }))))));
            }
        }
        try {
            this.await();
        }
        finally {
            vx.close();
        }
    }

    @Test
    public void testLowerCaseHeaders() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.response().putHeader("Quux", "quux");
            this.assertEquals("quux", req.response().headers().get("Quux"));
            this.assertEquals("quux", req.response().headers().get("quux"));
            this.assertEquals("quux", req.response().headers().get("qUUX"));
            this.assertTrue(req.response().headers().contains("Quux"));
            this.assertTrue(req.response().headers().contains("quux"));
            this.assertTrue(req.response().headers().contains("qUUX"));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.putHeader("Foo", "foo");
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.send(this.onSuccess(resp -> {
                this.assertEquals("quux", resp.headers().get("Quux"));
                this.assertEquals("quux", resp.headers().get("quux"));
                this.assertEquals("quux", resp.headers().get("qUUX"));
                this.assertTrue(resp.headers().contains("Quux"));
                this.assertTrue(resp.headers().contains("quux"));
                this.assertTrue(resp.headers().contains("qUUX"));
                this.testComplete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testServerActualPortWhenSet() {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        this.server.requestHandler(request -> request.response().end("hello")).listen(this.onSuccess(s -> {
            this.assertEquals(s.actualPort(), 8080L);
            HttpClient client = this.vertx.createHttpClient(this.createBaseClientOptions());
            client.request(new RequestOptions(this.requestOptions).setPort(Integer.valueOf(s.actualPort()))).onComplete(this.onSuccess(req -> req.send().flatMap(resp -> {
                this.assertEquals(resp.statusCode(), 200L);
                return resp.body();
            }).onComplete(this.onSuccess(body -> {
                this.assertEquals(body.toString("UTF-8"), "hello");
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testServerActualPortWhenZero() {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setPort(0).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(this.onSuccess(s -> {
            this.assertTrue(s.actualPort() != 0);
            HttpClient client = this.vertx.createHttpClient(this.createBaseClientOptions());
            client.request(new RequestOptions(this.requestOptions).setPort(Integer.valueOf(s.actualPort()))).onComplete(this.onSuccess(req -> req.send(this.onSuccess(response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            }))));
        }));
        this.await();
    }

    @Test
    public void testServerActualPortWhenZeroPassedInListen() {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        this.server = this.vertx.createHttpServer(new HttpServerOptions(this.createBaseServerOptions()).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(0, this.onSuccess(s -> {
            this.assertTrue(s.actualPort() != 0);
            HttpClient client = this.vertx.createHttpClient(this.createBaseClientOptions());
            client.request(new RequestOptions(this.requestOptions).setPort(Integer.valueOf(s.actualPort())), this.onSuccess(req -> {
                req.response(this.onSuccess(response -> {
                    this.assertEquals(response.statusCode(), 200L);
                    response.bodyHandler(body -> {
                        this.assertEquals(body.toString("UTF-8"), "hello");
                        this.testComplete();
                    });
                }));
                req.end();
            }));
        }));
        this.await();
    }

    @Test
    public void testClientRequestOptionsSocketAddressOnly() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        Integer port = this.requestOptions.getPort();
        String host = this.requestOptions.getHost();
        this.server.requestHandler(request -> {
            this.assertEquals(host + ":" + port, request.host());
            this.assertEquals(host, request.authority().host());
            this.assertEquals(port.intValue(), request.authority().port());
            request.response().end();
        });
        this.startServer(this.testAddress);
        SocketAddress server = SocketAddress.inetSocketAddress((int)port, (String)host);
        this.client.request(new RequestOptions().setServer(server)).compose(req -> req.send().compose(resp -> {
            this.assertEquals(200L, resp.statusCode());
            return resp.body();
        })).onComplete(this.onSuccess(body -> this.testComplete()));
        this.await();
    }

    @Test
    public void testInvalidAbsoluteURI() {
        try {
            this.client.request(new RequestOptions().setAbsoluteURI("ijdijwidjqwoijd192d192192ej12d"));
            this.fail("Should throw exception");
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testPutHeadersOnRequest() {
        this.server.requestHandler(req -> {
            this.assertEquals("bar", req.headers().get("foo"));
            this.assertEquals("bar", req.getHeader("foo"));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.putHeader("foo", "bar");
            req.send(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testPutHeaderReplacesPreviousHeaders() throws Exception {
        this.server.requestHandler(req -> req.response().putHeader("Location", "http://example1.org").putHeader("location", "http://example2.org").send());
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(Collections.singletonList("http://example2.org"), resp.headers().getAll("LocatioN"));
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testSimpleGET() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOST() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEAD() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONS() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCH() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleGETAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testEmptyPathGETAbsolute() {
        String uri = "";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testNoPathButQueryGETAbsolute() {
        String uri = "?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOSTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEADAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONSAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCHAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    private void testSimpleRequest(String uri, HttpMethod method, Handler<HttpClientResponse> handler) {
        this.testSimpleRequest(uri, method, false, handler);
    }

    private void testSimpleRequest(String uri, HttpMethod method, boolean absolute, Handler<HttpClientResponse> handler) {
        boolean ssl = this instanceof Http2Test;
        RequestOptions options = absolute ? new RequestOptions(this.requestOptions).setServer(this.testAddress).setMethod(method).setAbsoluteURI((ssl ? "https://" : "http://") + "localhost" + ":" + 8080 + uri) : new RequestOptions(this.requestOptions).setMethod(method).setURI(uri);
        this.testSimpleRequest(uri, method, options, absolute, handler);
    }

    private void testSimpleRequest(String uri, HttpMethod method, RequestOptions requestOptions, boolean absolute, Handler<HttpClientResponse> handler) {
        String query;
        String path;
        int index = uri.indexOf(63);
        if (index == -1) {
            path = uri;
            query = null;
        } else {
            path = uri.substring(0, index);
            query = uri.substring(index + 1);
        }
        String resource = absolute && path.isEmpty() ? "/" + path : path;
        this.server.requestHandler(req -> {
            String expectedPath = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : resource;
            String expectedQuery = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : query;
            this.assertEquals(expectedPath, req.path());
            this.assertEquals(method, req.method());
            this.assertEquals(expectedQuery, req.query());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(arg_0 -> ((Handler)handler).handle(arg_0)))))));
        this.await();
    }

    @Test
    public void testServerChaining() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().setChunked(true) == req.response());
            this.testComplete();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send))));
        this.await();
    }

    @Test
    public void testServerChainingSendFile() throws Exception {
        File file = this.setupFile("test-server-chaining.dat", "blah");
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().sendFile(file.getAbsolutePath(), null) == req.response());
            file.delete();
            this.testComplete();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.end()))));
        this.await();
    }

    @Test
    public void testResponseEndHandlers1() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(0L, req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("wibble", resp.headers().get("extraheader"));
            this.complete();
        }))))));
        this.await();
    }

    @Test
    public void testResponseEndHandlers2() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "blah";
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end(content);
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testResponseEndHandlersChunkedResponse() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String chunk = "blah";
        int numChunks = 6;
        StringBuilder content = new StringBuilder(chunk.length() * numChunks);
        IntStream.range(0, numChunks).forEach(i -> content.append(chunk));
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().setChunked(true);
            IntStream.range(0, numChunks - 1).forEach(x -> req.response().write(chunk));
            req.response().end(chunk);
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content.toString()), buff);
                this.complete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testResponseEndHandlersSendFile() throws Exception {
        this.waitFor(4);
        AtomicInteger cnt = new AtomicInteger();
        String content = "iqdioqwdqwiojqwijdwqd";
        File toSend = this.setupFile("somefile.txt", content);
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().endHandler(v -> this.complete());
            req.response().sendFile(toSend.getAbsolutePath());
        }).listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testAbsoluteURI() {
        String uri = "http://localhost:8080/this/is/a/path/foo.html";
        this.testURIAndPath(uri, uri, "/this/is/a/path/foo.html");
    }

    @Test
    public void testRelativeURI() {
        String uri = "/this/is/a/path/foo.html";
        this.testURIAndPath(uri, uri, uri);
    }

    @Test
    public void testAbsoluteURIWithHttpSchemaInQuery() {
        String uri = "http://localhost:8080/correct/path?url=http://localhost:8008/wrong/path";
        this.testURIAndPath(uri, uri, "/correct/path");
    }

    @Test
    public void testRelativeURIWithHttpSchemaInQuery() {
        String uri = "/correct/path?url=http://localhost:8008/wrong/path";
        this.testURIAndPath(uri, uri, "/correct/path");
    }

    @Test
    public void testAbsoluteURIEmptyPath() {
        String uri = "http://localhost:8080/";
        this.testURIAndPath(uri, uri, "/");
    }

    @Test
    public void testEmptyURI() {
        this.testURIAndPath("", "/", "/");
    }

    private void testURIAndPath(String uri, String expectedUri, String expectedPath) {
        this.server.requestHandler(req -> {
            this.assertEquals(expectedUri, req.uri());
            this.assertEquals(expectedPath, req.path());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setURI(uri)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testParamUmlauteDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6");
    }

    @Test
    public void testParamPlusDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("+");
    }

    @Test
    public void testParamPercentDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("%");
    }

    @Test
    public void testParamSpaceDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding(" ");
    }

    @Test
    public void testParamNormalDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("hello");
    }

    @Test
    public void testParamAltogetherDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6+% hello");
    }

    private void testParamDecoding(String value) throws UnsupportedEncodingException {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                MultiMap formAttributes = req.formAttributes();
                this.assertEquals(value, formAttributes.get("param"));
            });
            req.response().end();
        });
        Buffer body = Buffer.buffer((String)("param=" + URLEncoder.encode(value, "UTF-8")));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(body.length())).putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED).response(this.onSuccess(resp -> this.testComplete())).end(body)))));
        this.await();
    }

    @Test
    public void testParamsAmpersand() {
        this.testParams('&');
    }

    @Test
    public void testParamsSemiColon() {
        this.testParams(';');
    }

    private void testParams(char delim) {
        MultiMap params = TestUtils.randomMultiMap(10);
        String query = HttpTest.generateQueryString(params, delim);
        this.server.requestHandler(req -> {
            this.assertEquals(query, req.query());
            this.assertEquals(params.size(), req.params().size());
            for (Map.Entry entry : req.params()) {
                this.assertEquals(entry.getValue(), params.get((String)entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setURI("some-uri/?" + query)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testNoParams() {
        this.server.requestHandler(req -> {
            this.assertNull(req.query());
            this.assertTrue(req.params().isEmpty());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testOverrideParamsCharset() {
        this.server.requestHandler(req -> {
            String val = req.getParam("param");
            this.assertEquals("\u20ac", val);
            req.setParamsCharset(StandardCharsets.ISO_8859_1.name());
            val = req.getParam("param");
            this.assertEquals("\u00e2\u0082\u00ac", val);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setURI("/?param=%E2%82%AC")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testGetParamDefaultValue() {
        String paramName1 = "foo";
        String paramName1Value = "bar";
        String paramName2 = "notPresentParam";
        String paramName2DefaultValue = "defaultValue";
        String reqUri = "some-uri/?" + paramName1 + "=" + paramName1Value;
        this.server.requestHandler(req -> {
            this.assertTrue(req.params().contains(paramName1));
            this.assertEquals(paramName1Value, req.getParam(paramName1, paramName2DefaultValue));
            this.assertFalse(req.params().contains(paramName2));
            this.assertEquals(paramName2DefaultValue, req.getParam(paramName2, paramName2DefaultValue));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setURI(reqUri)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testMissingContentTypeMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest(null, HttpMethod.POST);
    }

    @Test
    public void testInvalidContentTypeMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest("application/json", HttpMethod.POST);
    }

    @Test
    public void testInvalidMethodMultipartRequest() throws Exception {
        this.testInvalidMultipartRequest("multipart/form-data", HttpMethod.GET);
    }

    private void testInvalidMultipartRequest(String contentType, HttpMethod method) throws Exception {
        this.server.requestHandler(req -> {
            try {
                req.setExpectMultipart(true);
                this.fail();
            }
            catch (IllegalStateException ignore) {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        RequestOptions requestOptions = new RequestOptions(this.requestOptions).setMethod(method);
        this.client.request(requestOptions, this.onSuccess(req -> {
            if (contentType != null) {
                req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            req.send(this.onSuccess(resp -> this.testComplete()));
        }));
        this.await();
    }

    @Test
    public void testDefaultRequestHeaders() {
        this.server.requestHandler(req -> {
            if (req.version() == HttpVersion.HTTP_1_1) {
                this.assertEquals(1L, req.headers().size());
                this.assertEquals("localhost:8080", req.headers().get("host"));
            } else {
                this.assertEquals(0L, req.headers().size());
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testRequestHeadersWithCharSequence() {
        HashMap<AsciiString, String> expectedHeaders = new HashMap<AsciiString, String>();
        expectedHeaders.put(HttpHeaderNames.CONTENT_TYPE, "text/html; charset=utf-8");
        expectedHeaders.put(HttpHeaderNames.CONTENT_ENCODING, "gzip");
        expectedHeaders.put(HttpHeaderNames.USER_AGENT, "Mozilla/5.0");
        this.server.requestHandler(req -> {
            MultiMap headers = req.headers();
            headers.remove("host");
            this.assertEquals(expectedHeaders.size(), headers.size());
            expectedHeaders.forEach((k, v) -> this.assertEquals(v, headers.get(k)));
            expectedHeaders.forEach((k, v) -> this.assertEquals(v, req.getHeader(k)));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.testComplete()));
            expectedHeaders.forEach((k, v) -> req.headers().add(k, (CharSequence)v));
            req.end();
        }))));
        this.await();
    }

    @Test
    public void testRequestHeadersPutAll() {
        this.testRequestHeaders(false);
    }

    @Test
    public void testRequestHeadersIndividually() {
        this.testRequestHeaders(true);
    }

    private void testRequestHeaders(boolean individually) {
        MultiMap expectedHeaders = TestUtils.randomMultiMap(10);
        this.server.requestHandler(req -> {
            MultiMap headers = req.headers();
            headers.remove("host");
            this.assertEquals(expectedHeaders.size(), expectedHeaders.size());
            for (Map.Entry entry : expectedHeaders) {
                this.assertEquals(entry.getValue(), req.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), req.getHeader((String)entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.testComplete()));
            if (individually) {
                for (Map.Entry header : expectedHeaders) {
                    req.headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.headers().setAll(expectedHeaders);
            }
            req.end();
        }))));
        this.await();
    }

    @Test
    public void testResponseHeadersPutAll() {
        this.testResponseHeaders(false);
    }

    @Test
    public void testResponseHeadersIndividually() {
        this.testResponseHeaders(true);
    }

    private void testResponseHeaders(boolean individually) {
        MultiMap headers = TestUtils.randomMultiMap(10);
        this.server.requestHandler(req -> {
            if (individually) {
                for (Map.Entry header : headers) {
                    req.response().headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().headers().setAll(headers);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), resp.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getHeader((String)entry.getKey()));
            }
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testResponseHeadersWithCharSequence() {
        HashMap<AsciiString, String> headers = new HashMap<AsciiString, String>();
        headers.put(HttpHeaderNames.CONTENT_TYPE, "text/html; charset=utf-8");
        headers.put(HttpHeaderNames.CONTENT_ENCODING, "gzip");
        headers.put(HttpHeaderNames.USER_AGENT, "Mozilla/5.0");
        this.server.requestHandler(req -> {
            headers.forEach((k, v) -> req.response().headers().add(k, (CharSequence)v));
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            headers.forEach((k, v) -> this.assertEquals(v, resp.headers().get(k)));
            headers.forEach((k, v) -> this.assertEquals(v, resp.getHeader(k)));
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testResponseMultipleSetCookieInHeader() {
        this.testResponseMultipleSetCookie(true, false);
    }

    @Test
    public void testResponseMultipleSetCookieInTrailer() {
        this.testResponseMultipleSetCookie(false, true);
    }

    @Test
    public void testResponseMultipleSetCookieInHeaderAndTrailer() {
        this.testResponseMultipleSetCookie(true, true);
    }

    private void testResponseMultipleSetCookie(boolean inHeader, boolean inTrailer) {
        ArrayList cookies = new ArrayList();
        this.server.requestHandler(req -> {
            if (inHeader) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("h1=h1v1");
                headers.add("h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(headers);
                req.response().headers().set("Set-Cookie", headers);
            }
            if (inTrailer) {
                req.response().setChunked(true);
                ArrayList<String> trailers = new ArrayList<String>();
                trailers.add("t1=t1v1");
                trailers.add("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(trailers);
                req.response().trailers().set("Set-Cookie", trailers);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertEquals(cookies.size(), resp.cookies().size());
            for (int i = 0; i < cookies.size(); ++i) {
                this.assertEquals(cookies.get(i), resp.cookies().get(i));
            }
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testUseRequestAfterComplete() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.end();
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateExceptionAsync(() -> req.end());
            TestUtils.assertIllegalStateException(() -> req.continueHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.end("foo"));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.end(buff));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.sendHead());
            TestUtils.assertIllegalStateException(() -> req.setChunked(false));
            TestUtils.assertIllegalStateException(() -> req.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.write((Object)buff));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.write("foo"));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateExceptionAsync(() -> req.write((Object)buff));
            TestUtils.assertIllegalStateException(() -> req.writeQueueFull());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRequestBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(body, this.onSuccess(resp -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testRequestBodyStringDefaultEncodingAtEnd() {
        this.testRequestBodyStringAtEnd(null);
    }

    @Test
    public void testRequestBodyStringUTF8AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-8");
    }

    @Test
    public void testRequestBodyStringUTF16AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-16");
    }

    private void testRequestBodyStringAtEnd(String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(bodyBuff, buffer);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            if (encoding == null) {
                req.end(body);
            } else {
                req.end(body, encoding);
            }
        }))));
        this.await();
    }

    @Test
    public void testRequestBodyWriteChunked() {
        this.testRequestBodyWrite(true);
    }

    @Test
    public void testRequestBodyWriteNonChunked() {
        this.testRequestBodyWrite(false);
    }

    private void testRequestBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.testComplete()));
            int numWrites = 10;
            int chunkSize = 100;
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.write((Object)b);
            }
            req.end();
        }))));
        this.await();
    }

    @Test
    public void testRequestBodyWriteStringChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(true, null);
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF8() {
        this.testRequestBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF16() {
        this.testRequestBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(false, null);
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF8() {
        this.testRequestBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF16() {
        this.testRequestBodyWriteString(false, "UTF-16");
    }

    private void testRequestBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.write(body);
            } else {
                req.write(body, encoding);
            }
            req.end();
        }))));
        this.await();
    }

    @Test
    public void testRequestWrite() {
        int times = 3;
        Buffer chunk = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            Buffer expected = Buffer.buffer();
            for (int i = 0; i < times; ++i) {
                expected.appendBuffer(chunk);
            }
            this.assertEquals(expected, buff);
            this.testComplete();
        }));
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.setChunked(true);
            int padding = 5;
            for (int i = 0; i < times; ++i) {
                Buffer paddedChunk = TestUtils.leftPad(padding, chunk);
                req.write((Object)paddedChunk);
            }
            req.end();
        }))));
        this.await();
    }

    @Repeat(times=10)
    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnection() throws Exception {
        int numReqs = 10;
        this.waitFor(numReqs);
        this.server.requestHandler(request -> request.response().close()).listen(this.testAddress, this.onSuccess(s -> {
            for (int i = 0; i < numReqs; ++i) {
                this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onFailure(err -> this.complete()));
            }
        }));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnectionAfterPartialResponse() throws Exception {
        this.server.requestHandler(request -> {
            HttpServerResponse resp = request.response().setChunked(true);
            resp.write("foo");
            resp.close();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.exceptionHandler(t -> this.testComplete())))))));
        this.await();
    }

    @Test
    public void testContextExceptionHandlerCalledWhenExceptionOnDataHandler() throws Exception {
        this.client.close();
        this.server.requestHandler(request -> request.response().end("foo")).listen(this.testAddress, this.onSuccess(s -> {
            Context ctx = this.vertx.getOrCreateContext();
            RuntimeException cause = new RuntimeException("should be caught");
            ctx.exceptionHandler(err -> {
                if (err == cause) {
                    this.testComplete();
                }
            });
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.handler(data -> {
                throw cause;
            })))));
        }));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenExceptionOnBodyHandler() {
        this.client.close();
        this.server.requestHandler(request -> request.response().end("foo")).listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            Context ctx = this.vertx.getOrCreateContext();
            RuntimeException cause = new RuntimeException("should be caught");
            ctx.exceptionHandler(err -> {
                if (err == cause) {
                    this.testComplete();
                }
            });
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(data -> {
                throw cause;
            })))));
        }));
        this.await();
    }

    @Test
    public void testNoExceptionHandlerCalledWhenResponseEnded() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            req.exceptionHandler(this::fail);
            resp.exceptionHandler(err -> this.fail((Throwable)err));
            resp.end();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.exceptionHandler(t -> this.fail("Should not be called")).send(this.onSuccess(resp -> {
            resp.endHandler(v -> this.vertx.setTimer(100L, tid -> this.testComplete()));
            resp.exceptionHandler(t -> this.fail("Should not be called"));
        }))))));
        this.await();
    }

    @Test
    public void testServerExceptionHandlerOnClose() {
        this.waitFor(3);
        this.vertx.createHttpServer().requestHandler(req -> {
            HttpServerResponse resp = req.response();
            AtomicInteger reqExceptionHandlerCount = new AtomicInteger();
            AtomicInteger respExceptionHandlerCount = new AtomicInteger();
            AtomicInteger respEndHandlerCount = new AtomicInteger();
            req.exceptionHandler(err -> {
                this.assertEquals(1L, reqExceptionHandlerCount.incrementAndGet());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.get());
                this.assertTrue(resp.closed());
                this.assertFalse(resp.ended());
                try {
                    resp.end();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
            resp.exceptionHandler(err -> {
                this.assertEquals(0L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.incrementAndGet());
                this.assertEquals(0L, respEndHandlerCount.get());
                this.complete();
            });
            resp.endHandler(v -> {
                this.assertEquals(0L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.incrementAndGet());
                this.complete();
            });
            req.connection().closeHandler(v -> {
                this.assertEquals(1L, reqExceptionHandlerCount.get());
                this.assertEquals(1L, respExceptionHandlerCount.get());
                this.assertEquals(1L, respEndHandlerCount.get());
                this.complete();
            });
        }).listen(this.testAddress, this.onSuccess(ar -> {
            HttpClient client = this.vertx.createHttpClient();
            client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
                req.setChunked(true);
                req.sendHead(v -> req.connection().close());
            }));
        }));
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        this.server.requestHandler(req -> req.handler(buff -> req.connection().close()));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.setChunked(true);
            req.exceptionHandler(err -> this.testComplete());
            req.write("chunk");
        }));
        this.await();
    }

    @Test
    public void testClientResponseExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        AtomicReference conn = new AtomicReference();
        this.server.requestHandler(req -> {
            conn.set(req.connection());
            req.response().setChunked(true).write("chunk");
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            resp.handler(buff -> ((HttpConnection)conn.get()).close());
            resp.exceptionHandler(err -> this.testComplete());
        }))));
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenRequestEnded() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.exceptionHandler(this::fail).send(this.onFailure(err -> this.complete()));
            try {
                req.exceptionHandler(err -> this.fail());
                this.fail();
            }
            catch (Exception e) {
                this.complete();
            }
        }));
        this.await();
    }

    @Test
    public void testDefaultStatus() {
        this.testStatusCode(-1, null);
    }

    @Test
    public void testDefaultOther() {
        this.testStatusCode(405, null);
    }

    @Test
    public void testOverrideStatusMessage() {
        this.testStatusCode(404, "some message");
    }

    @Test
    public void testOverrideDefaultStatusMessage() {
        this.testStatusCode(-1, "some other message");
    }

    private void testStatusCode(int code, String statusMessage) {
        this.server.requestHandler(req -> {
            if (code != -1) {
                req.response().setStatusCode(code);
            }
            if (statusMessage != null) {
                req.response().setStatusMessage(statusMessage);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            int theCode;
            if (code == -1) {
                this.assertEquals(200L, resp.statusCode());
                theCode = 200;
            } else {
                theCode = code;
            }
            if (statusMessage != null && resp.version() != HttpVersion.HTTP_2) {
                this.assertEquals(statusMessage, resp.statusMessage());
            } else {
                this.assertEquals(HttpResponseStatus.valueOf((int)theCode).reasonPhrase(), resp.statusMessage());
            }
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testResponseTrailersPutAll() throws Exception {
        this.testResponseTrailers(false);
    }

    @Test
    public void testResponseTrailersPutIndividually() throws Exception {
        this.testResponseTrailers(true);
    }

    private void testResponseTrailers(boolean individually) throws Exception {
        MultiMap trailers = TestUtils.randomMultiMap(10);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            if (individually) {
                for (Map.Entry header : trailers) {
                    req.response().trailers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().trailers().setAll(trailers);
            }
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> resp.end().map(v -> {
            this.assertEquals(trailers.size(), resp.trailers().size());
            for (Map.Entry entry : trailers) {
                this.assertEquals(entry.getValue(), resp.trailers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getTrailer((String)entry.getKey()));
            }
            return v;
        }))).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testResponseNoTrailers() {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertTrue(resp.trailers().isEmpty());
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testUseAfterServerResponseHeadSent() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"128");
            resp.write("01234567");
            this.assertTrue(resp.headWritten());
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setStatusCode(200));
            TestUtils.assertIllegalStateException(() -> resp.setStatusMessage("OK"));
            TestUtils.assertIllegalStateException(() -> resp.putHeader("foo", "bar"));
            TestUtils.assertIllegalStateException(() -> resp.addCookie(Cookie.cookie((String)"the_cookie", (String)"wibble")));
            TestUtils.assertIllegalStateException(() -> resp.removeCookie("the_cookie"));
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testUseAfterServerResponseSent() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            this.assertFalse(resp.ended());
            resp.end();
            this.assertTrue(resp.ended());
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateException(() -> resp.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.exceptionHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> resp.writeQueueFull());
            TestUtils.assertIllegalStateException(() -> resp.putHeader("foo", "bar"));
            TestUtils.assertIllegalStateException(() -> resp.sendFile("webroot/somefile.html"));
            TestUtils.assertIllegalStateException(() -> resp.end());
            TestUtils.assertIllegalStateException(() -> resp.end("foo"));
            TestUtils.assertIllegalStateException(() -> resp.end(buff));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write((Object)buff));
            TestUtils.assertIllegalStateException(() -> resp.write("foo"));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write((Object)buff));
            TestUtils.assertIllegalStateException(() -> resp.sendFile("webroot/somefile.html", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end(ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end(buff, ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write((Object)buff, ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8", ar -> {}));
            TestUtils.assertIllegalStateException(() -> resp.write((Object)buff, ar -> {}));
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testSetInvalidStatusMessage() {
        this.server.requestHandler(req -> {
            try {
                req.response().setStatusMessage("hello\nworld");
                this.assertEquals(HttpVersion.HTTP_2, req.version());
            }
            catch (IllegalArgumentException ignore) {
                this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testResponseBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().end(body));
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testResponseBodyWriteChunked() {
        this.testResponseBodyWrite(true);
    }

    @Test
    public void testResponseBodyWriteNonChunked() {
        this.testResponseBodyWrite(false);
    }

    private void testResponseBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        int numWrites = 10;
        int chunkSize = 100;
        this.server.requestHandler(req -> {
            this.assertFalse(req.response().headWritten());
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            this.assertFalse(req.response().headWritten());
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.response().write((Object)b);
                this.assertTrue(req.response().headWritten());
            }
            req.response().end();
            this.assertTrue(req.response().headWritten());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testResponseBodyWriteStringChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(true, null);
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF8() {
        this.testResponseBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF16() {
        this.testResponseBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(false, null);
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF8() {
        this.testResponseBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF16() {
        this.testResponseBodyWriteString(false, "UTF-16");
    }

    private void testResponseBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> {
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.response().write(body);
            } else {
                req.response().write(body, encoding);
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testResponseWrite() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write((Object)body);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    @DetectFileDescriptorLeaks
    public void testSendFile() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, false, () -> this.client.request(this.requestOptions));
    }

    @Test
    public void testSendFileWithHandler() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, true, () -> this.client.request(this.requestOptions));
    }

    protected void sendFile(String fileName, String contentExpected, boolean useHandler, Supplier<Future<HttpClientRequest>> requestFact) throws Exception {
        this.waitFor(2);
        File fileToSend = this.setupFile(fileName, contentExpected);
        this.server.requestHandler(req -> {
            if (useHandler) {
                Handler<AsyncResult<Void>> completionHandler = this.onSuccess(v -> this.complete());
                req.response().sendFile(fileToSend.getAbsolutePath(), completionHandler);
            } else {
                req.response().sendFile(fileToSend.getAbsolutePath());
                this.complete();
            }
        });
        this.startServer(this.testAddress);
        requestFact.get().onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/html", resp.headers().get("Content-Type"));
            resp.exceptionHandler(this::fail);
            resp.bodyHandler(buff -> {
                this.assertEquals(contentExpected, buff.toString());
                this.assertEquals(fileToSend.length(), Long.parseLong(resp.headers().get("content-length")));
                this.complete();
            });
        }))));
        this.await();
    }

    @Test
    public void testSendNonExistingFile() throws Exception {
        this.server.requestHandler(req -> {
            Context ctx = this.vertx.getOrCreateContext();
            req.response().sendFile("/not/existing/path", event -> {
                this.assertEquals(ctx, this.vertx.getOrCreateContext());
                if (event.failed()) {
                    req.response().end("failed");
                }
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.bodyHandler(buff -> {
            this.assertEquals("failed", buff.toString());
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testSendFileOverrideHeaders() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile("test-send-file.html", content);
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(file.getAbsolutePath());
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(file.length(), Long.parseLong(resp.headers().get("content-length")));
            this.assertEquals("wibble", resp.headers().get("content-type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(content, buff.toString());
                file.delete();
                this.testComplete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testSendFileNotFound() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html");
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {}))));
            this.vertx.setTimer(100L, tid -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testSendFileNotFoundWithHandler() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html", this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {}))))));
        this.await();
    }

    @Test
    public void testSendFileDirectoryWithHandler() throws Exception {
        File dir = this.testFolder.newFolder();
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(dir.getAbsolutePath(), this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {}))))));
        this.await();
    }

    @Test
    public void testSendOpenRangeFileFromClasspath() {
        this.server.requestHandler(res -> res.response().sendFile("hosts_config.txt", 13L)).listen(this.testAddress, this.onSuccess(res -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(resp -> {
            this.assertEquals(String.valueOf(10), resp.headers().get("Content-Length"));
            return resp.body();
        }).onComplete(this.onSuccess(body -> {
            this.assertTrue(body.toString().startsWith("server.net"));
            this.assertEquals(10L, body.toString().length());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testSendRangeFileFromClasspath() {
        this.server.requestHandler(res -> res.response().sendFile("hosts_config.txt", 13L, 10L)).listen(this.testAddress, this.onSuccess(res -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(resp -> {
            this.assertEquals(String.valueOf(10), resp.headers().get("Content-Length"));
            return resp.body();
        }).onComplete(this.onSuccess(body -> {
            this.assertEquals("server.net", body.toString());
            this.assertEquals(10L, body.toString().length());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void test100ContinueHandledAutomatically() {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHandle100ContinueAutomatically(true));
        this.server.requestHandler(req -> req.bodyHandler(data -> {
            this.assertEquals(toSend, data);
            req.response().end();
        }));
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> resp.endHandler(v -> this.testComplete())));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write((Object)toSend);
                req.end();
            });
            req.sendHead();
        }))));
        this.await();
    }

    @Test
    public void test100ContinueHandledManually() {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            this.assertEquals("100-continue", req.getHeader("expect"));
            req.response().writeContinue();
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> resp.endHandler(v -> this.testComplete())));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write((Object)toSend);
                req.end();
            });
            req.sendHead();
        }))));
        this.await();
    }

    @Test
    public void test100ContinueRejectedManually() {
        this.server.requestHandler(req -> {
            req.response().setStatusCode(405).end();
            req.bodyHandler(data -> this.fail("body should not be received"));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(405L, resp.statusCode());
                this.testComplete();
            }));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> this.fail("should not be called"));
            req.sendHead();
        }))));
        this.await();
    }

    @Test
    public void test100ContinueTimeout() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().writeContinue());
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(1));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.putHeader("Expect", "100-continue").continueHandler(v -> this.complete()).send(this.onFailure(err -> this.complete()))));
        this.await();
    }

    @Test
    public void test103EarlyHints() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            req.pause();
            resp.writeEarlyHints((MultiMap)HeadersMultiMap.httpHeaders().add("wibble", "wibble-103-value"), result -> {
                if (result.failed()) {
                    this.fail(result.cause());
                } else {
                    req.resume();
                    resp.putHeader("wibble", "wibble-200-value");
                    req.bodyHandler(body -> {
                        this.assertEquals("request-body", body.toString());
                        resp.end("response-body");
                    });
                }
            });
        });
        AtomicBoolean earlyHintsHandled = new AtomicBoolean();
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.earlyHintsHandler(earlyHintsHeaders -> {
            this.assertEquals("wibble-103-value", earlyHintsHeaders.get("wibble"));
            earlyHintsHandled.set(true);
        }).send("request-body", this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("wibble-200-value", resp.headers().get("wibble"));
            resp.endHandler(v -> {
                this.assertEquals("Early hints handle check", true, earlyHintsHandled.get());
                this.testComplete();
            }).bodyHandler(body -> this.assertEquals(body, Buffer.buffer((String)"response-body")));
        }))));
        this.await();
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer(resumeFuture -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.write((Object)buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        this.assertFalse(req.writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        })));
        this.await();
    }

    private void pausingServer(Consumer<Promise<Void>> consumer) {
        Promise resumeFuture = Promise.promise();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeFuture.future().onComplete(v1 -> ctx.runOnContext(v2 -> req.resume()));
            req.handler(buff -> req.response().write(buff));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> consumer.accept(resumeFuture)));
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer(resumeFuture -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            resp.pause();
            resumeFuture.onComplete(ar -> resp.resume());
        })));
        this.await();
    }

    private void drainingServer(Consumer<Future<Void>> consumer) {
        Promise resumeFuture = Promise.promise();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.assertFalse(req.response().writeQueueFull());
            req.response().setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.response().write((Object)buff);
                if (req.response().writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.response().drainHandler(v -> {
                        this.assertFalse(req.response().writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> consumer.accept(resumeFuture.future())));
    }

    @Test
    public void testConnectInvalidPort() {
        this.client.request(HttpMethod.GET, 9998, "localhost", "some-uri").onComplete(this.onFailure(err -> this.complete()));
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri").onComplete(this.onFailure(resp -> this.complete()));
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> this.server.webSocketHandler(this.noOpHandler()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening2() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
        TestUtils.assertIllegalStateException(() -> this.server.webSocketHandler(this.noOpHandler()));
        this.await();
    }

    @Test
    public void testListenNoHandlers() {
        TestUtils.assertIllegalStateException(() -> this.server.listen(ar -> {}));
    }

    @Test
    public void testListenNoHandlers2() {
        TestUtils.assertIllegalStateException(() -> this.server.listen());
    }

    @Test
    public void testListenTwice() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.listen());
        this.await();
    }

    @Test
    public void testListenTwice2() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.listen());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHeadCanSetContentLength() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().headers().set("Content-Length", String.valueOf(41));
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.HEAD)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals("41", resp.headers().get("Content-Length"));
            resp.endHandler(v -> this.testComplete());
        }))));
        this.await();
    }

    @Test
    public void testHeadDoesNotSetAutomaticallySetContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, HttpHeaders.headers());
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testHeadAllowsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, HttpHeaders.set((String)"content-length", (String)"34"));
        this.assertEquals("34", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testHeadRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.HEAD, 200, HttpHeaders.set((String)"transfer-encoding", (String)"chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNoContentRemovesContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 204, HttpHeaders.set((String)"content-length", (String)"34"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNoContentRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 204, HttpHeaders.set((String)"transfer-encoding", (String)"chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testResetContentSetsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 205, HttpHeaders.headers());
        this.assertEquals("0", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testResetContentRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 205, HttpHeaders.set((String)"transfer-encoding", (String)"chunked"));
        this.assertEquals("0", respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedDoesNotSetAutomaticallySetContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, HttpHeaders.headers());
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedAllowsContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, HttpHeaders.set((String)"content-length", (String)"34"));
        this.assertEquals("34", respHeaders.get("Content-Length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void testNotModifiedRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 304, HttpHeaders.set((String)"transfer-encoding", (String)"chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void test1xxRemovesContentLengthHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 102, HttpHeaders.set((String)"content-length", (String)"34"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    @Test
    public void test1xxRemovesTransferEncodingHeader() throws Exception {
        MultiMap respHeaders = this.checkEmptyHttpResponse(HttpMethod.GET, 102, HttpHeaders.set((String)"transfer-encoding", (String)"chunked"));
        this.assertNull(respHeaders.get("content-length"));
        this.assertNull(respHeaders.get("transfer-encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiMap checkEmptyHttpResponse(HttpMethod method, int sc, MultiMap reqHeaders) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setStatusCode(sc);
            reqHeaders.remove("transfer-encoding");
            resp.headers().addAll(reqHeaders);
            resp.end();
        });
        this.startServer(this.testAddress);
        try {
            CompletionStage result = this.client.request(new RequestOptions(this.requestOptions).setMethod(method)).compose(req -> req.setFollowRedirects(false).send().compose(resp -> resp.body().compose(body -> {
                if (body.length() > 0) {
                    return Future.failedFuture((Throwable)new Exception());
                }
                return Future.succeededFuture((Object)resp.headers());
            }))).toCompletionStage();
            MultiMap multiMap = (MultiMap)result.toCompletableFuture().get(20L, TimeUnit.SECONDS);
            return multiMap;
        }
        finally {
            this.client.close();
        }
    }

    @Test
    public void testHeadHasNoContentLengthByDefault() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.HEAD)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertNull(resp.headers().get(HttpHeaders.CONTENT_LENGTH));
            resp.endHandler(v -> this.testComplete());
        }))))));
        this.await();
    }

    @Test
    public void testHeadButCanSetContentLength() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"41").end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.HEAD)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals("41", resp.headers().get(HttpHeaders.CONTENT_LENGTH));
            resp.endHandler(v -> this.testComplete());
        }))))));
        this.await();
    }

    @Test
    public void testRemoteAddress() {
        this.server.requestHandler(req -> {
            if (this.testAddress.isInetSocket()) {
                this.assertEquals("127.0.0.1", req.remoteAddress().host());
            }
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(req -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testGetAbsoluteURI() {
        this.server.requestHandler(req -> {
            this.assertEquals(req.scheme() + "://localhost:" + 8080 + "/foo/bar", req.absoluteURI());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setURI("/foo/bar")).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(req -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testListenInvalidPort() throws Exception {
        this.server.close();
        try (ServerSocket occupied = null;){
            occupied = new ServerSocket(0);
            occupied.setReuseAddress(false);
            this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(occupied.getLocalPort()));
            this.server.requestHandler(this.noOpHandler()).listen(this.onFailure(server -> this.testComplete()));
            this.await();
        }
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("iqwjdoqiwjdoiqwdiojwd"));
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onFailure(s -> this.testComplete()));
    }

    @Test
    public void testPauseResumeClientResponseWontCallEndHandlePrematurely() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(8192));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> {
            resp.bodyHandler(body -> {
                this.assertEquals(expected, body);
                this.testComplete();
            });
            resp.pause();
            resp.resume();
        }))));
        this.await();
    }

    @Test
    public void testPauseClientResponse() throws Exception {
        int numWrites = 10;
        int numBytes = 100;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            for (int i = 0; i < numWrites; ++i) {
                req.response().write((Object)TestUtils.randomBuffer(numBytes));
            }
            req.response().end();
        });
        this.startServer(this.testAddress);
        AtomicBoolean paused = new AtomicBoolean();
        Buffer totBuff = Buffer.buffer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            resp.pause();
            paused.set(true);
            resp.handler(chunk -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    totBuff.appendBuffer(chunk);
                }
            });
            resp.endHandler(v -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    this.assertEquals(numWrites * numBytes, totBuff.length());
                    this.testComplete();
                }
            });
            this.vertx.setTimer(500L, id -> {
                paused.set(false);
                resp.resume();
            });
        }))));
        this.await();
    }

    @Test
    public void testDeliverPausedBufferWhenResume() throws Exception {
        this.testDeliverPausedBufferWhenResume(block -> this.vertx.setTimer(10L, id -> block.run()));
    }

    @Test
    public void testDeliverPausedBufferWhenResumeOnOtherThread() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            this.testDeliverPausedBufferWhenResume(block -> exec.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                    Thread.currentThread().interrupt();
                }
                block.run();
            }));
        }
        finally {
            exec.shutdown();
        }
    }

    private void testDeliverPausedBufferWhenResume(Consumer<Runnable> scheduler) throws Exception {
        int i;
        Buffer data = TestUtils.randomBuffer(2048);
        int num = 10;
        this.waitFor(num);
        List resumes = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < num; ++i) {
            resumes.add(new CompletableFuture());
        }
        this.server.requestHandler(req -> {
            int idx = Integer.parseInt(req.path().substring(1));
            HttpServerResponse resp = req.response();
            ((CompletableFuture)resumes.get(idx)).thenAccept(v -> resp.end());
            resp.setChunked(true).write((Object)data);
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (i = 0; i < num; ++i) {
            int idx = i;
            this.client.request(new RequestOptions(this.requestOptions).setURI("/" + i)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                Buffer body = Buffer.buffer();
                Thread t = Thread.currentThread();
                resp.handler(buff -> {
                    this.assertSame(t, Thread.currentThread());
                    ((CompletableFuture)resumes.get(idx)).complete(null);
                    body.appendBuffer(buff);
                });
                resp.endHandler(v -> this.complete());
                resp.pause();
                scheduler.accept(() -> ((HttpClientResponse)resp).resume());
            }))));
        }
        this.await();
    }

    @Test
    public void testClearPausedBuffersWhenResponseEnds() throws Exception {
        Buffer data = TestUtils.randomBuffer(20);
        int num = 10;
        this.waitFor(num);
        this.server.requestHandler(req -> req.response().end(data));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (int i = 0; i < num; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                resp.bodyHandler(buff -> {
                    this.assertEquals(data, buff);
                    this.complete();
                });
                resp.pause();
                this.vertx.setTimer(10L, id -> resp.resume());
            }))));
        }
        this.await();
    }

    @Test
    public void testPausedHttpServerRequest() throws Exception {
        CompletableFuture resumeCF = new CompletableFuture();
        Buffer expected = Buffer.buffer();
        this.server.requestHandler(req -> {
            req.pause();
            AtomicBoolean paused = new AtomicBoolean(true);
            Buffer body = Buffer.buffer();
            req.handler(buff -> {
                this.assertFalse(paused.get());
                body.appendBuffer(buff);
            });
            resumeCF.thenAccept(v -> {
                paused.set(false);
                req.resume();
            });
            req.endHandler(v -> {
                this.assertEquals(expected, body);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.setChunked(true).response(this.onSuccess(resp -> resp.endHandler(v -> this.testComplete())));
            while (!req.writeQueueFull()) {
                Buffer buff = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
                expected.appendBuffer(buff);
                req.write((Object)buff);
            }
            resumeCF.complete(null);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testHttpServerRequestPausedDuringLastChunk1() throws Exception {
        this.testHttpServerRequestPausedDuringLastChunk(false);
    }

    @Test
    public void testHttpServerRequestPausedDuringLastChunk2() throws Exception {
        this.testHttpServerRequestPausedDuringLastChunk(true);
    }

    private void testHttpServerRequestPausedDuringLastChunk(boolean fetching) throws Exception {
        this.server.requestHandler(req -> {
            AtomicBoolean ended = new AtomicBoolean();
            AtomicBoolean paused = new AtomicBoolean();
            req.handler(buff -> {
                this.assertEquals("small", buff.toString());
                req.pause();
                paused.set(true);
                this.vertx.setTimer(20L, id -> {
                    this.assertFalse(ended.get());
                    paused.set(false);
                    if (fetching) {
                        req.fetch(1L);
                    } else {
                        req.resume();
                    }
                });
            });
            req.endHandler(v -> {
                this.assertFalse(paused.get());
                ended.set(true);
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.send(Buffer.buffer((String)"small"), this.onSuccess(resp -> this.complete()))));
        this.await();
    }

    @Test
    public void testHttpClientResponsePausedDuringLastChunk1() throws Exception {
        this.testHttpClientResponsePausedDuringLastChunk(false);
    }

    @Test
    public void testHttpClientResponsePausedDuringLastChunk2() throws Exception {
        this.testHttpClientResponsePausedDuringLastChunk(true);
    }

    private void testHttpClientResponsePausedDuringLastChunk(boolean fetching) throws Exception {
        this.server.requestHandler(req -> req.response().end("small"));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            AtomicBoolean ended = new AtomicBoolean();
            AtomicBoolean paused = new AtomicBoolean();
            resp.handler(buff -> {
                this.assertEquals("small", buff.toString());
                resp.pause();
                paused.set(true);
                this.vertx.setTimer(20L, id -> {
                    this.assertFalse(ended.get());
                    paused.set(false);
                    if (fetching) {
                        resp.fetch(1L);
                    } else {
                        resp.resume();
                    }
                });
            });
            resp.endHandler(v -> {
                this.assertFalse(paused.get());
                ended.set(true);
                this.complete();
            });
        }))));
        this.await();
    }

    @Test
    public void testHostHeaderOverridePossible() {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.host());
            this.assertEquals("localhost", req.authority().host());
            this.assertEquals(4444L, req.authority().port());
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions().setServer(this.testAddress).setHost("localhost").setPort(Integer.valueOf(4444))).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testResponseBodyWriteFixedString() {
        String body = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Buffer bodyBuff = Buffer.buffer((String)body);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.requestHandler(req -> {
            req.response().putHeader("count", req.headers().get("count"));
            req.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> {
            for (int i = 0; i < numThreads; ++i) {
                final int index = i;
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        HttpTest.this.client.request(HttpTest.this.requestOptions).compose(req -> req.putHeader("count", String.valueOf(index)).send()).onComplete(HttpTest.this.onSuccess(resp -> {
                            HttpTest.this.assertEquals(200L, resp.statusCode());
                            HttpTest.this.assertEquals(String.valueOf(index), resp.headers().get("count"));
                            latch.countDown();
                        }));
                    }
                };
                threads[i].start();
            }
        }));
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = Vertx.currentContext();
                if (worker) {
                    HttpTest.this.assertTrue(this.ctx.isWorkerContext());
                } else {
                    HttpTest.this.assertTrue(this.ctx.isEventLoopContext());
                }
                Thread thr = Thread.currentThread();
                HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
                HttpTest.this.server.requestHandler(req -> {
                    req.response().end();
                    HttpTest.this.assertSameEventLoop(this.ctx, Vertx.currentContext());
                    HttpTest.this.assertSame(((HttpServerRequestInternal)req).context(), Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                HttpTest.this.server.listen(HttpTest.this.testAddress, HttpTest.this.onSuccess(s -> {
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                    HttpTest.this.client.request(HttpTest.this.requestOptions).compose(HttpClientRequest::send).onComplete(HttpTest.this.onSuccess(resp -> {
                        HttpTest.this.assertSameEventLoop(this.ctx, Vertx.currentContext());
                        if (!worker) {
                            HttpTest.this.assertSame(thr, Thread.currentThread());
                        }
                        HttpTest.this.assertEquals(200L, resp.statusCode());
                        HttpTest.this.testComplete();
                    }));
                }));
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testWorkerServer() throws Exception {
        int numReq = 5;
        this.waitFor(numReq);
        final AtomicBoolean owner = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger connCount = new AtomicInteger();
        this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                this.vertx.createHttpServer(HttpTest.this.createBaseServerOptions()).requestHandler(req -> {
                    Context current = Vertx.currentContext();
                    HttpTest.this.assertTrue(current.isWorkerContext());
                    HttpTest.this.assertSameEventLoop(this.context, current);
                    try {
                        HttpTest.this.assertTrue(owner.compareAndSet(false, true));
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        HttpTest.this.fail(e);
                    }
                    finally {
                        owner.set(false);
                    }
                    req.response().end("pong");
                }).connectionHandler(conn -> {
                    Context current = Vertx.currentContext();
                    HttpTest.this.assertTrue(Context.isOnEventLoopThread());
                    HttpTest.this.assertTrue(current.isEventLoopContext());
                    HttpTest.this.assertNotSame(this.context, current);
                    connCount.incrementAndGet();
                }).listen(HttpTest.this.testAddress).mapEmpty().onComplete(startPromise);
            }
        }, new DeploymentOptions().setWorker(true), this.onSuccess(id -> latch.countDown()));
        this.awaitLatch(latch);
        for (int i = 0; i < numReq; ++i) {
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.complete()));
        }
        this.await();
        this.assertTrue(connCount.get() > 0);
    }

    @Test
    public void testInWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                HttpTest.this.assertTrue(Context.isOnWorkerThread());
                HttpServer server = this.vertx.createHttpServer(HttpTest.this.createBaseServerOptions());
                server.requestHandler(req -> {
                    HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    HttpTest.this.assertTrue(Context.isOnWorkerThread());
                    Buffer buf = Buffer.buffer();
                    req.handler(arg_0 -> ((Buffer)buf).appendBuffer(arg_0));
                    req.endHandler(v -> {
                        HttpTest.this.assertEquals("hello", buf.toString());
                        req.response().end("bye");
                    });
                }).listen(HttpTest.this.testAddress, HttpTest.this.onSuccess(s -> {
                    HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    HttpTest.this.assertTrue(Context.isOnWorkerThread());
                    HttpClient client = this.vertx.createHttpClient(HttpTest.this.createBaseClientOptions());
                    client.request(new RequestOptions(HttpTest.this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(HttpTest.this.onSuccess(req -> req.send(Buffer.buffer((String)"hello"), HttpTest.this.onSuccess(resp -> {
                        HttpTest.this.assertEquals(200L, resp.statusCode());
                        HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        HttpTest.this.assertTrue(Context.isOnWorkerThread());
                        resp.handler(buf -> {
                            HttpTest.this.assertEquals("bye", buf.toString());
                            resp.endHandler(v -> HttpTest.this.testComplete());
                        });
                    }))));
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testClientReadStreamInWorker() throws Exception {
        final int numReq = 16;
        this.waitFor(numReq);
        final Buffer body = Buffer.buffer((String)TestUtils.randomAlphaString(524288));
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                HttpServer server = this.vertx.createHttpServer(HttpTest.this.createBaseServerOptions());
                server.requestHandler(req -> req.response().end(body)).listen(HttpTest.this.testAddress).mapEmpty().onComplete(startPromise);
            }
        }).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                HttpClient client = this.vertx.createHttpClient(HttpTest.this.createBaseClientOptions().setMaxPoolSize(1));
                for (int i = 0; i < numReq; ++i) {
                    client.request(HttpTest.this.requestOptions, HttpTest.this.onSuccess(req -> req.send(HttpTest.this.onSuccess(resp -> {
                        resp.end(HttpTest.this.onSuccess(v -> HttpTest.this.complete()));
                        resp.pause();
                        this.vertx.setTimer(250L, id -> resp.resume());
                    }))));
                }
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testServerReadStreamInWorker() throws Exception {
        final int numReq = 16;
        this.waitFor(numReq);
        final Buffer body = Buffer.buffer((String)TestUtils.randomAlphaString(524288));
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                HttpServer server = this.vertx.createHttpServer(HttpTest.this.createBaseServerOptions());
                server.requestHandler(req -> {
                    req.end(HttpTest.this.onSuccess(v -> req.response().end()));
                    req.pause();
                    this.vertx.setTimer(250L, id -> req.resume());
                }).listen(HttpTest.this.testAddress).mapEmpty().onComplete(startPromise);
            }
        }, new DeploymentOptions().setWorker(true)).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                HttpClient client = this.vertx.createHttpClient(HttpTest.this.createBaseClientOptions().setMaxPoolSize(1));
                for (int i = 0; i < numReq; ++i) {
                    client.request(HttpTest.this.requestOptions, HttpTest.this.onSuccess(req -> req.send(body, HttpTest.this.onSuccess(resp -> resp.end(HttpTest.this.onSuccess(v -> HttpTest.this.complete()))))));
                }
            }
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.requestStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testRequestEnded() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.endHandler(v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                req.response().setStatusCode(200).end();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testRequestEndedNoEndHandler() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.response().setStatusCode(200).end();
            this.vertx.setTimer(500L, v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.assertEquals(200L, resp.statusCode())))));
        this.await();
    }

    @Test
    public void testAbsoluteURIServer() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHost("0.0.0.0"));
        this.server.requestHandler(req -> {
            String absURI = req.absoluteURI();
            this.assertEquals(req.scheme() + "://localhost:8080/path", absURI);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            String path = "/path";
            this.client.request(new RequestOptions(this.requestOptions).setURI(path)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testDumpManyRequestsOnQueue() throws Exception {
        int sendRequests = 10000;
        AtomicInteger receivedRequests = new AtomicInteger();
        HttpClientOptions ops = this.createBaseClientOptions().setDefaultPort(8080).setPipelining(true).setKeepAlive(true);
        this.client.close();
        this.client = this.vertx.createHttpClient(ops);
        this.vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(r -> {
            r.response().end();
            if (receivedRequests.incrementAndGet() == sendRequests) {
                this.testComplete();
            }
        }).listen(this.testAddress, this.onSuccess(s -> IntStream.range(0, sendRequests).forEach(x -> this.client.request(this.requestOptions).compose(HttpClientRequest::send))));
        this.await();
    }

    @Test
    public void testOtherMethodRequest() {
        this.server.requestHandler(r -> {
            this.assertEquals("COPY", r.method().name());
            r.response().end();
        }).listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.valueOf((String)"COPY"))).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testClientGlobalConnectionHandler() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        this.client.connectionHandler(conn -> {
            this.assertSame(ctx, Vertx.currentContext());
            this.complete();
        });
        ctx.runOnContext(v -> this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(resp -> this.complete()));
        this.await();
    }

    @Test
    public void testServerConnectionHandler() throws Exception {
        AtomicInteger status = new AtomicInteger();
        AtomicReference connRef = new AtomicReference();
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> {
            this.assertSameEventLoop(serverCtx, Vertx.currentContext());
            this.assertEquals(0L, status.getAndIncrement());
            this.assertNull(connRef.getAndSet(conn));
        });
        this.server.requestHandler(req -> {
            this.assertEquals(1L, status.getAndIncrement());
            this.assertSame(connRef.get(), req.connection());
            req.response().end();
        });
        this.startServer(this.testAddress, serverCtx, this.server);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(resp -> this.testComplete());
        this.await();
    }

    @Test
    public void testServerConnectionHandlerClose() throws Exception {
        this.waitFor(2);
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> {
            conn.close();
            conn.closeHandler(v -> this.complete());
        });
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress, serverCtx, this.server);
        this.client.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send);
        this.await();
    }

    @Test
    public void testClientConnectionClose() throws Exception {
        Promise latch = Promise.promise();
        this.server.requestHandler(req -> {
            AtomicInteger len = new AtomicInteger();
            req.handler(buff -> {
                if (len.addAndGet(buff.length()) == 1024) {
                    latch.complete();
                }
            });
            req.connection().closeHandler(v -> this.testComplete());
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).onComplete(this.onSuccess(req -> {
            req.setChunked(true).write((Object)TestUtils.randomBuffer(1024));
            latch.future().onComplete(this.onSuccess(v -> req.connection().close()));
        }));
        this.await();
    }

    @Test
    public void testServerConnectionClose() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        this.client.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onFailure(req -> this.complete()));
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLocalAddress() throws Exception {
        String expectedAddress = TestUtils.loopbackAddress();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLocalAddress(expectedAddress));
        this.server.requestHandler(req -> {
            this.assertEquals(expectedAddress, req.remoteAddress().host());
            req.response().end();
        });
        this.startServer();
        this.client.request(HttpMethod.GET, 8080, "localhost", "/somepath").compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectGetOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 301, 301, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 301, 301, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 302, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 302, 302, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 302, 302, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectNotOn304() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 304, 304, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 307, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.POST, 307, 307, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.PUT, 307, 307, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectWithRelativeLocation() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "/another", "http://localhost:8080/another");
    }

    @Test
    public void testFollowRedirectGetOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 308, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.POST, 308, 308, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectPutOn308() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.PUT, 308, 308, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    private void testFollowRedirect(HttpMethod method, HttpMethod expectedMethod, int statusCode, int expectedStatus, int expectedRequests, String location, String expectedURI) throws Exception {
        String s = this.createBaseServerOptions().isSsl() && location.startsWith("http://") ? "https://" + location.substring("http://".length()) : location;
        String t = this.createBaseServerOptions().isSsl() && expectedURI.startsWith("http://") ? "https://" + expectedURI.substring("http://".length()) : expectedURI;
        AtomicInteger numRequests = new AtomicInteger();
        Buffer expectedBody = Buffer.buffer((String)TestUtils.randomAlphaString(256));
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (numRequests.getAndIncrement() == 0) {
                resp.setStatusCode(statusCode);
                if (s != null) {
                    resp.putHeader(HttpHeaders.LOCATION, (CharSequence)s);
                }
                resp.end();
            } else {
                this.assertEquals(t, req.absoluteURI());
                this.assertEquals("foo_value", req.getHeader("foo"));
                this.assertEquals(expectedMethod, req.method());
                resp.end(expectedBody);
            }
        });
        this.startServer();
        this.client.request(new RequestOptions(this.requestOptions).setServer(null).setMethod(method).setURI("/somepath")).compose(req -> req.putHeader("foo", "foo_value").setFollowRedirects(true).send().compose(resp -> {
            this.assertEquals(resp.request().absoluteURI(), t);
            this.assertEquals(expectedRequests, numRequests.get());
            this.assertEquals(expectedStatus, resp.statusCode());
            return resp.body().compose(body -> {
                if (resp.statusCode() == 200) {
                    this.assertEquals(expectedBody, body);
                } else {
                    this.assertEquals(Buffer.buffer(), body);
                }
                return Future.succeededFuture();
            });
        })).onSuccess(v -> this.testComplete());
        this.await();
    }

    @Test
    public void testFollowRedirectWithBody() throws Exception {
        this.testFollowRedirectWithBody(Function.identity());
    }

    @Test
    public void testFollowRedirectWithPaddedBody() throws Exception {
        this.testFollowRedirectWithBody(buff -> TestUtils.leftPad(1, buff));
    }

    private void testFollowRedirectWithBody(Function<Buffer, Buffer> translator) throws Exception {
        Buffer expected = TestUtils.randomBuffer(2048);
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (redirected.compareAndSet(false, true)) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                this.assertNull(req.getHeader(HttpHeaders.CONTENT_LENGTH));
                req.response().end();
            }
        });
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(8080))).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.send((Buffer)translator.apply(expected), this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectHappensAfterResponseIsReceived() throws Exception {
        AtomicBoolean redirected = new AtomicBoolean();
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (redirected.compareAndSet(false, true)) {
                String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                resp.setStatusCode(303).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"11").putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).write("hello ");
                this.vertx.setTimer(500L, id -> {
                    sent.set(true);
                    resp.end("world");
                });
            } else {
                this.assertTrue(sent.get());
                resp.end();
            }
        });
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(8080))).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.send(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectWithChunkedBody() throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        Promise latch = Promise.promise();
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                latch.complete();
            }
            if (redirect) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                req.response().end();
            }
        });
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(8080)).setURI("some-uri")).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.setChunked(true);
            req.write((Object)buff1);
            latch.future().onSuccess(v -> req.end(buff2));
            req.response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectWithRequestNotEnded() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(false);
    }

    @Test
    public void testFollowRedirectWithRequestNotEndedFailing() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(true);
    }

    private void testFollowRedirectWithRequestNotEnded(boolean expectFail) throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        Promise latch = Promise.promise();
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                Buffer body = Buffer.buffer();
                req.handler(buff -> {
                    if (body.length() == 0) {
                        HttpServerResponse resp = req.response();
                        String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                        resp.setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever"));
                        if (expectFail) {
                            resp.setChunked(true).write("whatever");
                            this.vertx.runOnContext(v -> resp.close());
                        } else {
                            resp.end();
                        }
                        latch.complete();
                    }
                    body.appendBuffer(buff);
                });
                req.endHandler(v -> this.assertEquals(expected, body));
            } else {
                req.response().end();
            }
        });
        this.startServer();
        AtomicBoolean called = new AtomicBoolean();
        this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI("some-uri").setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(ar -> {
                this.assertEquals(expectFail, ar.failed());
                if (ar.succeeded()) {
                    HttpClientResponse resp = (HttpClientResponse)ar.result();
                    this.assertEquals(200L, resp.statusCode());
                    this.testComplete();
                } else if (called.compareAndSet(false, true)) {
                    this.testComplete();
                }
            });
            latch.future().onComplete(this.onSuccess(v -> {
                if (!expectFail) {
                    this.vertx.setTimer(500L, id -> req.end(buff2));
                }
            }));
            req.setFollowRedirects(true).setChunked(true).write((Object)buff1);
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectSendHeadThenBody() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (redirected.compareAndSet(false, true)) {
                this.assertEquals(HttpMethod.PUT, req.method());
                req.bodyHandler(body -> {
                    this.assertEquals(body, expected);
                    req.response().setStatusCode(303).putHeader(HttpHeaders.LOCATION, (CharSequence)"/whatever").end();
                });
            } else {
                this.assertEquals(HttpMethod.GET, req.method());
                req.response().end();
            }
        });
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).setHost("localhost").setPort(Integer.valueOf(8080)).setURI("/somepath")).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true).putHeader("Content-Length", "" + expected.length()).response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
            req.sendHead(this.onSuccess(v -> req.end(expected)));
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectLimit() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        AtomicInteger numberOfRequests = new AtomicInteger();
        this.server.requestHandler(req -> {
            int val = numberOfRequests.incrementAndGet();
            if (val > 17) {
                this.fail();
            } else {
                String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/otherpath")).end();
            }
        });
        this.startServer();
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.send(this.onSuccess(resp -> {
                this.assertEquals(17L, numberOfRequests.get());
                this.assertEquals(301L, resp.statusCode());
                this.assertEquals("/otherpath", resp.request().path());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectPropagatesTimeout() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        AtomicInteger redirections = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (redirections.getAndIncrement()) {
                case 0: {
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                }
            }
        });
        this.startServer();
        AtomicBoolean done = new AtomicBoolean();
        this.client.request(new RequestOptions(this.requestOptions).setTimeout(500L), this.onSuccess(req -> req.setFollowRedirects(true).send(this.onFailure(t -> {
            if (done.compareAndSet(false, true)) {
                this.assertEquals(2L, redirections.get());
                this.testComplete();
            }
        }))));
        this.await();
    }

    @Test
    public void testFollowRedirectHost() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer(this.testAddress);
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        this.client.request(this.requestOptions).compose(req -> req.setFollowRedirects(true).send()).onComplete(this.onSuccess(resp -> {
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", resp.request().absoluteURI());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testFollowRedirectWithCustomHandler() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer();
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/custom", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        Context ctx = this.vertx.getOrCreateContext();
        this.client.close();
        this.client = this.vertx.httpClientBuilder().with(this.createBaseClientOptions()).withRedirectHandler(resp -> {
            this.assertEquals(ctx, Vertx.currentContext());
            Promise fut = Promise.promise();
            this.vertx.setTimer(25L, id -> fut.complete((Object)new RequestOptions().setAbsoluteURI(scheme + "://localhost:" + port + "/custom")));
            return fut.future();
        }).build();
        ctx.runOnContext(v -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080))).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.putHeader("foo", "foo_value");
            req.send(this.onSuccess(resp -> {
                this.assertEquals(scheme + "://localhost:" + port + "/custom", resp.request().absoluteURI());
                this.complete();
            }));
        })));
        this.await();
    }

    @Test
    public void testDefaultRedirectHandler() throws Exception {
        this.testFoo("http://example.com", "http://example.com");
        this.testFoo("http://example.com/somepath", "http://example.com/somepath");
        this.testFoo("http://example.com:8000", "http://example.com:8000");
        this.testFoo("http://example.com:8000/somepath", "http://example.com:8000/somepath");
        this.testFoo("https://example.com", "https://example.com");
        this.testFoo("https://example.com/somepath", "https://example.com/somepath");
        this.testFoo("https://example.com:8000", "https://example.com:8000");
        this.testFoo("https://example.com:8000/somepath", "https://example.com:8000/somepath");
        this.testFoo("whatever://example.com", null);
        this.testFoo("http://", null);
        this.testFoo("http://:8080/somepath", null);
    }

    private void testFoo(String location, String expectedAbsoluteURI) throws Exception {
        final int status = 301;
        final MultiMap headers = HttpHeaders.headers().add(HttpHeaders.LOCATION.toString(), location);
        final HttpMethod method = HttpMethod.GET;
        final String baseURI = "https://localhost:8080";
        class MockReq
        implements HttpClientRequest {
            MockReq() {
            }

            public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> write(Buffer data) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest drainHandler(Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setFollowRedirects(boolean followRedirects) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setMaxRedirects(int maxRedirects) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setChunked(boolean chunked) {
                throw new UnsupportedOperationException();
            }

            public boolean isChunked() {
                return false;
            }

            public HttpClientRequest authority(HostAndPort authority) {
                throw new UnsupportedOperationException();
            }

            public HttpMethod getMethod() {
                return method;
            }

            public String absoluteURI() {
                return baseURI;
            }

            public HttpVersion version() {
                return HttpVersion.HTTP_1_1;
            }

            public String getURI() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setURI(String uri) {
                throw new UnsupportedOperationException();
            }

            public String path() {
                throw new UnsupportedOperationException();
            }

            public String query() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                return headers;
            }

            public HttpClientRequest putHeader(String name, String value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(String name, Iterable<String> values) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> write(String chunk) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> write(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest traceOperation(String op) {
                throw new UnsupportedOperationException();
            }

            public String traceOperation() {
                throw new UnsupportedOperationException();
            }

            public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void write(String chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest continueHandler(@Nullable Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public boolean isFollowRedirects() {
                throw new UnsupportedOperationException();
            }

            public int getMaxRedirects() {
                throw new UnsupportedOperationException();
            }

            public int numberOfRedirections() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest redirectHandler(@Nullable Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest earlyHintsHandler(@Nullable Handler<MultiMap> handler) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> sendHead() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest sendHead(Handler<AsyncResult<Void>> completionHandler) {
                throw new UnsupportedOperationException();
            }

            public Future<HttpClientResponse> connect() {
                throw new UnsupportedOperationException();
            }

            public void connect(Handler<AsyncResult<HttpClientResponse>> handler) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> end(String chunk) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> end(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public void end(Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public Future<Void> end() {
                throw new UnsupportedOperationException();
            }

            public Future<Void> end(Buffer chunk) {
                throw new UnsupportedOperationException();
            }

            public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setTimeout(long timeout) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
                throw new UnsupportedOperationException();
            }

            public boolean reset(long code) {
                return false;
            }

            public boolean reset(long code, Throwable cause) {
                return false;
            }

            public HttpConnection connection() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
                throw new UnsupportedOperationException();
            }

            public boolean writeQueueFull() {
                throw new UnsupportedOperationException();
            }

            public StreamPriority getStreamPriority() {
                return null;
            }

            public HttpClientRequest onComplete(Handler<AsyncResult<HttpClientResponse>> handler) {
                throw new UnsupportedOperationException();
            }

            public boolean isComplete() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                throw new UnsupportedOperationException();
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> Future<U> compose(Function<HttpClientResponse, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
                throw new UnsupportedOperationException();
            }

            public <U> Future<U> map(Function<HttpClientResponse, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> Future<V> map(V value) {
                throw new UnsupportedOperationException();
            }

            public Future<HttpClientResponse> otherwise(Function<Throwable, HttpClientResponse> mapper) {
                throw new UnsupportedOperationException();
            }

            public Future<HttpClientResponse> otherwise(HttpClientResponse value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setHost(String host) {
                throw new UnsupportedOperationException();
            }

            public String getHost() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setPort(int port) {
                throw new UnsupportedOperationException();
            }

            public int getPort() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setMethod(HttpMethod method2) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest response(Handler<AsyncResult<HttpClientResponse>> handler) {
                throw new UnsupportedOperationException();
            }

            public Future<HttpClientResponse> response() {
                throw new UnsupportedOperationException();
            }
        }
        final MockReq req = new MockReq();
        class MockResp
        implements HttpClientResponse {
            MockResp() {
            }

            public HttpClientResponse resume() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse handler(Handler<Buffer> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse pause() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse fetch(long amount) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse endHandler(Handler<Void> endHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpVersion version() {
                throw new UnsupportedOperationException();
            }

            public int statusCode() {
                return status;
            }

            public String statusMessage() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                throw new UnsupportedOperationException();
            }

            public String getHeader(String headerName) {
                return headers.get(headerName);
            }

            public String getHeader(CharSequence headerName) {
                return this.getHeader(headerName.toString());
            }

            public String getTrailer(String trailerName) {
                throw new UnsupportedOperationException();
            }

            public MultiMap trailers() {
                throw new UnsupportedOperationException();
            }

            public List<String> cookies() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
                throw new UnsupportedOperationException();
            }

            public NetSocket netSocket() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest request() {
                return req;
            }

            public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
                return this;
            }

            public Future<Buffer> body() {
                throw new UnsupportedOperationException();
            }

            public Future<Void> end() {
                throw new UnsupportedOperationException();
            }
        }
        MockResp resp = new MockResp();
        Function handler = this.client.redirectHandler();
        Future redirection = (Future)handler.apply(resp);
        if (expectedAbsoluteURI != null) {
            RequestOptions expectedOptions = new RequestOptions().setAbsoluteURI(location);
            this.assertEquals(expectedOptions.getHost(), ((RequestOptions)redirection.result()).getHost());
            this.assertEquals(expectedOptions.getPort(), ((RequestOptions)redirection.result()).getPort());
            this.assertEquals(expectedOptions.getURI(), ((RequestOptions)redirection.result()).getURI());
            this.assertEquals(expectedOptions.isSsl(), ((RequestOptions)redirection.result()).isSsl());
        } else {
            this.assertTrue(redirection == null || redirection.failed() || ((RequestOptions)redirection.result()).getHost() == null);
        }
    }

    @Test
    public void testFollowRedirectEncodedParams() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        String value1 = "\ud55c\uae00";
        String value2 = "A B+C";
        String value3 = "123 \u20ac";
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/first/call/from/client": {
                    StringBuilder location = null;
                    try {
                        location = new StringBuilder().append(req.scheme()).append("://").append("localhost").append(':').append(8080).append("/redirected/from/client?").append("encoded1=").append(URLEncoder.encode(value1, "UTF-8")).append('&').append("encoded2=").append(URLEncoder.encode(value2, "UTF-8")).append('&').append("encoded3=").append(URLEncoder.encode(value3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.fail(e);
                    }
                    req.response().setStatusCode(302).putHeader("location", location.toString()).send();
                    break;
                }
                case "/redirected/from/client": {
                    this.assertEquals(value1, req.params().get("encoded1"));
                    this.assertEquals(value2, req.params().get("encoded2"));
                    this.assertEquals(value3, req.params().get("encoded3"));
                    req.response().end();
                    break;
                }
                default: {
                    this.fail("Unknown path: " + req.path());
                }
            }
        });
        this.startServer();
        this.client.request(new RequestOptions(this.requestOptions).setURI("/first/call/from/client")).onComplete(this.onSuccess(req -> {
            req.setFollowRedirects(true);
            req.send(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testEventHandlersNotHoldingLock() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpConnection conn = req.connection();
            switch (req.path()) {
                case "/0": {
                    req.handler(chunk -> this.assertFalse(Thread.holdsLock(conn)));
                    req.endHandler(v -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        req.response().end(TestUtils.randomAlphaString(256));
                    });
                    break;
                }
                case "/1": {
                    AtomicBoolean paused = new AtomicBoolean();
                    req.pause();
                    paused.set(true);
                    this.vertx.runOnContext(v -> {
                        paused.set(false);
                        req.resume();
                    });
                    req.handler(chunk -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        this.assertFalse(paused.get());
                        paused.set(true);
                        req.pause();
                        this.vertx.runOnContext(v -> {
                            paused.set(false);
                            req.resume();
                        });
                    });
                    req.endHandler(v -> {
                        this.assertFalse(Thread.holdsLock(conn));
                        this.assertFalse(paused.get());
                        req.response().end(TestUtils.randomAlphaString(256));
                    });
                }
            }
        });
        this.startServer(this.testAddress);
        for (int i = 0; i < 2; ++i) {
            Buffer body = Buffer.buffer((String)TestUtils.randomAlphaString(256));
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST).setURI("/" + i)).onComplete(this.onSuccess(req -> req.send(body, this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                HttpConnection conn = resp.request().connection();
                switch (resp.request().path()) {
                    case "/0": {
                        resp.handler(chunk -> this.assertFalse(Thread.holdsLock(conn)));
                        resp.endHandler(v -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.complete();
                        });
                        break;
                    }
                    case "/1": {
                        AtomicBoolean paused = new AtomicBoolean();
                        resp.pause();
                        paused.set(true);
                        this.vertx.runOnContext(v -> {
                            paused.set(false);
                            resp.resume();
                        });
                        resp.handler(chunk -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.assertFalse(paused.get());
                            paused.set(true);
                            resp.pause();
                            this.vertx.runOnContext(v -> {
                                paused.set(false);
                                resp.resume();
                            });
                        });
                        resp.endHandler(v -> {
                            this.assertFalse(Thread.holdsLock(conn));
                            this.assertFalse(paused.get());
                            this.complete();
                        });
                    }
                }
            }))));
        }
        this.await();
    }

    @Test
    public void testEventHandlersNotHoldingLockOnClose() throws Exception {
        this.waitFor(7);
        this.server.requestHandler(req -> {
            HttpConnection conn = req.connection();
            req.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            HttpServerResponse resp = req.response();
            resp.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            resp.closeHandler(v -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            conn.closeHandler(err -> {
                this.assertFalse(Thread.holdsLock(conn));
                this.complete();
            });
            resp.setChunked(true).write("hello");
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                HttpConnection conn = resp.request().connection();
                resp.exceptionHandler(err -> {
                    this.assertFalse(Thread.holdsLock(conn));
                    this.complete();
                });
                conn.closeHandler(v -> {
                    this.assertFalse(Thread.holdsLock(conn));
                    this.complete();
                });
                conn.close();
            }));
            req.exceptionHandler(err -> {
                this.assertFalse(Thread.holdsLock(req.connection()));
                this.complete();
            });
            req.setChunked(true).sendHead();
        }));
        this.await();
    }

    @Test
    public void testCloseHandlerWhenConnectionEnds() throws Exception {
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> this.testComplete());
            req.response().setChunked(true).write("some-data");
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.handler(v -> resp.request().connection().close())))));
        this.await();
    }

    @Test
    public void testUseResponseAfterClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> {
            Buffer buff = Buffer.buffer();
            resp.drainHandler(this.noOpHandler());
            resp.exceptionHandler(this.noOpHandler());
            resp.setChunked(false);
            resp.setWriteQueueMaxSize(123);
            resp.writeQueueFull();
            resp.putHeader("foo", "bar");
            resp.setChunked(true);
            resp.write((Object)buff);
            resp.write("foo");
            resp.write("foo", "UTF-8");
            resp.write((Object)buff, this.onFailure(err1 -> resp.write("foo", this.onFailure(err2 -> resp.write("foo", "UTF-8", this.onFailure(err3 -> resp.end(this.onFailure(err4 -> this.testComplete()))))))));
        }));
    }

    @Test
    public void testSendFileAfterServerResponseClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> {
            resp.sendFile("webroot/somefile.html");
            this.testComplete();
        }));
    }

    @Test
    public void testSendFileAsyncAfterServerResponseClose() throws Exception {
        this.testAfterServerResponseClose((Handler<HttpServerResponse>)((Handler)resp -> resp.sendFile("webroot/somefile.html", this.onFailure(err -> this.testComplete()))));
    }

    private void testAfterServerResponseClose(Handler<HttpServerResponse> test) throws Exception {
        AtomicReference clientConn = new AtomicReference();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.closeHandler(v1 -> test.handle((Object)resp));
            ((HttpConnection)clientConn.get()).close();
        });
        this.startServer(this.testAddress);
        this.client.connectionHandler(clientConn::set);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {}))));
        this.await();
    }

    @Test
    public abstract void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception;

    protected void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(int expected) throws Exception {
        AtomicInteger closeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> closeCount.incrementAndGet());
            req.response().endHandler(v -> endCount.incrementAndGet());
            req.connection().closeHandler(v -> {
                this.assertEquals(expected, closeCount.get());
                this.assertEquals(1L, endCount.get());
                this.testComplete();
            });
            req.response().end("some-data");
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> resp.request().connection().close())))));
        this.await();
    }

    private TestLoggerFactory testLogging() throws Exception {
        return TestUtils.testLogging(() -> {
            try {
                this.server.requestHandler(req -> req.response().end());
                this.startServer(this.testAddress);
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.testComplete()))));
                this.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testClientDecompressionError() throws Exception {
        this.server.requestHandler(req -> req.response().putHeader("Content-Encoding", "gzip").end("long response with mismatched encoding causes connection leaks"));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setDecompressionSupported(true));
        this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onFailure(err -> {
            if (err instanceof Http2Exception) {
                this.testComplete();
            } else if (err instanceof DecompressionException) {
                this.testComplete();
            } else {
                this.fail();
            }
        });
        this.await();
    }

    @Test
    public void testContainsValueString() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains("Foo", "foo", false));
            this.assertFalse(req.headers().contains("Foo", "fOo", false));
            req.response().putHeader("quux", "quux");
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).compose(req -> req.putHeader("foo", "foo").send()).onComplete(this.onSuccess(resp -> {
            this.assertTrue(resp.headers().contains("Quux", "quux", false));
            this.assertFalse(resp.headers().contains("Quux", "quUx", false));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testContainsValueStringIgnoreCase() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains("Foo", "foo", true));
            this.assertTrue(req.headers().contains("Foo", "fOo", true));
            req.response().putHeader("quux", "quux");
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).compose(req -> req.putHeader("foo", "foo").send()).onComplete(this.onSuccess(resp -> {
            this.assertTrue(resp.headers().contains("Quux", "quux", true));
            this.assertTrue(resp.headers().contains("Quux", "quUx", true));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testContainsValueCharSequence() {
        CharSequence Foo = HttpHeaders.createOptimized((String)"Foo");
        CharSequence foo = HttpHeaders.createOptimized((String)"foo");
        CharSequence fOo = HttpHeaders.createOptimized((String)"fOo");
        CharSequence Quux = HttpHeaders.createOptimized((String)"Quux");
        CharSequence quux = HttpHeaders.createOptimized((String)"quux");
        CharSequence quUx = HttpHeaders.createOptimized((String)"quUx");
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains(Foo, foo, false));
            this.assertFalse(req.headers().contains(Foo, fOo, false));
            req.response().putHeader(quux, quux);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).compose(req -> req.putHeader(foo, foo).send()).onComplete(this.onSuccess(resp -> {
            this.assertTrue(resp.headers().contains(Quux, quux, false));
            this.assertFalse(resp.headers().contains(Quux, quUx, false));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testContainsValueCharSequenceIgnoreCase() {
        CharSequence Foo = HttpHeaders.createOptimized((String)"Foo");
        CharSequence foo = HttpHeaders.createOptimized((String)"foo");
        CharSequence fOo = HttpHeaders.createOptimized((String)"fOo");
        CharSequence Quux = HttpHeaders.createOptimized((String)"Quux");
        CharSequence quux = HttpHeaders.createOptimized((String)"quux");
        CharSequence quUx = HttpHeaders.createOptimized((String)"quUx");
        this.server.requestHandler(req -> {
            this.assertTrue(req.headers().contains(Foo, foo, true));
            this.assertTrue(req.headers().contains(Foo, fOo, true));
            req.response().putHeader(quux, quux);
            req.response().end();
        });
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(this.requestOptions).compose(req -> req.putHeader(foo, foo).send()).onComplete(this.onSuccess(resp -> {
            this.assertTrue(resp.headers().contains(Quux, quux, true));
            this.assertTrue(resp.headers().contains(Quux, quUx, true));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testBytesReadRequest() throws Exception {
        int length = 2048;
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(length));
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(req.bytesRead(), length);
            req.response().end();
        }));
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> req.response(this.onSuccess(resp -> resp.bodyHandler(buff -> this.testComplete()))).end(expected)));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSynchronousConnectFailures() {
        System.setProperty("vertx.disableDnsResolver", "true");
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setQueryTimeout(100L)));
        try {
            int poolSize = 2;
            HttpClient client = vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(poolSize));
            AtomicInteger failures = new AtomicInteger();
            vertx.runOnContext(v -> {
                for (int i = 0; i < poolSize + 1; ++i) {
                    AtomicBoolean f = new AtomicBoolean();
                    client.request(new RequestOptions().setAbsoluteURI("http://invalid-host-name.foo.bar")).onComplete(this.onFailure(req -> {
                        if (f.compareAndSet(false, true) && failures.incrementAndGet() == poolSize + 1) {
                            this.testComplete();
                        }
                    }));
                }
            });
            this.await();
        }
        finally {
            vertx.close();
            System.setProperty("vertx.disableDnsResolver", "false");
        }
    }

    @Test
    public void testClientConnectInvalidPort() {
        try {
            this.client.request(new RequestOptions(this.requestOptions).setPort(Integer.valueOf(-1)));
        }
        catch (Exception e) {
            this.assertEquals(e.getClass(), IllegalArgumentException.class);
            this.assertEquals(e.getMessage(), "port p must be in range 0 <= p <= 65535");
        }
    }

    protected File setupFile(String fileName, String content) throws Exception {
        File file = new File(this.testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    protected static String generateQueryString(MultiMap params, char delim) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry param : params.entries()) {
            sb.append((String)param.getKey()).append("=").append((String)param.getValue());
            if (++count == params.size()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    @Test
    public void testHttpClientRequestHeadersDontContainCROrLF() throws Exception {
        this.server.requestHandler(req -> {
            req.headers().forEach(header -> {
                String name = (String)header.getKey();
                switch (name.toLowerCase()) {
                    case "host": 
                    case ":method": 
                    case ":path": 
                    case ":scheme": 
                    case ":authority": {
                        break;
                    }
                    default: {
                        this.fail("Unexpected header " + name);
                    }
                }
            });
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            BiConsumer[] biConsumerArray = new BiConsumer[3];
            biConsumerArray[0] = (arg_0, arg_1) -> ((HttpClientRequest)req).putHeader(arg_0, arg_1);
            biConsumerArray[1] = (arg_0, arg_1) -> ((MultiMap)req.headers()).set(arg_0, arg_1);
            biConsumerArray[2] = (arg_0, arg_1) -> ((MultiMap)req.headers()).add(arg_0, arg_1);
            List<BiConsumer> list = Arrays.asList(biConsumerArray);
            list.forEach(cs -> {
                try {
                    req.putHeader("header-name: header-value\r\nanother-header", "another-value");
                    this.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            this.assertEquals(0L, req.headers().size());
            req.end();
        }));
        this.await();
    }

    @Test
    public void testHttpServerResponseHeadersDontContainCROrLF() throws Exception {
        this.server.requestHandler(req -> {
            BiConsumer[] biConsumerArray = new BiConsumer[3];
            biConsumerArray[0] = (arg_0, arg_1) -> ((HttpServerResponse)req.response()).putHeader(arg_0, arg_1);
            biConsumerArray[1] = (arg_0, arg_1) -> ((MultiMap)req.response().headers()).set(arg_0, arg_1);
            biConsumerArray[2] = (arg_0, arg_1) -> ((MultiMap)req.response().headers()).add(arg_0, arg_1);
            List<BiConsumer> list = Arrays.asList(biConsumerArray);
            list.forEach(cs -> {
                try {
                    cs.accept("header-name: header-value\r\nanother-header", "another-value");
                    this.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            this.assertEquals(Collections.emptySet(), req.response().headers().names());
            req.response().end();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            resp.headers().forEach(header -> {
                String name = (String)header.getKey();
                switch (name.toLowerCase()) {
                    case "content-length": {
                        break;
                    }
                    default: {
                        this.fail("Unexpected header " + name);
                    }
                }
            });
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDisableIdleTimeoutInPool() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(1).setMaxPoolSize(1).setKeepAliveTimeout(10));
        this.client.request(this.requestOptions, this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v1 -> {
            AtomicBoolean closed = new AtomicBoolean();
            resp.request().connection().closeHandler(v2 -> closed.set(true));
            this.vertx.setTimer(2000L, id -> {
                this.assertFalse(closed.get());
                this.testComplete();
            });
        })))));
        this.await();
    }

    @Test
    public void testKeepAliveTimeout() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        HttpClientOptions options = this.createBaseClientOptions().setKeepAliveTimeout(3).setHttp2KeepAliveTimeout(3);
        this.testKeepAliveTimeout(options, 1);
    }

    protected void testKeepAliveTimeout(HttpClientOptions options, int numReqs) throws Exception {
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(options.setPoolCleanerPeriod(1));
        AtomicInteger respCount = new AtomicInteger();
        for (int i = 0; i < numReqs; ++i) {
            int current = 1 + i;
            this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
                respCount.incrementAndGet();
                if (current == numReqs) {
                    long now = System.currentTimeMillis();
                    resp.request().connection().closeHandler(v -> {
                        long timeout = System.currentTimeMillis() - now;
                        int delta = 500;
                        int low = 3000 - delta;
                        int high = 3000 + delta;
                        this.assertTrue("Expected actual close timeout " + timeout + " to be > " + low, (long)low < timeout);
                        this.assertTrue("Expected actual close timeout " + timeout + " + to be < " + high, timeout < (long)high);
                        this.testComplete();
                    });
                }
            }));
        }
        this.await();
    }

    @Test
    public void testPoolNotExpiring1() throws Exception {
        this.testPoolNotExpiring(this.createBaseClientOptions().setPoolCleanerPeriod(0).setKeepAliveTimeout(100).setHttp2KeepAliveTimeout(100));
    }

    @Test
    public void testPoolNotExpiring2() throws Exception {
        this.testPoolNotExpiring(this.createBaseClientOptions().setPoolCleanerPeriod(10).setKeepAliveTimeout(0).setHttp2KeepAliveTimeout(0));
    }

    private void testPoolNotExpiring(HttpClientOptions options) throws Exception {
        AtomicLong now = new AtomicLong();
        this.server.requestHandler(req -> {
            req.response().end();
            now.set(System.currentTimeMillis());
            this.vertx.setTimer(2000L, id -> req.connection().close());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(options);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> resp.endHandler(v1 -> resp.request().connection().closeHandler(v2 -> {
            long time = System.currentTimeMillis() - now.get();
            this.assertTrue("Was expecting " + time + " to be > 2000", time >= 2000L);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testHttpConnect() {
        this.testHttpConnect(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT), 200);
    }

    protected void testHttpConnect(RequestOptions options, int sc) {
        Buffer buffer = TestUtils.randomBuffer(128);
        Buffer received = Buffer.buffer();
        CompletableFuture closeSocket = new CompletableFuture();
        this.vertx.createNetServer(new NetServerOptions().setPort(1235).setHost("localhost")).connectHandler(socket -> {
            socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0));
            closeSocket.thenAccept(v -> socket.close());
        }).listen(this.onSuccess(netServer -> {
            this.server.requestHandler(req -> this.vertx.createNetClient(new NetClientOptions()).connect(1235, "localhost", this.onSuccess(dst -> {
                req.response().setStatusCode(sc);
                req.response().setStatusMessage("Connection established");
                req.toNetSocket().onComplete(this.onSuccess(src -> {
                    Pump pump1 = Pump.pump((ReadStream)src, (WriteStream)dst).start();
                    Pump pump2 = Pump.pump((ReadStream)dst, (WriteStream)src).start();
                    dst.closeHandler(v -> {
                        pump1.stop();
                        pump2.stop();
                        src.close();
                    });
                }));
            })));
            this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(options).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
                this.assertEquals(sc, resp.statusCode());
                NetSocket socket = resp.netSocket();
                socket.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == buffer.length()) {
                        closeSocket.complete(null);
                    }
                });
                socket.closeHandler(v -> {
                    this.assertEquals(buffer, received);
                    this.testComplete();
                });
                socket.write((Object)buffer);
            }))))));
        }));
        this.await();
    }

    @Test
    public void testNetSocketConnectSuccessClientInitiatesCloseImmediately() {
        this.testNetSocketConnectSuccess((Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("hello", received.toString());
                so.end();
                this.complete();
            });
        }), (Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("", received.toString());
                this.complete();
            });
            so.end((Object)Buffer.buffer((String)"hello"));
        }));
    }

    @Test
    public void testNetSocketConnectSuccessServerInitiatesCloseImmediately() {
        this.testNetSocketConnectSuccess((Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("", received.toString());
                this.complete();
            });
            so.end((Object)Buffer.buffer((String)"hello"));
        }), (Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("hello", received.toString());
                so.end();
                this.complete();
            });
        }));
    }

    @Test
    public void testNetSocketConnectSuccessServerInitiatesCloseOnReply() {
        this.testNetSocketConnectSuccess((Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("pong", received.toString());
                so.end();
                this.complete();
            });
            so.write((Object)Buffer.buffer((String)"ping"));
        }), (Handler<NetSocket>)((Handler)so -> {
            so.handler(buff -> {
                if (buff.toString().equals("ping")) {
                    so.end((Object)Buffer.buffer((String)"pong"));
                }
            });
            so.endHandler(v -> this.complete());
        }));
    }

    @Test
    public void testNetSocketConnectSuccessClientInitiatesCloseOnReply() {
        this.testNetSocketConnectSuccess((Handler<NetSocket>)((Handler)so -> {
            so.handler(buff -> {
                if (buff.toString().equals("ping")) {
                    so.end((Object)Buffer.buffer((String)"pong"));
                }
            });
            so.endHandler(v -> this.complete());
        }), (Handler<NetSocket>)((Handler)so -> {
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.endHandler(v -> {
                this.assertEquals("pong", received.toString());
                so.end();
                this.complete();
            });
            so.write((Object)Buffer.buffer((String)"ping"));
        }));
    }

    private void testNetSocketConnectSuccess(Handler<NetSocket> clientHandler, Handler<NetSocket> serverHandler) {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().setStatusCode(101);
            req.toNetSocket().onComplete(this.onSuccess(arg_0 -> ((Handler)serverHandler).handle(arg_0)));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> clientHandler.handle((Object)resp.netSocket())))))));
        this.await();
    }

    @Test
    public void testClientNetSocketConnectReject() {
        this.server.requestHandler(req -> req.response().setStatusCode(404).end());
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
            this.assertEquals(404L, resp.statusCode());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testClientNetSocketConnectFailure() {
        this.server.requestHandler(req -> req.connection().close());
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testAccessNetSocketPendingResponseDataPaused() {
        this.testAccessNetSocketPendingResponseData(true);
    }

    @Test
    public void testAccessNetSocketPendingResponseDataNotPaused() {
        this.testAccessNetSocketPendingResponseData(false);
    }

    private void testAccessNetSocketPendingResponseData(boolean pause) {
        this.server.requestHandler(req -> req.toNetSocket().onComplete(this.onSuccess(so -> so.write("hello"))));
        this.client.close();
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(so -> {
                this.assertNotNull(so);
                so.handler(buff -> {
                    this.assertEquals("hello", buff.toString());
                    this.testComplete();
                });
                if (pause) {
                    so.pause();
                    this.vertx.setTimer(100L, id -> so.resume());
                }
            }))));
        }));
        this.await();
    }

    @Test
    public void testServerNetSocketCloseWithHandler() {
        this.waitFor(2);
        this.server.requestHandler(req -> req.toNetSocket().onComplete(this.onSuccess(so -> so.close(this.onSuccess(v -> this.complete())))));
        this.client.close();
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
                NetSocket so = resp.netSocket();
                so.closeHandler(v -> this.complete());
            }))));
        }));
        this.await();
    }

    @Test
    public void testClientNetSocketCloseWithHandler() {
        this.waitFor(2);
        this.server.requestHandler(req -> req.toNetSocket().onComplete(this.onSuccess(so -> so.closeHandler(v -> this.complete()))));
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).onComplete(this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
            NetSocket so = resp.netSocket();
            so.close(this.onSuccess(v -> this.complete()));
        }))))));
        this.await();
    }

    @Test
    public void testHttpInvalidConnectResponseEnded() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().end();
            req.toNetSocket(this.onFailure(err -> this.complete()));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testHttpInvalidConnectResponseChunked() {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("some-chunk");
            req.toNetSocket(this.onFailure(err -> this.complete()));
        });
        this.server.listen(this.testAddress, this.onSuccess(s -> this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.CONNECT)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testUpgradeTunnelNoSwitch() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            resp.write("chunk-1").compose(v -> resp.write("chunk-2")).compose(v -> resp.end("chunk-3"));
        });
        this.startServer();
        this.client.request(HttpMethod.GET, 8080, "localhost", "/", this.onSuccess(req -> req.connect(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            ArrayList chunks = new ArrayList();
            resp.handler(chunk -> chunks.add(chunk.toString()));
            resp.endHandler(v -> {
                this.assertEquals(Arrays.asList("chunk-1", "chunk-2", "chunk-3"), chunks);
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testEndFromAnotherThread() throws Exception {
        this.waitFor(2);
        this.disableThreadChecks();
        this.server.requestHandler(req -> {
            req.response().endHandler(v -> this.complete());
            new Thread(() -> req.response().end()).start();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testServerResponseWriteSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.write((Object)TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testServerResponseEndSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.end(TestUtils.randomBuffer(1024), handler));
    }

    private void testServerResponseWriteSuccess(BiConsumer<HttpServerResponse, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            op.accept(resp, this.onSuccess(v -> this.complete()));
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.complete()))));
        this.await();
    }

    @Test
    public void testServerResponseWriteFailure() throws Exception {
        this.server.requestHandler(req -> {
            Runnable[] task;
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            Buffer chunk = TestUtils.randomBuffer(1024);
            task = new Runnable[]{() -> resp.write((Object)chunk, ar1 -> {
                if (ar1.succeeded()) {
                    task[0].run();
                } else {
                    resp.end(ar2 -> this.testComplete());
                }
            })};
            task[0].run();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.request().connection().close()))));
        this.await();
    }

    @Test
    public void testClientRequestWriteSuccess() throws Exception {
        this.testClientRequestWriteSuccess((req, handler) -> {
            req.setChunked(true);
            req.write((Object)TestUtils.randomBuffer(1024), handler);
            req.end();
        });
    }

    @Test
    public void testClientRequestEnd1Success() throws Exception {
        this.testClientRequestWriteSuccess((req, handler) -> req.end(TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testClientRequestEnd2Success() throws Exception {
        this.testClientRequestWriteSuccess(HttpClientRequest::end);
    }

    private void testClientRequestWriteSuccess(BiConsumer<HttpClientRequest, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        CompletableFuture fut = new CompletableFuture();
        this.server.requestHandler(req -> {
            fut.complete(null);
            req.endHandler(v -> {
                HttpServerResponse resp = req.response();
                if (!resp.ended()) {
                    resp.end();
                }
            });
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.complete()));
            op.accept((HttpClientRequest)req, this.onSuccess(v -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testClientRequestLazyWriteSuccess() throws Exception {
        this.testClientRequestLazyWriteSuccess((resp, handler) -> resp.write((Object)TestUtils.randomBuffer(1024), handler));
    }

    @Test
    public void testClientRequestLazyEndSuccess() throws Exception {
        this.testServerResponseWriteSuccess((resp, handler) -> resp.end(TestUtils.randomBuffer(1024), handler));
    }

    private void testClientRequestLazyWriteSuccess(BiConsumer<HttpClientRequest, Handler<AsyncResult<Void>>> op) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> this.complete())).setChunked(true);
            op.accept((HttpClientRequest)req, this.onSuccess(v -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testClientResponseWriteFailure() throws Exception {
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT)).onComplete(this.onSuccess(req -> {
            Runnable[] task;
            req.setChunked(true);
            Buffer chunk = TestUtils.randomBuffer(1024);
            task = new Runnable[]{() -> req.write((Object)chunk, ar1 -> {
                if (ar1.succeeded()) {
                    task[0].run();
                } else {
                    req.end(ar2 -> this.testComplete());
                }
            })};
            task[0].run();
        }));
        this.await();
    }

    @Test
    public void testServerRequestBodyFuture() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
        this.server.requestHandler(req -> req.body(this.onSuccess(body -> {
            this.assertEquals(expected, body);
            req.response().end();
        })));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(v -> this.testComplete()));
            req.end(expected);
        }));
        this.await();
    }

    @Test
    public void testServerRequestBodyFutureFail() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
        CompletableFuture latch = new CompletableFuture();
        this.server.requestHandler(req -> {
            req.body(this.onFailure(err -> this.testComplete()));
            latch.complete(null);
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.setChunked(true);
            latch.whenComplete((v, err) -> req.reset());
            req.write((Object)expected);
        }));
        this.await();
    }

    @Test
    public void testResetClientRequestBeforeActualSend() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.response(this.onFailure(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.complete();
        })).exceptionHandler(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.complete();
        }).reset()));
        this.await();
    }

    @Test
    public void testResetFromNonVertxThread() throws Exception {
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.exceptionHandler(err -> {
                this.assertSame(Vertx.currentContext(), ctx);
                this.testComplete();
            });
            new Thread(() -> ((HttpClientRequest)req).reset()).start();
        })));
        this.await();
    }

    @Test
    public void testResetClientRequestInProgress() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onFailure(err -> this.complete())).exceptionHandler(err -> this.complete());
            req.sendHead(version -> req.reset(0L));
        })));
        this.await();
    }

    @Test
    public void testResetClientRequestAwaitingResponse() throws Exception {
        CompletableFuture fut = new CompletableFuture();
        this.server.requestHandler(req -> fut.complete(null));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            Context ctx = Vertx.currentContext();
            req.response(this.onFailure(err -> this.complete())).exceptionHandler(err -> this.fail());
            req.end();
            fut.thenAccept(v2 -> ctx.runOnContext(v3 -> req.reset(0L)));
        }));
        this.await();
    }

    @Test
    public void testResetClientRequestResponseInProgress() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            for (int i = 0; i < 16; ++i) {
                resp.write("chunk-" + i);
            }
            resp.end();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            resp.handler(buff -> this.fail());
            resp.endHandler(v -> this.fail());
            req.connection().close(this.onSuccess(v -> this.testComplete()));
            req.reset();
        }))));
        this.await();
    }

    @Test
    public void testSimpleCookie() throws Exception {
        this.testCookies("foo=bar", req -> {
            this.assertEquals(1L, req.cookieCount());
            Cookie cookie = req.getCookie("foo");
            this.assertNotNull(cookie);
            this.assertEquals("bar", cookie.getValue());
            req.response().end();
        }, response -> {});
    }

    @Test
    public void testGetCookies() throws Exception {
        this.testCookies("foo=bar; wibble=blibble; plop=flop", req -> {
            this.assertEquals(3L, req.cookieCount());
            Map cookies = req.cookieMap();
            this.assertTrue(cookies.containsKey("foo"));
            this.assertTrue(cookies.containsKey("wibble"));
            this.assertTrue(cookies.containsKey("plop"));
            Cookie removed = req.response().removeCookie("foo");
            cookies = req.cookieMap();
            this.assertTrue(cookies.containsKey("foo"));
            this.assertTrue(cookies.containsKey("wibble"));
            this.assertTrue(cookies.containsKey("plop"));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertTrue(((String)cookies.get(0)).contains("Max-Age=0"));
            this.assertTrue(((String)cookies.get(0)).contains("Expires="));
        });
    }

    @Test
    public void testGetCookiesSameIdentity() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub").setDomain("www.vertx.io")));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(3L, cookies.size());
            this.assertTrue(cookies.contains("foo=bar; Path=/"));
            this.assertTrue(cookies.contains("foo=bar; Path=/sub"));
            this.assertTrue(cookies.contains("foo=bar; Path=/sub; Domain=www.vertx.io"));
        });
    }

    @Test
    public void testGetCookiesSameIdentityRemoveOne() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub").setDomain("www.vertx.io")));
            req.response().removeCookie("foo");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            this.assertTrue(cookies.contains("foo=bar; Path=/sub"));
            this.assertTrue(cookies.contains("foo=bar; Path=/sub; Domain=www.vertx.io"));
        });
    }

    @Test
    public void testGetCookiesSameIdentityRemoveAll() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub").setDomain("www.vertx.io")));
            req.response().removeCookies("foo");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testGetCookiesSameIdentityReplace() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar").setPath("/sub").setDomain("www.vertx.io")));
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"barista").setPath("/sub").setDomain("www.vertx.io")));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(3L, cookies.size());
            this.assertTrue(cookies.contains("foo=bar; Path=/"));
            this.assertTrue(cookies.contains("foo=bar; Path=/sub"));
            this.assertTrue(cookies.contains("foo=barista; Path=/sub; Domain=www.vertx.io"));
        });
    }

    @Test
    public void testCookiesChanged() throws Exception {
        this.testCookies("foo=bar; wibble=blibble; plop=flop", req -> {
            this.assertEquals(3L, req.cookieCount());
            this.assertEquals("bar", req.getCookie("foo").getValue());
            this.assertEquals("blibble", req.getCookie("wibble").getValue());
            this.assertEquals("flop", req.getCookie("plop").getValue());
            req.response().removeCookie("plop");
            this.assertEquals(3L, req.cookieCount());
            this.assertEquals("bar", req.getCookie("foo").getValue());
            this.assertEquals("blibble", req.getCookie("wibble").getValue());
            this.assertNotNull(req.getCookie("plop"));
            req.response().addCookie(Cookie.cookie((String)"fleeb", (String)"floob"));
            this.assertEquals(4L, req.cookieCount());
            this.assertNull(req.response().removeCookie("blarb"));
            this.assertEquals(4L, req.cookieCount());
            Cookie foo = req.getCookie("foo");
            foo.setValue("blah");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(3L, cookies.size());
            this.assertTrue(cookies.contains("foo=blah"));
            this.assertTrue(cookies.contains("fleeb=floob"));
            boolean found = false;
            for (String s : cookies) {
                if (!s.startsWith("plop")) continue;
                found = true;
                this.assertTrue(s.contains("Max-Age=0"));
                this.assertTrue(s.contains("Expires="));
                break;
            }
            this.assertTrue(found);
        });
    }

    @Test
    public void testCookieFields() throws Exception {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar");
        this.assertEquals("foo", cookie.getName());
        this.assertEquals("bar", cookie.getValue());
        this.assertEquals("foo=bar", cookie.encode());
        this.assertNull(cookie.getPath());
        cookie.setPath("/somepath");
        this.assertEquals("/somepath", cookie.getPath());
        this.assertEquals("foo=bar; Path=/somepath", cookie.encode());
        this.assertNull(cookie.getDomain());
        cookie.setDomain("foo.com");
        this.assertEquals("foo.com", cookie.getDomain());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com", cookie.encode());
        long maxAge = 1800L;
        cookie.setMaxAge(maxAge);
        this.assertEquals(maxAge, cookie.getMaxAge());
        long now = System.currentTimeMillis();
        String encoded = cookie.encode();
        int startPos = encoded.indexOf("Expires=");
        int endPos = encoded.indexOf(59, startPos);
        String expiresDate = encoded.substring(startPos + 8, endPos);
        SimpleDateFormat dtf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        dtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = dtf.parse(expiresDate);
        this.assertTrue(d.getTime() - now >= maxAge);
        cookie.setMaxAge(Long.MIN_VALUE);
        cookie.setSecure(true);
        this.assertTrue(cookie.isSecure());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure", cookie.encode());
        cookie.setHttpOnly(true);
        this.assertTrue(cookie.isHttpOnly());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure; HTTPOnly", cookie.encode());
    }

    @Test
    public void testCookieSameSiteFieldEncoding() {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar").setSameSite(CookieSameSite.LAX);
        this.assertEquals("foo", cookie.getName());
        this.assertEquals("bar", cookie.getValue());
        this.assertEquals(CookieSameSite.LAX, cookie.getSameSite());
        this.assertEquals("foo=bar; SameSite=Lax", cookie.encode());
        cookie.setSecure(true);
        this.assertEquals("foo=bar; Secure; SameSite=Lax", cookie.encode());
        cookie.setHttpOnly(true);
        this.assertEquals("foo=bar; Secure; HTTPOnly; SameSite=Lax", cookie.encode());
    }

    @Test
    public void testCookieSameSiteFieldValidation() throws Exception {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar");
        try {
            cookie.setSameSite(CookieSameSite.LAX);
            cookie.setSameSite(CookieSameSite.STRICT);
            cookie.setSameSite(CookieSameSite.NONE);
            cookie.setSameSite(null);
        }
        catch (RuntimeException e) {
            this.fail();
        }
    }

    @Test
    public void testRemoveCookies() throws Exception {
        this.testCookies("foo=bar", req -> {
            Cookie removed = req.response().removeCookie("foo");
            this.assertNotNull(removed);
            this.assertEquals("foo", removed.getName());
            this.assertEquals("", removed.getValue());
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertTrue(((String)cookies.get(0)).contains("foo="));
            this.assertTrue(((String)cookies.get(0)).contains("Max-Age=0"));
            this.assertTrue(((String)cookies.get(0)).contains("Expires="));
        });
    }

    @Test
    public void testNoCookiesRemoveCookie() throws Exception {
        this.testCookies(null, req -> {
            req.response().removeCookie("foo");
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesCookieCount() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(0L, req.cookieCount());
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesGetCookie() throws Exception {
        this.testCookies(null, req -> {
            this.assertNull(req.getCookie("foo"));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        });
    }

    @Test
    public void testNoCookiesAddCookie() throws Exception {
        this.testCookies(null, req -> {
            this.assertEquals(req.response(), req.response().addCookie(Cookie.cookie((String)"foo", (String)"bar")));
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
        });
    }

    @Test
    public void testReplaceCookie() throws Exception {
        this.testCookies("XSRF-TOKEN=c359b44aef83415", req -> {
            this.assertEquals(1L, req.cookieCount());
            req.response().addCookie(Cookie.cookie((String)"XSRF-TOKEN", (String)"88533580000c314").setPath("/"));
            Map deprecatedMap = req.cookieMap();
            this.assertFalse(((ServerCookie)deprecatedMap.get("XSRF-TOKEN")).isFromUserAgent());
            this.assertEquals("/", ((Cookie)deprecatedMap.get("XSRF-TOKEN")).getPath());
            req.response().end();
        }, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertEquals("XSRF-TOKEN=88533580000c314; Path=/", cookies.get(0));
        });
    }

    private void testCookies(String cookieHeader, Consumer<HttpServerRequest> serverChecker, Consumer<HttpClientResponse> clientChecker) throws Exception {
        this.server.requestHandler(serverChecker::accept);
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.putHeader(HttpHeaders.COOKIE.toString(), cookieHeader).send()).onComplete(this.onSuccess(resp -> {
            clientChecker.accept((HttpClientResponse)resp);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testClientRequestFutureSetHandlerFromAnotherThread() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.close();
        Context ctx = this.vertx.getOrCreateContext();
        CompletableFuture reqFut = new CompletableFuture();
        ctx.runOnContext(v -> {
            this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
                req.response(this.onSuccess(resp -> this.complete()));
                reqFut.complete(req);
            }));
        });
        HttpClientRequest req2 = (HttpClientRequest)reqFut.get(10L, TimeUnit.SECONDS);
        Future endFut = req2.end("msg");
        HttpTest.waitUntil(() -> ((Future)endFut).succeeded());
        endFut.onComplete(this.onSuccess(v -> {
            this.assertNotNull(Vertx.currentContext());
            this.assertSameEventLoop(ctx, Vertx.currentContext());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testClientRequestWithLargeBodyInSmallChunks() throws Exception {
        this.testClientRequestWithLargeBodyInSmallChunks(false, HttpClientRequest::send);
    }

    @Test
    public void testClientRequestWithLargeBodyInSmallChunksChunked() throws Exception {
        this.testClientRequestWithLargeBodyInSmallChunks(true, HttpClientRequest::send);
    }

    @Test
    public void testClientRequestWithLargeBodyInSmallChunksWithHandler() throws Exception {
        this.testClientRequestWithLargeBodyInSmallChunks(false, (req, src) -> {
            Promise p = Promise.promise();
            req.send(src, (Handler)p);
            return p.future();
        });
    }

    @Test
    public void testClientRequestWithLargeBodyInSmallChunksChunkedWithHandler() throws Exception {
        this.testClientRequestWithLargeBodyInSmallChunks(true, (req, src) -> {
            Promise p = Promise.promise();
            req.send(src, (Handler)p);
            return p.future();
        });
    }

    private void testClientRequestWithLargeBodyInSmallChunks(boolean chunked, BiFunction<HttpClientRequest, ReadStream<Buffer>, Future<HttpClientResponse>> sendFunction) throws Exception {
        StringBuilder sb = new StringBuilder();
        FakeStream<Buffer> src = new FakeStream<Buffer>();
        src.pause();
        int numChunks = 1024;
        int chunkLength = 1024;
        for (int i = 0; i < numChunks; ++i) {
            String chunk = TestUtils.randomAlphaString(chunkLength);
            sb.append(chunk);
            src.write(Buffer.buffer((String)chunk));
        }
        src.end();
        String expected = sb.toString();
        String contentLength = "" + numChunks * chunkLength;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(chunked ? null : contentLength, req.getHeader(HttpHeaders.CONTENT_LENGTH));
            this.assertEquals(chunked & req.version() != HttpVersion.HTTP_2 ? HttpHeaders.CHUNKED.toString() : null, req.getHeader(HttpHeaders.TRANSFER_ENCODING));
            req.bodyHandler(body -> {
                this.assertEquals(HttpMethod.PUT, req.method());
                this.assertEquals(Buffer.buffer((String)expected), body);
                this.complete();
                req.response().end();
            });
        });
        this.startServer();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.PUT).setPort(Integer.valueOf(8080)).setHost("localhost").setURI("some-uri");
        this.client.request(options).compose(req -> {
            if (!chunked) {
                req.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)contentLength);
            }
            return (Future)sendFunction.apply((HttpClientRequest)req, (ReadStream<Buffer>)src);
        }).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testClientRequestFlowControlDifferentEventLoops() throws Exception {
        Promise resume = Promise.promise();
        this.server.requestHandler(req -> {
            req.pause();
            req.end(v -> req.response().end());
            resume.future().onComplete(ar -> req.resume());
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        Buffer chunk = Buffer.buffer((String)TestUtils.randomAlphaString(1024));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req1 -> {
            this.assertTrue(req1.reset());
            new Thread(() -> {
                Context ctx = this.vertx.getOrCreateContext();
                this.client.request(this.requestOptions).onComplete(this.onSuccess(req2 -> {
                    this.assertSame(ctx, this.vertx.getOrCreateContext());
                    req2.setChunked(true);
                    while (!req2.writeQueueFull()) {
                        req2.write((Object)chunk);
                    }
                    resume.complete();
                    req2.drainHandler(v -> {
                        this.assertSame(ctx, this.vertx.getOrCreateContext());
                        req2.end();
                    });
                    req2.response(this.onSuccess(resp -> {
                        this.assertSame(ctx, this.vertx.getOrCreateContext());
                        resp.end(this.onSuccess(v -> {
                            this.assertSame(ctx, this.vertx.getOrCreateContext());
                            this.testComplete();
                        }));
                    }));
                }));
            }).start();
        }));
        this.await();
    }

    @Test
    public void testHAProxyProtocolIdleTimeout() throws Exception {
        HAProxy proxy = new HAProxy(this.testAddress, Buffer.buffer());
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setProxyProtocolTimeout(2L).setUseProxyProtocol(true));
        this.server.requestHandler(req -> this.fail("Should not be called"));
        this.startServer(this.testAddress);
        this.vertx.createNetClient().connect(proxy.getPort(), proxy.getHost(), res -> ((NetSocket)res.result()).closeHandler(event -> this.testComplete()));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAProxyProtocolIdleTimeoutNotHappened() throws Exception {
        this.waitFor(2);
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setProxyProtocolTimeout(100L).setProxyProtocolTimeoutUnit(TimeUnit.MILLISECONDS).setUseProxyProtocol(true));
        this.server.requestHandler(req -> {
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(HttpMethod.GET, proxy.getPort(), proxy.getHost(), "some-uri").compose(HttpClientRequest::send).onComplete(this.onSuccess(v -> this.complete()));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolVersion1TCP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion1TCP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion1TCP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion1Unknown() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        Buffer header = HAProxy.createVersion1UnknownProtocolHeader();
        this.testHAProxyProtocolAccepted(header, null, null);
    }

    @Test
    public void testHAProxyProtocolVersion2TCP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion2TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2TCP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion2TCP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2UnixSocket() throws Exception {
        SocketAddress remote = SocketAddress.domainSocketAddress((String)"/tmp/remoteSocket");
        SocketAddress local = SocketAddress.domainSocketAddress((String)"/tmp/localSocket");
        Buffer header = HAProxy.createVersion2UnixStreamProtocolHeader(remote, local);
        this.testHAProxyProtocolAccepted(header, remote, local);
    }

    @Test
    public void testHAProxyProtocolVersion2Unknown() throws Exception {
        Assume.assumeTrue((boolean)this.testAddress.isInetSocket());
        Buffer header = HAProxy.createVersion2UnknownProtocolHeader();
        this.testHAProxyProtocolAccepted(header, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHAProxyProtocolAccepted(Buffer header, SocketAddress remote, SocketAddress local) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setUseProxyProtocol(true)).requestHandler(req -> {
            this.assertAddresses(remote == null && this.testAddress.isInetSocket() ? proxy.getConnectionLocalAddress() : remote, req.remoteAddress());
            this.assertAddresses(local == null && this.testAddress.isInetSocket() ? proxy.getConnectionRemoteAddress() : local, req.localAddress());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions().setHost(proxy.getHost()).setPort(Integer.valueOf(proxy.getPort())).setURI("some-uri")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(event -> this.complete()))));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolVersion2UDP4() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion2UDP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    @Test
    public void testHAProxyProtocolVersion2UDP6() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"2001:db8:85a3:0:0:8a2e:370:7334");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion2UDP6ProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    @Test
    public void testHAProxyProtocolVersion2UnixDataGram() throws Exception {
        SocketAddress remote = SocketAddress.domainSocketAddress((String)"/tmp/remoteSocket");
        SocketAddress local = SocketAddress.domainSocketAddress((String)"/tmp/localSocket");
        Buffer header = HAProxy.createVersion2UnixDatagramProtocolHeader(remote, local);
        this.testHAProxyProtocolRejected(header);
    }

    private void testHAProxyProtocolRejected(Buffer header) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setUseProxyProtocol(true)).exceptionHandler(ex -> {
            if (ex.equals(HAProxyMessageCompletionHandler.UNSUPPORTED_PROTOCOL_EXCEPTION)) {
                this.complete();
            }
        }).requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions().setPort(Integer.valueOf(proxy.getPort())).setHost(proxy.getHost()).setURI("some-uri")).compose(HttpClientRequest::send).onComplete(this.onFailure(req -> this.complete()));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testHAProxyProtocolEmptyHeader() throws Exception {
        this.testHAProxyProtocolIllegal(Buffer.buffer());
    }

    @Test
    public void testHAProxyProtocolIllegalHeader() throws Exception {
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"2001:db8:85a3:0:0:8a2e:370:7333");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        this.testHAProxyProtocolIllegal(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientClose() throws Exception {
        AtomicInteger inflight = new AtomicInteger();
        int num = 3;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        try {
            for (int i = 0; i < num; ++i) {
                HttpServer server = this.vertx.createHttpServer(this.createBaseServerOptions());
                server.requestHandler(req -> {});
                this.startServer(SocketAddress.inetSocketAddress((int)(8080 + i), (String)"localhost"), server);
                servers.add(server);
            }
            HttpClient client = this.vertx.createHttpClient(this.createBaseClientOptions());
            client.connectionHandler(conn -> {
                inflight.incrementAndGet();
                conn.closeHandler(v -> inflight.decrementAndGet());
            });
            for (int i = 0; i < num; ++i) {
                client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(8080 + i))).onComplete(this.onSuccess(HttpClientRequest::send));
            }
            HttpTest.assertWaitUntil(() -> inflight.get() == num);
            CountDownLatch latch = new CountDownLatch(1);
            client.close(this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
            HttpTest.assertWaitUntil(() -> inflight.get() == 0);
        }
        finally {
            servers.forEach(HttpServer::close);
        }
    }

    private void testHAProxyProtocolIllegal(Buffer header) throws Exception {
        this.waitFor(2);
        HAProxy proxy = new HAProxy(this.testAddress, header);
        proxy.start(this.vertx);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setUseProxyProtocol(true)).exceptionHandler(ex -> {
            if (ex instanceof HAProxyProtocolException) {
                this.complete();
            }
        }).requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions().setPort(Integer.valueOf(proxy.getPort())).setHost(proxy.getHost()).setURI("some-uri")).compose(HttpClientRequest::send).onComplete(this.onFailure(ex -> this.complete()));
        this.await();
        proxy.stop();
    }

    private void assertAddresses(SocketAddress address1, SocketAddress address2) {
        if (address1 == null || address2 == null) {
            this.assertEquals(address1, address2);
        } else {
            this.assertEquals(address1.hostAddress(), address2.hostAddress());
            this.assertEquals(address1.port(), address2.port());
        }
    }

    @Test
    public void testStickyContext() throws Exception {
        HashSet contexts = new HashSet();
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        int numReq = 3;
        CountDownLatch latch = new CountDownLatch(numReq);
        for (int i = 0; i < numReq; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                contexts.add(Vertx.currentContext());
                latch.countDown();
            }))));
        }
        this.awaitLatch(latch);
        this.assertEquals(1L, contexts.size());
    }

    @Test
    public void testRetrySameHostOnCallbackFailure() {
        this.client.request(this.requestOptions).onComplete(this.onFailure(req1 -> this.client.request(this.requestOptions).onComplete(this.onFailure(req2 -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testHttpServerEndHandlerSuccess() throws Exception {
        this.server.requestHandler(req -> req.end(this.onSuccess(v -> req.response().end())));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().map(resp -> resp.statusCode())).onComplete(this.onSuccess(sc -> {
            this.assertEquals(200L, sc.intValue());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHttpServerEndHandlerError() throws Exception {
        Promise promise = Promise.promise();
        this.server.requestHandler(req -> {
            promise.complete();
            req.end(this.onFailure(err -> this.testComplete()));
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.PUT), this.onSuccess(req -> {
            req.setChunked(true).sendHead();
            promise.future().onSuccess(v -> req.connection().close());
        }));
        this.await();
    }

    @Test
    public void testHttpClientEndHandlerSuccess() throws Exception {
        this.server.requestHandler(req -> req.response().end("hello"));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().compose(HttpClientResponse::end)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testHttpClientEndHandlerFailure() throws Exception {
        Promise promise = Promise.promise();
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("hello");
            promise.future().onSuccess(v -> req.connection().close());
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> {
            promise.complete();
            return resp.end();
        })).onComplete(this.onFailure(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testServerResponseSend() throws Exception {
        this.testServerResponseSend(false);
    }

    protected void testServerResponseSend(boolean chunked) throws Exception {
        int num = 16;
        ArrayList<Buffer> chunks = new ArrayList<Buffer>();
        Buffer expected = Buffer.buffer();
        for (int i = 0; i < num; ++i) {
            Buffer chunk = Buffer.buffer((String)("chunk-" + i));
            chunks.add(chunk);
            expected.appendBuffer(chunk);
        }
        String contentLength = "" + expected.length();
        this.server.requestHandler(req -> {
            FakeStream stream = new FakeStream();
            stream.pause();
            stream.emit(chunks.stream());
            stream.end();
            HttpServerResponse resp = req.response();
            if (!chunked) {
                resp.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)contentLength);
            }
            resp.send(stream);
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> {
            if (!chunked) {
                this.assertEquals(contentLength, resp.getHeader(HttpHeaders.CONTENT_LENGTH));
            }
            ArrayList list = new ArrayList();
            resp.handler(buff -> {
                if (buff.length() > 0) {
                    list.add(buff);
                }
            });
            return resp.end().map(list);
        })).onComplete(this.onSuccess(list -> {
            if (chunked) {
                this.assertEquals(num, list.size());
            }
            Buffer result = Buffer.buffer();
            list.forEach(arg_0 -> ((Buffer)result).appendBuffer(arg_0));
            this.assertEquals(expected, result);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testConnectTimeout() {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setConnectTimeout(1));
        this.client.request(new RequestOptions().setHost("10.0.0.0").setPort(Integer.valueOf(8080))).onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof ConnectTimeoutException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResponseEndFutureCompletes_WithoutBody() throws Exception {
        this.testResponseEndFutureCompletes(HttpServerResponse::end);
    }

    @Test
    public void testResponseEndFutureCompletes_WithBody() throws Exception {
        this.testResponseEndFutureCompletes(httpServerResponse -> httpServerResponse.end("hello"));
    }

    @Test
    public void testResponseEndFutureCompletes_ChunkedWithoutBody() throws Exception {
        this.testResponseEndFutureCompletes(httpServerResponse -> httpServerResponse.setChunked(true).write("hello").compose(nothing -> httpServerResponse.end()));
    }

    @Test
    public void testResponseEndFutureCompletes_ChunkedWithBody() throws Exception {
        this.testResponseEndFutureCompletes(httpServerResponse -> httpServerResponse.setChunked(true).write("hello").compose(nothing -> httpServerResponse.end("world")));
    }

    private void testResponseEndFutureCompletes(Function<HttpServerResponse, Future<Void>> function) throws Exception {
        this.waitFor(2);
        this.server.requestHandler(httpServerRequest -> ((Future)function.apply(httpServerRequest.response())).onComplete(this.onSuccess(nothing -> this.complete())));
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::end).onComplete(this.onSuccess(nothing -> this.complete()));
        this.await();
    }

    @Test
    public void shouldThrowISEIfSendingResponseFromHeadersEndHandler() throws Exception {
        AtomicBoolean flag = new AtomicBoolean();
        this.waitFor(3);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.headersEndHandler(v -> {
                if (flag.compareAndSet(false, true)) {
                    try {
                        resp.end("bar");
                    }
                    catch (IllegalStateException e) {
                        this.complete();
                    }
                }
            });
            resp.end("foo");
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().andThen(this.onSuccess(resp -> this.assertEquals(200L, resp.statusCode()))).compose(HttpClientResponse::end)).onComplete(this.onSuccess(nothing -> this.complete()));
        this.await();
    }

    @Test
    public void testInvalidPort() {
        try {
            this.server.requestHandler(req -> {}).listen(65536);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        this.waitFor(1);
        AtomicReference received = new AtomicReference();
        this.server.requestHandler(req -> req.body().onSuccess(buffer -> {
            received.set(buffer.toString());
            req.response().end();
        }));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).compose(req -> req.setChunked(true).sendHead().compose(v -> {
            AtomicBoolean latch = new AtomicBoolean(false);
            new Thread(() -> {
                req.write("msg1");
                latch.set(true);
            }).start();
            while (!latch.get()) {
            }
            req.write("msg2");
            req.end();
            return req.response();
        })).onComplete(this.onSuccess(resp -> this.complete()));
        this.await();
        this.assertEquals("msg1msg2", received.get());
    }
}

