/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.core.http.impl.HttpUtils;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=2)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class ContentLengthToString {
    @Param(value={"255", "511", "1023"})
    public int maxContentLength;
    private int[] contentLengthIndexes;
    private long inputSequence;

    @Setup
    public void init(Blackhole bh, BenchmarkParams params) {
        int MAX_CONTENT_LENGTH_SIZE = 1024;
        if (this.maxContentLength >= 1024) {
            throw new IllegalArgumentException("maxContentLength must be < 1024");
        }
        this.contentLengthIndexes = new int[131072];
        if (Integer.bitCount(this.contentLengthIndexes.length) != 1) {
            throw new IllegalArgumentException("contentLengthIndexes must be a power of 2");
        }
        Random rnd = new Random(42L);
        for (int i = 0; i < this.contentLengthIndexes.length; ++i) {
            this.contentLengthIndexes[i] = rnd.nextInt(this.maxContentLength);
        }
    }

    private long nextContentLength() {
        int[] contentLengthIndexes = this.contentLengthIndexes;
        int nextInputIndex = (int)this.inputSequence & contentLengthIndexes.length - 1;
        int contentLength = contentLengthIndexes[nextInputIndex];
        ++this.inputSequence;
        return contentLength;
    }

    @Benchmark
    public String contentLengthToString() {
        return String.valueOf(this.nextContentLength());
    }

    @Benchmark
    public String contentLengthHttpUtils() {
        return HttpUtils.positiveLongToString((long)this.nextContentLength());
    }
}

