/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Test;

public class FutureAwaitTest
extends VertxTestBase {
    @Test
    public void testAwaitFromEventLoopThread() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ctx.nettyEventLoop().execute(() -> {
            try {
                Future.await((Future)future);
            }
            catch (IllegalStateException expected) {
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testAwaitFromNonVertxThread() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        Thread current = Thread.currentThread();
        new Thread(() -> {
            while (current.getState() != Thread.State.WAITING) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            promise.complete((Object)"the-result");
        }).start();
        String res = (String)Future.await((Future)future);
        this.assertEquals("the-result", res);
    }

    @Test
    public void testAwaitWithTimeout() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        long now = System.currentTimeMillis();
        try {
            Future.await((Future)future, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.assertTrue(System.currentTimeMillis() - now >= 100L);
    }
}

