/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.core.file.ZipFileResolverTest;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.junit.Assert;

public class CustomJarFileResolverTest
extends FileResolverTestBase {
    static File getFiles(File baseDir) throws Exception {
        File file = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "files.custom", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)file.delete());
        return ZipFileResolverTest.getFiles(baseDir, file, out -> {
            try {
                return new JarOutputStream((OutputStream)out);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }, JarEntry::new);
    }

    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        final File files = CustomJarFileResolverTest.getFiles(baseDir);
        return new ClassLoader(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public URL getResource(final String name) {
                try (JarFile jf = new JarFile(files);){
                    if (jf.getJarEntry(name) != null) return new URL("jar", "null", -1, "custom:/whatever!/" + name, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new JarURLConnection(new URL("jar:file:/whatever!/" + name)){

                                @Override
                                public JarFile getJarFile() throws IOException {
                                    return new JarFile(files);
                                }

                                @Override
                                public int getContentLength() {
                                    try {
                                        return (int)this.getJarFile().getJarEntry(name).getSize();
                                    }
                                    catch (IOException e) {
                                        return -1;
                                    }
                                }

                                @Override
                                public void connect() throws IOException {
                                }
                            };
                        }
                    });
                    URL uRL = super.getResource(name);
                    return uRL;
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }
}

