/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.metrics;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.metrics.Measured;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakemetrics.EndpointMetric;
import io.vertx.test.fakemetrics.FakeDatagramSocketMetrics;
import io.vertx.test.fakemetrics.FakeEventBusMetrics;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import io.vertx.test.fakemetrics.HandlerMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.PacketMetric;
import io.vertx.test.fakemetrics.ReceivedMessage;
import io.vertx.test.fakemetrics.SentMessage;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hamcrest.core.Is;
import org.junit.Test;

public class MetricsTest
extends VertxTestBase {
    private static final String ADDRESS1 = "some-address1";
    private HttpServer server;
    private HttpClient client;

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
        FakeMetricsBase.sanityCheck();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory()));
        return options;
    }

    @Test
    public void testSendMessage() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, false, new SentMessage(ADDRESS1, false, true, false));
    }

    @Test
    public void testSendMessageInCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, false, new SentMessage(ADDRESS1, false, false, true));
    }

    @Test
    public void testPublishMessageToSelf() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, true, new SentMessage(ADDRESS1, true, true, false));
    }

    @Test
    public void testPublishMessageToRemote() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, true, new SentMessage(ADDRESS1, true, false, true));
    }

    @Test
    public void testPublishMessageToCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], this.vertices, true, new SentMessage(ADDRESS1, true, false, true), new SentMessage(ADDRESS1, true, true, false));
    }

    private void testBroadcastMessage(Vertx from, Vertx[] to, boolean publish, SentMessage ... expected) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        AtomicInteger broadcastCount = new AtomicInteger();
        AtomicInteger receiveCount = new AtomicInteger();
        for (Vertx vertx : to) {
            MessageConsumer consumer = vertx.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(this.onSuccess(v -> {
                if (broadcastCount.incrementAndGet() == to.length) {
                    String msg = TestUtils.randomAlphaString(10);
                    if (publish) {
                        from.eventBus().publish(ADDRESS1, (Object)msg);
                    } else {
                        from.eventBus().send(ADDRESS1, (Object)msg);
                    }
                }
            }));
            consumer.handler(msg -> {
                if (receiveCount.incrementAndGet() == to.length) {
                    this.testComplete();
                }
            });
        }
        MetricsTest.waitUntil(() -> eventBusMetrics.getSentMessages().size() == expected.length);
        this.assertEquals(new HashSet<SentMessage>(Arrays.asList(expected)), new HashSet<SentMessage>(eventBusMetrics.getSentMessages()));
        this.await();
    }

    @Test
    public void testReceiveSentMessageFromSelf() {
        this.testReceiveMessageSent(this.vertx, this.vertx, true, 1);
    }

    @Test
    public void testReceiveMessageSentFromRemote() {
        this.startNodes(2);
        this.testReceiveMessageSent(this.vertices[0], this.vertices[1], false, 1);
    }

    private void testReceiveMessageSent(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.completionHandler(done -> {
            this.assertTrue(done.succeeded());
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().send(ADDRESS1, (Object)msg);
        });
        consumer.handler(msg -> {
            this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, false, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReceivePublishedMessageFromSelf() {
        this.testReceiveMessagePublished(this.vertx, this.vertx, true, 3);
    }

    @Test
    public void testReceiveMessagePublishedFromRemote() {
        this.startNodes(2);
        this.testReceiveMessagePublished(this.vertices[0], this.vertices[1], false, 3);
    }

    private void testReceiveMessagePublished(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        AtomicInteger count = new AtomicInteger();
        int i = 0;
        while (i < expectedHandlers) {
            MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(done -> {
                this.assertTrue(done.succeeded());
                if (count.incrementAndGet() == expectedHandlers) {
                    String msg = TestUtils.randomAlphaString(10);
                    from.eventBus().publish(ADDRESS1, (Object)msg);
                }
            });
            int index = i++;
            consumer.handler(msg -> {
                if (index == 0) {
                    this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, true, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Test
    public void testReplyMessageFromSelf() throws Exception {
        this.testReply(this.vertx, this.vertx, true, false);
    }

    @Test
    public void testReplyMessageFromRemote() throws Exception {
        this.startNodes(2);
        this.testReply(this.vertices[0], this.vertices[1], false, true);
    }

    private void testReply(Vertx from, Vertx to, boolean expectedLocal, boolean expectedRemote) throws Exception {
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(this.onSuccess(v -> {
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().request(ADDRESS1, (Object)msg, reply -> latch.countDown());
        }));
        consumer.handler(msg -> {
            toMetrics.getReceivedMessages().clear();
            toMetrics.getSentMessages().clear();
            msg.reply((Object)TestUtils.randomAlphaString(10));
        });
        this.awaitLatch(latch);
        MetricsTest.assertWaitUntil(() -> fromMetrics.getReceivedMessages().size() > 0);
        ReceivedMessage receivedMessage = fromMetrics.getReceivedMessages().get(0);
        this.assertEquals(false, receivedMessage.publish);
        this.assertEquals(expectedLocal, receivedMessage.local);
        this.assertEquals(1L, receivedMessage.handlers);
        MetricsTest.assertWaitUntil(() -> toMetrics.getSentMessages().size() > 0);
        SentMessage sentMessage = toMetrics.getSentMessages().get(0);
        this.assertEquals(false, sentMessage.publish);
        this.assertEquals(expectedLocal, sentMessage.local);
        this.assertEquals(expectedRemote, sentMessage.remote);
        this.assertEquals(sentMessage.address, receivedMessage.address);
    }

    @Test
    public void testDiscardOnOverflow1() {
        this.startNodes(2);
        Vertx from = this.vertices[0];
        Vertx to = this.vertices[1];
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        int num = 10;
        consumer.setMaxBufferedMessages(num);
        consumer.pause();
        consumer.completionHandler(this.onSuccess(v -> {
            for (int i = 0; i < num; ++i) {
                from.eventBus().send(ADDRESS1, (Object)("" + i));
            }
            from.eventBus().send(ADDRESS1, (Object)"last");
        }));
        consumer.handler(msg -> this.fail());
        MetricsTest.waitUntil(() -> toMetrics.getRegistrations().size() == 1);
        HandlerMetric metric = toMetrics.getRegistrations().get(0);
        MetricsTest.waitUntil(() -> metric.scheduleCount.get() == num + 1);
        MetricsTest.waitUntil(() -> metric.discardCount.get() == 1);
    }

    @Test
    public void testDiscardOnOverflow2() {
        this.startNodes(2);
        Vertx from = this.vertices[0];
        Vertx to = this.vertices[1];
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        int num = 10;
        consumer.setMaxBufferedMessages(num);
        consumer.pause();
        consumer.completionHandler(this.onSuccess(v -> {
            for (int i = 0; i < num; ++i) {
                from.eventBus().send(ADDRESS1, (Object)("" + i));
            }
        }));
        consumer.handler(msg -> this.fail());
        MetricsTest.waitUntil(() -> toMetrics.getRegistrations().size() == 1);
        HandlerMetric metric = toMetrics.getRegistrations().get(0);
        MetricsTest.waitUntil(() -> metric.scheduleCount.get() == num);
        consumer.setMaxBufferedMessages(num - 1);
        MetricsTest.waitUntil(() -> metric.discardCount.get() == 1);
    }

    @Test
    public void testDiscardMessageOnUnregistration() {
        this.startNodes(2);
        Vertx from = this.vertices[0];
        Vertx to = this.vertices[1];
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.pause();
        consumer.completionHandler(this.onSuccess(v -> from.eventBus().send(ADDRESS1, (Object)"last")));
        consumer.handler(msg -> this.fail());
        MetricsTest.waitUntil(() -> toMetrics.getRegistrations().size() == 1);
        HandlerMetric metric = toMetrics.getRegistrations().get(0);
        MetricsTest.waitUntil(() -> metric.scheduleCount.get() == 1);
        consumer.unregister();
        MetricsTest.waitUntil(() -> metric.discardCount.get() == 1);
    }

    @Test
    public void testSignalMetricEventAfterUnregistration() {
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        int nums = 1000;
        ArrayList<HandlerMetric> metrics = new ArrayList<HandlerMetric>();
        for (int i = 0; i < nums; ++i) {
            String addr = "some-address1-" + i;
            MessageConsumer consumer = this.vertx.eventBus().consumer(addr);
            consumer.handler(msg -> {});
            HandlerMetric metric = toMetrics.getRegistrations().stream().filter(m -> m.address.equals(addr)).findFirst().get();
            metrics.add(metric);
            this.vertx.eventBus().send(addr, (Object)"the-msg");
            consumer.unregister();
        }
        MetricsTest.assertWaitUntil(() -> metrics.stream().noneMatch(metric -> metric.discardCount.get() == 0 && metric.localDeliveredCount.get() == 0));
    }

    @Test
    public void testHandlerRegistration() throws Exception {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        MessageConsumer consumer = this.vertx.eventBus().consumer(ADDRESS1, msg -> {});
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(1L, metrics.getRegistrations().size());
        HandlerMetric registration = metrics.getRegistrations().get(0);
        this.assertEquals(ADDRESS1, registration.address);
        this.assertEquals(null, registration.repliedAddress);
        consumer.unregister(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, metrics.getRegistrations().size());
            consumer.unregister(ar2 -> this.testComplete());
        });
        this.await();
    }

    @Test
    public void testClusterUnregistration() {
        this.startNodes(1);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[0].eventBus());
        Context ctx = this.vertices[0].getOrCreateContext();
        ctx.runOnContext(v1 -> {
            MessageConsumer consumer = this.vertices[0].eventBus().consumer(ADDRESS1, ar -> this.fail("Should not receive message"));
            consumer.completionHandler(this.onSuccess(v2 -> consumer.unregister(this.onSuccess(v3 -> {
                this.assertSame(Vertx.currentContext(), ctx);
                List<HandlerMetric> registrations = metrics.getRegistrations();
                this.assertEquals(Collections.emptyList(), registrations);
                this.testComplete();
            }))));
        });
        this.await();
    }

    @Test
    public void testHandlerProcessMessage() {
        this.testHandlerProcessMessage(this.vertx, this.vertx, 1);
    }

    @Test
    public void testHandlerProcessMessageFromRemote() {
        this.startNodes(2);
        this.testHandlerProcessMessage(this.vertices[0], this.vertices[1], 0);
    }

    private HandlerMetric assertRegistration(FakeEventBusMetrics metrics) {
        Optional<HandlerMetric> registration = metrics.getRegistrations().stream().filter(reg -> reg.address.equals(ADDRESS1)).findFirst();
        this.assertTrue(registration.isPresent());
        return registration.get();
    }

    private void testHandlerProcessMessage(Vertx from, Vertx to, int expectedLocalCount) {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        CountDownLatch latch1 = new CountDownLatch(1);
        to.runOnContext(v -> to.eventBus().consumer(ADDRESS1, msg -> {
            HandlerMetric registration = this.assertRegistration(metrics);
            this.assertEquals(ADDRESS1, registration.address);
            this.assertEquals(null, registration.repliedAddress);
            this.assertEquals(1L, registration.scheduleCount.get());
            this.assertEquals(expectedLocalCount, registration.localScheduleCount.get());
            this.assertEquals(1L, registration.deliveredCount.get());
            msg.reply((Object)"pong");
        }).completionHandler(this.onSuccess(v2 -> to.runOnContext(v3 -> latch1.countDown()))));
        try {
            this.awaitLatch(latch1);
        }
        catch (InterruptedException e) {
            this.fail(e);
            return;
        }
        HandlerMetric registration = this.assertRegistration(metrics);
        this.assertEquals(ADDRESS1, registration.address);
        this.assertEquals(null, registration.repliedAddress);
        from.eventBus().request(ADDRESS1, (Object)"ping", reply -> {
            this.assertEquals(1L, registration.scheduleCount.get());
            MetricsTest.assertWaitUntil(() -> 1 == registration.deliveredCount.get());
            this.assertEquals(expectedLocalCount, registration.localDeliveredCount.get());
            this.testComplete();
        });
        MetricsTest.assertWaitUntil(() -> registration.scheduleCount.get() == 1);
        this.await();
        this.assertEquals(expectedLocalCount, registration.localDeliveredCount.get());
    }

    @Test
    public void testHandlerMetricReply() throws Exception {
        AtomicReference replyRegistration = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        this.vertx.eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
            MetricsTest.assertWaitUntil(() -> metrics.getRegistrations().size() == 2);
            HandlerMetric registration = metrics.getRegistrations().get(1);
            this.assertEquals(ADDRESS1, registration.repliedAddress);
            this.assertEquals(0L, registration.scheduleCount.get());
            this.assertEquals(0L, registration.deliveredCount.get());
            this.assertEquals(0L, registration.localDeliveredCount.get());
            replyRegistration.set(registration);
            msg.reply((Object)"pong");
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.vertx.eventBus().request(ADDRESS1, (Object)"ping", reply -> {
            this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
            HandlerMetric registration = (HandlerMetric)replyRegistration.get();
            this.assertEquals(ADDRESS1, registration.repliedAddress);
            this.assertEquals(1L, registration.scheduleCount.get());
            this.assertEquals(1L, registration.deliveredCount.get());
            this.assertEquals(1L, registration.localDeliveredCount.get());
            this.vertx.runOnContext(v -> {
                this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
                this.assertEquals(ADDRESS1, registration.repliedAddress);
                this.assertEquals(1L, registration.scheduleCount.get());
                this.assertEquals(1L, registration.deliveredCount.get());
                this.assertEquals(1L, registration.localDeliveredCount.get());
            });
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBytesCodec() throws Exception {
        this.startNodes(2);
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[0].eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[1].eventBus());
        this.vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            int encoded = fromMetrics.getEncodedBytes(ADDRESS1);
            int decoded = toMetrics.getDecodedBytes(ADDRESS1);
            this.assertTrue("Expected to have more " + encoded + " > 1000 encoded bytes", encoded > 1000);
            this.assertTrue("Expected to have more " + decoded + " > 1000 decoded bytes", decoded > 1000);
            this.testComplete();
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, fromMetrics.getEncodedBytes(ADDRESS1));
            this.assertEquals(0L, toMetrics.getDecodedBytes(ADDRESS1));
            this.vertices[0].eventBus().send(ADDRESS1, (Object)Buffer.buffer((byte[])new byte[1000]));
        });
        this.await();
    }

    @Test
    public void testReplyFailureNoHandlers() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        eb.request(ADDRESS1, (Object)"bar", ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        this.assertEquals(Collections.singletonList(ADDRESS1), metrics.getReplyFailureAddresses());
        this.assertEquals(Collections.singletonList(ReplyFailure.NO_HANDLERS), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureTimeout1() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        eb.consumer(ADDRESS1, msg -> {});
        eb.request(ADDRESS1, (Object)"bar", new DeliveryOptions().setSendTimeout(10L), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        MetricsTest.waitUntil(() -> metrics.getReplyFailureAddresses().size() == 1, 11000L);
        this.assertEquals(Collections.singletonList(ReplyFailure.TIMEOUT), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureTimeout2() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        eb.consumer(ADDRESS1, msg -> msg.replyAndRequest((Object)"juu", new DeliveryOptions().setSendTimeout(10L), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        }));
        eb.request(ADDRESS1, (Object)"bar", ar -> {});
        this.awaitLatch(latch);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        MetricsTest.waitUntil(() -> metrics.getReplyFailureAddresses().size() == 1);
        this.assertEquals(Collections.singletonList(ReplyFailure.TIMEOUT), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureRecipientFailure() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        AtomicReference replyAddress = new AtomicReference();
        CountDownLatch regLatch = new CountDownLatch(1);
        eb.consumer("foo", msg -> {
            replyAddress.set(msg.replyAddress());
            msg.fail(0, "whatever");
        }).completionHandler(this.onSuccess(v -> regLatch.countDown()));
        this.awaitLatch(regLatch);
        eb.request("foo", (Object)"bar", new DeliveryOptions(), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        MetricsTest.assertWaitUntil(() -> metrics.getReplyFailureAddresses().equals(Collections.singletonList("foo")));
        this.assertEquals(Collections.singletonList(ReplyFailure.RECIPIENT_FAILURE), metrics.getReplyFailures());
    }

    @Test
    public void testServerWebSocket() {
        this.server = this.vertx.createHttpServer();
        this.server.webSocketHandler(ws -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            WebSocketMetric metric = metrics.getWebSocketMetric((ServerWebSocket)ws);
            this.assertNotNull(metric);
            ws.handler(arg_0 -> ((ServerWebSocket)ws).write(arg_0));
            ws.closeHandler(closed -> {
                this.assertNull(metrics.getWebSocketMetric((ServerWebSocket)ws));
                this.testComplete();
            });
        });
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/", this.onSuccess(ws -> {
                ws.write((Object)Buffer.buffer((String)"wibble"));
                ws.handler(buff -> ws.close());
            }));
        });
        this.await();
    }

    @Test
    public void testServerWebSocketUpgrade() {
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            this.assertNotNull(metrics.getRequestMetric((HttpServerRequest)req));
            req.toWebSocket().onComplete(this.onSuccess(ws -> {
                this.assertNull(metrics.getRequestMetric((HttpServerRequest)req));
                WebSocketMetric metric = metrics.getWebSocketMetric((ServerWebSocket)ws);
                this.assertNotNull(metric);
                ws.handler(arg_0 -> ((ServerWebSocket)ws).write(arg_0));
                ws.closeHandler(closed -> {
                    WebSocketMetric a = metrics.getWebSocketMetric((ServerWebSocket)ws);
                    this.assertNull(a);
                    this.testComplete();
                });
            }));
        });
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/" + TestUtils.randomAlphaString(16), this.onSuccess(ws -> {
                ws.write((Object)Buffer.buffer((String)"wibble"));
                ws.handler(buff -> ws.close());
            }));
        });
        this.await();
    }

    @Test
    public void testWebSocket() {
        this.server = this.vertx.createHttpServer();
        this.server.webSocketHandler(ws -> {
            ws.write((Object)Buffer.buffer((String)"wibble"));
            ws.handler(buff -> ws.close());
        });
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.client = this.vertx.createHttpClient();
            this.client.webSocket(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/", this.onSuccess(ws -> {
                FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
                WebSocketMetric metric = metrics.getMetric((WebSocket)ws);
                this.assertNotNull(metric);
                ws.closeHandler(closed -> {
                    this.assertNull(metrics.getMetric((WebSocket)ws));
                    this.testComplete();
                });
                ws.handler(arg_0 -> ((WebSocket)ws).write(arg_0));
            }));
        });
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpClientName() throws Exception {
        try (HttpClient client1 = this.vertx.createHttpClient();){
            FakeHttpClientMetrics metrics1 = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client1);
            this.assertEquals("", metrics1.getName());
            String name = TestUtils.randomAlphaString(10);
            try (HttpClient client2 = this.vertx.createHttpClient(new HttpClientOptions().setMetricsName(name));){
                FakeHttpClientMetrics metrics2 = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client2);
                this.assertEquals(name, metrics2.getName());
            }
        }
    }

    @Test
    public void testHttpClientMetricsQueueLength() throws Exception {
        int i;
        this.server = this.vertx.createHttpServer();
        List requests = Collections.synchronizedList(new ArrayList());
        this.server.requestHandler(req -> requests.add(() -> this.vertx.runOnContext(v -> req.response().end())));
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAliveTimeout(1));
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)this.client);
        CountDownLatch responsesLatch = new CountDownLatch(5);
        for (i = 0; i < 5; ++i) {
            this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/somepath").compose(HttpClientRequest::send).onComplete(resp -> responsesLatch.countDown());
        }
        MetricsTest.assertWaitUntil(() -> requests.size() == 5);
        this.assertEquals(Collections.singleton("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT), metrics.endpoints());
        this.assertEquals(0L, metrics.queueSize("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        for (i = 0; i < 8; ++i) {
            this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/somepath").compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {}));
        }
        this.assertEquals(Collections.singleton("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT), metrics.endpoints());
        this.assertEquals(8L, metrics.queueSize("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        ArrayList<Runnable> copy = new ArrayList<Runnable>(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        this.awaitLatch(responsesLatch);
        MetricsTest.assertWaitUntil(() -> requests.size() == 5);
        this.assertEquals(Collections.singleton("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT), metrics.endpoints());
        this.assertEquals(3L, metrics.queueSize("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        copy = new ArrayList(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        MetricsTest.assertWaitUntil(() -> requests.size() == 3);
        this.assertEquals(Collections.singleton("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT), metrics.endpoints());
        this.assertEquals(0L, metrics.queueSize("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT).intValue());
        MetricsTest.assertWaitUntil(() -> metrics.connectionCount("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT) == 3);
        copy = new ArrayList(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        MetricsTest.assertWaitUntil(() -> metrics.connectionCount("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT) == null);
    }

    @Test
    public void testHttpClientMetricsQueueClose() throws Exception {
        this.server = this.vertx.createHttpServer();
        List requests = Collections.synchronizedList(new ArrayList());
        this.server.requestHandler(req -> requests.add(() -> this.vertx.runOnContext(v -> req.connection().close())));
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client = this.vertx.createHttpClient();
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)this.client);
        for (int i = 0; i < 5; ++i) {
            this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/somepath").compose(HttpClientRequest::end).onComplete(this.onSuccess(v -> {}));
        }
        MetricsTest.assertWaitUntil(() -> requests.size() == 5);
        EndpointMetric endpoint = metrics.endpoint("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT);
        this.assertEquals(5L, endpoint.connectionCount.get());
        ArrayList<Runnable> copy = new ArrayList<Runnable>(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        MetricsTest.assertWaitUntil(() -> metrics.endpoints().isEmpty());
        this.assertEquals(0L, endpoint.connectionCount.get());
    }

    @Test
    public void testHttpClientConnectionCloseAfterRequestEnd() throws Exception {
        CountDownLatch started = new CountDownLatch(1);
        this.client = this.vertx.createHttpClient();
        AtomicReference endpointMetrics = new AtomicReference();
        this.server = this.vertx.createHttpServer().requestHandler(req -> {
            endpointMetrics.set(((FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)this.client)).endpoint("localhost:" + HttpTestBase.DEFAULT_HTTP_PORT));
            req.response().end();
        }).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            started.countDown();
        });
        this.awaitLatch(started);
        this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/somepath").compose(req -> req.send().compose(HttpClientResponse::end).compose(v -> req.connection().close())).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        EndpointMetric val = (EndpointMetric)endpointMetrics.get();
        MetricsTest.assertWaitUntil(() -> val.connectionCount.get() == 0);
        this.assertEquals(0L, val.queueSize.get());
        this.assertEquals(0L, val.requestCount.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMulti() {
        int size = 2;
        this.waitFor(size);
        this.client = this.vertx.createHttpClient();
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        List requests = Collections.synchronizedList(new ArrayList());
        BiConsumer<HttpServer, HttpServerRequest> check = (server, request) -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            HttpServerMetric metric = metrics.getRequestMetric((HttpServerRequest)request);
            this.assertNotNull(metric);
            requests.add(request);
            if (requests.size() == size) {
                requests.forEach(req -> req.response().end());
            }
        };
        for (int i = 0; i < size; ++i) {
            HttpServer server2 = this.vertx.createHttpServer();
            server2.requestHandler(req -> check.accept(server2, (HttpServerRequest)req));
            servers.add(server2);
        }
        try {
            List collect = servers.stream().map(server -> server.listen(HttpTestBase.DEFAULT_HTTP_PORT)).collect(Collectors.toList());
            CompositeFuture.all(collect).onSuccess(v -> {
                this.assertEquals("Was expecting a single metric", 1L, servers.stream().map(FakeMetricsBase::getMetrics).distinct().count());
                for (int i = 0; i < 2; ++i) {
                    this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", TestUtils.randomAlphaString(16)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.complete()));
                }
            });
            this.await();
        }
        finally {
            servers.forEach(HttpServer::close);
        }
    }

    @Test
    public void testHttpConnect1() {
        this.testHttpConnect(TestUtils.loopbackAddress(), socketMetric -> this.assertEquals(TestUtils.loopbackAddress(), socketMetric.remoteName));
    }

    @Test
    public void testHttpConnect2() {
        this.testHttpConnect(TestUtils.loopbackAddress(), socketMetric -> this.assertEquals(socketMetric.remoteAddress.host(), socketMetric.remoteName));
    }

    private void testHttpConnect(String host, Consumer<SocketMetric> checker) {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer();
        AtomicReference clientMetric = new AtomicReference();
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric serverMetric = metrics.getRequestMetric((HttpServerRequest)req);
            this.assertNotNull(serverMetric);
            req.response().setStatusCode(200);
            req.response().setStatusMessage("Connection established");
            req.toNetSocket().onComplete(this.onSuccess(so -> {
                so.handler(arg_0 -> ((NetSocket)so).write(arg_0));
                so.closeHandler(v -> {
                    this.assertNull(metrics.getRequestMetric((HttpServerRequest)req));
                    this.assertFalse(serverMetric.socket.connected.get());
                    this.assertEquals(5L, serverMetric.socket.bytesRead.get());
                    this.assertEquals(5L, serverMetric.socket.bytesWritten.get());
                    this.assertEquals(serverMetric.socket.remoteAddress.host(), serverMetric.socket.remoteName);
                    this.assertFalse(serverMetric.socket.connected.get());
                    this.assertEquals(5L, serverMetric.socket.bytesRead.get());
                    this.assertEquals(5L, serverMetric.socket.bytesWritten.get());
                    checker.accept(serverMetric.socket);
                    this.complete();
                });
            }));
        }).listen(HttpTestBase.DEFAULT_HTTP_PORT, this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient();
            this.client.request(new RequestOptions().setMethod(HttpMethod.CONNECT).setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost(host).setURI(TestUtils.randomAlphaString(16))).onComplete(this.onSuccess(req -> {
                FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
                req.connect(this.onSuccess(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    clientMetric.set(metrics.getMetric((HttpClientRequest)req));
                    this.assertNotNull(clientMetric.get());
                    NetSocket socket = resp.netSocket();
                    socket.write((Object)Buffer.buffer((String)"hello"));
                    socket.handler(buf -> {
                        this.assertEquals("hello", buf.toString());
                        this.assertNotNull(metrics.getMetric((HttpClientRequest)req));
                        socket.closeHandler(v -> this.assertNull(metrics.getMetric((HttpClientRequest)req)));
                        socket.close();
                        this.complete();
                    });
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testDatagram1() throws Exception {
        this.testDatagram("127.0.0.1", packet -> {
            this.assertEquals("127.0.0.1", packet.remoteAddress.host());
            this.assertEquals(1234L, packet.remoteAddress.port());
            this.assertEquals(5L, packet.numberOfBytes);
        });
    }

    @Test
    public void testDatagram2() throws Exception {
        this.testDatagram("localhost", packet -> {
            this.assertEquals("localhost", packet.remoteAddress.host());
            this.assertEquals(1234L, packet.remoteAddress.port());
            this.assertEquals(5L, packet.numberOfBytes);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDatagram(String host, Consumer<PacketMetric> checker) throws Exception {
        this.waitFor(2);
        DatagramSocket peer1 = this.vertx.createDatagramSocket();
        DatagramSocket peer2 = this.vertx.createDatagramSocket();
        FakeDatagramSocketMetrics peer1Metrics = (FakeDatagramSocketMetrics)FakeMetricsBase.getMetrics((Measured)peer1);
        FakeDatagramSocketMetrics peer2Metrics = (FakeDatagramSocketMetrics)FakeMetricsBase.getMetrics((Measured)peer2);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            peer1.handler(packet -> this.complete());
            peer1.listen(1234, host, this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
            peer2.send("hello", 1234, host, this.onSuccess(v -> this.complete()));
            this.await();
        }
        finally {
            peer1.close();
            peer2.close();
        }
        this.assertEquals(host, peer1Metrics.getLocalName());
        this.assertEquals("127.0.0.1", peer1Metrics.getLocalAddress().host());
        this.assertNull(peer2Metrics.getLocalAddress());
        this.assertEquals(1L, peer1Metrics.getReads().size());
        PacketMetric read = peer1Metrics.getReads().get(0);
        this.assertEquals(5L, read.numberOfBytes);
        this.assertEquals(0L, peer1Metrics.getWrites().size());
        this.assertEquals(0L, peer2Metrics.getReads().size());
        this.assertEquals(1L, peer2Metrics.getWrites().size());
        checker.accept(peer2Metrics.getWrites().get(0));
    }

    @Test
    public void testThreadPoolMetricsWithExecuteBlocking() throws Exception {
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-worker-thread");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getWorkerPoolSize()));
        Handler<Promise<Void>> job = this.getSomeDumbTask();
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        for (int i = 0; i < 100; ++i) {
            this.vertx.executeBlocking(job, ar -> {
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
            });
        }
        MetricsTest.assertWaitUntil(() -> metrics.numberOfSubmittedTask() == 100);
        MetricsTest.assertWaitUntil(() -> metrics.numberOfCompletedTasks() == 100);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        MetricsTest.assertWaitUntil(() -> metrics.numberOfIdleThreads() == this.getOptions().getWorkerPoolSize());
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testThreadPoolMetricsWithInternalExecuteBlocking() {
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-internal-blocking");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        int num = 20;
        int count = num * 5;
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        VertxInternal v = (VertxInternal)this.vertx;
        HashMap<Integer, CountDownLatch> latches = new HashMap<Integer, CountDownLatch>();
        for (int i = 0; i < count; ++i) {
            CountDownLatch latch = latches.computeIfAbsent(i / num, k -> new CountDownLatch(num));
            v.executeBlockingInternal(fut -> {
                latch.countDown();
                try {
                    this.awaitLatch(latch);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                    Thread.currentThread().interrupt();
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                fut.complete();
            }, false, ar -> {
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
            });
        }
        MetricsTest.assertWaitUntil(() -> metrics.numberOfSubmittedTask() == 100);
        MetricsTest.assertWaitUntil(() -> metrics.numberOfCompletedTasks() == 100);
        MetricsTest.assertWaitUntil(() -> hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), this.getOptions().getWorkerPoolSize());
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testThreadPoolMetricsWithWorkerVerticle() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-worker-thread");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getWorkerPoolSize()));
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        int count = 100;
        AtomicInteger msg = new AtomicInteger();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ContextInternal ctx = ((VertxInternal)this.vertx).createWorkerContext();
        ctx.runOnContext(v -> {
            this.vertx.eventBus().localConsumer("message", d -> {
                msg.incrementAndGet();
                try {
                    Thread.sleep(10L);
                    if (metrics.numberOfWaitingTasks() > 0) {
                        hadWaitingQueue.set(true);
                    }
                    if (metrics.numberOfIdleThreads() > 0) {
                        hadIdle.set(true);
                    }
                    if (metrics.numberOfRunningTasks() > 0) {
                        hadRunning.set(true);
                    }
                    if (counter.incrementAndGet() == count) {
                        latch2.countDown();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().isInterrupted();
                }
            });
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        for (int i = 0; i < count; ++i) {
            this.vertx.eventBus().send("message", (Object)i);
        }
        this.awaitLatch(latch2);
        MetricsTest.assertWaitUntil(() -> count + 1 == metrics.numberOfCompletedTasks());
        this.assertEquals(count + 1, metrics.numberOfSubmittedTask());
        this.assertEquals(count + 1, metrics.numberOfCompletedTasks());
        this.assertTrue("Had no idle threads", hadIdle.get());
        this.assertTrue("Had no waiting tasks", hadWaitingQueue.get());
        this.assertTrue("Had running tasks", hadRunning.get());
        this.assertEquals(this.getOptions().getWorkerPoolSize(), metrics.numberOfIdleThreads());
        this.assertEquals(0L, metrics.numberOfRunningTasks());
        this.assertEquals(0L, metrics.numberOfWaitingTasks());
    }

    @Test
    public void testThreadPoolMetricsWithNamedExecuteBlocking() throws InterruptedException {
        this.vertx.close();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory())));
        WorkerExecutor workerExec = this.vertx.createSharedWorkerExecutor("my-pool", 10);
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("my-pool");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)10));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)10));
        Handler<Promise<Void>> job = this.getSomeDumbTask();
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        for (int i = 0; i < 100; ++i) {
            workerExec.executeBlocking(job, false, ar -> {
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
            });
        }
        MetricsTest.waitUntil(() -> metrics.numberOfSubmittedTask() == 100 && metrics.numberOfCompletedTasks() == 100);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), 10L);
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testWorkerPoolClose() {
        WorkerExecutor ex1 = this.vertx.createSharedWorkerExecutor("ex1");
        WorkerExecutor ex1_ = this.vertx.createSharedWorkerExecutor("ex1");
        WorkerExecutor ex2 = this.vertx.createSharedWorkerExecutor("ex2");
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics1 = (FakePoolMetrics)all.get("ex1");
        FakePoolMetrics metrics2 = (FakePoolMetrics)all.get("ex2");
        this.assertNotNull(metrics1);
        this.assertNotNull(metrics2);
        this.assertNotSame(metrics1, metrics2);
        this.assertFalse(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex1_.close();
        this.assertFalse(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex1.close();
        this.assertTrue(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex2.close();
        this.assertTrue(metrics1.isClosed());
        this.assertTrue(metrics2.isClosed());
    }

    private Handler<Promise<Void>> getSomeDumbTask() {
        return future -> {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().isInterrupted();
            }
            future.complete(null);
        };
    }

    @Test
    public void testInitialization() {
        EventLoop next;
        this.assertSame(this.vertx, ((FakeVertxMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx)).vertx());
        this.startNodes(1);
        this.assertSame(this.vertices[0], ((FakeVertxMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[0])).vertx());
        EventLoopGroup group = this.vertx.nettyEventLoopGroup();
        HashSet<EventLoop> loops = new HashSet<EventLoop>();
        int count = 0;
        while (loops.add(next = group.next())) {
            this.assertTrue(++count <= VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE);
        }
        this.assertEquals(loops.size(), VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE);
    }

    @Test
    public void testHTTP2ConnectionCloseBeforePrefaceIsReceived() throws Exception {
        HttpServerOptions options = Http2TestBase.createHttp2ServerOptions(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").setIdleTimeout(1);
        HttpServer server = this.vertx.createHttpServer(options);
        server.requestHandler(req -> {}).listen().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeVertxMetrics.getMetrics((Measured)server);
        NetClient client = this.vertx.createNetClient(new NetClientOptions().setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setUseAlpn(true).setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()).setHostnameVerificationAlgorithm("HTTPS").setApplicationLayerProtocols(Collections.singletonList("h2")));
        CountDownLatch latch = new CountDownLatch(1);
        client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", this.onSuccess(so -> {
            this.assertEquals("h2", so.applicationLayerProtocol());
            so.closeHandler(v -> latch.countDown());
        }));
        this.awaitLatch(latch);
        this.assertEquals(0L, metrics.connectionCount());
    }

    @Test
    public void testServerLifecycle() {
        final AtomicInteger lifecycle = new AtomicInteger();
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory(options -> new VertxMetrics(){

            public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                lifecycle.compareAndSet(0, 1);
                return new HttpServerMetrics<Object, Object, Object>(){

                    public void close() {
                        lifecycle.compareAndSet(1, 2);
                        super.close();
                    }
                };
            }
        })));
        vertx.createHttpServer().requestHandler(req -> {}).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost");
        vertx.close().onComplete(this.onSuccess(v -> {
            this.assertEquals(2L, lifecycle.get());
            this.testComplete();
        }));
        this.await();
    }
}

