/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.logging.SLF4JLogDelegate;
import io.vertx.core.spi.logging.LogDelegate;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogDelegateTest {
    @Test
    public void testDelegateUnwrap() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-slf4j-logger");
        LogDelegate delegate = logger.getDelegate();
        Assert.assertNotNull((String)"Delegate is null", (Object)delegate);
        try {
            Logger unwrapped = (Logger)delegate.unwrap();
            Assert.assertNotNull((String)"Unwrapped is null", (Object)unwrapped);
        }
        catch (ClassCastException e) {
            Assert.fail((String)("Unexpected unwrapped type: " + e.getMessage()));
        }
    }

    @Test
    public void testInfo() {
        this.testInfo(LoggerFactory.getLogger((String)"my-slf4j-logger"));
    }

    @Test
    public void testInfoLocationAware() {
        this.testInfo(new io.vertx.core.logging.Logger((LogDelegate)new SLF4JLogDelegate((Object)new TestLocationAwareLogger("my-slf4j-logger"))));
    }

    private void testInfo(io.vertx.core.logging.Logger logger) {
        String result = this.record(() -> logger.info((Object)"hello"));
        this.assertContains("[main] INFO my-slf4j-logger - hello", result);
        result = this.record(() -> logger.info((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.info((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.info((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.info((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.info((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.info((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.info((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testError() {
        this.testError(LoggerFactory.getLogger((String)"my-slf4j-logger"));
    }

    @Test
    public void testErrorLocationAware() {
        this.testError(LoggerFactory.getLogger((String)"my-slf4j-logger"));
    }

    private void testError(io.vertx.core.logging.Logger logger) {
        String result = this.record(() -> logger.error((Object)"hello"));
        this.assertContains("[main] ERROR my-slf4j-logger - hello", result);
        result = this.record(() -> logger.error((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.error((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.error((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.error((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.error((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.error((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.error((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    private void assertContains(String expectedExcerpt, String object) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.contains(expectedExcerpt));
    }

    @Test
    public void testWarning() {
        this.testWarning(LoggerFactory.getLogger((String)"my-slf4j-logger"));
    }

    @Test
    public void testWarningLocationAware() {
        this.testWarning(LoggerFactory.getLogger((String)"my-slf4j-logger"));
    }

    private void testWarning(io.vertx.core.logging.Logger logger) {
        String result = this.record(() -> logger.warn((Object)"hello"));
        this.assertContains("[main] WARN my-slf4j-logger - hello", result);
        result = this.record(() -> logger.warn((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.warn((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.warn((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.warn((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.warn((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.warn((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.warn((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withStream(PrintStream stream, Runnable runnable) {
        PrintStream prev = System.out;
        System.setOut(stream);
        try {
            runnable.run();
        }
        finally {
            System.setOut(prev);
        }
    }

    private String record(Runnable runnable) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream written = new PrintStream(stream);
        this.withStream(written, () -> {
            runnable.run();
            written.flush();
        });
        String result = stream.toString();
        this.quiet(() -> {
            written.close();
            return null;
        });
        return result;
    }

    private void quiet(Callable<Void> action) {
        try {
            action.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class TestLocationAwareLogger
    implements LocationAwareLogger {
        private final Logger actual;

        TestLocationAwareLogger(String name) {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)name);
            SLF4JLogDelegate delegate = (SLF4JLogDelegate)logger.getDelegate();
            this.actual = (Logger)delegate.unwrap();
        }

        public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
            switch (level) {
                case 40: {
                    this.error(marker, message, t);
                    break;
                }
                case 30: {
                    this.warn(marker, message, t);
                    break;
                }
                case 20: {
                    this.info(marker, message, t);
                    break;
                }
                case 10: {
                    this.debug(marker, message, t);
                    break;
                }
                case 0: {
                    this.trace(marker, message, t);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public String getName() {
            return this.actual.getName();
        }

        public boolean isTraceEnabled() {
            return this.actual.isTraceEnabled();
        }

        public void trace(String msg) {
            throw new AssertionError();
        }

        public void trace(String format, Object arg) {
            throw new AssertionError();
        }

        public void trace(String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void trace(String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void trace(String msg, Throwable t) {
            this.actual.trace(msg, t);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.actual.isTraceEnabled();
        }

        public void trace(Marker marker, String msg) {
            throw new AssertionError();
        }

        public void trace(Marker marker, String format, Object arg) {
            throw new AssertionError();
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.actual.trace(marker, format, arg1, arg2);
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            throw new AssertionError();
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.actual.trace(marker, msg, t);
        }

        public boolean isDebugEnabled() {
            return this.actual.isDebugEnabled();
        }

        public void debug(String msg) {
            throw new AssertionError();
        }

        public void debug(String format, Object arg) {
            throw new AssertionError();
        }

        public void debug(String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void debug(String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void debug(String msg, Throwable t) {
            throw new AssertionError();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.actual.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String msg) {
            throw new AssertionError();
        }

        public void debug(Marker marker, String format, Object arg) {
            throw new AssertionError();
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.actual.debug(marker, msg, t);
        }

        public boolean isInfoEnabled() {
            return this.actual.isInfoEnabled();
        }

        public void info(String msg) {
            throw new AssertionError();
        }

        public void info(String format, Object arg) {
            throw new AssertionError();
        }

        public void info(String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void info(String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void info(String msg, Throwable t) {
            throw new AssertionError();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.actual.isInfoEnabled(marker);
        }

        public void info(Marker marker, String msg) {
            throw new AssertionError();
        }

        public void info(Marker marker, String format, Object arg) {
            throw new AssertionError();
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void info(Marker marker, String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.actual.info(marker, msg, t);
        }

        public boolean isWarnEnabled() {
            return this.actual.isWarnEnabled();
        }

        public void warn(String msg) {
            throw new AssertionError();
        }

        public void warn(String format, Object arg) {
            throw new AssertionError();
        }

        public void warn(String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void warn(String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void warn(String msg, Throwable t) {
            throw new AssertionError();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.actual.isWarnEnabled();
        }

        public void warn(Marker marker, String msg) {
            throw new AssertionError();
        }

        public void warn(Marker marker, String format, Object arg) {
            throw new AssertionError();
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.actual.warn(marker, msg, t);
        }

        public boolean isErrorEnabled() {
            return this.actual.isErrorEnabled();
        }

        public void error(String msg) {
            throw new AssertionError();
        }

        public void error(String format, Object arg) {
            throw new AssertionError();
        }

        public void error(String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void error(String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void error(String msg, Throwable t) {
            throw new AssertionError();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.actual.isErrorEnabled(marker);
        }

        public void error(Marker marker, String msg) {
            throw new AssertionError();
        }

        public void error(Marker marker, String format, Object arg) {
            this.actual.error(marker, format, arg);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            throw new AssertionError();
        }

        public void error(Marker marker, String format, Object ... arguments) {
            throw new AssertionError();
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.actual.error(marker, msg, t);
        }
    }
}

