/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=400, timeUnit=TimeUnit.MILLISECONDS)
public class HeadersSetBenchmark
extends BenchmarkBase {
    @Param(value={"true", "false"})
    public boolean validate;
    @Param(value={"true", "false"})
    public boolean asciiNames;
    private HttpHeaders nettySmallHeaders;
    private HeadersMultiMap vertxSmallHeaders;

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(HttpHeaders headers) {
    }

    @Setup
    public void setup() {
        this.nettySmallHeaders = new DefaultHttpHeaders(this.validate);
        this.vertxSmallHeaders = new HeadersMultiMap(this.validate ? HttpUtils::validateHeader : null);
    }

    @Benchmark
    public void nettySmall() {
        this.nettySmallHeaders.clear();
        HeadersUtils.setBaseHeaders(this.nettySmallHeaders, this.asciiNames, true);
        HeadersSetBenchmark.consume(this.nettySmallHeaders);
    }

    @Benchmark
    public void vertxSmall() {
        this.vertxSmallHeaders.clear();
        HeadersUtils.setBaseHeaders((HttpHeaders)this.vertxSmallHeaders, this.asciiNames, true);
        HeadersSetBenchmark.consume((HttpHeaders)this.vertxSmallHeaders);
    }
}

