/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileResolverTestBase;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ZipFileResolverTest
extends FileResolverTestBase {
    static File getFiles(File baseDir) throws Exception {
        File file = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "files.jar", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)file.delete());
        return ZipFileResolverTest.getFiles(baseDir, file, ZipOutputStream::new, ZipEntry::new);
    }

    static File getFiles(File baseDir, File files, Function<OutputStream, ZipOutputStream> zipFact, final Function<String, ZipEntry> entryFact) throws Exception {
        if (!files.exists()) {
            try (final ZipOutputStream zip = zipFact.apply(new FileOutputStream(files));){
                final Path filesPath = new File(baseDir, "files").toPath();
                Files.walkFileTree(filesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = (ZipEntry)entryFact.apply(TestUtils.getJarEntryName(filesPath.relativize(file)));
                        zip.putNextEntry(entry);
                        zip.write(Files.readAllBytes(file));
                        zip.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String name = TestUtils.getJarEntryName(filesPath.relativize(dir));
                        if (!name.isEmpty()) {
                            ZipEntry entry = (ZipEntry)entryFact.apply(name + "/");
                            zip.putNextEntry(entry);
                            zip.closeEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                zip.putNextEntry(entryFact.apply("afilewithspaceatend "));
                zip.write("afilewithspaceatend ".getBytes());
                zip.closeEntry();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileResolverShouldNotUseCachedURLConnection() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream in = cl.getResourceAsStream("afile.html");){
            Buffer buffer = this.vertx.fileSystem().readFileBlocking("afile.html");
            byte[] tmp = new byte[256];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int amount = 0;
            while (amount != -1) {
                baos.write(tmp, 0, amount);
                amount = in.read(tmp);
            }
            baos.close();
            this.assertEquals(baos.toString(), buffer.toString());
        }
    }

    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File files = ZipFileResolverTest.getFiles(baseDir);
        return new URLClassLoader(new URL[]{files.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }
}

