/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.handler.proxy.ProxyConnectException;
import io.vertx.core.Future;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.test.proxy.HttpProxy;
import io.vertx.test.proxy.Socks4Proxy;
import io.vertx.test.proxy.SocksProxy;
import io.vertx.test.proxy.TestProxyBase;
import io.vertx.test.tls.Cert;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class Http1xProxyTest
extends HttpTestBase {
    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 www1.example1.com\n127.0.0.1 www2.example1.com\n127.0.0.1 www1.example2.com\n127.0.0.1 www2.example2.com\n"));
        return options;
    }

    @Test
    public void testHttpProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())));
        this.testHttpProxyRequest(() -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).compose(HttpClientRequest::send)).onComplete(this.onSuccess(v -> {
            this.assertProxiedRequest("localhost");
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHttpProxyRequest2() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.testHttpProxyRequest(() -> this.client.request(new RequestOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())).setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).compose(HttpClientRequest::send)).onComplete(this.onSuccess(v -> {
            this.assertProxiedRequest("localhost");
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAcceptFilter() throws Exception {
        this.testFilter(true);
    }

    @Test
    public void testRejectFilter() throws Exception {
        this.testFilter(false);
    }

    private void testFilter(boolean accept) throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())));
        Set filtered = Collections.synchronizedSet(new HashSet());
        ((HttpClientImpl)this.client).proxyFilter(so -> {
            filtered.add(so);
            return accept;
        });
        this.testHttpProxyRequest(() -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).compose(HttpClientRequest::send)).onComplete(this.onSuccess(v -> {
            if (accept) {
                this.assertProxiedRequest("localhost");
            }
            this.assertEquals(Collections.singleton(SocketAddress.inetSocketAddress((int)DEFAULT_HTTP_PORT, (String)"localhost")), filtered);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNonProxyHosts1() throws Exception {
        this.testNonProxyHosts(Collections.singletonList("www1.example1.com"), "www1.example1.com", false);
    }

    @Test
    public void testNonProxyHosts2() throws Exception {
        this.testNonProxyHosts(Collections.singletonList("www1.example1.com"), "www2.example1.com", true);
    }

    @Test
    public void testNonProxyHosts3() throws Exception {
        this.testNonProxyHosts(Collections.singletonList("*.example2.com"), "www1.example2.com", false);
    }

    @Test
    public void testNonProxyHosts4() throws Exception {
        this.testNonProxyHosts(Collections.singletonList("*.example2.com"), "www2.example2.com", false);
    }

    private void testNonProxyHosts(List<String> nonProxyHosts, String host, boolean proxied) throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setNonProxyHosts(nonProxyHosts).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())));
        this.testHttpProxyRequest(() -> this.client.request(new RequestOptions().setHost(host).setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).compose(HttpClientRequest::send)).onComplete(this.onSuccess(v -> {
            if (proxied) {
                this.assertProxiedRequest(host);
            }
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHttpProxyRequestOverrideClientSsl() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())));
        this.testHttpProxyRequest(() -> this.client.request(new RequestOptions().setSsl(Boolean.valueOf(false)).setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT))).compose(HttpClientRequest::send)).onComplete(this.onSuccess(v -> {
            this.assertProxiedRequest("localhost");
            this.testComplete();
        }));
        this.await();
    }

    private void assertProxiedRequest(String host) {
        this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
        this.assertEquals("Host header doesn't contain target host", host + ":" + DEFAULT_HTTP_PORT, this.proxy.getLastRequestHeaders().get("Host"));
    }

    private Future<Void> testHttpProxyRequest(Supplier<Future<HttpClientResponse>> reqFact) throws Exception {
        this.server.requestHandler(req -> req.response().end());
        return this.server.listen().compose(s -> ((Future)reqFact.get()).compose(resp -> {
            int sc = resp.statusCode();
            if (sc == 200) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((String)("Was expected 200 response instead of " + sc));
        }));
    }

    @Test
    public void testHttpProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.assertEquals("Host header doesn't contain target host", DEFAULT_HTTP_HOST_AND_PORT, this.proxy.getLastRequestHeaders().get("Host"));
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testHttpProxyFtpRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())));
        String url = "ftp://ftp.gnu.org/gnu/";
        this.proxy.setForceUri("http://" + DEFAULT_HTTP_HOST_AND_PORT + "/");
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.request(new RequestOptions().setURI("ftp://ftp.gnu.org/gnu/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("request did sent the expected url", "ftp://ftp.gnu.org/gnu/", this.proxy.getLastUri());
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.port())));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.port()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testHttpProxyPooling() throws Exception {
        HttpProxy proxy1 = (HttpProxy)new HttpProxy().port(13128);
        HttpProxy proxy2 = (HttpProxy)new HttpProxy().port(13129);
        ProxyOptions req1 = new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(proxy1.port());
        ProxyOptions req2 = new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(proxy2.port());
        List<String> res = this.testPooling(req1, req2, proxy1, proxy2);
        this.assertEquals(Arrays.asList(proxy1.lastLocalAddress(), proxy2.lastLocalAddress()), res);
    }

    @Test
    public void testHttpProxyPooling2() throws Exception {
        HttpProxy proxy = (HttpProxy)new HttpProxy().port(13128);
        ProxyOptions req = new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req, req, proxy);
        this.assertEquals(Arrays.asList(proxy.lastLocalAddress(), proxy.lastLocalAddress()), res);
    }

    @Test
    public void testHttpProxyAuthPooling1() throws Exception {
        HttpProxy proxy = (HttpProxy)((HttpProxy)new HttpProxy().port(11080)).username(Arrays.asList("user1", "user2"));
        ProxyOptions req1 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port());
        ProxyOptions req2 = new ProxyOptions().setUsername("user2").setPassword("user2").setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req1, req2, proxy);
        this.assertEquals(proxy.localAddresses(), res);
    }

    @Test
    public void testHttpProxyAuthPooling2() throws Exception {
        HttpProxy proxy = (HttpProxy)((HttpProxy)new HttpProxy().port(11080)).username(Arrays.asList("user1"));
        ProxyOptions req1 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port());
        ProxyOptions req2 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.HTTP).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req1, req2, proxy);
        this.assertEquals(1L, proxy.localAddresses().size());
        this.assertEquals(Arrays.asList(proxy.localAddresses().get(0), proxy.localAddresses().get(0)), res);
    }

    @Test
    public void testSocksProxyPooling1() throws Exception {
        SocksProxy proxy1 = (SocksProxy)new SocksProxy().port(11080);
        SocksProxy proxy2 = (SocksProxy)new SocksProxy().port(11081);
        ProxyOptions req1 = new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy1.port());
        ProxyOptions req2 = new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy2.port());
        List<String> res = this.testPooling(req1, req2, proxy1, proxy2);
        this.assertEquals(Arrays.asList(proxy1.lastLocalAddress(), proxy2.lastLocalAddress()), res);
    }

    @Test
    public void testSocksProxyPooling2() throws Exception {
        SocksProxy proxy = (SocksProxy)new SocksProxy().port(11080);
        ProxyOptions req = new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req, req, proxy);
        this.assertEquals(Arrays.asList(proxy.lastLocalAddress(), proxy.lastLocalAddress()), res);
    }

    @Test
    public void testSocksProxyAuthPooling1() throws Exception {
        SocksProxy proxy = (SocksProxy)((SocksProxy)new SocksProxy().port(11080)).username(Arrays.asList("user1", "user2"));
        ProxyOptions req1 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy.port());
        ProxyOptions req2 = new ProxyOptions().setUsername("user2").setPassword("user2").setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req1, req2, proxy);
        this.assertEquals(proxy.localAddresses(), res);
    }

    @Test
    public void testSocksProxyAuthPooling2() throws Exception {
        SocksProxy proxy = (SocksProxy)((SocksProxy)new SocksProxy().port(11080)).username(Arrays.asList("user1"));
        ProxyOptions req1 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy.port());
        ProxyOptions req2 = new ProxyOptions().setUsername("user1").setPassword("user1").setType(ProxyType.SOCKS5).setHost("localhost").setPort(proxy.port());
        List<String> res = this.testPooling(req1, req2, proxy);
        this.assertEquals(1L, proxy.localAddresses().size());
        this.assertEquals(Arrays.asList(proxy.localAddresses().get(0), proxy.localAddresses().get(0)), res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> testPooling(ProxyOptions request1, ProxyOptions request2, TestProxyBase ... proxies) throws Exception {
        for (TestProxyBase proxy : proxies) {
            proxy.start(this.vertx);
        }
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        CompletableFuture ret = new CompletableFuture();
        try {
            this.server.requestHandler(req -> {
                SocketAddress addr = req.connection().remoteAddress();
                req.response().end("" + addr);
            }).listen(this.onSuccess(s -> {
                RequestOptions baseOptions = new RequestOptions().setHost("localhost").setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setURI("/");
                this.client.request(new RequestOptions(baseOptions).setProxyOptions(request1)).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(res1 -> this.client.request(new RequestOptions(baseOptions).setProxyOptions(request2)).compose(HttpClientRequest::send).compose(HttpClientResponse::body).onComplete(this.onSuccess(res2 -> ret.complete(Arrays.asList(res1.toString(), res2.toString()))))));
            }));
            List list = (List)ret.get(40L, TimeUnit.SECONDS);
            return list;
        }
        finally {
            for (TestProxyBase proxy : proxies) {
                proxy.stop();
            }
        }
    }

    @Test
    public void testWssHttpProxy() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.testWebSocket(this.createBaseServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()), new HttpClientOptions().setSsl(true).setTrustOptions((TrustOptions)Cert.SERVER_JKS.get()).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())), true);
    }

    @Test
    public void testWsHttpProxy() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.testWebSocket(this.createBaseServerOptions(), new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())), true);
    }

    @Test
    public void testWssSocks5Proxy() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.testWebSocket(this.createBaseServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()), new HttpClientOptions().setSsl(true).setTrustOptions((TrustOptions)Cert.SERVER_JKS.get()).setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.port())), true);
    }

    @Test
    public void testWsSocks5Proxy() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.testWebSocket(this.createBaseServerOptions(), new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.port())), true);
    }

    @Test
    public void testWsNonProxyHosts() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.testWebSocket(this.createBaseServerOptions(), new HttpClientOptions().addNonProxyHost("localhost").setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.port())), false);
    }

    private void testWebSocket(HttpServerOptions serverOptions, HttpClientOptions clientOptions, boolean proxied) throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(serverOptions);
        this.client.close();
        this.client = this.vertx.createHttpClient(clientOptions);
        this.server.webSocketHandler(ws -> ws.handler(buff -> {
            ws.write(buff);
            ws.close();
        }));
        this.server.listen(DEFAULT_HTTPS_PORT, "localhost").onSuccess(s -> this.client.webSocket(DEFAULT_HTTPS_PORT, "localhost", "/").onSuccess(ws -> {
            ws.handler(buff -> ws.close(this.onSuccess(v -> {
                if (proxied) {
                    this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
                    if (clientOptions.getProxyOptions().getType() == ProxyType.HTTP) {
                        this.assertEquals("Host header doesn't contain target host", DEFAULT_HTTPS_HOST_AND_PORT, this.proxy.getLastRequestHeaders().get("Host"));
                    }
                } else {
                    this.assertNull("request did go through proxy", this.proxy.getLastUri());
                }
                this.testComplete();
            })));
            ws.write((Object)Buffer.buffer((String)"Hello world"));
        }));
        this.await();
    }

    @Test
    public void testNoConnectTimeoutHttpProxy() throws Exception {
        this.testConnectTimeout(ProxyType.HTTP, false);
    }

    @Test
    public void testNoConnectTimeoutSocksProxy() throws Exception {
        this.testConnectTimeout(ProxyType.SOCKS4, false);
    }

    @Test
    public void testNoConnectTimeoutSocks5Proxy() throws Exception {
        this.testConnectTimeout(ProxyType.SOCKS5, false);
    }

    @Test
    public void testConnectTimeoutHttpProxy() throws Exception {
        this.testConnectTimeout(ProxyType.HTTP, true);
    }

    @Test
    public void testConnectTimeoutSocksProxy() throws Exception {
        this.testConnectTimeout(ProxyType.SOCKS4, true);
    }

    @Test
    public void testConnectTimeoutSocks5Proxy() throws Exception {
        this.testConnectTimeout(ProxyType.SOCKS5, true);
    }

    private void testConnectTimeout(ProxyType proxyType, boolean shouldTimeout) throws Exception {
        this.server.close();
        HttpServerOptions serverOptions = this.createBaseServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        this.server = this.vertx.createHttpServer(serverOptions).requestHandler(request -> request.response().end());
        this.startServer(SocketAddress.inetSocketAddress((int)DEFAULT_HTTPS_PORT, (String)"localhost"));
        this.proxy = proxyType == ProxyType.HTTP ? new HttpProxy() : (proxyType == ProxyType.SOCKS4 ? new Socks4Proxy() : new SocksProxy());
        Duration delay = Duration.ofSeconds(1L);
        ((TestProxyBase)this.proxy.username((String)null)).successDelayMillis(delay.toMillis());
        this.proxy.start(this.vertx);
        ProxyOptions proxyOptions = new ProxyOptions().setType(proxyType).setHost("localhost").setPort(this.proxy.port()).setConnectTimeout(shouldTimeout ? delay.dividedBy(2L) : delay.multipliedBy(2L));
        HttpClientOptions clientOptions = this.createBaseClientOptions().setSsl(true).setTrustOptions((TrustOptions)Cert.SERVER_JKS.get()).setProxyOptions(proxyOptions);
        this.client = this.vertx.createHttpClient(clientOptions);
        RequestOptions requestOptions = new RequestOptions(this.requestOptions).setPort(Integer.valueOf(DEFAULT_HTTPS_PORT)).setConnectTimeout(delay.multipliedBy(3L).toMillis());
        this.client.request(requestOptions).compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(ar -> {
            if (shouldTimeout) {
                this.assertTrue(ar.failed());
                this.assertThat(ar.cause(), CoreMatchers.instanceOf(ProxyConnectException.class));
            } else {
                this.assertTrue(ar.succeeded());
            }
            this.testComplete();
        });
        this.await();
    }
}

